/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Globals;
import core.Matrix;

public class Calc_C2 {
    Object[][] data;
    String[][] flags;
    String[][] dimdata;
    double RAi;
    double RAe;
    int cT;

    public String[][] getFlags() {
        return this.flags;
    }

    private double getRAirLayer(long flag, double dd) {
        double res = 0.0;
        double[] dlayer = new double[]{0.5, 0.7, 1.0, 1.5, 2.5, 5.0, 10.0, 30.0};
        double[] asc = new double[]{0.11, 0.13, 0.15, 0.16, 0.16, 0.16, 0.16, 0.16};
        double[] hor = new double[]{0.11, 0.13, 0.15, 0.17, 0.18, 0.18, 0.18, 0.18};
        double[] desc = new double[]{0.11, 0.13, 0.15, 0.17, 0.19, 0.21, 0.22, 0.23};
        int pos = 0;
        int cter = 0;
        while (cter < dlayer.length && dd >= dlayer[cter] / 100.0) {
            pos = cter++;
        }
        if ((flag & 1L) == 1L) {
            res = asc[pos];
        } else if ((flag & 2L) == 2L) {
            res = hor[pos];
        } else if ((flag & 4L) == 4L) {
            res = desc[pos];
        }
        return res;
    }

    public double getRMoy(double[] dim, int coucheCh, int nlay) {
        double res = 0.0;
        double p1_c = 0.0;
        double p2_c = 0.0;
        float kch = 1.0f;
        double sum_d = 0.0;
        double sum_r1 = this.RAi + this.RAe;
        double sum_r2 = this.RAi + this.RAe;
        double rinf = this.RAi + this.RAe;
        double rsup = 0.0;
        double rmoy = 0.0;
        double dimtmp = 0.0;
        double rtmp = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        p1_c = dim[0] / (dim[0] + dim[1]);
        p2_c = 1.0 - p1_c;
        for (int cter = 0; cter < nlay; ++cter) {
            try {
                dimtmp = Globals.getDoubleValue(this.dimdata[cter][0]) / 100.0;
                sum_d += dimtmp;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (coucheCh == 0) {
                kch = 1.0f;
            } else if (cter < coucheCh) {
                kch = 1.0f;
            } else if (cter == coucheCh) {
                kch = 0.5f;
            } else if (cter > coucheCh) {
                kch = 0.0f;
            }
            r1 = ((String)this.data[cter][1]).equals("") ? 0.0 : dimtmp / Globals.getDoubleValue(this.data[cter][1]) * (double)kch;
            r2 = this.data[cter][6] == null ? 0.0 : (this.data[cter][6].equals("") ? 0.0 : dimtmp / Globals.getDoubleValue(this.data[cter][6]) * (double)kch);
            if (p1_c > 0.0) {
                sum_r1 += r1;
            }
            if (p2_c > 0.0) {
                sum_r2 += r2;
            }
            rtmp = p1_c > 0.0 && r1 > 0.0 && p2_c > 0.0 && r2 > 0.0 ? 1.0 / (p1_c / r1 + p2_c / r2) : (p1_c > 0.0 && p2_c == 0.0 ? r1 : (p1_c == 0.0 && p2_c > 0.0 ? r2 : 0.0));
            rinf += rtmp;
        }
        rsup = p1_c > 0.0 && sum_r1 > 0.0 && p2_c > 0.0 && sum_r2 > 0.0 ? 1.0 / (p1_c / sum_r1 + p2_c / sum_r2) : (p1_c > 0.0 && p2_c == 0.0 ? sum_r1 : (p1_c == 0.0 && p2_c > 0.0 ? sum_r2 : 0.0));
        res = rmoy = (rinf + rsup) / 2.0;
        return res;
    }

    public double getRmoyAvecPontThermique(double RmoySansPt, int numPT, double valPT) {
        double Umoy = 1.0 / RmoySansPt;
        double res = 1.0 / (Umoy + (double)numPT * valPT);
        return res;
    }

    public double getRmoyD(String type, int nlay) {
        double res = 0.0;
        Matrix[] matrix = new Matrix[3];
        matrix[0] = new Matrix(4, 4);
        matrix[2] = new Matrix(4, 4);
        double RR = 0.0;
        double dd = 0.0;
        double lambda = 0.0;
        double rho = 0.0;
        double cc = 0.0;
        double bb = 0.0;
        double hh = 0.0;
        double zz = 0.0;
        boolean b_air = false;
        for (int ii = 0; ii < 4; ++ii) {
            for (int jj = 0; jj < 4; ++jj) {
                if (ii == jj) {
                    matrix[2].set(ii, jj, 1);
                    matrix[0].set(ii, jj, 1);
                    continue;
                }
                matrix[2].set(ii, jj, 0);
                matrix[0].set(ii, jj, 0);
            }
        }
        if (type.equals("6")) {
            matrix[2].set(0, 2, this.RAe);
            matrix[2].set(1, 3, this.RAe);
            matrix[0].set(0, 2, this.RAi);
            matrix[0].set(1, 3, this.RAi);
        } else {
            matrix[2].set(0, 2, this.RAi);
            matrix[2].set(1, 3, this.RAi);
            matrix[0].set(0, 2, this.RAe);
            matrix[0].set(1, 3, this.RAe);
        }
        for (int cter = nlay - 1; cter >= 0; --cter) {
            b_air = false;
            matrix[1] = new Matrix(4, 4);
            dd = this.dimdata[cter][1].equals("-1") ? Globals.getDoubleValue(this.dimdata[cter][0]) / 100.0 : Globals.getDoubleValue(this.dimdata[cter][1]) / 100.0;
            if (this.flags[cter] != null && this.flags[cter][0] != null) {
                int flagInt = 0;
                try {
                    flagInt = Integer.parseInt(this.flags[cter][0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if ((flagInt & 8) == 8) {
                    b_air = true;
                }
            }
            if (!((String)this.data[cter][1]).trim().equals("")) {
                lambda = Globals.getDoubleValue(this.data[cter][1]);
                cc = Globals.getDoubleValue(this.data[cter][2]);
                rho = Globals.getDoubleValue(this.data[cter][3]);
            } else {
                lambda = 0.0;
                cc = 0.0;
                rho = 0.0;
            }
            if (b_air) {
                try {
                    double rr = this.getRAirLayer(Long.parseLong(this.flags[cter][0]), dd);
                    for (int ii = 0; ii < 4; ++ii) {
                        for (int jj = 0; jj < 4; ++jj) {
                            if (ii != jj) continue;
                            matrix[1].set(ii, jj, 1);
                        }
                    }
                    matrix[1].set(0, 2, rr);
                    matrix[1].set(1, 3, rr);
                }
                catch (NumberFormatException rr) {}
            } else if (cc == 0.0) {
                for (int ii = 0; ii < 4; ++ii) {
                    for (int jj = 0; jj < 4; ++jj) {
                        if (ii != jj) continue;
                        matrix[1].set(ii, jj, 1);
                    }
                }
                matrix[1].set(0, 2, dd / lambda);
                matrix[1].set(1, 3, dd / lambda);
            } else {
                RR = dd / lambda;
                bb = Math.sqrt(lambda * rho * cc);
                hh = Math.sqrt(Math.PI / (double)this.cT) * bb;
                zz = hh * RR;
                double chz = 0.5 * (Math.exp(zz) + Math.exp(-zz));
                double shz = 0.5 * (Math.exp(zz) - Math.exp(-zz));
                double F1 = chz * Math.cos(zz);
                double F2 = shz * Math.sin(zz);
                double F3 = chz * Math.sin(zz) + shz * Math.cos(zz);
                double F4 = chz * Math.sin(zz) - shz * Math.cos(zz);
                matrix[1].set(0, 0, F1);
                matrix[1].set(0, 1, F2);
                matrix[1].set(0, 2, F3 / (2.0 * hh));
                matrix[1].set(0, 3, F4 / (2.0 * hh));
                matrix[1].set(1, 0, -F2);
                matrix[1].set(1, 1, F1);
                matrix[1].set(1, 2, -F4 / (2.0 * hh));
                matrix[1].set(1, 3, F3 / (2.0 * hh));
                matrix[1].set(2, 0, -hh * F4);
                matrix[1].set(2, 1, hh * F3);
                matrix[1].set(2, 2, F1);
                matrix[1].set(2, 3, F2);
                matrix[1].set(3, 0, -hh * F3);
                matrix[1].set(3, 1, -hh * F4);
                matrix[1].set(3, 2, -F2);
                matrix[1].set(3, 3, F1);
            }
            matrix[0] = new Matrix(matrix[0].times(matrix[1]));
        }
        matrix[0] = new Matrix(matrix[0].times(matrix[2]));
        res = Math.sqrt(Math.pow(matrix[0].get(0, 2), 2.0) + Math.pow(matrix[0].get(0, 3), 2.0));
        return res;
    }

    public void setCT(int cT) {
        this.cT = cT == 0 ? 24 : cT;
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public void setDimData(String[][] dimdata) {
        this.dimdata = dimdata;
    }

    public void setFlags(String[][] flags) {
        this.flags = flags;
    }

    public void setRAie(double RAi, double RAe) {
        this.RAi = RAi;
        this.RAe = RAe;
    }

    public void setRAie(float[] RAie) {
        this.RAi = RAie[0];
        this.RAe = RAie[1];
    }
}

