/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.hibernate.cat.dao.HibernateCeb_D1Dao;
import core.hibernate.cat.db.Ceb_D1;
import enercad2007.DM_Zone;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.Map;

public class Calc_Ceb {
    private final String[] DIAM = new String[]{"1/8", "1/4", "3/8", "1/2", "3/4", "1", "1.5", "1.75", "2", "2.5"};
    private final double KCO2STD = 0.05;
    DM_Zone dm_zone = Ecad2007.getDM_Zone(0);
    HibernateCeb_D1Dao hibernateCeb_D1Dao;
    double[] elCH;
    int units = 0;

    public Calc_Ceb() {
    }

    public Calc_Ceb(int units) {
        this.setUnits(units);
    }

    public String[] getDiams() {
        return this.DIAM;
    }

    public double getEnergieAuxiliaireTot(double Ae, double ind_generator_ch, double ind_distrib_ech, double ind_distrib_ch) {
        double res = 0.0;
        res = Ae * (ind_generator_ch + ind_distrib_ech + ind_distrib_ch) / 1000.0;
        return res;
    }

    public double getKCO2Std() {
        return 0.05;
    }

    public double getQls(double lambda, double dext, double dint, double dd, double hh, double length, double dtemp) {
        double res = Math.PI * 2;
        double div = 0.0;
        double ln = 0.0;
        res *= lambda;
        res *= hh;
        res *= 0.001 * (dext / 2.0 + dd);
        ln = Math.log(2.0 * (dext / 2.0 + dd) / dint);
        div = lambda + hh * 0.001 * (dext / 2.0 + dd) * ln;
        res /= div;
        res *= length * dtemp;
        res *= 3.1536E7;
        return res /= Math.pow(10.0, 9.0);
    }

    public double getQtot(double lossQH, double lossQW, double lossQHWgen, double flossQH, double flossQW, double recupQgen) {
        double fap = Ecad2007.getDM_Zone(0).getFap();
        double qw = this.dm_zone.getQww();
        double qh = Ecad2007.getDM_Zone(0).getQh();
        double ae = this.dm_zone.getSRE();
        double c6 = qh * ae / 1000.0;
        double e6 = qw * ae / 1000.0;
        double QHtot = c6 + lossQH;
        double QWtot = e6 + lossQW;
        double c14 = QHtot + QWtot / 2.0;
        double c9 = (double)Math.round(flossQH * 100.0) / 100.0 * lossQH;
        double e9 = (double)Math.round(flossQW * 100.0) / 100.0 * lossQW;
        double c18 = c9 + e9 + recupQgen;
        double c20 = 0.8 * c18 * fap;
        return c14 + lossQHWgen - c20;
    }

    public double getPrimTot(Map<String, Object> map) {
        double prim_tot = 0.0;
        Object object = null;
        double lossQH = Globals.getDoubleValue(map.get("lossQH"));
        double lossQW = Globals.getDoubleValue(map.get("lossQW"));
        double lossQHWgen = Globals.getDoubleValue(map.get("lossQHWgen"));
        double flossQH = Globals.getDoubleValue(map.get("flossQH"));
        double flossQW = Globals.getDoubleValue(map.get("flossQW"));
        double recupQgen = Globals.getDoubleValue(map.get("recupQGen"));
        double qtot = this.getQtot(lossQH, lossQW, lossQHWgen, flossQH, flossQW, recupQgen);
        Globals.println("Calc_Ceb.getPrimTot qtot: " + String.format("%#.1f", qtot));
        double[] part = new double[3];
        double[] fep = new double[3];
        object = map.get("part");
        if (object instanceof double[]) {
            part = (double[])object;
            object = map.get("fep");
            if (object instanceof double[]) {
                fep = (double[])object;
            }
            for (int ii = 0; ii < part.length; ++ii) {
                if (!(part[ii] > 0.0) || !(fep[ii] > 0.0)) continue;
                double prim = qtot * (double)Math.round(fep[ii] * 100.0) * part[ii] / 10000.0;
                prim_tot += prim;
            }
        }
        return prim_tot;
    }

    public double getQWsto(int volume) {
        return 315.0 + 50.0 * Math.pow(volume, 0.6666666666666666);
    }

    public double getQWgen(double eta, double Qw, double Qwsto, double Qwdis) {
        return (1.0 - eta) / eta * (Qw + Qwsto + Qwdis);
    }

    public double getQls(double lambda, String dn, double dd, double hh, double length, double dtemp) {
        double[] diam = this.getDiamExtInt(dn);
        return this.getQls(lambda, diam[0], diam[1], dd, hh, length, dtemp);
    }

    public double[] getDiamExtInt(int dn) {
        double[] res = new double[2];
        int[] DN = new int[]{6, 8, 10, 15, 20, 25, 32, 40, 50, 65};
        double[] dint = new double[]{6.0, 8.0, 10.0, 13.0, 20.0, 25.0, 32.0, 40.0, 50.0, 65.0};
        double[] dext = new double[]{8.0, 10.0, 12.0, 15.0, 22.0, 28.0, 35.0, 43.0, 54.0, 70.0};
        if (dn < 0) {
            return res;
        }
        for (int ii = 0; ii < DN.length; ++ii) {
            if (DN[ii] != dn) continue;
            res = new double[]{dext[ii], dint[ii]};
            break;
        }
        return res;
    }

    public double[] getDiamExtInt(String dn) {
        double[] res = new double[2];
        int[] DN = new int[]{6, 8, 10, 15, 20, 25, 32, 40, 50, 65};
        if (dn == null) {
            return res;
        }
        String diam = dn.trim();
        if (dn.endsWith("''")) {
            diam = dn.substring(0, dn.length() - 1);
        }
        for (int ii = 0; ii < DN.length; ++ii) {
            if (!diam.equals(this.DIAM[ii])) continue;
            res = this.getDiamExtInt(DN[ii]);
            break;
        }
        return res;
    }

    public double getEpStd() {
        int calcMod = Ecad2007.getCalcmod();
        int afp = Ecad2007.getDM_Zone(0).getAFP();
        double[][] EpStd_data = new double[][]{{570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}, {570.0, 540.0, 450.0, 340.0, 530.0, 910.0, 470.0, 620.0, 370.0, 200.0, 680.0, 1240.0}};
        return EpStd_data[calcMod][afp - 1];
    }

    public double getApStd() {
        int calcMod = Ecad2007.getCalcmod();
        int afp = Ecad2007.getDM_Zone(0).getAFP();
        double[][] EpApStd_data = new double[][]{{67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}, {67.0, 47.0, 42.0, 17.0, 22.0, 100.0, 18.0, 76.0, 100.0, 0.0, 4.0, 16.0}};
        return EpApStd_data[calcMod][afp - 1];
    }

    public double getEel() {
        int calcMod = Ecad2007.getCalcmod();
        int afp = Ecad2007.getDM_Zone(0).getAFP();
        double[][] Eel_data = new double[][]{{111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}, {111.0, 101.0, 80.0, 67.0, 272.0, 67.0, 90.0, 72.0, 101.0, 125.0, 74.0, 88.0}};
        return Eel_data[calcMod][afp - 1];
    }

    public double getEev() {
        int calcMod = Ecad2007.getCalcmod();
        int afp = Ecad2007.getDM_Zone(0).getAFP();
        double[][] Eev_data = new double[][]{{7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}, {7.0, 6.0, 15.0, 31.0, 140.0, 159.0, 98.0, 42.0, 98.0, 10.0, 28.0, 111.0}};
        return Eev_data[calcMod][afp - 1];
    }

    public double[] getEletricityCH() {
        if (this.elCH == null) {
            if (this.hibernateCeb_D1Dao == null) {
                this.hibernateCeb_D1Dao = new HibernateCeb_D1Dao();
            }
            Ceb_D1 ceb_D1 = this.hibernateCeb_D1Dao.getCeb_D1("4,1");
            this.elCH = new double[3];
            if (ceb_D1 != null) {
                this.elCH[0] = ceb_D1.getFep();
                this.elCH[1] = ceb_D1.getFren();
                this.elCH[2] = ceb_D1.getKco2();
            }
        }
        return this.elCH;
    }

    public double getEstimatedLoss(double qhw, double nn) {
        double res = 0.0;
        res = (1.0 - nn) / nn;
        return res *= qhw;
    }

    public void setAutoRefresh(boolean b_refresh) {
        if (this.dm_zone != null) {
            if (b_refresh) {
                this.dm_zone.addFlag(8);
            } else {
                this.dm_zone.removeFlag(8);
            }
        }
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int units) {
        if (units == 1) {
            if (this.dm_zone == null) {
                this.dm_zone = new DM_Zone(0, 0);
            }
            this.dm_zone.setUnits(0, true);
            this.dm_zone.getCalcZone(0);
        } else {
            this.dm_zone = Ecad2007.getDM_Zone(0);
        }
    }
}

