/*
 * Decompiled with CFR 0.152.
 */
package core;

import enercad2007.DM_Met;
import enercad2007.DM_Zone;
import enercad2007.Ecad2007;

public class Calc_Solar {
    final double[][] couv_x = new double[][]{{0.184, -0.764, 1.035}, {0.243, -0.054, 0.0}};
    final double[][] couv_c = new double[][]{{-1.098, 3.707, -2.832}, {0.19, 0.09, 0.0}};
    final double[][] ncouv_x = new double[][]{{0.1812, -0.6737, 0.8004}, {0.177, -0.025}};
    final double[][] ncouv_c = new double[][]{{-0.741, 2.7115, -2.7212}, {-0.256, 0.07}};
    double[] qww;
    double[] ecsqs;
    double[] ecsqsu;
    double[] ecsqsnu;
    double[] ecsn;
    double[] ecs_ge;
    double fu = 1.0;
    final double[][] VARS = new double[][]{{-1.925, 0.7523, 0.01266, 0.0077, 0.3124, -4.0088}, {-3.34, 0.7209, 0.0555, -0.01177, 0.0, 0.0}};

    public void setUnit(int unit) {
        boolean b_refresh = false;
        if (Ecad2007.getIntCalcmod() < 7) {
            if (unit == 0) {
                if (this.fu != 1.0) {
                    b_refresh = true;
                }
                this.fu = 1.0;
            } else if (unit == 1) {
                if (this.fu == 1.0) {
                    b_refresh = true;
                }
                this.fu = 0.2777777777777778;
            }
        } else {
            this.fu = 0.2777777777777778;
        }
        if (b_refresh) {
            this.qww = null;
            this.ecsqs = null;
            this.ecsqsu = null;
            this.ecsqsnu = null;
            this.ecsn = null;
            this.ecs_ge = null;
        }
    }

    public double[] getECSProductionUtile(boolean cn, int paz, int inc, double acs, double sr) {
        this.ecsqsu = new double[13];
        double[] qww = this.getQww(Ecad2007.getDM_Zone(0).getAE());
        this.ecsqs = this.getECSQs(cn, paz, inc, acs, sr);
        for (int ii = 0; ii < 12; ++ii) {
            this.ecsqsu[ii] = qww[ii] < this.ecsqs[ii] ? qww[ii] : this.ecsqs[ii];
            this.ecsqsu[12] = this.ecsqsu[12] + this.ecsqsu[ii];
        }
        return this.ecsqsu;
    }

    public double[] getECSProductionUtile() {
        this.ecsqsu = new double[13];
        this.qww = this.getQww();
        for (int ii = 0; ii < 12; ++ii) {
            this.ecsqsu[ii] = this.qww[ii] < this.ecsqs[ii] ? this.qww[ii] : this.ecsqs[ii];
            this.ecsqsu[12] = this.ecsqsu[12] + this.ecsqsu[ii];
        }
        return this.ecsqsu;
    }

    public double[] getECSProductionNonUtilisable(boolean cn, int paz, int inc, double acs, double sr) {
        this.ecsqsnu = new double[13];
        this.ecsqs = this.getECSQs(cn, paz, inc, acs, sr);
        this.ecsqsu = this.getECSProductionUtile(cn, paz, inc, acs, sr);
        for (int ii = 0; ii < 12; ++ii) {
            this.ecsqsnu[ii] = this.ecsqs[ii] - this.ecsqsu[ii];
            this.ecsqsnu[12] = this.ecsqsnu[12] + this.ecsqsnu[ii];
        }
        return this.ecsqsnu;
    }

    public double[] getECSProductionNonUtilisable() {
        this.ecsqsnu = new double[13];
        for (int ii = 0; ii < 12; ++ii) {
            this.ecsqsnu[ii] = this.ecsqs[ii] - this.ecsqsu[ii];
            this.ecsqsnu[12] = this.ecsqsnu[12] + this.ecsqsnu[ii];
        }
        return this.ecsqsnu;
    }

    public double[] getECSRendement(double acs) {
        this.ecsn = new double[13];
        for (int ii = 0; ii < 13; ++ii) {
            this.ecsn[ii] = this.ecsqsu[ii] / acs / this.ecs_ge[ii];
        }
        return this.ecsn;
    }

    public double[] getECSQs(boolean cn, int paz, int inc, double acs, double sr) {
        this.ecsqs = new double[13];
        this.ecs_ge = new double[13];
        double xx = 0.0;
        double cc = 0.0;
        DM_Met dm_met = Ecad2007.getDM_Met();
        double[] ge = dm_met.getG_E(Math.toRadians(paz), Math.toRadians(inc));
        int[] jj = dm_met.getJ();
        if (cn) {
            if (sr < 2.0) {
                xx = this.couv_x[0][0] * Math.pow(sr, 2.0) + this.couv_x[0][1] * sr + this.couv_x[0][2];
                cc = this.couv_c[0][0] * Math.pow(sr, 2.0) + this.couv_c[0][1] * sr + this.couv_c[0][2];
            } else {
                xx = this.couv_x[1][0] - this.couv_x[1][1] * (sr - 2.0);
                cc = this.couv_c[1][0] + this.couv_c[1][1] * (sr - 2.0);
            }
        } else if (sr < 2.0) {
            xx = this.ncouv_x[0][0] * Math.pow(sr, 2.0) + this.ncouv_x[0][1] * sr + this.ncouv_x[0][2];
            cc = this.ncouv_c[0][0] * Math.pow(sr, 2.0) + this.ncouv_c[0][1] * sr + this.ncouv_c[0][2];
        } else {
            xx = this.ncouv_x[1][0] - this.ncouv_x[1][1] * (sr - 2.0);
            cc = this.ncouv_c[1][0] + this.ncouv_c[1][1] * (sr - 2.0);
        }
        for (int ii = 0; ii < 12; ++ii) {
            this.ecs_ge[ii] = ge[ii] * this.fu;
            this.ecsqs[ii] = (xx * ge[ii] / (double)jj[ii] + cc) * (double)jj[ii] * acs;
            int n = ii;
            this.ecsqs[n] = this.ecsqs[n] * this.fu;
            this.ecs_ge[12] = this.ecs_ge[12] + this.ecs_ge[ii];
            this.ecsqs[12] = this.ecsqs[12] + this.ecsqs[ii];
        }
        return this.ecsqs;
    }

    public double[] getQww() {
        return this.getQww(Ecad2007.getDM_Zone(0).getAE());
    }

    public double[] getQww(double ae) {
        this.qww = new double[13];
        DM_Zone dm_zone = Ecad2007.getDM_Zone(0);
        double qw = dm_zone.getQww();
        DM_Met dm_met = Ecad2007.getDM_Met();
        int[] jj = dm_met.getJ();
        for (int ii = 0; ii < 12; ++ii) {
            this.qww[ii] = qw * ae * (double)jj[ii] / 365.0 * this.fu;
            this.qww[12] = this.qww[12] + this.qww[ii];
        }
        return this.qww;
    }

    public double[] getQe() {
        double[] qee = new double[13];
        DM_Zone dm_zone = Ecad2007.getDM_Zone(0);
        double qe = dm_zone.getQEJ();
        DM_Met dm_met = Ecad2007.getDM_Met();
        int[] jj = dm_met.getJ();
        for (int ii = 0; ii < 12; ++ii) {
            qee[ii] = qe * (double)jj[ii] / 365.0 * this.fu;
        }
        qee[12] = qe;
        return qee;
    }

    public double[] getPVProduction(double paz, double inc, double acs, double pv_factor) {
        double[] pv_prod = new double[13];
        DM_Met dm_met = Ecad2007.getDM_Met();
        double[] ge = dm_met.getG_E(paz, inc);
        for (int ii = 0; ii < 12; ++ii) {
            pv_prod[ii] = ge[ii] * acs * pv_factor * this.fu;
            pv_prod[12] = pv_prod[12] + pv_prod[ii];
        }
        return pv_prod;
    }

    public double[] getECSTc() {
        double ecstcpy = 0.0;
        double ecstcps = 0.0;
        DM_Met dm_met = Ecad2007.getDM_Met();
        int[] jj = dm_met.getJ();
        int dayspy = 0;
        int daysps = 0;
        for (int ii = 0; ii < 12; ++ii) {
            ecstcpy += this.ecsqsu[ii] / this.qww[ii] * (double)jj[ii];
            dayspy += jj[ii];
            if (ii < 4 || ii > 8) continue;
            ecstcps += this.ecsqsu[ii] / this.qww[ii] * (double)jj[ii];
            daysps += jj[ii];
        }
        return new double[]{ecstcpy / (double)dayspy, ecstcps / (double)daysps};
    }

    public double[][] getQSc(boolean cn, double paz, double inc, double acs, double ae) {
        double[][] qsc = new double[4][13];
        double TI = Ecad2007.getDM_Zone(0).getTI();
        double[] TE = Ecad2007.getDM_Met().getTE();
        double TDIST = Ecad2007.getDM_Zone(0).getTH1();
        int i_cn = 0;
        if (!cn) {
            i_cn = 1;
        }
        DM_Met dm_met = Ecad2007.getDM_Met();
        double[] g_e = dm_met.getG_E(paz, inc);
        int[] jj = dm_met.getJ();
        double[] qh = this.getQh(ae);
        double f_qh = 1.0;
        if (Ecad2007.getCalcmod() < 7) {
            f_qh = this.fu;
        }
        for (int ii = 0; ii < 12; ++ii) {
            double dT = TE[ii] * (TI - TDIST) / TI + TDIST - TE[ii];
            qsc[0][ii] = Math.max((this.VARS[i_cn][0] + this.VARS[i_cn][1] * g_e[ii] / (double)jj[ii] + this.VARS[i_cn][2] * dT - this.VARS[i_cn][3] * dT * g_e[ii] / (double)jj[ii]) * (double)jj[ii] * acs, 0.0);
            double[] dArray = qsc[0];
            dArray[12] = dArray[12] + qsc[0][ii];
            if (Ecad2007.getCalcmod() < 7) {
                qsc[2][ii] = Math.max((g_e[ii] / (double)jj[ii] * this.VARS[i_cn][4] + this.VARS[i_cn][5]) * (double)jj[ii] * acs, 0.0);
            } else {
                qsc[2][ii] = Math.max((g_e[ii] * 3.6 / (double)jj[ii] * this.VARS[i_cn][4] + this.VARS[i_cn][5]) * (double)jj[ii] * acs, 0.0);
                double[] dArray2 = qsc[2];
                int n = ii;
                dArray2[n] = dArray2[n] * 0.2777777777777778;
            }
            double[] dArray3 = qsc[2];
            dArray3[12] = dArray3[12] + qsc[2][ii];
            qsc[1][ii] = Math.min(qsc[0][ii], qh[ii]);
            double[] dArray4 = qsc[1];
            dArray4[12] = dArray4[12] + qsc[1][ii];
            qsc[3][ii] = qsc[0][ii] - qsc[1][ii];
            double[] dArray5 = qsc[3];
            dArray5[12] = dArray5[12] + qsc[3][ii];
        }
        return qsc;
    }

    public double[][] getQSc(boolean cn, double paz, double inc, double acs) {
        return this.getQSc(cn, paz, inc, acs, 1.0);
    }

    public double[] getQh(double ae) {
        double[] qh = new double[13];
        double[] qhm = Ecad2007.getDM_Zone(0).getQhM();
        double sre = Ecad2007.getDM_Zone(0).getAE();
        for (int ii = 0; ii < qhm.length; ++ii) {
            qh[ii] = qhm[ii] * ae / sre;
            qh[12] = qh[12] + qh[ii];
        }
        return qh;
    }
}

