/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Matrix;
import core.hibernate.pro.db.Envelope;
import enercad2007.DM_Element;
import enercad2007.DMpr_Comp;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Calculation {
    Object[][] data;
    String[][] flags;
    String[][] dimdata;
    double RAi;
    double RAe;
    int cT;

    public Map<String, Object[]> createEcoList(int idZ) {
        DM_Element dm_element = Ecad2007.getDM_Element(idZ);
        if (dm_element == null) {
            Ecad2007.setDM_Element(idZ, new DM_Element(idZ));
        }
        DMpr_Comp dmpr_comp = Ecad2007.getDMpr_Comp();
        Map<String, String[]> dataM4P = dmpr_comp.getDataM4P();
        TreeMap<String, Object[]> tm = new TreeMap<String, Object[]>(new EcoListComparator(dataM4P));
        Map<Integer, Envelope> elements = dm_element.getElementData();
        for (Envelope element : elements.values()) {
            String id_c = element.getId_c();
            if (!Globals.isBitwiseEquals(id_c, "15,1,127,3")) continue;
            double a_e = element.getA_e();
            double num_e = element.getNum_e();
            Object[] component = dmpr_comp.getComponent(id_c);
            TreeMap<String, String> tm_r2pr = dmpr_comp.getRef2ProvRef();
            if (dataM4P == null || component == null) continue;
            int n_lay = Globals.getIntValue(component[0]);
            double d1_c = Globals.getDoubleValue(component[7]);
            double d2_c = Globals.getDoubleValue(component[8]);
            Object[][] comp = (Object[][])component[10];
            String[][] dds = (String[][])component[11];
            for (int ii = 0; ii < n_lay; ++ii) {
                String[] m4_2;
                String ref_m4 = (String)comp[ii][2];
                String ref_m4_2 = (String)comp[ii][5];
                double dd = Globals.getDoubleValue(dds[ii][0]);
                if (ref_m4 == null || ref_m4_2 == null || !(dd > 0.0)) continue;
                String[] m4 = dataM4P.get(ref_m4);
                if (m4 == null) {
                    m4 = dataM4P.get(tm_r2pr.get(ref_m4));
                    ref_m4 = tm_r2pr.get(ref_m4);
                }
                if ((m4_2 = dataM4P.get(ref_m4_2)) == null) {
                    m4_2 = dataM4P.get(tm_r2pr.get(ref_m4_2));
                    ref_m4_2 = tm_r2pr.get(ref_m4_2);
                }
                String ref = ref_m4;
                int limit = 1;
                if (d2_c > 0.0) {
                    limit = 2;
                }
                for (int jj = 0; jj < limit; ++jj) {
                    String[] mm = (String[])m4.clone();
                    double d_c = d1_c;
                    Object[] objects = new Object[8];
                    if (jj == 1) {
                        ref = ref_m4_2;
                        mm = (String[])m4_2.clone();
                        d_c = d2_c;
                    }
                    objects[0] = mm[Ecad2007.getCodeLan()];
                    double rho = Globals.getDoubleValue(mm[8]);
                    objects[3] = rho;
                    objects[4] = Globals.getDoubleValue(mm[14]);
                    objects[5] = Globals.getDoubleValue(mm[15]);
                    objects[6] = Globals.getDoubleValue(mm[16]);
                    objects[7] = ref;
                    double vol = a_e * num_e * d_c * Globals.getDoubleValue(dd) / 100.0;
                    objects[1] = vol;
                    objects[2] = vol * rho;
                    if (tm.get(ref) == null) {
                        tm.put(ref, objects);
                        continue;
                    }
                    Object[] objs = tm.get(ref);
                    double vv = Globals.getDoubleValue(objs[1]);
                    double pp = Globals.getDoubleValue(objs[2]);
                    objects[1] = vv += vol;
                    objects[2] = pp += vol * rho;
                }
            }
        }
        return tm;
    }

    private int getCoucheChByFlags() {
        int res = -1;
        int flag = 0;
        for (int ii = 0; ii < this.flags.length; ++ii) {
            if (this.flags[ii][0] == null || this.flags[ii][0].equals("") || this.flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.flags[ii][0])) & 0x10) != 16) continue;
            res = ii;
            break;
        }
        return res;
    }

    private int getCoucheStByFlags() {
        int res = -1;
        int flag = 0;
        for (int ii = 0; ii < this.flags.length; ++ii) {
            if (this.flags[ii][0] == null || this.flags[ii][0].equals("") || this.flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.flags[ii][0])) & 0x20) != 32) continue;
            res = ii;
            break;
        }
        return res;
    }

    public String[][] getFlags() {
        return this.flags;
    }

    private double getRAirLayer(long flag, double dd) {
        double res = 0.0;
        double[] dlayer = new double[]{0.5, 0.7, 1.0, 1.5, 2.5, 5.0, 10.0, 30.0};
        double[] asc = new double[]{0.11, 0.13, 0.15, 0.16, 0.16, 0.16, 0.16, 0.16};
        double[] hor = new double[]{0.11, 0.13, 0.15, 0.17, 0.18, 0.18, 0.18, 0.18};
        double[] desc = new double[]{0.11, 0.13, 0.15, 0.17, 0.19, 0.21, 0.22, 0.23};
        int pos = 0;
        int cter = 0;
        while (cter < dlayer.length && dd >= dlayer[cter] / 100.0) {
            pos = cter++;
        }
        if ((flag & 1L) == 1L) {
            res = asc[pos];
        } else if ((flag & 2L) == 2L) {
            res = hor[pos];
        } else if ((flag & 4L) == 4L) {
            res = desc[pos];
        }
        return res;
    }

    public double getRMoy(double[] rsdim, int nlay) {
        return this.getRMoy(rsdim, -1, -1, nlay);
    }

    public double getRMoy(double[] rsdim, int coucheCh, int coucheSt, int nlay) {
        double res = 0.0;
        double p1_c = 0.0;
        double p2_c = 0.0;
        float kch = 1.0f;
        float kst = 1.0f;
        double sum_d = 0.0;
        double sum_r1 = this.RAe;
        double sum_r2 = this.RAe;
        double rinf = this.RAe;
        double rsup = 0.0;
        double rmoy = 0.0;
        double dimtmp = 0.0;
        double rtmp = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        if (this.data == null) {
            return -1.0;
        }
        p1_c = rsdim[0] / (rsdim[0] + rsdim[1]);
        p2_c = 1.0 - p1_c;
        if (this.flags != null) {
            coucheCh = this.getCoucheChByFlags();
            coucheSt = this.getCoucheStByFlags();
        }
        for (int cter = 0; cter < nlay; ++cter) {
            dimtmp = Globals.getDoubleValue(this.dimdata[cter][0]) < 0.0 ? Globals.getDoubleValue(this.dimdata[cter][1]) / 100.0 : Globals.getDoubleValue(this.dimdata[cter][0]) / 100.0;
            sum_d += dimtmp;
            if (coucheCh == -1) {
                kch = 1.0f;
            } else if (cter < coucheCh) {
                kch = 1.0f;
            } else if (cter == coucheCh) {
                kch = 0.5f;
            } else if (cter > coucheCh) {
                kch = 0.0f;
            }
            r1 = this.data[cter][1] == null ? 0.0 : (((String)this.data[cter][1]).equals("") ? 0.0 : dimtmp / Globals.getDoubleValue(this.data[cter][1]) * (double)kch * (double)kst);
            r2 = this.data[cter][6] == null ? 0.0 : (((String)this.data[cter][6]).equals("") ? 0.0 : dimtmp / Globals.getDoubleValue(this.data[cter][6]) * (double)kch * (double)kst);
            if (p1_c > 0.0) {
                sum_r1 += r1;
            }
            if (p2_c > 0.0) {
                sum_r2 += r2;
            }
            rtmp = p1_c > 0.0 && r1 > 0.0 && p2_c > 0.0 && r2 > 0.0 ? 1.0 / (p1_c / r1 + p2_c / r2) : (p1_c > 0.0 && p2_c == 0.0 ? r1 : (p1_c == 0.0 && p2_c > 0.0 ? r2 : 0.0));
            rinf += rtmp;
        }
        if (coucheCh < 0) {
            sum_r1 += this.RAi;
            sum_r2 += this.RAi;
            rinf += this.RAi;
        }
        rsup = p1_c > 0.0 && sum_r1 > 0.0 && p2_c > 0.0 && sum_r2 > 0.0 ? 1.0 / (p1_c / sum_r1 + p2_c / sum_r2) : (p1_c > 0.0 && p2_c == 0.0 ? sum_r1 : (p1_c == 0.0 && p2_c > 0.0 ? sum_r2 : 0.0));
        res = rmoy = (rinf + rsup) / 2.0;
        return res;
    }

    public double getRmoyAvecPontThermique(double RmoySansPt, double valPT, double numPT) {
        double Umoy = 1.0 / RmoySansPt;
        double res = 1.0 / (Umoy + numPT * valPT);
        return res;
    }

    public double getRelativeHumidity(double Tex) {
        double res = 0.0;
        res = Tex > 20.0 ? 0.8 : (Tex <= 20.0 && Tex > 10.0 ? 0.63 : (Tex <= 10.0 && Tex > -20.0 ? 0.5 : 0.4));
        return res;
    }

    public double getRmoyD(String type, int nlay) {
        double res = 0.0;
        Matrix[] matrix = new Matrix[3];
        matrix[0] = new Matrix(4, 4);
        matrix[2] = new Matrix(4, 4);
        double RR = 0.0;
        double dd = 0.0;
        double lambda = 0.0;
        double rho = 0.0;
        double cc = 0.0;
        double bb = 0.0;
        double hh = 0.0;
        double zz = 0.0;
        boolean b_air = false;
        for (int ii = 0; ii < 4; ++ii) {
            for (int jj = 0; jj < 4; ++jj) {
                if (ii == jj) {
                    matrix[2].set(ii, jj, 1);
                    matrix[0].set(ii, jj, 1);
                    continue;
                }
                matrix[2].set(ii, jj, 0);
                matrix[0].set(ii, jj, 0);
            }
        }
        if (type.equals("0") || type.equals("1")) {
            matrix[2].set(0, 2, this.RAe);
            matrix[2].set(1, 3, this.RAe);
            matrix[0].set(0, 2, this.RAi);
            matrix[0].set(1, 3, this.RAi);
        } else {
            matrix[2].set(0, 2, this.RAi);
            matrix[2].set(1, 3, this.RAi);
            matrix[0].set(0, 2, this.RAe);
            matrix[0].set(1, 3, this.RAe);
        }
        for (int cter = nlay - 1; cter >= 0; --cter) {
            int flagInt;
            b_air = false;
            matrix[1] = new Matrix(4, 4);
            if (this.dimdata[cter][1] == null) break;
            dd = this.dimdata[cter][1].equals("-1") ? Globals.getDoubleValue(this.dimdata[cter][0].trim()) / 100.0 : Globals.getDoubleValue(this.dimdata[cter][1].trim()) / 100.0;
            if (this.flags[cter] != null && this.flags[cter][0] != null && ((flagInt = Globals.getIntValue(this.flags[cter][0])) & 8) == 8) {
                b_air = true;
            }
            if (!((String)this.data[cter][1]).trim().equals("")) {
                lambda = Globals.getDoubleValue(this.data[cter][1]);
                cc = Globals.getDoubleValue(this.data[cter][2]);
                rho = Globals.getDoubleValue(this.data[cter][3]);
            } else {
                lambda = 0.0;
                cc = 0.0;
                rho = 0.0;
            }
            if (b_air) {
                double rr = this.getRAirLayer(Globals.getLongValue(this.flags[cter][0]), dd);
                for (int ii = 0; ii < 4; ++ii) {
                    for (int jj = 0; jj < 4; ++jj) {
                        if (ii != jj) continue;
                        matrix[1].set(ii, jj, 1);
                    }
                }
                matrix[1].set(0, 2, rr);
                matrix[1].set(1, 3, rr);
            } else if (cc == 0.0) {
                for (int ii = 0; ii < 4; ++ii) {
                    for (int jj = 0; jj < 4; ++jj) {
                        if (ii != jj) continue;
                        matrix[1].set(ii, jj, 1);
                    }
                }
                matrix[1].set(0, 2, dd / lambda);
                matrix[1].set(1, 3, dd / lambda);
            } else {
                RR = dd / lambda;
                bb = Math.sqrt(lambda * rho * cc);
                hh = Math.sqrt(Math.PI / (double)this.cT) * bb;
                zz = hh * RR;
                double chz = 0.5 * (Math.exp(zz) + Math.exp(-zz));
                double shz = 0.5 * (Math.exp(zz) - Math.exp(-zz));
                double F1 = chz * Math.cos(zz);
                double F2 = shz * Math.sin(zz);
                double F3 = chz * Math.sin(zz) + shz * Math.cos(zz);
                double F4 = chz * Math.sin(zz) - shz * Math.cos(zz);
                matrix[1].set(0, 0, F1);
                matrix[1].set(0, 1, F2);
                matrix[1].set(0, 2, F3 / (2.0 * hh));
                matrix[1].set(0, 3, F4 / (2.0 * hh));
                matrix[1].set(1, 0, -F2);
                matrix[1].set(1, 1, F1);
                matrix[1].set(1, 2, -F4 / (2.0 * hh));
                matrix[1].set(1, 3, F3 / (2.0 * hh));
                matrix[1].set(2, 0, -hh * F4);
                matrix[1].set(2, 1, hh * F3);
                matrix[1].set(2, 2, F1);
                matrix[1].set(2, 3, F2);
                matrix[1].set(3, 0, -hh * F3);
                matrix[1].set(3, 1, -hh * F4);
                matrix[1].set(3, 2, -F2);
                matrix[1].set(3, 3, F1);
            }
            matrix[0] = new Matrix(matrix[0].times(matrix[1]));
        }
        matrix[0] = new Matrix(matrix[0].times(matrix[2]));
        res = Math.sqrt(Math.pow(matrix[0].get(0, 2), 2.0) + Math.pow(matrix[0].get(0, 3), 2.0));
        return res;
    }

    public void setCT(int cT) {
        this.cT = cT == 0 ? 24 : cT;
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public void setDimData(String[][] dimdata) {
        this.dimdata = dimdata;
    }

    public String[][] getDimData() {
        return this.dimdata;
    }

    public void setFlags(String[][] flags) {
        this.flags = flags;
    }

    public void setRAie(double RAi, double RAe) {
        this.RAi = RAi;
        this.RAe = RAe;
    }

    public void setRAie(float[] RAie) {
        this.RAi = RAie[0];
        this.RAe = RAie[1];
    }

    public Map getCompFen(double uf, double ug, double ff, double fc, double g, double ui, double lr) {
        HashMap<String, Double> map = new HashMap<String, Double>(5);
        double u = uf * ff + ug * (1.0 - ff) + ui * lr;
        map.put("U", new Double(u));
        map.put("FR", new Double((1.0 - fc) * g * (1.0 - ff)));
        if (uf * ff == 0.0) {
            map.put("PF", new Double(0.0));
        } else {
            map.put("PF", new Double(uf * ff / u * 100.0));
        }
        if (ug * (1.0 - ff) == 0.0) {
            map.put("PG", new Double(0.0));
        } else {
            map.put("PG", new Double(ug * (1.0 - ff) / u * 100.0));
        }
        if (ui * lr == 0.0) {
            map.put("PI", new Double(0.0));
        } else {
            map.put("PI", new Double(ui * lr / u * 100.0));
        }
        return map;
    }

    class EcoListComparator
    implements Comparator,
    Serializable {
        Map<String, String[]> map;

        public EcoListComparator(Map<String, String[]> map) {
            this.map = map;
        }

        public int compare(Object o1, Object o2) {
            String[] strings;
            int res = 0;
            String value1 = null;
            String value2 = null;
            if (o1 instanceof String && (strings = this.map.get(o1)) != null) {
                value1 = strings[Ecad2007.getCodeLan()];
            }
            if (o2 instanceof String && (strings = this.map.get(o2)) != null) {
                value2 = strings[Ecad2007.getCodeLan()];
            }
            if (value1 != null && value2 != null) {
                res = value1.compareTo(value2);
            }
            return res;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EcoListComparator;
        }
    }
}

