/*
 * Decompiled with CFR 0.152.
 */
package core;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class Config {
    boolean b_valid = false;
    private String fileName;
    private File file;
    private InputStream inputStream;
    private DocumentBuilder builder;
    private Document xmlDocument;
    private XPath xPath;
    private Element root;

    public static void main(String[] argv) {
        Config dd = null;
        try {
            dd = new Config(argv[0]);
            Globals.println("nt = " + dd.getPropertyDouble("constants", "lambdaDL"));
            Globals.println("dir = " + dd.getPropertyString("properties", "dir", new String[]{"c2", "plan"}));
            dd.setPropertyString("properties", "url", new String[]{"int"}, "33");
        }
        catch (IllegalArgumentException iaex) {
            Ecad2007.trace(iaex);
            iaex.printStackTrace(System.out);
        }
    }

    public Config(String fileName) {
        this.fileName = fileName;
        this.file = new File(fileName);
        this.createDocument();
    }

    public Config(File file) {
        this.file = file;
        if (file != null) {
            this.fileName = file.getAbsolutePath();
            this.createDocument();
        }
    }

    public Config(InputStream inputStream) {
        this.inputStream = inputStream;
        if (inputStream != null) {
            this.createDocument();
        }
    }

    private void createDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            this.builder = factory.newDocumentBuilder();
            if (this.inputStream != null) {
                this.xmlDocument = this.builder.parse(this.inputStream);
            } else if (this.fileName != null) {
                this.xmlDocument = this.builder.parse(new File(this.fileName));
            } else {
                return;
            }
            this.xmlDocument.getDocumentElement().normalize();
            this.root = this.xmlDocument.getDocumentElement();
            this.xPath = XPathFactory.newInstance().newXPath();
            this.b_valid = true;
        }
        catch (ParserConfigurationException pcex) {
            Globals.println("Config: Failed to create DOM document: " + pcex);
        }
        catch (SAXException saxex) {
            Globals.println("Config: Failed to read xml file: " + this.fileName);
        }
        catch (IOException ioex) {
            Globals.println("Config.createDocument: Failed to read xml file: " + ioex);
        }
    }

    private void writeFile(String fileName) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            if (Globals.getStringValue(System.getProperty("debug")).equals("-6")) {
                NodeList nodelist = this.xmlDocument.getChildNodes();
                boolean b_xslt = false;
                for (int cter = 0; cter < nodelist.getLength(); ++cter) {
                    Node node = nodelist.item(cter);
                    if (!node.getNodeName().equals("xml-stylesheet")) continue;
                    b_xslt = true;
                    break;
                }
                String fnr = fileName.substring(0, fileName.lastIndexOf("."));
                if (!b_xslt) {
                    ProcessingInstruction pi = this.xmlDocument.createProcessingInstruction("xml-stylesheet", "href=\"" + fnr + ".xsl\" type=\"text/xsl\"");
                    this.xmlDocument.insertBefore(pi, this.root);
                }
                transformer.setOutputProperty("doctype-system", fnr + ".dtd");
                transformer.transform(new DOMSource(this.xmlDocument), new StreamResult(fileName));
            } else {
                transformer.transform(new DOMSource(this.root), new StreamResult(fileName));
            }
        }
        catch (TransformerConfigurationException tcex) {
            System.err.println("Failed to create transformer factory:" + tcex);
        }
        catch (TransformerException tex) {
            System.err.println("Failed to transform DOM tree:" + tex);
        }
    }

    public boolean addPropertyString(String section, String key, String[] attributes, String value) {
        boolean b_res = false;
        NodeList nl = this.xmlDocument.getElementsByTagName(section);
        NodeList nlch = nl.item(0).getChildNodes();
        if (b_res) {
            this.writeFile(this.fileName);
        }
        return b_res;
    }

    public int[] getIMFOrders() {
        int[] res = new int[]{0, 0, 0};
        res[0] = this.getPropertyInt("properties", "liste", new String[]{"floor"});
        res[1] = this.getPropertyInt("properties", "liste", new String[]{"front"});
        res[2] = this.getPropertyInt("properties", "liste", new String[]{"roof"});
        return res;
    }

    public Map<String, String> getProperties(String section, String key) {
        HashMap<String, String> map = new HashMap<String, String>(20);
        NodeList nl = this.xmlDocument.getElementsByTagName(section);
        NodeList nlch = nl.item(0).getChildNodes();
        for (int ii = 0; ii < nlch.getLength(); ++ii) {
            Node node = nlch.item(ii);
            NamedNodeMap att = node.getAttributes();
            if (node.getChildNodes().getLength() <= 0 || !node.getNodeName().equals(key)) continue;
            for (int jj = 0; jj < att.getLength(); ++jj) {
                Node attnode = att.item(jj);
                map.put(attnode.getNodeValue(), node.getFirstChild().getNodeValue().trim().replaceAll("&#92;", "\\\\"));
            }
        }
        return map;
    }

    public Set<String> getValueListFromAttr(String[] keys, String attribute, QName xpathconstants) {
        TreeSet<String> set = new TreeSet<String>();
        Set<String> res = null;
        if (keys == null) {
            return res;
        }
        if (keys.length == 0) {
            return res;
        }
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = this.inputStream.read(buffer)) > 0) {
                System.out.println(read);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return set;
    }

    public double getPropertyDouble(String section, String key) {
        return this.getPropertyDouble(section, key, null);
    }

    public double getPropertyDouble(String section, String key, String[] attributes) {
        String[] keys = new String[]{section, key};
        Object object = this.getPropertyObject(keys, attributes, XPathConstants.NUMBER);
        return Globals.getDoubleValue(object);
    }

    public double getPropertyDouble(String[] keys, Map<String, String> attr) {
        Object object = this.getPropertyObject(keys, attr, XPathConstants.NUMBER);
        return Globals.getDoubleValue(object);
    }

    public int getPropertyInt(String section, String key) {
        return this.getPropertyInt(section, key, null);
    }

    public int getPropertyInt(String section, String key, String[] attributes) {
        String[] keys = new String[]{section, key};
        Object object = this.getPropertyObject(keys, attributes, XPathConstants.NUMBER);
        return Globals.getIntValue(object);
    }

    public int getPropertyInt(String[] keys, Map<String, String> attr) {
        Object object = this.getPropertyObject(keys, attr, XPathConstants.NUMBER);
        return Globals.getIntValue(object);
    }

    private Object getPropertyObject(String[] keys, Map<String, String> attr, QName xpathconstants) {
        Object res = null;
        if (keys == null) {
            return res;
        }
        if (keys.length == 0) {
            return res;
        }
        String expression = "//" + keys[0];
        for (int ii = 1; ii < keys.length; ++ii) {
            expression = expression + "/" + keys[ii];
        }
        if (attr != null) {
            for (String key : attr.keySet()) {
                String value = attr.get(key);
                expression = expression + "[@" + key + "='" + value + "']";
            }
        }
        if (xpathconstants.equals(XPathConstants.NUMBER)) {
            expression = "number(" + expression + ")";
        } else if (xpathconstants.equals(XPathConstants.STRING)) {
            expression = "string(" + expression + ")";
        }
        try {
            XPathExpression xPathExpression = this.xPath.compile(expression);
            res = xPathExpression.evaluate(this.root, xpathconstants);
            System.out.println("core.Config.setPropertyString object: " + res);
        }
        catch (XPathExpressionException xpeex) {
            System.out.println("core.Config.getPropertyObject XPathExpressionException: " + xpeex.getMessage());
        }
        return res;
    }

    private Object getPropertyObject(String[] keys, String[] a_values, QName xpathconstants) {
        int ii;
        Object res = null;
        if (keys == null) {
            return res;
        }
        if (keys.length == 0) {
            return res;
        }
        String expression = "//" + keys[0];
        for (ii = 1; ii < keys.length; ++ii) {
            expression = expression + "/" + keys[ii];
        }
        if (a_values != null) {
            for (ii = 0; ii < a_values.length; ++ii) {
                expression = expression + "[@*='" + a_values[ii] + "']";
            }
        }
        if (xpathconstants.equals(XPathConstants.NUMBER)) {
            expression = "number(" + expression + ")";
        } else if (xpathconstants.equals(XPathConstants.STRING)) {
            expression = "string(" + expression + ")";
        }
        try {
            if (this.xPath == null) {
                return null;
            }
            XPathExpression xPathExpression = this.xPath.compile(expression);
            res = xPathExpression.evaluate(this.root, xpathconstants);
        }
        catch (XPathExpressionException xpeex) {
            System.out.println("core.Config.getPropertyObject XPathExpressionException: " + xpeex.getMessage());
        }
        return res;
    }

    private boolean setPropertyObject(String[] keys, Map<String, String> attr, Object value) {
        boolean b_res = false;
        if (keys == null) {
            return b_res;
        }
        if (keys.length == 0) {
            return b_res;
        }
        if (value == null) {
            return b_res;
        }
        String expression = "//" + keys[0];
        for (int ii = 1; ii < keys.length; ++ii) {
            expression = expression + "/" + keys[ii];
        }
        if (attr != null) {
            for (String key : attr.keySet()) {
                String val = attr.get(key);
                expression = expression + "[@" + key + "='" + val + "']";
            }
        }
        try {
            XPathExpression xPathExpression = this.xPath.compile(expression);
            Object node = xPathExpression.evaluate(this.root, XPathConstants.NODE);
            if (node != null) {
                ((Node)node).setTextContent(value.toString());
                b_res = true;
            }
        }
        catch (XPathExpressionException xpeex) {
            System.out.println("core.Config.getPropertyObject XPathExpressionException: " + xpeex.getMessage());
        }
        if (b_res) {
            this.writeFile(this.fileName);
        }
        return b_res;
    }

    private boolean setPropertyObject(String[] keys, String[] a_values, Object value) {
        int ii;
        boolean b_res = false;
        if (keys == null) {
            return b_res;
        }
        if (keys.length == 0) {
            return b_res;
        }
        if (value == null) {
            return b_res;
        }
        String expression = "//" + keys[0];
        for (ii = 1; ii < keys.length; ++ii) {
            expression = expression + "/" + keys[ii];
        }
        if (a_values != null) {
            for (ii = 0; ii < a_values.length; ++ii) {
                expression = expression + "[@*='" + a_values[ii] + "']";
            }
        }
        try {
            XPathExpression xPathExpression = this.xPath.compile(expression);
            Object node = xPathExpression.evaluate(this.root, XPathConstants.NODE);
            if (node != null) {
                ((Node)node).setTextContent(value.toString());
                b_res = true;
            }
        }
        catch (XPathExpressionException xpeex) {
            System.out.println("core.Config.setPropertyObject XPathExpressionException: " + xpeex.getMessage());
        }
        if (b_res) {
            this.writeFile(this.fileName);
        }
        return b_res;
    }

    public String getPropertyString(String section, String key) {
        return this.getPropertyString(section, key, null);
    }

    public String getPropertyString(String section, String key, String[] attributes) {
        String res = "";
        String[] keys = new String[]{section, key};
        Object object = this.getPropertyObject(keys, attributes, XPathConstants.STRING);
        if (object != null) {
            res = (String)object;
        }
        return res;
    }

    public String getPropertyString(String[] keys, Map<String, String> attr) {
        String res = "";
        Object object = this.getPropertyObject(keys, attr, XPathConstants.STRING);
        if (object != null) {
            res = (String)object;
        }
        return res;
    }

    public boolean isValid() {
        return this.b_valid;
    }

    public boolean setProperties(String section, String key, Map<String, String> map) {
        Object[] keys = map.keySet().toArray();
        int res = 0;
        int dim = keys.length;
        for (int ii = 0; ii < dim; ++ii) {
            if (!this.setPropertyString(section, key, new String[]{String.valueOf(keys[ii])}, map.get(keys[ii]))) continue;
            ++res;
        }
        return res == dim;
    }

    public boolean setPropertyInt(String section, String key, int value) {
        return this.setPropertyInt(section, key, null, value);
    }

    public boolean setPropertyInt(String section, String key, String[] attributes, int value) {
        String[] keys = new String[]{section, key};
        return this.setPropertyObject(keys, attributes, (Object)new Integer(value));
    }

    public boolean setPropertyInt(String[] keys, Map<String, String> attr, int value) {
        return this.setPropertyObject(keys, attr, (Object)new Integer(value));
    }

    public boolean setPropertyString(String section, String key, String value) {
        return this.setPropertyString(section, key, null, value);
    }

    public boolean setPropertyString(String section, String key, String[] attributes, String value) {
        String[] keys = new String[]{section, key};
        return this.setPropertyObject(keys, attributes, (Object)value);
    }
}

