/*
 * Decompiled with CFR 0.152.
 */
package core;

import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ContextMenu1 {
    Component comp;
    JTextComponent tc;
    JPopupMenu menu;
    Font FT_STAND;
    DM_Trad gen_trad;
    String txt_copy = "Copy";
    String txt_cut = "Cut";
    String txt_paste = "Paste";
    String txt_delete = "Delete";
    String txt_select_all = "Select all";
    Vector action;

    public ContextMenu1(Component comp) {
        try {
            this.comp = comp;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ContextMenu1(Component comp, String[] menu) {
        try {
            this.comp = comp;
            this.action = new Vector(5);
            for (int ii = 0; ii < menu.length; ++ii) {
                this.action.add(menu[ii]);
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setComponent(Component comp) {
        comp.addMouseListener(new ContextMenu1_MouseAdapter(this));
        this.tc = (JTextComponent)comp;
    }

    private void jbInit() throws Exception {
        if (this.comp != null) {
            this.comp.addMouseListener(new ContextMenu1_MouseAdapter(this));
            this.tc = (JTextComponent)this.comp;
        }
        if (this.gen_trad == null) {
            this.gen_trad = Ecad2007.getTraduction("gen");
        }
        if (this.gen_trad != null) {
            this.txt_copy = this.gen_trad.getCodeLan("copy");
            this.txt_cut = this.gen_trad.getCodeLan("cut");
            this.txt_paste = this.gen_trad.getCodeLan("paste");
            this.txt_delete = this.gen_trad.getCodeLan("delete2");
            this.txt_select_all = this.gen_trad.getCodeLan("select_all");
        }
    }

    private void mouseClicked(MouseEvent me) {
        if (!(this.comp instanceof JTextComponent)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (me.getButton() != 3) {
            return;
        }
        this.menu = new JPopupMenu();
        if (this.action == null) {
            this.menu.add(new CutAction(this.tc));
            this.menu.add(new CopyAction(this.tc));
            this.menu.add(new PasteAction(this.tc));
            this.menu.add(new DeleteAction(this.tc));
            this.menu.addSeparator();
            this.menu.add(new SelectAllAction(this.tc));
        } else {
            if (this.action.contains("cut")) {
                this.menu.add(new CutAction(this.tc));
            }
            if (this.action.contains("copy")) {
                this.menu.add(new CopyAction(this.tc));
            }
            if (this.action.contains("paste")) {
                this.menu.add(new PasteAction(this.tc));
            }
            if (this.action.contains("delete")) {
                this.menu.add(new DeleteAction(this.tc));
            }
            if (this.action.size() > 1) {
                this.menu.addSeparator();
            }
            if (this.action.contains("select")) {
                this.menu.add(new SelectAllAction(this.tc));
            }
        }
        Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), this.tc);
        this.menu.show(this.tc, pt.x, pt.y);
    }

    class ContextMenu1_MouseAdapter
    extends MouseAdapter {
        ContextMenu1 adaptee;

        public ContextMenu1_MouseAdapter(ContextMenu1 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.adaptee.mouseClicked(me);
        }
    }

    class SelectAllAction
    extends AbstractAction {
        JTextComponent comp;

        public SelectAllAction(JTextComponent comp) {
            super(ContextMenu1.this.txt_select_all);
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEnabled() && this.comp.getText().length() > 0;
        }
    }

    class CopyAction
    extends AbstractAction {
        JTextComponent comp;

        public CopyAction(JTextComponent comp) {
            super(ContextMenu1.this.txt_copy);
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }

    class DeleteAction
    extends AbstractAction {
        JTextComponent comp;

        public DeleteAction(JTextComponent comp) {
            super(ContextMenu1.this.txt_delete);
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.replaceSelection(null);
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }

    class PasteAction
    extends AbstractAction {
        JTextComponent comp;

        public PasteAction(JTextComponent comp) {
            super(ContextMenu1.this.txt_paste);
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.paste();
        }

        @Override
        public boolean isEnabled() {
            if (this.comp.isEditable() && this.comp.isEnabled()) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }

    class CutAction
    extends AbstractAction {
        JTextComponent comp;

        public CutAction(JTextComponent comp) {
            super(ContextMenu1.this.txt_cut);
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }
}

