/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOM {
    static final String outputEncoding = "UTF-8";
    DocumentBuilderFactory dbf;
    private Document doc;
    private PrintWriter out;
    private int indent = 0;
    private final String basicIndent = "  ";
    static boolean dtdValidate = false;
    static boolean xsdValidate = false;
    static String schemaSource = null;
    static boolean ignoreWhitespace = false;
    static boolean ignoreComments = false;
    static boolean putCDATAIntoText = false;
    static boolean createEntityRefs = false;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    String element = "dir";
    boolean b_element = false;
    Map<String, String> attr = new HashMap<String, String>(2);
    boolean[] b_attr = new boolean[]{false, false};
    int i_attr = 0;

    public DOM(String filename) {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        this.dbf.setValidating(dtdValidate || xsdValidate);
        if (xsdValidate) {
            try {
                this.dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException x) {
                System.err.println("Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                System.err.println("Check to see if parser conforms to JAXP 1.2 spec.");
                System.exit(1);
            }
        }
        if (schemaSource != null) {
            this.dbf.setAttribute(JAXP_SCHEMA_SOURCE, new File(schemaSource));
        }
        this.dbf.setIgnoringComments(ignoreComments);
        this.dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
        this.dbf.setCoalescing(putCDATAIntoText);
        this.dbf.setExpandEntityReferences(!createEntityRefs);
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, outputEncoding);
            db.setErrorHandler(new PrivateErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            if (filename != null) {
                this.doc = db.parse(new File(filename));
            }
        }
        catch (ParserConfigurationException pcex) {
            System.out.println("DOM: " + pcex.getMessage());
        }
        catch (UnsupportedEncodingException ueex) {
            System.out.println("DOM: " + ueex.getMessage());
        }
        catch (SAXException saxex) {
            System.out.println("DOM: " + saxex.getMessage());
        }
        catch (IOException ioex) {
            System.out.println("DOM: " + ioex.getMessage());
        }
    }

    public DOM() {
        this(null);
    }

    DOM(String filename, PrintWriter out) {
        this(filename);
        this.out = out;
    }

    Document getDocument() {
        return this.doc;
    }

    private String[] readCommon(Node node) {
        String value;
        String name = node.getNodeName();
        if (name == null) {
            name = "";
        }
        if ((value = node.getNodeValue()) == null) {
            value = "";
        }
        return new String[]{name, value};
    }

    public void setAttribute(String key, String value) {
        this.attr.put(key, value);
    }

    public void setFileName(String filename) {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, outputEncoding);
            db.setErrorHandler(new PrivateErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            if (filename != null) {
                this.doc = db.parse(new File(filename));
            }
        }
        catch (ParserConfigurationException pcex) {
            System.out.println("DOM: " + pcex.getMessage());
        }
        catch (UnsupportedEncodingException ueex) {
            System.out.println("DOM: " + ueex.getMessage());
        }
        catch (SAXException saxex) {
            System.out.println("DOM: " + saxex.getMessage());
        }
        catch (IOException ioex) {
            System.out.println("DOM: " + ioex.getMessage());
        }
    }

    public String getXmlValue(String section, String key, Map<String, String> attributes) {
        String res = "";
        if (attributes == null) {
            return res;
        }
        int i_attributes = attributes.size();
        NodeList nodeList = this.doc.getElementsByTagName("stereograph");
        Node node = nodeList.item(0);
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NodeList nodelist = element.getElementsByTagName(section);
            for (int mm = 0; mm < nodelist.getLength(); ++mm) {
                int i_va = 0;
                Node subnode = nodelist.item(mm);
                if (subnode.getNodeType() != 1) continue;
                Element subelement = (Element)node;
                NodeList nl = subelement.getElementsByTagName(key);
                Node nd = nl.item(0);
                NamedNodeMap anm = nd.getAttributes();
                String[] keys = new String[i_attributes];
                keys = attributes.keySet().toArray(keys);
                for (int ii = 0; ii < i_attributes; ++ii) {
                    Node an = anm.getNamedItem(keys[ii]);
                    if (an == null || !an.getNodeValue().equals(attributes.get(keys[ii]))) continue;
                    ++i_va;
                }
                if (i_va != i_attributes) continue;
                Node attr = anm.getNamedItem("dlg");
                Node attr2 = anm.getNamedItem("name");
                res = nd.getFirstChild().getNodeValue();
                break;
            }
        }
        return res;
    }

    private String getNodeValue(Node node) {
        String res = "";
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                break;
            }
            case 9: {
                res = this.readCommon(node)[0];
                break;
            }
            case 1: {
                res = this.readCommon(node)[0];
                if (res.equals(this.element)) {
                    this.b_element = true;
                }
                NamedNodeMap atts = node.getAttributes();
                String[] nv = new String[2];
                String name = "";
                this.indent += 2;
                for (int ii = 0; ii < atts.getLength(); ++ii) {
                    Node att = atts.item(ii);
                    nv = this.readCommon(att);
                    name = this.attr.get(nv[0]);
                    if (name == null || !this.attr.get(nv[0]).equals(nv[1])) continue;
                    ++this.i_attr;
                }
                this.indent -= 2;
                break;
            }
            case 3: {
                res = this.readCommon(node)[1];
                break;
            }
            default: {
                res = "";
            }
        }
        ++this.indent;
        if (this.i_attr == this.attr.size() && this.b_element) {
            res = node.getFirstChild().getNodeValue();
        } else {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                res = this.getNodeValue(child);
            }
        }
        --this.indent;
        if (this.i_attr != this.attr.size() || this.b_element) {
            // empty if block
        }
        this.i_attr = 0;
        this.b_element = false;
        return res;
    }

    private void printlnCommon(Node n) {
        this.out.print(" nodeName=\"" + n.getNodeName() + "\"");
        String val = n.getNamespaceURI();
        if (val != null) {
            this.out.print(" uri=\"" + val + "\"");
        }
        if ((val = n.getPrefix()) != null) {
            this.out.print(" pre=\"" + val + "\"");
        }
        if ((val = n.getLocalName()) != null) {
            this.out.print(" local=\"" + val + "\"");
        }
        if ((val = n.getNodeValue()) != null) {
            this.out.print(" nodeValue=");
            if (val.trim().equals("")) {
                this.out.print("[WS]");
            } else {
                this.out.print("\"" + n.getNodeValue() + "\"");
            }
        }
        this.out.println();
    }

    private void outputIndentation() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print("  ");
        }
    }

    private void echo(Node n) {
        this.outputIndentation();
        short type = n.getNodeType();
        switch (type) {
            case 2: {
                this.out.print("ATTR:");
                this.printlnCommon(n);
                break;
            }
            case 4: {
                this.out.print("CDATA:");
                this.printlnCommon(n);
                break;
            }
            case 8: {
                this.out.print("COMM:");
                this.printlnCommon(n);
                break;
            }
            case 11: {
                this.out.print("DOC_FRAG:");
                this.printlnCommon(n);
                break;
            }
            case 9: {
                this.out.print("DOC:");
                this.printlnCommon(n);
                break;
            }
            case 10: {
                this.out.print("DOC_TYPE:");
                this.printlnCommon(n);
                NamedNodeMap nodeMap = ((DocumentType)n).getEntities();
                this.indent += 2;
                for (int i = 0; i < nodeMap.getLength(); ++i) {
                    Entity entity = (Entity)nodeMap.item(i);
                    this.echo(entity);
                }
                this.indent -= 2;
                break;
            }
            case 1: {
                this.out.print("ELEM:");
                this.printlnCommon(n);
                NamedNodeMap atts = n.getAttributes();
                this.indent += 2;
                for (int i = 0; i < atts.getLength(); ++i) {
                    Node att = atts.item(i);
                    this.echo(att);
                }
                this.indent -= 2;
                break;
            }
            case 6: {
                this.out.print("ENT:");
                this.printlnCommon(n);
                break;
            }
            case 5: {
                this.out.print("ENT_REF:");
                this.printlnCommon(n);
                break;
            }
            case 12: {
                this.out.print("NOTATION:");
                this.printlnCommon(n);
                break;
            }
            case 7: {
                this.out.print("PROC_INST:");
                this.printlnCommon(n);
                break;
            }
            case 3: {
                this.out.print("TEXT:");
                this.printlnCommon(n);
                break;
            }
            default: {
                this.out.print("UNSUPPORTED NODE: " + type);
                this.printlnCommon(n);
            }
        }
        ++this.indent;
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.echo(child);
        }
        --this.indent;
    }

    private static void usage() {
        System.err.println("Usage: DOMEcho [-options] <file.xml>");
        System.err.println("       -dtd = DTD validation");
        System.err.println("       -xsd | -xsdss <file.xsd> = W3C XML Schema validation using xsi: hints");
        System.err.println("           in instance document or schema source <file.xsd>");
        System.err.println("       -ws = do not create element content whitespace nodes");
        System.err.println("       -co[mments] = do not create comment nodes");
        System.err.println("       -cd[ata] = put CDATA into Text nodes");
        System.err.println("       -e[ntity-ref] = create EntityReference nodes");
        System.err.println("       -usage or -help = this message");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        String filename = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dtd")) {
                dtdValidate = true;
                continue;
            }
            if (args[i].equals("-xsd")) {
                xsdValidate = true;
                continue;
            }
            if (args[i].equals("-xsdss")) {
                if (i == args.length - 1) {
                    DOM.usage();
                }
                xsdValidate = true;
                schemaSource = args[++i];
                continue;
            }
            if (args[i].equals("-ws")) {
                ignoreWhitespace = true;
                continue;
            }
            if (args[i].startsWith("-co")) {
                ignoreComments = true;
                continue;
            }
            if (args[i].startsWith("-cd")) {
                putCDATAIntoText = true;
                continue;
            }
            if (args[i].startsWith("-e")) {
                createEntityRefs = true;
                continue;
            }
            if (args[i].equals("-usage")) {
                DOM.usage();
                continue;
            }
            if (args[i].equals("-help")) {
                DOM.usage();
                continue;
            }
            filename = args[i];
            if (i == args.length - 1) continue;
            DOM.usage();
        }
        if (filename == null) {
            DOM.usage();
        }
        DOM dom = new DOM(filename);
        String res = "";
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put("dlg", "mf");
        attributes.put("name", "epw");
        res = dom.getXmlValue("properties", "dir", attributes);
        System.out.println("DOM res2: " + res);
    }

    private static class PrivateErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        PrivateErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

