/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Config;
import core.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import sun.swing.FilePane;

public class DlgPrint
extends JDialog {
    private JPanel jPanel1 = new JPanel();
    private JPanel jPa_support = new JPanel();
    private JComboBox jCb_print;
    int jcbtf_print = 250;
    private JComboBox jCb_media = new JComboBox();
    private JComboBox jCb_src = new JComboBox();
    private JLabel jLa_print = new JLabel();
    private JLabel jLa_size = new JLabel();
    private JPanel jPa_margin = new JPanel();
    private JPanel jPa_orient = new JPanel();
    private JButton jB_esc = new JButton();
    private JButton jB_print = new JButton();
    private ButtonGroup BG_pl = new ButtonGroup();
    private JRadioButton jRB_portrait = new JRadioButton();
    private JRadioButton jRB_landscape = new JRadioButton();
    private JLabel jLa_src = new JLabel();
    private JLabel jLa_left = new JLabel();
    private JTextField jTF_left = new JTextField();
    private JTextField jTF_right = new JTextField();
    private JLabel jLa_right = new JLabel();
    private JTextField jTF_sup = new JTextField();
    private JTextField jTF_inf = new JTextField();
    private JLabel jLa_inf = new JLabel();
    private JLabel jLa_sup = new JLabel();
    private JLabel jLa_impo = new JLabel();
    private JLabel jLa_impa = new JLabel();
    Font FT_STAND = new Font("Dialog", 0, 11);
    Font FT_BOLD = new Font("Dialog", 1, 11);
    Color C_TITLE = new Color(0, 0, 0);
    TitledBorder titledBorder;
    Map<String, String> printerSettings;
    transient PrinterJob pj;
    transient PrintService[] ps;
    String[] printerList;
    double[] mpa = new double[4];
    MediaSize ms;
    MediaSizeName msn;
    float[] msfl = new float[4];
    Media[] media;
    ArrayList mediatrays;
    String[] trays;
    DecimalFormatSymbols dfs;
    DecimalFormat df1;
    String separator = System.getProperty("file.separator");
    String osVersion = System.getProperty("os.version").toLowerCase();
    String[] marges = new String[4];
    String tmp;
    String parent;
    boolean b_ls = false;
    boolean b_ok = false;
    private JPanel jPa_copy = new JPanel();
    private JSpinner jSp_copy = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
    private JCheckBox jChB_file = new JCheckBox();
    private JTextField jTF_file = new JTextField();
    private JLabel jLa_copy = new JLabel();
    int lan = 0;
    int mediaUnits = 1000;
    private String[][] trad = new String[][]{{"Pdf-Datei", "In Datei umleiten", "Kopien", "Drucken", "Medien", "Drucker", "Gr\u00f6sse", "R\u00e4nder", "Ausrichtung", "Quelle", "links", "rechts", "unten", "oben", "Automatische Auswahl", "Hochformat", "Querformat", "Drucken", "Abbrechen", "alle", "Diese Datei existiert bereits.\nM\u00f6chten Sie die vorhandene Datei \u00fcberschreiben?"}, {"Fichier pdf", "Imprimer dans fichier", "Copies", "Imprimante", "Support", "Imprimante", "Taille", "Marges", "Orientation", "Source", "gauche", "droite", "inf\u00e9rieur", "sup\u00e9rieur", "S\u00e9lection automatique", "Portrait", "Paysage", "Imprimer", "Annuler", "tous", "Ce fichier existe d\u00e9j\u00e0.\nRemplacer le fichier existant?"}, {"Stampa su pdf", "Stampa su file", "Copie", "Stampa", "Supporti", "Stampa", "Dimensioni", "Margini", "Sorgente", "sinistra", "destra", "basso", "alto", "Seleziona automaticamente", "Verticale", "Orizzontale", "Stampa", "Annulla", "tuti", "Il file esiste gi\u00e0. Soverascrivere il file esistente?"}, {"Pdf file", "Print into file", "Copies", "Printer", "Media", "Printer", "Size", "Borders", "Orientiation", "Source", "left", "right", "bottom", "top", "Automatically Select", "Portrait", "Landscape", "Print", "Cancel", "all", "This file already exists.\nWould you like to overwrite the existing file?"}};

    public DlgPrint() {
        this((Dialog)null, "", false);
    }

    public DlgPrint(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgPrint(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgPrint(Dialog parent, String title, Map<String, String> printersettings, boolean modal) {
        super(parent, title, modal);
        this.printerSettings = printersettings;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String language;
        HashMap<String, ImageIcon> hsmIc = new HashMap<String, ImageIcon>(2);
        if (this.getParent() != null) {
            this.parent = this.getParent().getClass().getName();
            this.parent = this.parent.substring(this.parent.lastIndexOf(".") + 1);
        }
        this.lan = (language = Locale.getDefault().getLanguage()).equals("de") ? 0 : (language.equals("fr") ? 1 : (language.equals("it") ? 2 : 3));
        this.pj = PrinterJob.getPrinterJob();
        this.ps = PrinterJob.lookupPrintServices();
        this.dfs = new DecimalFormatSymbols();
        this.dfs.setDecimalSeparator('.');
        this.df1 = new DecimalFormat("0.0", this.dfs);
        int dim = this.ps.length;
        int idprint = 0;
        int idmedia = 0;
        int idtray = -1;
        String printservice = this.printerSettings.get("printService");
        this.printerList = new String[dim + 1];
        for (int ii = 0; ii < dim; ++ii) {
            this.printerList[ii] = this.ps[ii].getName();
            if (!printservice.equals(this.printerList[ii])) continue;
            idprint = ii;
        }
        if (printservice.equals("pdf")) {
            idprint = this.printerList.length - 1;
            this.jChB_file.setEnabled(false);
            this.jTF_file.setEnabled(false);
        }
        String pdf = this.trad[this.lan][0] + ": " + this.printerSettings.get("pdf");
        BufferedImage image = new BufferedImage(200, 20, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setFont(this.FT_STAND);
        int pdfwidth = g2d.getFontMetrics().stringWidth(pdf);
        if (pdfwidth > this.jcbtf_print) {
            int index = pdf.lastIndexOf(this.separator);
            String slpdf = "";
            String srpdf = "";
            if (index != -1) {
                slpdf = pdf.substring(0, index);
                srpdf = this.separator + "..." + pdf.substring(index);
                while (pdfwidth > this.jcbtf_print && (index = slpdf.lastIndexOf(this.separator)) > -1) {
                    slpdf = slpdf.substring(0, index);
                    pdfwidth = g2d.getFontMetrics().stringWidth(slpdf + srpdf);
                }
                pdf = slpdf + srpdf;
            }
        }
        this.printerList[dim] = pdf;
        String mediasize = this.printerSettings.get("mediaSize");
        this.media = this.getMedia(idprint);
        for (int ii = 0; ii < this.media.length; ++ii) {
            if (!mediasize.equals(this.media[ii].toString())) continue;
            idmedia = ii;
        }
        this.tmp = this.printerSettings.get("printableArea");
        if (this.tmp.split(",").length > 0) {
            String[] mediaPrintableArea = this.tmp.split(",");
            for (int ii = 0; ii < 4; ++ii) {
                this.mpa[ii] = Globals.getDoubleValue(mediaPrintableArea[ii]);
            }
        }
        idtray = Integer.parseInt(this.printerSettings.get("mediaTray"));
        this.getContentPane().setLayout(null);
        this.setFont(this.FT_STAND);
        this.setTitle(this.trad[this.lan][3]);
        this.setBounds(new Rectangle(10, 10, 445, 374));
        this.jPanel1.setBounds(new Rectangle(0, 0, 445, 350));
        this.jPanel1.setLayout(null);
        this.jPanel1.setForeground(new Color(247, 247, 247));
        this.jPanel1.setFont(this.FT_BOLD);
        this.jPa_support.setBounds(new Rectangle(16, 16, 407, 111));
        this.titledBorder = BorderFactory.createTitledBorder(this.trad[this.lan][4]);
        this.titledBorder.setTitleColor(this.C_TITLE);
        this.titledBorder.setTitleFont(this.FT_BOLD);
        this.jPa_support.setBorder(this.titledBorder);
        this.jPa_support.setLayout(null);
        this.jPa_support.setForeground(new Color(237, 237, 237));
        this.jPa_support.setOpaque(false);
        this.jCb_print = new JComboBox<String>(this.printerList);
        this.jCb_print.setFont(this.FT_STAND);
        this.jCb_print.setBounds(new Rectangle(100, 16, this.jcbtf_print + 43, 23));
        this.jCb_print.setSelectedIndex(idprint);
        this.jCb_print.addItemListener(new DlgPrint_itemAdapter(this));
        this.jCb_media = new JComboBox<Media>(this.media);
        this.jCb_media.setFont(this.FT_STAND);
        this.jCb_media.setBounds(new Rectangle(100, 46, 293, 23));
        this.jCb_media.setSelectedIndex(idmedia);
        this.jCb_src = new JComboBox<String>(this.trays);
        this.jCb_src.setFont(this.FT_STAND);
        this.jCb_src.setBounds(new Rectangle(100, 76, 293, 23));
        this.jCb_src.setSelectedIndex(idtray);
        this.jLa_print.setFont(this.FT_STAND);
        this.jLa_print.setText(this.trad[this.lan][5] + ":");
        this.jLa_print.setBounds(new Rectangle(10, 16, 83, 22));
        this.jLa_size.setFont(this.FT_STAND);
        this.jLa_size.setText(this.trad[this.lan][6] + ":");
        this.jLa_size.setBounds(new Rectangle(10, 46, 83, 22));
        this.jPa_margin.setBounds(new Rectangle(197, 136, 226, 147));
        this.jPa_margin.setLayout(null);
        this.jPa_margin.setForeground(new Color(247, 247, 247));
        this.titledBorder = BorderFactory.createTitledBorder(this.trad[this.lan][7]);
        this.titledBorder.setTitleColor(this.C_TITLE);
        this.titledBorder.setTitleFont(this.FT_BOLD);
        this.jPa_margin.setBorder(this.titledBorder);
        this.jPa_orient.setBounds(new Rectangle(13, 136, 169, 75));
        this.jPa_orient.setLayout(null);
        this.jPa_orient.setForeground(new Color(247, 247, 247));
        this.titledBorder = BorderFactory.createTitledBorder(this.trad[this.lan][8]);
        this.titledBorder.setTitleColor(this.C_TITLE);
        this.titledBorder.setTitleFont(this.FT_BOLD);
        this.jPa_orient.setBorder(this.titledBorder);
        this.jPa_copy.setBounds(new Rectangle(13, 220, 169, 61));
        this.jPa_copy.setBorder(BorderFactory.createTitledBorder(""));
        this.jPa_copy.setLayout(null);
        this.jPa_copy.setForeground(new Color(247, 247, 247));
        this.jSp_copy.setFont(this.FT_STAND);
        this.jSp_copy.setBounds(new Rectangle(104, 9, 50, 20));
        this.jSp_copy.setValue(new Integer(this.printerSettings.get("copies").toString()));
        this.jLa_copy.setFont(this.FT_STAND);
        this.jLa_copy.setText(this.trad[this.lan][2] + ":");
        this.jLa_copy.setBounds(new Rectangle(11, 8, 88, 20));
        this.jChB_file.setFont(this.FT_STAND);
        this.jChB_file.setBounds(new Rectangle(138, 36, 20, 20));
        this.jChB_file.setHorizontalAlignment(4);
        this.jChB_file.setHorizontalTextPosition(10);
        if (this.printerSettings.get("prn").equals("1")) {
            this.jChB_file.setSelected(true);
        }
        this.jTF_file.setFont(this.FT_STAND);
        this.jTF_file.setText(this.trad[this.lan][1] + ":");
        this.jTF_file.setBounds(new Rectangle(11, 36, 125, 20));
        this.jTF_file.setEditable(false);
        this.jTF_file.setBackground(this.getBackground());
        this.jTF_file.setBorder(null);
        this.jTF_file.addMouseListener(new DlgPrint_mouseAdapter(this));
        this.jB_esc.setFont(this.FT_STAND);
        this.jB_esc.setText(this.trad[this.lan][18]);
        this.jB_esc.setBounds(new Rectangle(211, 293, 92, 26));
        this.jB_esc.addActionListener(new DlgPrint_actionAdapter(this));
        this.jB_print.setFont(this.FT_STAND);
        this.jB_print.setText(this.trad[this.lan][17]);
        this.jB_print.addActionListener(new DlgPrint_actionAdapter(this));
        this.jB_print.setBounds(new Rectangle(316, 293, 92, 26));
        this.jRB_portrait.setFont(this.FT_STAND);
        this.jRB_portrait.setText(this.trad[this.lan][15]);
        this.jRB_portrait.setBounds(new Rectangle(46, 15, 108, 24));
        this.jRB_portrait.addActionListener(new DlgPrint_actionAdapter(this));
        this.BG_pl.add(this.jRB_portrait);
        this.jRB_landscape.setFont(this.FT_STAND);
        this.jRB_landscape.setText(this.trad[this.lan][16]);
        this.jRB_landscape.setBounds(new Rectangle(46, 40, 108, 24));
        this.jRB_landscape.addActionListener(new DlgPrint_actionAdapter(this));
        this.BG_pl.add(this.jRB_landscape);
        if (this.printerSettings.get("orientation").equals("portrait")) {
            this.jRB_portrait.setSelected(true);
            this.b_ls = false;
        } else {
            this.jRB_landscape.setSelected(true);
            this.b_ls = true;
        }
        this.jLa_src.setFont(this.FT_STAND);
        this.jLa_src.setText(this.trad[this.lan][9] + ":");
        this.jLa_src.setBounds(new Rectangle(10, 76, 83, 22));
        this.jLa_left.setFont(this.FT_STAND);
        this.jLa_left.setText(this.trad[this.lan][10] + " (mm)");
        this.jLa_left.setBounds(new Rectangle(15, 19, 98, 21));
        this.jTF_left.setFont(this.FT_STAND);
        this.jTF_left.setBounds(new Rectangle(15, 44, 93, 20));
        this.jTF_left.setText(this.df1.format(this.mpa[0]));
        this.jTF_left.addFocusListener(new DlgPrint_focusAdapter(this));
        this.jTF_right.setFont(this.FT_STAND);
        this.jTF_right.setBounds(new Rectangle(119, 44, 93, 20));
        this.jTF_right.setText(this.df1.format(this.mpa[2]));
        this.jTF_right.addFocusListener(new DlgPrint_focusAdapter(this));
        this.jLa_right.setFont(this.FT_STAND);
        this.jLa_right.setText(this.trad[this.lan][11] + " (mm)");
        this.jLa_right.setBounds(new Rectangle(119, 19, 98, 21));
        this.jTF_inf.setFont(this.FT_STAND);
        this.jTF_inf.setBounds(new Rectangle(119, 106, 93, 20));
        this.jTF_inf.setText(this.df1.format(this.mpa[3]));
        this.jTF_inf.addFocusListener(new DlgPrint_focusAdapter(this));
        this.jLa_inf.setFont(this.FT_STAND);
        this.jLa_inf.setText(this.trad[this.lan][12] + " (mm)");
        this.jLa_inf.setBounds(new Rectangle(119, 81, 98, 21));
        this.jTF_sup.setFont(this.FT_STAND);
        this.jTF_sup.setBounds(new Rectangle(15, 106, 93, 20));
        this.jTF_sup.setText(this.df1.format(this.mpa[1]));
        this.jTF_sup.addFocusListener(new DlgPrint_focusAdapter(this));
        this.jLa_sup.setFont(this.FT_STAND);
        this.jLa_sup.setText(this.trad[this.lan][13] + " (mm)");
        this.jLa_sup.setBounds(new Rectangle(15, 81, 98, 21));
        ClassLoader cl = this.getClass().getClassLoader();
        hsmIc.put("portrait", new ImageIcon(cl.getResource("icons/portrait_1818.png")));
        hsmIc.put("landscape", new ImageIcon(cl.getResource("icons/landscape_1818.png")));
        this.jLa_impo.setBounds(new Rectangle(20, 15, 21, 24));
        this.jLa_impo.setIcon((ImageIcon)hsmIc.get("portrait"));
        this.jLa_impo.setHorizontalAlignment(0);
        this.jLa_impa.setBounds(new Rectangle(20, 40, 21, 24));
        this.jLa_impa.setIcon((ImageIcon)hsmIc.get("landscape"));
        this.jLa_impa.setHorizontalAlignment(0);
        this.jPa_support.add((Component)this.jCb_src, null);
        this.jPa_support.add((Component)this.jLa_src, null);
        this.jPa_support.add((Component)this.jLa_size, null);
        this.jPa_support.add((Component)this.jLa_print, null);
        this.jPa_support.add((Component)this.jCb_media, null);
        this.jPa_support.add((Component)this.jCb_print, null);
        this.jPa_copy.add((Component)this.jLa_copy, null);
        this.jPa_copy.add((Component)this.jSp_copy, null);
        this.jPa_copy.add((Component)this.jChB_file, null);
        this.jPa_copy.add((Component)this.jTF_file, null);
        this.jPanel1.add((Component)this.jPa_copy, null);
        this.jPanel1.add((Component)this.jB_print, null);
        this.jPanel1.add((Component)this.jB_esc, null);
        this.jPanel1.add((Component)this.jPa_orient, null);
        this.jPanel1.add((Component)this.jPa_margin, null);
        this.jPanel1.add((Component)this.jPa_support, null);
        this.jPa_orient.add((Component)this.jLa_impa, null);
        this.jPa_orient.add((Component)this.jLa_impo, null);
        this.jPa_orient.add((Component)this.jRB_landscape, null);
        this.jPa_orient.add((Component)this.jRB_portrait, null);
        this.jPa_margin.add((Component)this.jLa_sup, null);
        this.jPa_margin.add((Component)this.jLa_inf, null);
        this.jPa_margin.add((Component)this.jTF_inf, null);
        this.jPa_margin.add((Component)this.jTF_sup, null);
        this.jPa_margin.add((Component)this.jLa_right, null);
        this.jPa_margin.add((Component)this.jTF_right, null);
        this.jPa_margin.add((Component)this.jTF_left, null);
        this.jPa_margin.add((Component)this.jLa_left, null);
        this.setSize(new Dimension(445, 374));
        this.getContentPane().add((Component)this.jPanel1, null);
        this.SetDlgLocation();
    }

    public HashPrintRequestAttributeSet createAttributeSet() {
        HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
        int i_tmp = 0;
        float[] paperSize = this.getMediaSize(this.jCb_media.getSelectedItem().toString());
        attributeSet.add(this.msn);
        if (this.mediatrays.size() > 0) {
            MediaTray[] mt = (MediaTray[])this.mediatrays.toArray();
            attributeSet.add(mt[this.jCb_src.getSelectedIndex()]);
        }
        i_tmp = Integer.parseInt((String)this.jSp_copy.getValue());
        attributeSet.add(new Copies(i_tmp));
        return attributeSet;
    }

    private JFileChooser createJFileChooser(String filetype) {
        JFileChooser FChprt = new JFileChooser();
        FChprt.setDialogTitle(this.trad[this.lan][1]);
        FChprt.setApproveButtonText("Ok");
        File dir = null;
        Locale locale = Locale.getDefault();
        String extension = "ps";
        if (filetype.equals("prn")) {
            dir = new File(this.printerSettings.get("file").replaceAll("&#92;", "\\\\"));
        } else if (filetype.equals("pdf")) {
            dir = new File(this.printerSettings.get("pdf").replaceAll("&#92;", "\\\\"));
            extension = "pdf";
        } else {
            return null;
        }
        FChprt.setCurrentDirectory(dir);
        FChprt.setSelectedFile(dir);
        if (!FChprt.getLocale().equals(locale)) {
            FChprt.setLocale(locale);
            SwingUtilities.updateComponentTreeUI(FChprt);
            JOptionPane.setDefaultLocale(locale);
        }
        FChprt.enableInputMethods(false);
        FChprt.setFileSelectionMode(0);
        FChprt.addChoosableFileFilter(new PrtFilter(this.trad[this.lan][18] + " (*.*)", new String[]{"*"}));
        PrtFilter prtFilter = new PrtFilter("*." + extension, new String[]{extension});
        FChprt.addChoosableFileFilter(prtFilter);
        FChprt.setFileFilter(prtFilter);
        FChprt.setFont(this.FT_STAND);
        FChprt.setAcceptAllFileFilterUsed(false);
        Config config = new Config(System.getProperty("conf.file.name"));
        int fileviewtype = config.getPropertyInt("properties", "fileviewtype");
        Component[] components = FChprt.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof FilePane)) continue;
            FilePane filePane = (FilePane)components[ii];
            filePane.setViewType(fileviewtype);
            break;
        }
        return FChprt;
    }

    private Media[] getMedia(int idprint) {
        HashMap<PrintService, String[]> map = new HashMap<PrintService, String[]>();
        if (idprint > this.printerList.length - 2) {
            this.media = new Media[]{MediaSizeName.ISO_A5, MediaSizeName.ISO_A4, MediaSizeName.ISO_A3, MediaSizeName.NA_LETTER};
            this.trays = new String[1];
            this.trays[0] = this.trad[this.lan][14];
        } else {
            PrintServiceAttributeSet psas = this.ps[idprint].getAttributes();
            Attribute[] atts = psas.toArray();
            ArrayList<MediaTray> mediatrays = new ArrayList<MediaTray>();
            map.put(this.ps[idprint], this.trays);
            for (int ii = 0; ii < atts.length; ++ii) {
                Attribute att = atts[ii];
                if (!(att instanceof MediaTray)) continue;
                System.out.println("MediaTray");
            }
            Object supportedAttributes = this.ps[idprint].getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, psas);
            if (supportedAttributes.getClass().isArray()) {
                this.media = (Media[])supportedAttributes;
            }
            for (int ii = 0; ii < this.media.length; ++ii) {
                if (!(this.media[ii] instanceof MediaTray)) continue;
                mediatrays.add((MediaTray)this.media[ii]);
            }
            if (mediatrays.size() > 0) {
                if (mediatrays.toArray() instanceof Object[]) {
                    Object[] ot = mediatrays.toArray();
                    if (ot != null) {
                        int dim = ot.length;
                        this.trays = new String[dim];
                        for (int ii = 0; ii < dim; ++ii) {
                            this.trays[ii] = ((MediaTray)mediatrays.get(ii)).toString();
                        }
                    }
                } else {
                    this.trays = (String[])mediatrays.toArray();
                }
            } else {
                this.trays = new String[1];
                this.trays[0] = this.trad[this.lan][14];
            }
        }
        return this.media;
    }

    private float[] getMediaSize(String mediasize) {
        int mediaIndex = -1;
        HashMap<String, MediaSizeName> mediaMap = new HashMap<String, MediaSizeName>(100, 10.0f);
        mediaMap.put("iso-a0", MediaSizeName.ISO_A0);
        mediaMap.put("iso-a1", MediaSizeName.ISO_A1);
        mediaMap.put("iso-a2", MediaSizeName.ISO_A2);
        mediaMap.put("iso-a3", MediaSizeName.ISO_A3);
        mediaMap.put("iso-a4", MediaSizeName.ISO_A4);
        mediaMap.put("iso-a5", MediaSizeName.ISO_A5);
        mediaMap.put("iso-a6", MediaSizeName.ISO_A6);
        mediaMap.put("iso-a7", MediaSizeName.ISO_A7);
        mediaMap.put("iso-a8", MediaSizeName.ISO_A8);
        mediaMap.put("iso-a9", MediaSizeName.ISO_A9);
        mediaMap.put("iso-a10", MediaSizeName.ISO_A10);
        mediaMap.put("iso-b0", MediaSizeName.ISO_B0);
        mediaMap.put("iso-b1", MediaSizeName.ISO_B1);
        mediaMap.put("iso-b2", MediaSizeName.ISO_B2);
        mediaMap.put("iso-b3", MediaSizeName.ISO_B3);
        mediaMap.put("iso-b4", MediaSizeName.ISO_B4);
        mediaMap.put("iso-b5", MediaSizeName.ISO_B5);
        mediaMap.put("iso-b6", MediaSizeName.ISO_B6);
        mediaMap.put("iso-b7", MediaSizeName.ISO_B7);
        mediaMap.put("iso-b8", MediaSizeName.ISO_B8);
        mediaMap.put("iso-b9", MediaSizeName.ISO_B9);
        mediaMap.put("iso-b10", MediaSizeName.ISO_B10);
        mediaMap.put("jis-b0", MediaSizeName.JIS_B0);
        mediaMap.put("jis-b1", MediaSizeName.JIS_B1);
        mediaMap.put("jis-b2", MediaSizeName.JIS_B2);
        mediaMap.put("jis-b3", MediaSizeName.JIS_B3);
        mediaMap.put("jis-b4", MediaSizeName.JIS_B4);
        mediaMap.put("jis-b5", MediaSizeName.JIS_B5);
        mediaMap.put("jis-b6", MediaSizeName.JIS_B6);
        mediaMap.put("jis-b7", MediaSizeName.JIS_B7);
        mediaMap.put("jis-b8", MediaSizeName.JIS_B8);
        mediaMap.put("jis-b9", MediaSizeName.JIS_B9);
        mediaMap.put("jis-b10", MediaSizeName.JIS_B10);
        mediaMap.put("iso-c0", MediaSizeName.ISO_C0);
        mediaMap.put("iso-c1", MediaSizeName.ISO_C1);
        mediaMap.put("iso-c2", MediaSizeName.ISO_C2);
        mediaMap.put("iso-c3", MediaSizeName.ISO_C3);
        mediaMap.put("iso-c4", MediaSizeName.ISO_C4);
        mediaMap.put("iso-c5", MediaSizeName.ISO_C5);
        mediaMap.put("iso-c6", MediaSizeName.ISO_C6);
        mediaMap.put("na-letter", MediaSizeName.NA_LETTER);
        mediaMap.put("na-legal", MediaSizeName.NA_LEGAL);
        mediaMap.put("executive", MediaSizeName.EXECUTIVE);
        mediaMap.put("ledger", MediaSizeName.LEDGER);
        mediaMap.put("tabloid", MediaSizeName.TABLOID);
        mediaMap.put("invoice", MediaSizeName.INVOICE);
        mediaMap.put("folio", MediaSizeName.FOLIO);
        mediaMap.put("quarto", MediaSizeName.QUARTO);
        mediaMap.put("japanese-postcard", MediaSizeName.JAPANESE_POSTCARD);
        mediaMap.put("oufuko-postcard", MediaSizeName.JAPANESE_DOUBLE_POSTCARD);
        mediaMap.put("a", MediaSizeName.A);
        mediaMap.put("b", MediaSizeName.B);
        mediaMap.put("c", MediaSizeName.C);
        mediaMap.put("d", MediaSizeName.D);
        mediaMap.put("e", MediaSizeName.E);
        mediaMap.put("iso-designated-long", MediaSizeName.ISO_DESIGNATED_LONG);
        mediaMap.put("italian-envelope", MediaSizeName.ITALY_ENVELOPE);
        mediaMap.put("monarch-envelope", MediaSizeName.MONARCH_ENVELOPE);
        mediaMap.put("personal-envelope", MediaSizeName.PERSONAL_ENVELOPE);
        mediaMap.put("na-number-9-envelope", MediaSizeName.NA_NUMBER_9_ENVELOPE);
        mediaMap.put("na-number-10-envelope", MediaSizeName.NA_NUMBER_10_ENVELOPE);
        mediaMap.put("na-number-11-envelope", MediaSizeName.NA_NUMBER_11_ENVELOPE);
        mediaMap.put("na-number-12-envelope", MediaSizeName.NA_NUMBER_12_ENVELOPE);
        mediaMap.put("na-number-14-envelope", MediaSizeName.NA_NUMBER_14_ENVELOPE);
        mediaMap.put("na-6x9-envelope", MediaSizeName.NA_6X9_ENVELOPE);
        mediaMap.put("na-7x9-envelope", MediaSizeName.NA_7X9_ENVELOPE);
        mediaMap.put("na-9x11-envelope", MediaSizeName.NA_9X11_ENVELOPE);
        mediaMap.put("na-9x12-envelope", MediaSizeName.NA_9X12_ENVELOPE);
        mediaMap.put("na-10x13-envelope", MediaSizeName.NA_10X13_ENVELOPE);
        mediaMap.put("na-10x14-envelope", MediaSizeName.NA_10X14_ENVELOPE);
        mediaMap.put("na-10x15-envelope", MediaSizeName.NA_10X15_ENVELOPE);
        mediaMap.put("na-5x7", MediaSizeName.NA_5X7);
        mediaMap.put("na-8x10", MediaSizeName.NA_8X10);
        Object mediaobj = mediaMap.get(mediasize);
        if (mediaobj != null) {
            this.msn = (MediaSizeName)mediaobj;
            this.ms = MediaSize.getMediaSizeForName(this.msn);
        }
        this.msfl = this.ms.getSize(this.mediaUnits);
        return this.msfl;
    }

    public boolean fileExists(String[] fileList, String file) {
        int index;
        boolean res = false;
        if (file != null && fileList != null && (index = file.lastIndexOf("/") + 1) > 1) {
            file = file.substring(index);
            for (int ii = 0; ii < fileList.length; ++ii) {
                if (!fileList[ii].equals(file)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public boolean isOk() {
        return this.b_ok;
    }

    public Map<String, String> getPrinterSettings() {
        return this.printerSettings;
    }

    protected void SetDlgLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void setMediaUnits(int mediaUnits) {
        this.mediaUnits = mediaUnits <= 0 ? 1000 : 25400;
    }

    private void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.jB_print) {
            String file;
            String[] files;
            int msg;
            JFileChooser jfc = null;
            String extension = "ps";
            if (this.osVersion.equals("windows")) {
                extension = "prn";
            }
            int fileprint = -1;
            if (this.jCb_print.getSelectedIndex() == this.printerList.length - 1) {
                this.jChB_file.setEnabled(false);
                this.jTF_file.setEnabled(false);
            } else {
                this.printerSettings.put("printService", Globals.getStringValue(this.jCb_print.getSelectedItem()));
                this.jChB_file.setEnabled(true);
                this.jTF_file.setEnabled(true);
            }
            this.printerSettings.put("mediaSize", Globals.getStringValue(this.jCb_media.getSelectedItem()));
            this.printerSettings.put("mediaTray", String.valueOf(this.jCb_src.getSelectedIndex()));
            this.printerSettings.put("copies", Globals.getStringValue(this.jSp_copy.getValue()));
            if (this.jRB_portrait.isSelected()) {
                this.printerSettings.put("orientation", "portrait");
            } else {
                this.printerSettings.put("orientation", "landscape");
            }
            this.tmp = this.jTF_left.getText();
            this.tmp = this.tmp + "," + this.jTF_sup.getText();
            this.tmp = this.tmp + "," + this.jTF_right.getText();
            this.tmp = this.tmp + "," + this.jTF_inf.getText();
            this.printerSettings.put("printableArea", this.tmp);
            if (this.jChB_file.isSelected() && this.jCb_print.getSelectedIndex() < this.printerList.length - 1) {
                fileprint = 0;
                this.printerSettings.put("prn", "1");
                jfc = this.createJFileChooser("prn");
                if (jfc != null) {
                    if (jfc.showOpenDialog(this) == 0) {
                        msg = 0;
                        files = jfc.getCurrentDirectory().list();
                        file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\");
                        if (file.indexOf("." + extension) < file.length() - extension.length() - 1) {
                            file = file + "." + extension;
                        }
                        while (this.fileExists(files, file) && msg != 0) {
                            Toolkit.getDefaultToolkit().beep();
                            msg = JOptionPane.showConfirmDialog(this, this.trad[this.lan][20], this.trad[this.lan][1], 0, 3);
                            if (msg != 1) break;
                            if (jfc.showOpenDialog(this) != 0) break;
                            files = jfc.getCurrentDirectory().list();
                            if (this.fileExists(files, file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\"))) {
                                msg = 1;
                                continue;
                            }
                            msg = 0;
                            break;
                        }
                        if (msg == 0) {
                            this.printerSettings.put("file", file);
                            fileprint = 1;
                        }
                    }
                }
            } else {
                this.printerSettings.put("prn", "0");
            }
            if (this.jCb_print.getSelectedIndex() == this.printerList.length - 1) {
                fileprint = 0;
                jfc = this.createJFileChooser("pdf");
                if (jfc != null && jfc.showOpenDialog(this) == 0) {
                    msg = -1;
                    files = jfc.getCurrentDirectory().list();
                    file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\");
                    if (!file.endsWith(".pdf")) {
                        file = file + ".pdf";
                    }
                    while (this.fileExists(files, file) && msg != 0) {
                        Toolkit.getDefaultToolkit().beep();
                        msg = JOptionPane.showConfirmDialog(this, this.trad[this.lan][20], this.trad[this.lan][1], 0, 3);
                        if (msg != 1 || jfc.showOpenDialog(this) != 0) break;
                        files = jfc.getCurrentDirectory().list();
                        if (this.fileExists(files, file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\"))) {
                            msg = -1;
                            continue;
                        }
                        msg = 0;
                        break;
                    }
                    this.printerSettings.put("pdf", file);
                    this.printerSettings.put("printService", "pdf");
                    fileprint = 1;
                }
            }
            if (fileprint == -1 || fileprint == 1) {
                this.b_ok = true;
                this.dispose();
            }
        } else if (ae.getSource() == this.jB_esc) {
            this.b_ok = false;
            this.dispose();
        } else if (ae.getSource() == this.jRB_landscape) {
            if (!this.b_ls) {
                this.jTF_left.setText(this.df1.format(this.mpa[3]));
                this.jTF_sup.setText(this.df1.format(this.mpa[0]));
                this.jTF_right.setText(this.df1.format(this.mpa[1]));
                this.jTF_inf.setText(this.df1.format(this.mpa[2]));
                this.printerSettings.put("orientation", "portrait");
                this.b_ls = true;
            }
        } else if (ae.getSource() == this.jRB_portrait && this.b_ls) {
            this.jTF_left.setText(this.df1.format(this.mpa[0]));
            this.jTF_sup.setText(this.df1.format(this.mpa[1]));
            this.jTF_right.setText(this.df1.format(this.mpa[2]));
            this.jTF_inf.setText(this.df1.format(this.mpa[3]));
            this.printerSettings.put("orientation", "landscape");
            this.b_ls = false;
        }
    }

    private void focusGained(FocusEvent fe) {
        if (fe.getSource() == this.jTF_left) {
            this.marges[0] = this.jTF_left.getText();
        } else if (fe.getSource() == this.jTF_sup) {
            this.marges[1] = this.jTF_sup.getText();
        } else if (fe.getSource() == this.jTF_right) {
            this.marges[2] = this.jTF_right.getText();
        } else if (fe.getSource() == this.jTF_inf) {
            this.marges[3] = this.jTF_inf.getText();
        }
    }

    private void focusLost(FocusEvent fe) {
        double dbl_tmp = 0.0;
        boolean b_format = false;
        if (fe.getSource() == this.jTF_left) {
            try {
                dbl_tmp = Globals.getDoubleValue(this.jTF_left.getText());
                this.jTF_left.setText(this.df1.format(dbl_tmp));
            }
            catch (NumberFormatException nfe) {
                this.jTF_left.setText(this.marges[0]);
                b_format = true;
            }
        }
        if (fe.getSource() == this.jTF_sup) {
            try {
                dbl_tmp = Globals.getDoubleValue(this.jTF_sup.getText());
                this.jTF_sup.setText(this.df1.format(dbl_tmp));
            }
            catch (NumberFormatException nfe) {
                this.jTF_sup.setText(this.marges[1]);
                b_format = true;
            }
        }
        if (fe.getSource() == this.jTF_right) {
            try {
                dbl_tmp = Globals.getDoubleValue(this.jTF_right.getText());
                this.jTF_right.setText(this.df1.format(dbl_tmp));
            }
            catch (NumberFormatException nfe) {
                this.jTF_right.setText(this.marges[2]);
                b_format = true;
            }
        }
        if (fe.getSource() == this.jTF_inf) {
            try {
                dbl_tmp = Globals.getDoubleValue(this.jTF_inf.getText());
                this.jTF_inf.setText(this.df1.format(dbl_tmp));
            }
            catch (NumberFormatException nfe) {
                this.jTF_inf.setText(this.marges[3]);
                b_format = true;
            }
        }
    }

    private void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.jCb_print) {
            this.media = this.getMedia(this.jCb_print.getSelectedIndex());
            this.printerSettings.put("printService", Globals.getStringValue(this.jCb_print.getSelectedItem()));
            String mediasize = this.printerSettings.get("mediaSize").toString();
            this.tmp = this.jCb_media.getSelectedItem().toString();
            this.jCb_media.removeAllItems();
            int idprev = -1;
            int idconf = 0;
            for (int ii = 0; ii < this.media.length; ++ii) {
                if (this.media[ii].toString().equals(this.tmp)) {
                    idprev = ii;
                }
                if (this.media[ii].equals(mediasize)) {
                    idconf = ii;
                }
                this.jCb_media.addItem(this.media[ii]);
            }
            this.jCb_media.repaint();
            if (idprev == -1) {
                idprev = idconf;
            }
            this.jCb_media.setSelectedIndex(idprev);
            if (this.jCb_print.getSelectedIndex() < this.printerList.length - 1) {
                this.jChB_file.setEnabled(true);
                this.jTF_file.setEnabled(true);
            } else {
                this.jChB_file.setEnabled(false);
                this.jTF_file.setEnabled(false);
            }
        } else if (ie.getSource() == this.jCb_media) {
            this.printerSettings.put("mediaSize", Globals.getStringValue(this.jCb_media.getSelectedItem()));
        } else if (ie.getSource() == this.jCb_src) {
            this.printerSettings.put("mediaTray", String.valueOf(this.jCb_src.getSelectedIndex()));
        }
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getSource() == this.jTF_file && this.jChB_file.isEnabled()) {
            this.jChB_file.setSelected(!this.jChB_file.isSelected());
        }
    }

    class PrtFilter
    extends FileFilter {
        String description;
        String[] extension;

        public PrtFilter(String description, String[] extension) {
            this.description = description;
            this.extension = extension;
        }

        @Override
        public boolean accept(File file) {
            boolean b_accept = false;
            if (file.isDirectory()) {
                return true;
            }
            String extension = null;
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                extension = s.substring(i + 1).toLowerCase();
            }
            if (extension != null) {
                for (int cter = 0; cter < this.extension.length; ++cter) {
                    if (!extension.equals(this.extension[cter]) && !this.extension[cter].equals("*")) continue;
                    b_accept = true;
                    break;
                }
            }
            return b_accept;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    class DlgPrint_mouseAdapter
    extends MouseAdapter {
        DlgPrint adaptee;

        DlgPrint_mouseAdapter(DlgPrint adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.adaptee.mouseClicked(me);
        }
    }

    class DlgPrint_focusAdapter
    implements FocusListener {
        DlgPrint adaptee;

        DlgPrint_focusAdapter(DlgPrint adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            this.adaptee.focusGained(fe);
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.adaptee.focusLost(fe);
        }
    }

    class DlgPrint_itemAdapter
    implements ItemListener {
        DlgPrint adaptee;

        DlgPrint_itemAdapter(DlgPrint adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            this.adaptee.itemStateChanged(ie);
        }
    }

    class DlgPrint_actionAdapter
    implements ActionListener {
        DlgPrint adaptee;

        DlgPrint_actionAdapter(DlgPrint adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

