/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Config;
import core.hibernate.DbMetadata;
import core.hibernate.SessionFactoryUtil;
import core.hibernate.usrcat.dao.HibernateM4_UsrDao;
import core.hibernate.usrcat.dao.HibernateMatDbDao;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import sun.swing.FilePane;

public class FileUtilities {
    JFrame parent;
    DbMetadata dbMetaUsrCat;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;

    public FileUtilities() {
    }

    public FileUtilities(JFrame parent) {
        this.parent = parent;
    }

    public JFileChooser createJFileChooser(String file, String description, String extension, String title, int selectionMode) {
        return this.createJFileChooser(file, new String[]{description}, new String[]{extension}, title, selectionMode);
    }

    public JFileChooser createJFileChooser(String file, String[] description, String[] extension, String title, int selectionMode) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setApproveButtonText("Ok");
        fileChooser.setFont(Globals.FT_STAND1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.enableInputMethods(false);
        fileChooser.setFileSelectionMode(selectionMode);
        if (selectionMode == 0 || selectionMode == 2) {
            fileChooser.addChoosableFileFilter(new FileTypeFilter(Ecad2007.getTraduction("gen").getCodeLan("all_files"), "*"));
        } else if (selectionMode == 1) {
            fileChooser.addChoosableFileFilter(new FileTypeFilter(Ecad2007.getTraduction("gen").getCodeLan("all_directories"), "*", 1));
        }
        if (extension != null) {
            if (description == null) {
                description = new String[extension.length];
            }
            for (int ii = 0; ii < extension.length; ++ii) {
                if (extension[ii] == null) continue;
                FileTypeFilter fileTypeFilter = new FileTypeFilter(description[ii], extension[ii]);
                fileChooser.addChoosableFileFilter(fileTypeFilter);
                if (ii != 0) continue;
                fileChooser.setFileFilter(fileTypeFilter);
            }
            File selDir = new File(file.replaceAll("&#92;", "\\\\"));
            for (int ii = 0; ii < extension.length; ++ii) {
                if (!file.endsWith("." + extension[ii])) continue;
                int index = file.lastIndexOf(System.getProperty("file.separator"));
                if (index > 0) {
                    file = file.substring(0, index);
                    break;
                }
                selDir = null;
                break;
            }
            fileChooser.setSelectedFile(selDir);
        }
        Locale locale = Locale.getDefault();
        if (!fileChooser.getLocale().equals(locale)) {
            fileChooser.setLocale(locale);
            SwingUtilities.updateComponentTreeUI(fileChooser);
            JOptionPane.setDefaultLocale(locale);
        }
        Config config = new Config(System.getProperty("conf.file.name"));
        int fileviewtype = config.getPropertyInt("properties", "fileviewtype");
        Component[] components = fileChooser.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof FilePane)) continue;
            FilePane filePane = (FilePane)components[ii];
            filePane.setViewType(fileviewtype);
            break;
        }
        return fileChooser;
    }

    public boolean fileExists(String[] fileList, String file, String fileExtension) {
        int index;
        boolean res = false;
        if (!file.endsWith(fileExtension)) {
            file = file + fileExtension;
        }
        if (file != null && fileList != null && (index = file.lastIndexOf(System.getProperty("file.separator")) + 1) > 1) {
            file = file.substring(index);
            for (int ii = 0; ii < fileList.length; ++ii) {
                if (!fileList[ii].equals(file)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public boolean importUsrDb(File file) {
        boolean res = false;
        Vector<Object[]> vector = new Vector(100);
        int build = Ecad2007.getScy(Globals.ENERCAD_NAME).getIntValue("buildVER");
        String[][] tpCols = null;
        Object[] defValues = null;
        tpCols = new String[][]{{"NOM_FR", "NOM_FR"}, {"NOM_AL", "NOM_AL"}, {"NOM_IT", "NOM_IT"}, {"NOM_EN", "NOM_EN"}, {"GG", "GG"}, {"ALPHA", "ALPHA"}, {"LAMBDA", "LAMBDA"}, {"CC", "CC"}, {"DD", "DD"}, {"VMIN", "VMIN"}, {"VMAX", "VMAX"}, {"H2O", "H2O"}, {"POROSITE", "POROSITE"}, {"EPAISSEUR", "EPAISSEUR"}, {"NRE", "NRE"}, {"CO2", "CO2"}, {"UBP", "UBP"}, {"SRC", "SRC"}, {"SRCECO", "SRCECO"}, {"PATTERN", "PATTERN"}, {"DTSTART", "DTSTART"}, {"DTSTOP", "DTSTOP"}, {"UPDT", "UPDT"}, {"RES", "RES"}, {"FLAGS", "FLAGS"}, {"POSITION", "POSITION"}, {"REF", "REF"}};
        if (build < 424) {
            defValues = new Object[tpCols.length];
            tpCols[16][0] = "SO2";
            defValues[0] = new Float(0.0f);
        }
        vector = this.readUsrTableByUniqueRef("jdbc:derby:" + file.getAbsolutePath(), "m4_usr", FileUtilities.reverseArray(tpCols)[0], defValues);
        vector = this.redefineRefs(vector);
        int i_res = this.insertIntoTable("m4_usr", FileUtilities.reverseArray(tpCols)[1], vector);
        return i_res == vector.size();
    }

    public boolean importH2UsrDb(File file) {
        boolean res = false;
        Vector<Object[]> vector = new Vector(100);
        if (file == null) {
            return res;
        }
        String[][] tpCols = null;
        Object[] defValues = null;
        tpCols = new String[][]{{"NOM_FR", "NOM_FR"}, {"NOM_AL", "NOM_AL"}, {"NOM_IT", "NOM_IT"}, {"NOM_EN", "NOM_EN"}, {"GG", "GG"}, {"ALPHA", "ALPHA"}, {"LAMBDA", "LAMBDA"}, {"CC", "CC"}, {"DD", "DD"}, {"VMIN", "VMIN"}, {"VMAX", "VMAX"}, {"H2O", "H2O"}, {"POROSITE", "POROSITE"}, {"EPAISSEUR", "EPAISSEUR"}, {"NRE", "NRE"}, {"CO2", "CO2"}, {"UBP", "UBP"}, {"SRC", "SRC"}, {"SRCECO", "SRCECO"}, {"PATTERN", "PATTERN"}, {"DTSTART", "DTSTART"}, {"DTSTOP", "DTSTOP"}, {"UPDT", "UPDT"}, {"RES", "RES"}, {"FLAGS", "FLAGS"}, {"POSITION", "POSITION"}, {"REF", "REF"}};
        String fileName = file.getAbsolutePath();
        if (fileName.endsWith(".mv.db")) {
            fileName = fileName.substring(0, fileName.indexOf(".mv.db"));
        }
        if (fileName.endsWith(".db")) {
            fileName = fileName.substring(0, fileName.indexOf(".db"));
        }
        vector = this.readUsrTableByUniqueRef("jdbc:h2://" + fileName, "m4_usr", FileUtilities.reverseArray(tpCols)[0], defValues);
        vector = this.redefineRefs(vector);
        int i_res = this.insertIntoTable("m4_usr", FileUtilities.reverseArray(tpCols)[1], vector);
        return i_res == vector.size();
    }

    private int insertIntoTable(String table, String[] cols, Vector<Object[]> rows) {
        int i_res = 0;
        String xml = "enercad.cfg.xml";
        if (Globals.int_ver >= 510) {
            xml = "enercad_h2.cfg.xml";
        }
        SessionFactory sessionFactory = Ecad2007.getSession(xml, "usrcat").getSessionFactory();
        Session session = sessionFactory.openSession();
        HibernateM4_UsrDao hibernateM4_usrDao = new HibernateM4_UsrDao(session);
        i_res = hibernateM4_usrDao.insertIntoTable(table, cols, rows);
        return i_res;
    }

    private String[][] prepareColumnMapping(String table) {
        return this.prepareColumnMapping(table, false);
    }

    private String[][] prepareColumnMapping(String table, boolean idFirst) {
        String[][] cols = null;
        if (this.dbMetaUsrCat == null) {
            this.dbMetaUsrCat = new DbMetadata("usrcat");
        }
        List<String> list = this.dbMetaUsrCat.listColumns(table);
        int start = 0;
        int dim = list.size();
        if (list.size() == 0) {
            return cols;
        }
        if (list.contains("ID") && !idFirst) {
            start = 1;
        }
        cols = new String[dim - start][2];
        for (int ii = 0; ii < dim - start; ++ii) {
            cols[ii][0] = list.get(ii + start);
            cols[ii][1] = list.get(ii + start);
        }
        return cols;
    }

    private Vector<Object[]> readTableByUniqueRef(File db, String table, String[] cols, Object[] defValues) {
        Vector<Object[]> vector = new Vector(100);
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(100);
        ArrayList<String> al = new ArrayList<String>(20);
        if (db == null) {
            return null;
        }
        int dim = cols.length;
        String sql = "SELECT DISTINCT ";
        for (int ii = 0; ii < dim - 1; ++ii) {
            if (cols[ii].equals("")) continue;
            sql = sql + cols[ii] + ", ";
            al.add(cols[ii]);
        }
        sql = sql + cols[dim - 1] + " FROM " + table;
        if (!cols[dim - 1].equals("")) {
            al.add(cols[dim - 1]);
        }
        if (db.isFile()) {
            HibernateMatDbDao ii = new HibernateMatDbDao(true);
        } else {
            String[] resources = new String[]{"core/hibernate/usrcat509.hbm.xml"};
            Properties properties = new Properties();
            String protocol = "jdbc:derby:";
            String url = protocol + db.getAbsolutePath();
            properties.put("hibernate.connection.url", url);
            SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil("enercad.cfg.xml", properties, resources);
            Session session = sessionFactoryUtil.getCurrentSession();
            HibernateM4_UsrDao hibernateM4_UsrDao = new HibernateM4_UsrDao(session);
            List<Object[]> list = hibernateM4_UsrDao.getM4_UsrList(cols, sql);
            for (int ii = 0; ii < list.size(); ++ii) {
                Object[] row = list.get(ii);
                map.put(Globals.getStringValue(row[dim - 1]), row);
            }
        }
        vector = new Vector(map.values());
        return vector;
    }

    private Vector<Object[]> readUsrTableByUniqueRef(String url, String table, String[] cols, Object[] defValues) {
        Vector<Object[]> vector = new Vector(100);
        ArrayList<String> al = new ArrayList<String>(20);
        if (url == null) {
            return null;
        }
        String xml = "enercad.cfg.xml";
        String[] resources = null;
        if (url.contains("h2")) {
            xml = "enercad_h2.cfg.xml";
        } else {
            resources = new String[]{"core/hibernate/usrcat.hbm.xml"};
        }
        Session session = Ecad2007.getSession(url, xml, "usrcat", resources);
        int dim = cols.length;
        String sql = "SELECT DISTINCT ";
        for (int ii = 0; ii < dim - 1; ++ii) {
            if (cols[ii].equals("")) continue;
            sql = sql + cols[ii] + ", ";
            al.add(cols[ii]);
        }
        sql = sql + cols[dim - 1] + " FROM " + table;
        if (!cols[dim - 1].equals("")) {
            al.add(cols[dim - 1]);
        }
        HibernateM4_UsrDao hibernateM4_UsrDao = new HibernateM4_UsrDao(session);
        List<Object[]> list = hibernateM4_UsrDao.getM4_UsrList(cols, sql);
        vector = new Vector<Object[]>(list);
        return vector;
    }

    private Vector<Object[]> redefineRefs(Vector<Object[]> vector) {
        Vector<Object[]> vct = new Vector<Object[]>(vector.size());
        HibernateM4_UsrDao hibernateM4_UsrDao = new HibernateM4_UsrDao();
        int lastRRef = hibernateM4_UsrDao.getLastRRef();
        int size = vector.size();
        for (int ii = 0; ii < size; ++ii) {
            Object[] object = vector.get(ii);
            String ref = "1," + (lastRRef + 1 + ii);
            object[object.length - 1] = ref;
            vct.add(object);
        }
        return vct;
    }

    public static String[][] reverseArray(String[][] array) {
        int xx = array.length;
        int yy = array[0].length;
        String[][] res = new String[yy][xx];
        for (int ii = 0; ii < yy; ++ii) {
            for (int jj = 0; jj < xx; ++jj) {
                res[ii][jj] = array[jj][ii];
            }
        }
        return res;
    }

    class FileTypeFilter
    extends FileFilter {
        String description;
        String extension;
        int fileType = 0;

        public FileTypeFilter(String extension) {
            this.extension = extension;
        }

        public FileTypeFilter(String description, String extensionOfFilter) {
            this.description = description;
            this.extension = extensionOfFilter;
        }

        public FileTypeFilter(String description, String extensionOfFilter, int fileType) {
            this.description = description;
            this.extension = extensionOfFilter;
            this.fileType = fileType;
        }

        @Override
        public boolean accept(File file) {
            boolean b_accept = false;
            if (file.isDirectory()) {
                return true;
            }
            if (this.extension == null) {
                return false;
            }
            String fn = file.getName();
            String fe = fn.toLowerCase();
            int index = fe.indexOf("." + this.extension);
            if (index > 0 && index < fe.length() - 1) {
                fe = fe.substring(index + 1);
            }
            if (fe.equals(this.extension) || this.extension.equals("*")) {
                b_accept = true;
            }
            return b_accept;
        }

        @Override
        public String getDescription() {
            if (this.description == null) {
                return String.format("*.%s", this.extension);
            }
            if (this.fileType == 1) {
                return this.description + String.format(" (%s)", this.extension);
            }
            return this.description + String.format(" (*.%s)", this.extension);
        }
    }
}

