/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class Globals {
    public static final char GROUPINGSEPARATOR = '\'';

    public static float getFloatValue(Object value) {
        float res = 0.0f;
        Double rres = Globals.getDouble(value);
        if (rres != null) {
            res = rres.floatValue();
        }
        return res;
    }

    public static float getFloatValue(JFormattedTextField jFormattedTextField) {
        Object value = Globals.commitEdit(jFormattedTextField);
        float res = 0.0f;
        Double rres = Globals.getDouble(value);
        if (rres != null) {
            res = rres.floatValue();
        }
        return res;
    }

    public static float getDoubleValue(Object value, float def) {
        float res = def;
        Double rres = Globals.getDouble(value);
        if (rres != null) {
            res = rres.floatValue();
        }
        return res;
    }

    public static double getDoubleValue(Object value) {
        double res = 0.0;
        Double rres = Globals.getDouble(value);
        if (rres != null) {
            res = rres;
        }
        return res;
    }

    public static double getDoubleValue(JFormattedTextField jFormattedTextField, double defValue) {
        if (jFormattedTextField == null) {
            return 0.0;
        }
        Object value = Globals.commitEdit(jFormattedTextField);
        double res = 0.0;
        Double rres = Globals.getDouble(value, defValue);
        res = rres == null ? defValue : rres;
        return res;
    }

    public static double getDoubleValue(JFormattedTextField jFormattedTextField) {
        return Globals.getDoubleValue(jFormattedTextField, 0.0);
    }

    public static String getStringValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public static String getStringValue(Object object, String defaultValue) {
        String res = Globals.getStringValue(object);
        if (res.equals("")) {
            res = defaultValue;
        }
        return res;
    }

    public static String getStringValue(JFormattedTextField jFormattedTextField) {
        return String.valueOf(Globals.getDoubleValue(jFormattedTextField, 0.0));
    }

    public static double getDoubleValue(Object value, double def) {
        double res = def;
        Double rres = Globals.getDouble(value);
        if (rres != null) {
            res = rres;
        }
        return res;
    }

    public static int getIntValue(Object value, int def) {
        return (int)Globals.getDoubleValue(value, def);
    }

    public static int getIntValue(JFormattedTextField jFormattedTextField) {
        Object value = Globals.commitEdit(jFormattedTextField);
        int res = 0;
        Integer rres = Globals.getInteger(value);
        if (rres != null) {
            res = rres;
        }
        return res;
    }

    public static int getIntValue(JTextField jTextField) {
        String value = jTextField.getText();
        int res = 0;
        Integer rres = Globals.getInteger(value);
        if (rres != null) {
            res = rres;
        }
        return res;
    }

    public static Integer getInteger(Object value) {
        return Globals.getIntValue(value);
    }

    public static BigInteger getBigInteger(Object value) {
        if (value == null) {
            return BigInteger.valueOf(0L);
        }
        BigInteger bigInteger = BigInteger.valueOf(Globals.getLongValue(value));
        return bigInteger;
    }

    public static short getShortValue(Object value) {
        return (short)Globals.getDoubleValue(value);
    }

    public static int getIntValue(Object value) {
        return (int)Globals.getDoubleValue(value);
    }

    public static long getLongValue(Object value, long def) {
        return (long)Globals.getDoubleValue(value, def);
    }

    public static long getLongValue(Object value) {
        return (long)Globals.getDoubleValue(value);
    }

    public static Double getDouble(Object value, double defValue) {
        Double res = Globals.getDouble(value);
        if (res == null) {
            res = new Double(defValue);
        }
        return res;
    }

    public static Double getDouble(Object value) {
        Double res = null;
        if (value == null) {
            return res;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).doubleValue();
        }
        String str_val = value.toString();
        str_val = str_val.trim();
        str_val = str_val.replaceAll(String.valueOf('\''), "");
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp2 = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        if (Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", str_val)) {
            res = Double.valueOf(str_val);
        }
        return res;
    }

    public static double getDouble(JFormattedTextField jFormattedTextField) {
        return Globals.getDouble(jFormattedTextField, 0.0);
    }

    public static Double getDouble(JFormattedTextField jFormattedTextField, double defValue) {
        if (jFormattedTextField == null) {
            return new Double(defValue);
        }
        Object value = Globals.commitEdit(jFormattedTextField);
        Double res = Globals.getDouble(value, defValue);
        if (res == null) {
            res = new Double(defValue);
        }
        return res;
    }

    public static Object commitEdit(JFormattedTextField formattedTextField) {
        Object object = null;
        if (formattedTextField == null) {
            return object;
        }
        try {
            formattedTextField.commitEdit();
            object = formattedTextField.getValue();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return object;
    }
}

