/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private int width;
    private int height;
    private ImageIcon icon;
    private transient Image image;
    private Rectangle rectangle;
    private int ACCSIZE = 155;
    private Color bg;

    public ImagePreviewPanel() {
        this.setPreferredSize(new Dimension(this.ACCSIZE, -1));
        this.bg = this.getBackground();
    }

    public ImagePreviewPanel(File file) {
        this();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        String name = file.getAbsolutePath();
        if (name != null && name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png")) {
            this.icon = new ImageIcon(name);
            this.image = this.icon.getImage();
            this.scaleImage();
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName = pce.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            File selection = (File)pce.getNewValue();
            if (selection == null) {
                return;
            }
            String name = selection.getAbsolutePath();
            if (name != null && name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png")) {
                this.icon = new ImageIcon(name);
                this.image = this.icon.getImage();
                this.scaleImage();
                this.repaint();
            }
        }
    }

    private void scaleImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        double ratio = 1.0;
        if (this.image == null) {
            return;
        }
        if (this.width >= this.height) {
            ratio = (double)(this.ACCSIZE - 5) / (double)this.width;
            this.width = this.ACCSIZE - 5;
            this.height = (int)((double)this.height * ratio);
        } else if (this.getHeight() > 150) {
            ratio = (double)(this.ACCSIZE - 5) / (double)this.height;
            this.height = this.ACCSIZE - 5;
            this.width = (int)((double)this.width * ratio);
        } else {
            ratio = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * ratio);
        }
        if (this.width <= 0) {
            this.width = this.image.getWidth(this);
        }
        if (this.width <= 0) {
            this.width = 800;
        }
        if (this.height <= 0) {
            this.height = this.image.getHeight(this);
        }
        if (this.height <= 0 || this.height > this.ACCSIZE) {
            this.height = this.ACCSIZE - 5;
        }
        if (this.width <= 0 || this.width > this.ACCSIZE) {
            this.width = this.ACCSIZE - 5;
        }
        this.image = this.image.getScaledInstance(this.width, this.height, 1);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.rectangle = rectangle;
        this.ACCSIZE = rectangle.width;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        String name = file.getAbsolutePath();
        if (name != null && name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png")) {
            this.icon = new ImageIcon(name);
            this.image = this.icon.getImage();
            this.scaleImage();
            this.repaint();
        }
    }

    public void setIcon(ImageIcon icon) {
        if (icon == null) {
            this.image = new BufferedImage(this.rectangle.width, this.rectangle.height, 2);
            this.repaint();
            return;
        }
        this.image = icon.getImage();
        this.repaint();
    }

    public void setIconAndAdaptHeight(ImageIcon icon) {
        if (icon == null) {
            this.image = new BufferedImage(this.rectangle.width, this.rectangle.height, 2);
            this.repaint();
            return;
        }
        this.image = icon.getImage();
        double hh = icon.getIconHeight();
        double ratio = (double)icon.getIconWidth() / this.rectangle.getWidth();
        if (this.rectangle.height > (int)(hh /= ratio)) {
            this.setSize(this.rectangle.width, (int)hh + 3);
        } else {
            this.setSize(this.rectangle.width, this.rectangle.height);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.bg);
        if (this.image == null) {
            return;
        }
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        double ratio = this.rectangle.getWidth() / (double)this.width;
        Dimension size = new Dimension(this.rectangle.width, (int)(ratio * (double)this.height));
        g2d.fillRect(0, 0, this.rectangle.width, this.rectangle.height);
        g2d.drawImage(this.image, 0, 0, size.width, size.height, this);
    }
}

