/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Config;
import core.FileUtilities;
import core.hibernate.DbMetadata;
import core.hibernate.pro.dao.HibernateComposant_MDao;
import core.hibernate.pro.dao.HibernateEnvelopeDao;
import core.hibernate.pro.dao.HibernateFacadeDao;
import core.hibernate.pro.dao.HibernateMaterialsDao;
import core.hibernate.pro.dao.HibernateProjetDao;
import core.hibernate.pro.dao.HibernateScyDao;
import core.hibernate.pro.db.Composant_M;
import core.hibernate.pro.db.Envelope;
import core.hibernate.pro.db.Facade;
import core.hibernate.pro.db.MatDb;
import core.hibernate.pro.db.Materials;
import core.hibernate.tmp.dao.HibernateTmpDao;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import scy.Scy;
import security.DecryptGenerator;
import sun.swing.FilePane;

public class JarFile {
    public final int BUFFER_SIZE = 1024;
    private final int FILE_SAVE = 2;
    private final int FILE_OPEN = 1;
    String dir;
    File jar;
    Container parent;
    Globals globals = new Globals();
    Config config = new Config(System.getProperty("conf.file.name"));
    DM_Trad gen_trad;
    DM_Trad print_trad;
    DbMetadata dbMetaTmp;
    DbMetadata dbMetaPro;
    HibernateTmpDao hibernateTmpDao;
    int prevfileviewtype = 0;
    int fileviewtype = 0;
    JarOutputStream jos = null;
    int iBaseFolderLength = 0;

    public JarFile() {
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.print_trad = Ecad2007.getTraduction("print");
        this.prevfileviewtype = this.config.getPropertyInt("properties", "fileviewtype");
    }

    public JarFile(JFrame parent) {
        this.parent = parent;
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.print_trad = Ecad2007.getTraduction("print");
        this.prevfileviewtype = this.config.getPropertyInt("properties", "fileviewtype");
    }

    public JarFile(JFrame parent, String dir) {
        this.parent = parent;
        this.dir = dir;
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.print_trad = Ecad2007.getTraduction("print");
    }

    public JarFile(String dir, String jar) {
        this.dir = dir;
        this.jar = new File(jar);
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.print_trad = Ecad2007.getTraduction("print");
        this.prevfileviewtype = this.config.getPropertyInt("properties", "fileviewtype");
    }

    public boolean createJarFile() {
        return this.createJarFile(null);
    }

    public boolean createJarFile(File jar) {
        boolean res = false;
        if (jar == null) {
            res = this.showFileDialog(2, "pro");
        } else {
            this.jar = jar;
            res = true;
        }
        if (this.jar == null) {
            return false;
        }
        try {
            String strBaseFolder = this.dir + File.separator;
            this.iBaseFolderLength = strBaseFolder.length();
            FileOutputStream fos = new FileOutputStream(this.jar);
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.putValue("userNAME", this.config.getPropertyString("properties", "userNAME"));
            attributes.putValue("macID", Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("mac"));
            attributes.putValue("saveVER", String.valueOf(Globals.int_ver));
            attributes.putValue("versionDate", "2021-03-02");
            attributes.putValue("buildVER", String.valueOf(Globals.int_ver));
            attributes.putValue("buildLVL", Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("fLevel"));
            attributes.putValue("buildUSR", Ecad2007.getUserName());
            attributes.putValue("fLevel", Ecad2007.getScy(Globals.PROJECT_NAME).getValue("fLevel"));
            attributes.putValue("vmVersion", System.getProperty("java.vm.version"));
            attributes.putValue("vmVendor", System.getProperty("java.vm.vendor"));
            attributes.putValue("vmName", System.getProperty("java.vm.name"));
            attributes.putValue("javaVersion", System.getProperty("java.version"));
            attributes.putValue("osName", System.getProperty("os.name"));
            attributes.putValue("osArch", System.getProperty("os.arch"));
            attributes.putValue("osVersion", System.getProperty("os.version"));
            this.jos = new JarOutputStream((OutputStream)fos, manifest);
            this.jos.setLevel(1);
            this.checkDirectory(this.dir);
            this.jos.flush();
            this.jos.close();
            fos.close();
            res = true;
        }
        catch (IOException ex) {
            Globals.println("JarFile.createJarFile(): " + ex.getMessage());
            res = false;
        }
        return res;
    }

    public void checkDirectory(String directoryName) {
        File dirobject = new File(directoryName);
        if (dirobject.exists()) {
            if (dirobject.isDirectory()) {
                File[] fileList = dirobject.listFiles();
                for (int ii = 0; ii < fileList.length; ++ii) {
                    String file = fileList[ii].getPath();
                    if (file.endsWith(".lck") || file.equals("tmp") || file.equals("meta-inf") || file.equals("META-INF") || file.equals("MANIFEST.MF") || file.equals("manifest.mf")) continue;
                    if (fileList[ii].isDirectory()) {
                        this.checkDirectory(fileList[ii].getPath());
                        continue;
                    }
                    if (!fileList[ii].isFile()) continue;
                    this.jarFile(fileList[ii].getPath());
                }
            } else {
                Globals.println(directoryName + " is not a directory.");
            }
        }
    }

    public void copyAdditionalFiles() {
        String imgdir = this.dir + File.separator + "img";
        String xlsdir = this.dir + File.separator + "xls";
        File[] imgs = new File(imgdir).listFiles();
        File[] xlss = new File(xlsdir).listFiles();
        HashMap<String, File[]> map = new HashMap<String, File[]>(2);
        if (imgs != null) {
            map.put("img", imgs);
        }
        if (xlss != null) {
            map.put("xls", xlss);
        }
        String[] keys = new String[]{};
        keys = map.keySet().toArray(keys);
        if (keys == null) {
            return;
        }
        for (int kk = 0; kk < keys.length; ++kk) {
            File[] files = (File[])map.get(keys[kk]);
            String outdir = Globals.getProjectDBDir(true) + keys[kk];
            new File(outdir).mkdir();
            for (int ii = 0; ii < files.length; ++ii) {
                try {
                    int byteCount;
                    String outf = outdir + File.separator + files[ii].getName();
                    File output = new File(outf);
                    byte[] data = new byte[1024];
                    FileInputStream is = new FileInputStream(files[ii]);
                    FileOutputStream fos = new FileOutputStream(output);
                    while ((byteCount = ((InputStream)is).read(data, 0, 1024)) > -1) {
                        fos.write(data, 0, byteCount);
                    }
                    ((InputStream)is).close();
                    fos.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void jarFile(String filePath) {
        try {
            int byteCount;
            FileInputStream fis = new FileInputStream(filePath);
            BufferedInputStream bis = new BufferedInputStream(fis);
            JarEntry fileEntry = new JarEntry(filePath.substring(this.iBaseFolderLength));
            this.jos.putNextEntry(fileEntry);
            byte[] data = new byte[1024];
            while ((byteCount = bis.read(data, 0, 1024)) > -1) {
                this.jos.write(data, 0, byteCount);
            }
        }
        catch (IOException ex) {
            Ecad2007.trace(ex);
        }
    }

    public boolean extractJarFile(Component glasspane) {
        boolean res = false;
        if (this.jar == null) {
            res = this.showFileDialog(1, "pro");
        }
        if (res) {
            res = this.extractJarFile(this.jar, glasspane);
        }
        return res;
    }

    public boolean extractJarFile(File proFile, Component glasspane) {
        long proLevel;
        HashMap<String, String> proValues;
        java.util.jar.JarFile jar;
        File dirFile;
        String saveVER;
        String ecadDataDir;
        String fileSeparator;
        boolean res;
        block45: {
            res = false;
            fileSeparator = File.separator;
            ecadDataDir = System.getProperty("ecad.home.dir");
            saveVER = "";
            dirFile = null;
            jar = null;
            proValues = new HashMap<String, String>(250);
            proLevel = 0L;
            try {
                String scode;
                String puk1hex;
                jar = new java.util.jar.JarFile(proFile);
                Manifest manifest = jar.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                saveVER = attributes.getValue("saveVER");
                String fLevel = attributes.getValue("fLevel");
                if (fLevel == null) {
                    fLevel = String.valueOf(Ecad2007.getLicenseLevel());
                } else if (fLevel.equals("null")) {
                    fLevel = String.valueOf(Ecad2007.getLicenseLevel());
                } else if (fLevel.trim().equals("")) {
                    fLevel = String.valueOf(Ecad2007.getLicenseLevel());
                }
                if (saveVER != null) {
                    Ecad2007.setProjectVersion(Globals.getIntValue(saveVER));
                } else {
                    Ecad2007.setProjectVersion(412);
                }
                if (Ecad2007.getProjectVersion() < 416) {
                    fLevel = "4";
                }
                if (Globals.int_ver == 515) {
                    fLevel = "4";
                }
                proLevel = Globals.getLongValue(fLevel);
                if (Globals.int_ver == 515) break block45;
                DecryptGenerator decryptGenerator = new DecryptGenerator();
                String prk2hex = Ecad2007.getPrk2Hex(Globals.int_ver);
                String[] code = decryptGenerator.getSCParameters(prk2hex, puk1hex = Ecad2007.getPuk1Hex(Globals.int_ver), scode = Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("scode"));
                if (code != null) {
                    if (code.length > 4) {
                        long level = Globals.getLongValue(code[2]);
                        String cdate = code[3];
                        String cperiod = code[4];
                        if (cperiod == null) {
                            level = 0L;
                        } else {
                            int iperiod = Globals.getIntValue(cperiod);
                            if (iperiod > 0) {
                                Calendar cal = this.globals.getDate(cdate);
                                cal.add(5, iperiod);
                                if (Ecad2007.getToday().compareTo(cal) > 0) {
                                    level = 0L;
                                }
                            }
                        }
                        if (level < proLevel) {
                            proLevel = level;
                        }
                    }
                    break block45;
                }
                return false;
            }
            catch (IOException ioex) {
                String version = "EnerCAD version no:";
                String tmp = "";
                String[] tbl = null;
                int intercter = 1;
                try {
                    StreamTokenizer tok = new StreamTokenizer(new FileReader(proFile));
                    tok.resetSyntax();
                    tok.wordChars(32, 255);
                    tok.wordChars(9, 9);
                    tok.whitespaceChars(10, 13);
                    tok.eolIsSignificant(true);
                    tok.commentChar(42);
                    while (tok.nextToken() != -1) {
                        if (intercter == 2) {
                            tok.ordinaryChar(42);
                        }
                        switch (tok.ttype) {
                            case -3: {
                                if (tok.sval == null) break;
                                proValues.put(String.valueOf(intercter), tok.sval);
                                ++intercter;
                            }
                        }
                    }
                    tmp = (String)proValues.get("1");
                    if (tmp != null) {
                        tbl = tmp.split(" ");
                        if (tmp.indexOf(version) != -1) {
                            Ecad2007.setProjectVersion(Integer.parseInt(tbl[3]));
                        } else {
                            Ecad2007.setProjectVersion(218);
                        }
                    }
                }
                catch (FileNotFoundException fnex) {
                    Globals.println("JarFile.extractJarFile() message: No file " + proFile.getName() + " found.");
                }
                catch (IOException ioex2) {
                    Globals.println("JarFile.extractJarFile(): " + ioex2.getMessage());
                }
            }
        }
        if (this.dir == null) {
            if (Ecad2007.getProjectVersion() <= Globals.int_ver) {
                this.dir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + "tmp";
                this.globals.closeDb(this.dir);
                Ecad2007.removeScy(Globals.PROJECT_NAME);
            } else {
                String msg = Ecad2007.getTraduction("mf").getCodeLan("uver", new String[]{"EnerCAD", String.valueOf(Globals.int_ver), saveVER});
                JOptionPane.showMessageDialog(this.parent, msg, "EnerCAD-info", 1);
                return false;
            }
        }
        dirFile = new File(this.dir);
        this.globals.deleteFiles(new File(this.dir).listFiles());
        if (Ecad2007.getProjectVersion() >= 412) {
            Enumeration<JarEntry> entries = jar.entries();
            JarEntry entry = null;
            File file = null;
            File[] files = null;
            glasspane.setCursor(new Cursor(3));
            glasspane.setVisible(true);
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                String absoluteFile = dirFile.getAbsolutePath() + fileSeparator + entry.getName();
                absoluteFile = Ecad2007.isWindowsOS() ? absoluteFile.replace("/", fileSeparator) : absoluteFile.replace("\\", fileSeparator);
                file = new File(absoluteFile);
                String path = file.getAbsolutePath();
                String name = file.getName();
                if (!entry.isDirectory()) {
                    path = path.substring(0, path.length() - name.length() - 1);
                }
                files = dirFile.listFiles();
                int b_dir = -1;
                if (files != null) {
                    for (int ii = 0; ii < files.length; ++ii) {
                        if (!files[ii].getAbsolutePath().equals(path)) continue;
                        b_dir = ii;
                        break;
                    }
                }
                if (entry.isDirectory() || file.getName().toLowerCase().equals("manifest.mf")) continue;
                if (b_dir == -1) {
                    new File(path).mkdir();
                }
                try {
                    int byteCount;
                    InputStream is = jar.getInputStream(entry);
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] data = new byte[1024];
                    while ((byteCount = is.read(data, 0, 1024)) > -1) {
                        fos.write(data, 0, byteCount);
                    }
                    fos.close();
                    is.close();
                    res = true;
                }
                catch (IOException ioex) {
                    Globals.println("JarFile: " + ioex.getMessage());
                    res = false;
                }
            }
            Ecad2007.getScy(Globals.PROJECT_NAME).setValue("fLevel", String.valueOf(proLevel));
            Ecad2007.setLicenseLevel(proLevel);
        } else if (Ecad2007.getProjectVersion() >= 250) {
            this.globals.beep();
            JOptionPane.showMessageDialog(this.parent, this.gen_trad.getCodeLan("noucad"), "EnerCAD-info", 0);
        } else if (Ecad2007.getProjectVersion() >= 218) {
            this.extractPro(proValues, glasspane);
            glasspane.setCursor(new Cursor(0));
        }
        return res;
    }

    private Map<String, Vector> extractPro(Map<String, String> proValues, Component glasspane) {
        HashMap<String, Vector> map = new HashMap<String, Vector>(40);
        Vector<String> vector = null;
        int dim = proValues.size();
        int blCter = 0;
        String value = "";
        Object cols = null;
        String[] blocs = new String[]{"BLOC PROJET INFO", "BLOC 'MET' CLIMATE", "BLOC 'HOR' HORIZON", "BLOC 'B' BUILDING", "BLOC 'A1' SRE-V", "BLOC 'A2' VENTILATION", "BLOC 'A3' EL LOADS", "BLOC 'A4' OCCUPATION", "BLOC 'O' SHADING", "BLOC 'M' MATERIALS", "BLOC 'F' FACADES", "BLOC 'E' ENVELOPE", "BLOC 'C' COMPONANTS", "BLOC 'DLF-OPT'"};
        this.globals.beep();
        JOptionPane.showMessageDialog(this.parent, this.gen_trad.getCodeLan("noecad2004", String.valueOf(Ecad2007.getProjectVersion())) + ".", "EnerCAD-info", 0);
        glasspane.setCursor(new Cursor(3));
        glasspane.setVisible(true);
        block0: for (int ii = 1; ii < dim; ++ii) {
            value = proValues.get(String.valueOf(ii));
            if (value == null || !(value = value.trim()).equals(blocs[blCter])) continue;
            Globals.println("\nNom du bloc: " + value + "\n");
            vector = new Vector<String>(20);
            for (int jj = ii + 1; jj < dim; ++jj) {
                if (!(value = proValues.get(String.valueOf(++ii))).startsWith(" BLOC '")) {
                    if (value.startsWith(" ") || value.startsWith("%")) continue;
                    vector.add(value);
                    Globals.println(value);
                    continue;
                }
                map.put(blocs[blCter], vector);
                --ii;
                if (blCter >= blocs.length - 1) continue block0;
                ++blCter;
                continue block0;
            }
        }
        return map;
    }

    public File getJarFile() {
        return this.jar;
    }

    public int getProVersion() {
        return Ecad2007.getProjectVersion();
    }

    private boolean insertIntoTable(String table, String[] cols, Vector<Object[]> rows) {
        boolean b_res = false;
        HibernateProjetDao hibernateProjetDao = new HibernateProjetDao(false);
        hibernateProjetDao.insertIntoTable(table, cols, rows);
        return b_res;
    }

    private boolean insertIntoISETable(String table, String[] cols, Vector<Object[]> rows) {
        boolean b_res = false;
        HibernateProjetDao hibernateProjetDao = new HibernateProjetDao(false);
        hibernateProjetDao.insertIntoTable("ise", table, cols, rows);
        return b_res;
    }

    private Vector<Object[]> readTable(String table, String[] cols) {
        return this.readTable(table, cols, null);
    }

    private Vector<Object[]> readISETable(String table, String[] cols) {
        return this.readTable("ise", table, cols, null);
    }

    private Vector<Object[]> readTable(String table, String[] cols, Object[] defValues) {
        if (this.hibernateTmpDao == null) {
            this.hibernateTmpDao = new HibernateTmpDao(false);
        }
        Vector<Object[]> vector = this.hibernateTmpDao.listFromTable(table, cols, defValues);
        return vector;
    }

    private Vector<Object[]> readTable(String schema, String table, String[] cols, Object[] defValues) {
        if (this.hibernateTmpDao == null) {
            this.hibernateTmpDao = new HibernateTmpDao(false);
        }
        Vector<Object[]> vector = this.hibernateTmpDao.listFromTable(schema, table, cols, defValues);
        return vector;
    }

    private String[][] prepareColumnMapping(String table) {
        return this.prepareColumnMapping(table, false);
    }

    private String[][] prepareColumnMapping(String table, boolean idFirst) {
        String[][] cols = null;
        if (this.dbMetaPro == null) {
            this.dbMetaPro = new DbMetadata(Globals.PROJECT_NAME);
        }
        List<String> list = this.dbMetaPro.listColumns(table);
        int start = 0;
        int dim = list.size();
        if (list.size() == 0) {
            return cols;
        }
        if (list.contains("ID") && !idFirst) {
            start = 1;
        }
        cols = new String[dim - start][2];
        for (int ii = 0; ii < dim - start; ++ii) {
            cols[ii][0] = list.get(ii + start);
            cols[ii][1] = list.get(ii + start);
        }
        return cols;
    }

    private Vector<Object[]> readAndCorrectMaterialTable(String[] cols) {
        Vector<Object[]> vector = new Vector<Object[]>(100);
        ArrayList<String> al = new ArrayList<String>(20);
        Connection cn_tmp = Ecad2007.getConnection("tmp");
        String ref = null;
        String prevref = null;
        int dim = cols.length;
        String sql = "SELECT ";
        for (int ii = 0; ii < dim - 1; ++ii) {
            if (cols[ii].equals("")) continue;
            sql = sql + cols[ii] + ", ";
            al.add(cols[ii]);
        }
        sql = sql + cols[dim - 1] + " FROM materials ORDER BY REF";
        if (!cols[dim - 1].equals("")) {
            al.add(cols[dim - 1]);
        }
        Globals.println("JarFile readAndCorrectMaterialTable (<424) sql: " + sql);
        try {
            PreparedStatement prstData = cn_tmp.prepareStatement(sql);
            ResultSet rsData = prstData.executeQuery();
            Object[] row = null;
            ResultSetMetaData rsmd = rsData.getMetaData();
            while (rsData.next()) {
                int corCol = 0;
                row = new Object[dim];
                for (int ii = 0; ii < dim; ++ii) {
                    String provref;
                    if (al.contains(cols[ii])) {
                        row[ii] = rsData.getObject(cols[ii]);
                        if (row[ii] != null) continue;
                        int ct = rsmd.getColumnType(ii + 1 - corCol);
                        if (ct == 91) {
                            row[ii] = new Date(0L);
                            continue;
                        }
                        if (ct == 1) {
                            row[ii] = "";
                            continue;
                        }
                        if (ct == 12) {
                            row[ii] = "";
                            continue;
                        }
                        Globals.println("No type defined for column " + cols[ii] + ".");
                        continue;
                    }
                    long flags = 0L;
                    ref = rsData.getString("REF");
                    if (ref != null) {
                        ref = ref.trim();
                    }
                    if ((provref = rsData.getString("PROVREF")) != null) {
                        provref = provref.trim();
                    }
                    String temp = null;
                    if (ref.indexOf(",") > 0) {
                        temp = ref.substring(0, ref.indexOf(","));
                        if (temp.equals("20")) {
                            flags = 16L;
                        }
                        if (temp.equals("21")) {
                            flags += 32L;
                        }
                    }
                    if (provref.indexOf(",") > 0) {
                        temp = provref.substring(0, provref.indexOf(","));
                        if (temp.equals("20") && (flags & 0x10L) == 0L) {
                            flags = 16L;
                        }
                        if (temp.equals("21") && (flags & 0x20L) == 0L) {
                            flags += 32L;
                        }
                    }
                    row[ii] = new Long(flags);
                    ++corCol;
                }
                if (ref == null) continue;
                if (prevref == null) {
                    vector.add(row);
                } else if (!prevref.equals(ref)) {
                    vector.add(row);
                }
                prevref = ref;
            }
            if (prstData != null) {
                prstData.close();
            }
            if (rsData != null) {
                rsData.close();
            }
        }
        catch (SQLException sqlEx) {
            Globals.println("JarFile.readAndCorrectMaterialTable(): " + sqlEx.getMessage());
        }
        return vector;
    }

    public boolean repairComponentTable() {
        TreeMap<String, String[][]> tm_comp = new TreeMap<String, String[][]>();
        TreeMap<String, Short> tm_ch_c = new TreeMap<String, Short>();
        TreeMap<String, String> tm_compn = new TreeMap<String, String>();
        Vector<String> v_mat = new Vector<String>(20);
        String codeLan = "FR";
        if (Ecad2007.getCodeLan() == 0) {
            codeLan = "GE";
        } else if (Ecad2007.getCodeLan() == 1) {
            codeLan = "FR";
        } else if (Ecad2007.getCodeLan() == 2) {
            codeLan = "IT";
        } else if (Ecad2007.getCodeLan() == 3) {
            codeLan = "EN";
        }
        HibernateComposant_MDao hibernateComposant_MDao = new HibernateComposant_MDao();
        List<Composant_M> composants_m = hibernateComposant_MDao.getComposant_MList();
        for (Composant_M composant_m : composants_m) {
            String[][] refs = composant_m.getRefsInv_m4();
            String ref = composant_m.getComposant_MRef();
            String nom = composant_m.getNom();
            Short ch_c = composant_m.getCh_c();
            tm_comp.put(ref, refs);
            tm_compn.put(ref, nom);
            tm_ch_c.put(ref, ch_c);
        }
        HibernateMaterialsDao hibernateMaterialsDao = new HibernateMaterialsDao();
        List<Materials> materials = hibernateMaterialsDao.getMaterialList();
        for (Materials mat : materials) {
            String ref = mat.getRef();
            if (ref == null) continue;
            v_mat.add(ref);
        }
        List<MatDb> matDb = hibernateMaterialsDao.getMatDbList();
        for (MatDb mat : matDb) {
            String ref = mat.getRef();
            if (ref == null) continue;
            v_mat.add(ref);
        }
        boolean b_error = false;
        Object[] refs = tm_comp.keySet().toArray();
        Vector<String> del = new Vector<String>(20);
        block6: for (int jj = 0; jj < refs.length; ++jj) {
            String[][] mat_refs = (String[][])tm_comp.get(refs[jj]);
            for (int kk = 0; kk < mat_refs.length; ++kk) {
                b_error = false;
                if (mat_refs[kk][0] != null && mat_refs[kk][0].length() > 2 && mat_refs[kk][0].substring(0, 2).equals("00") && !v_mat.contains(mat_refs[kk][0])) {
                    b_error = true;
                }
                if (mat_refs[kk][1] != null && mat_refs[kk][1].length() > 2 && mat_refs[kk][1].substring(0, 2).equals("00") && !v_mat.contains(mat_refs[kk][1])) {
                    b_error = true;
                }
                if (!b_error) continue;
                del.add((String)refs[jj]);
                continue block6;
            }
        }
        int cter = del.size();
        ArrayList al = new ArrayList(20);
        ArrayList<String> alref = new ArrayList<String>(20);
        if (cter > 0) {
            String ref;
            int ii;
            HibernateEnvelopeDao hibernateEnvelopeDao = new HibernateEnvelopeDao();
            for (ii = 0; ii < cter; ++ii) {
                ref = (String)del.get(ii);
                String[] cc = ref.split(",");
                String defref = cc[0] + "," + cc[1] + "," + cc[2] + "," + cc[3] + ",0";
                al.add(tm_compn.get(ref));
                alref.add(ref);
                hibernateEnvelopeDao.updateEnvelopeByIdCManual(ref, defref);
            }
            for (ii = 0; ii < cter; ++ii) {
                ref = (String)del.get(ii);
                hibernateComposant_MDao.deleteComposant_M(ref);
            }
        }
        if (al.size() > 0) {
            String fn = this.config.getPropertyString("properties", "dir", new String[]{"mf", "pro"});
            File file = new File(fn);
            String filename = file.getParent() + System.getProperty("file.separator") + "error.log";
            filename = filename.replaceAll("&#92;", "\\\\");
            try {
                int ii;
                FileOutputStream out = new FileOutputStream(filename);
                BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "8859_1"));
                String ul = "";
                for (ii = 0; ii < 100; ++ii) {
                    ul = ul + "=";
                }
                awriter.write(this.config.getPropertyString("properties", "dir", new String[]{"mf", "pro"}));
                awriter.newLine();
                awriter.write(ul);
                awriter.newLine();
                awriter.newLine();
                awriter.flush();
                for (ii = 0; ii < al.size(); ++ii) {
                    awriter.write((String)al.get(ii));
                    awriter.newLine();
                    awriter.flush();
                }
                awriter.newLine();
                awriter.flush();
                awriter.write(ul);
                awriter.close();
                out.close();
            }
            catch (FileNotFoundException fnfex) {
                Globals.println(fnfex.getMessage());
            }
            catch (IOException ioex) {
                Globals.println(ioex.getMessage());
            }
            int msgWidth = 400;
            String href = "<a href='file://" + filename + "'>" + filename.replaceAll("\\\\", "&#92;") + "</a>";
            String txt_repair_envelope = this.gen_trad.getCodeLan("repair_envelope", href) + "<br><br>";
            JTextPane jTP_txt = new JTextPane();
            jTP_txt.setContentType("text/html");
            Color bgcolor = this.parent.getBackground();
            jTP_txt.setBackground(bgcolor);
            jTP_txt.setFont(Globals.FT_STAND1);
            txt_repair_envelope = this.globals.transformToHTML(txt_repair_envelope, bgcolor, "width: " + msgWidth + "px");
            jTP_txt.setText(txt_repair_envelope);
            jTP_txt.setEditable(false);
            jTP_txt.addHyperlinkListener(new JarFile_HyperlinkAdapter(this));
            StyledDocument doc = jTP_txt.getStyledDocument();
            Style style = jTP_txt.addStyle("FT_STAND", null);
            StyleConstants.setFontFamily(style, Globals.FT_STAND1.getFamily());
            StyleConstants.setFontSize(style, Globals.FT_STAND1.getSize());
            StyleConstants.setBackground(style, bgcolor);
            doc.setCharacterAttributes(0, txt_repair_envelope.length(), style, false);
            Object[] names = al.toArray();
            Object[] errefs = alref.toArray();
            int dim = names.length;
            Object[][] data = new Object[dim][2];
            for (int ii = 0; ii < dim; ++ii) {
                data[ii][0] = errefs[ii];
                data[ii][1] = names[ii];
            }
            DefaultTableColumnModel dtcm = new DefaultTableColumnModel();
            JTable jTbl = new JTable(data, new Object[]{"0", "1"});
            jTbl.setRowHeight(16);
            TableColumn tc_1 = jTbl.getColumnModel().getColumn(1);
            tc_1.setCellRenderer(new MessageCellRenderer(alref, tm_ch_c));
            tc_1.setPreferredWidth(msgWidth);
            dtcm.addColumn(tc_1);
            jTbl.setColumnModel(dtcm);
            jTbl.setShowGrid(false);
            jTbl.setRowSelectionAllowed(true);
            jTbl.setTableHeader(null);
            JScrollPane scrollPane = new JScrollPane(jTbl);
            scrollPane.setPreferredSize(new Dimension(msgWidth, 100));
            JPanel jPa = new JPanel();
            jPa.setLayout(new BoxLayout(jPa, 1));
            jPa.add(jTP_txt);
            jPa.add((Component)scrollPane, null);
            JOptionPane.showMessageDialog(this.parent, jPa, "EnerCAD-info", 2);
        }
        return del.size() > 0;
    }

    public boolean repairFrontTable() {
        int id_f;
        int res = 0;
        ArrayList<Integer> al = new ArrayList<Integer>();
        HibernateEnvelopeDao hb_EnvelopeDao = new HibernateEnvelopeDao();
        List<Envelope> li_env = hb_EnvelopeDao.getEnvelopeList();
        for (Envelope envelope : li_env) {
            Integer oid_f;
            int id_f2 = Globals.getIntValue(envelope.getId_f(), 0);
            if (id_f2 <= 0 || al.contains(oid_f = new Integer(id_f2))) continue;
            al.add(oid_f);
        }
        HibernateFacadeDao hb_facadeDao = new HibernateFacadeDao();
        List<Facade> li_facade = hb_facadeDao.getFacadeList();
        for (Facade facade : li_facade) {
            Integer oid_f;
            id_f = Globals.getIntValue(facade.getId_f(), 0);
            if (id_f <= 0 || !al.contains(oid_f = new Integer(id_f))) continue;
            al.remove(oid_f);
        }
        res = al.size();
        if (res > 0) {
            for (int ii = 0; ii < res; ++ii) {
                id_f = (Integer)al.get(ii);
                hb_EnvelopeDao.deleteLostFacades(id_f);
            }
        }
        return res > 0;
    }

    public void repairScyTable() {
    }

    public boolean repairShadingTable() {
        PreparedStatement prstData;
        int res = 0;
        Connection cn_pro = Ecad2007.getConnection(Globals.PROJECT_NAME);
        String sql = "select nom_e from envelope where id_o=-1";
        Vector<String> v_nom = new Vector<String>(10);
        try {
            prstData = cn_pro.prepareStatement(sql);
            ResultSet rsData = prstData.executeQuery();
            while (rsData.next()) {
                String nom_e = rsData.getString("nom_e");
                if (nom_e == null) continue;
                nom_e = nom_e.trim();
                v_nom.add(nom_e);
            }
        }
        catch (SQLException sqlEx) {
            Globals.println("JarFile.repairShadingTable select envelope: " + sqlEx.getMessage());
        }
        res = v_nom.size();
        if (res > 0) {
            sql = "update ENVELOPE set ID_O=0 where ID_O=-1";
            try {
                prstData = cn_pro.prepareStatement(sql);
                prstData.execute();
                cn_pro.commit();
                prstData.close();
            }
            catch (SQLException sqlEx) {
                Globals.println("JarFile.repairShadingTable update envelope: " + sqlEx.getMessage());
            }
            for (int ii = 0; ii < res; ++ii) {
                Globals.println("Error 433: JarFile.repairShadingTable() updated element in table \"envelope\" with nom_e = " + (String)v_nom.get(ii));
            }
        }
        return res > 0;
    }

    private boolean updateSecureTable(String table, String[] cols, Vector<Object[]> rows) {
        boolean b_res = false;
        HibernateProjetDao hibernateProjetDao = new HibernateProjetDao(false);
        hibernateProjetDao.deleteTable(table);
        hibernateProjetDao.insertIntoTable(table, cols, rows);
        return b_res;
    }

    private boolean showFileDialog(int os, String fileExtension) {
        FileUtilities fu;
        JFileChooser jfc;
        boolean res = false;
        String sfile = this.config.getPropertyString("properties", "dir", new String[]{"mf", fileExtension});
        String title = this.gen_trad.getCodeLan("open_file");
        if (os == 2) {
            title = this.gen_trad.getCodeLan("saveas");
        }
        if ((jfc = (fu = new FileUtilities()).createJFileChooser(sfile, null, fileExtension, title, 0)) != null) {
            if (os == 1) {
                if (jfc.showOpenDialog(this.parent) == 0) {
                    this.jar = jfc.getSelectedFile();
                    String file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\");
                    this.config.setPropertyString("properties", "dir", new String[]{"mf", fileExtension}, file);
                    if (fileExtension != null && fileExtension.equals("pro")) {
                        this.config.setPropertyString("properties", "dir", new String[]{"mf", "pdf"}, file);
                    }
                    res = true;
                }
            } else if (os == 2 && jfc.showSaveDialog(this.parent) == 0) {
                int msg = 0;
                String[] files = jfc.getCurrentDirectory().list();
                String file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\");
                if (file.indexOf("." + fileExtension) != file.length() - 4) {
                    file = file + "." + fileExtension;
                }
                while (fu.fileExists(files, file, fileExtension) && msg == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    msg = JOptionPane.showConfirmDialog(this.parent, this.gen_trad.getCodeLan("file_overwrite"), this.gen_trad.getCodeLan("saveas"), 0, 3);
                    if (msg != 1 || jfc.showSaveDialog(this.parent) != 0) break;
                    files = jfc.getCurrentDirectory().list();
                    if (fu.fileExists(files, file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\"), fileExtension)) {
                        msg = -1;
                        continue;
                    }
                    msg = 0;
                    break;
                }
                if (msg == 0) {
                    this.jar = new File(file);
                    this.config.setPropertyString("properties", "dir", new String[]{"mf", fileExtension}, file);
                    if (fileExtension != null && fileExtension.equals("pro")) {
                        this.config.setPropertyString("properties", "dir", new String[]{"mf", "pdf"}, file);
                    }
                    res = true;
                }
            }
            if (res) {
                Component[] components = jfc.getComponents();
                for (int ii = 0; ii < components.length; ++ii) {
                    if (!(components[ii] instanceof FilePane)) continue;
                    FilePane filePane = (FilePane)components[ii];
                    this.fileviewtype = filePane.getViewType();
                    if (this.fileviewtype == this.prevfileviewtype) break;
                    this.prevfileviewtype = this.fileviewtype;
                    this.config.setPropertyInt("properties", "fileviewtype", this.fileviewtype);
                    break;
                }
            }
        }
        return res;
    }

    public boolean importTmpDb() {
        boolean res = false;
        int saveVer = Ecad2007.getProjectVersion();
        Vector<Object[]> vector = new Vector(100);
        if (this.dbMetaTmp == null) {
            this.dbMetaTmp = new DbMetadata("tmp");
        }
        String[][] tpCols = null;
        Object[] defValues = null;
        tpCols = this.prepareColumnMapping("composant_m");
        if (!this.dbMetaTmp.isColumnInTable("composant_m", "ID_PROJ")) {
            defValues = new Object[tpCols.length];
            tpCols[0][0] = "";
            defValues[0] = new Integer(1);
        }
        vector = this.readTable("composant_m", this.reverseArray(tpCols)[0], defValues);
        this.insertIntoTable("composant_m", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("composant_p");
        vector = this.readTable("composant_p", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("composant_p", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("composant_w");
        vector = this.readTable("composant_w", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("composant_w", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("envelope");
        vector = this.readTable("envelope", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("envelope", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("facade");
        vector = this.readTable("facade", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("facade", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("m1_ver");
        vector = this.readTable("m1_ver", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("m1_ver", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("m2_cad");
        vector = this.readTable("m2_cad", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("m2_cad", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("m3_voil");
        vector = this.readTable("m3_voil", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("m3_voil", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("m6_icl");
        vector = this.readTable("m6_icl", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("m6_icl", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("materials");
        if (!this.dbMetaTmp.isColumnInTable("materials", "FLAGS")) {
            if (saveVer < 424) {
                tpCols[16][0] = "SO2";
            }
            tpCols[23][0] = "";
            vector = this.readAndCorrectMaterialTable(this.reverseArray(tpCols)[0]);
        } else if (saveVer < 424) {
            tpCols[16][0] = "SO2";
            vector = this.readTable("materials", this.reverseArray(tpCols)[0]);
        } else {
            vector = this.readTable("materials", this.reverseArray(tpCols)[0]);
        }
        this.insertIntoTable("materials", this.reverseArray(tpCols)[1], vector);
        Vector_MatDb vct_matdb = new Vector_MatDb();
        tpCols = this.prepareColumnMapping("matdb");
        vector = this.readISETable("matdb", this.reverseArray(tpCols)[0]);
        for (Object[] objects : vector) {
            if (vct_matdb.contains(objects)) continue;
            vct_matdb.add(objects);
        }
        this.insertIntoISETable("matdb", this.reverseArray(tpCols)[1], vct_matdb);
        tpCols = this.prepareColumnMapping("pro");
        defValues = new Object[tpCols.length];
        if (!this.dbMetaTmp.isColumnInTable("pro", "F_LIM")) {
            tpCols[2][0] = "";
            defValues[2] = new Integer(1);
        }
        if (!this.dbMetaTmp.isColumnInTable("pro", "AC_B")) {
            tpCols[21][0] = "";
            defValues[21] = new Integer(0);
        }
        if (!this.dbMetaTmp.isColumnInTable("pro", "REN_B")) {
            tpCols[22][0] = "";
            defValues[22] = new Integer(0);
        }
        if (!this.dbMetaTmp.isColumnInTable("pro", "REN_B")) {
            tpCols[23][0] = "";
            defValues[23] = new Short(0);
        }
        vector = this.readTable("pro", this.reverseArray(tpCols)[0], defValues);
        this.updateSecureTable("pro", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("Pro_Ceb");
        if (tpCols != null) {
            if (this.dbMetaTmp == null) {
                this.dbMetaTmp = new DbMetadata("tmp");
            }
            if (this.dbMetaTmp.isTableInDb("pro_ceb")) {
                vector = this.readTable("pro_ceb", this.reverseArray(tpCols)[0]);
                this.updateSecureTable("pro_ceb", this.reverseArray(tpCols)[1], vector);
            }
        }
        tpCols = this.prepareColumnMapping("shade");
        vector = this.readTable("shade", this.reverseArray(tpCols)[0]);
        this.insertIntoTable("shade", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("sre", true);
        if (saveVer == 413) {
            tpCols[4][0] = "A";
        } else if (saveVer == 412) {
            tpCols[4][0] = "A";
        }
        vector = this.readTable("sre", this.reverseArray(tpCols)[0]);
        this.updateSecureTable("sre", this.reverseArray(tpCols)[1], vector);
        tpCols = this.prepareColumnMapping("zone");
        defValues = new Object[tpCols.length];
        if (!this.dbMetaTmp.isColumnInTable("zone", "nvfv")) {
            tpCols[27][0] = "";
            defValues[27] = "5,2";
        }
        vector = this.readTable("zone", this.reverseArray(tpCols)[0], defValues);
        this.updateSecureTable("zone", this.reverseArray(tpCols)[1], vector);
        int dim0 = 0;
        if (this.dbMetaTmp.isTableInDb("scy")) {
            tpCols = this.prepareColumnMapping("scy");
            vector = this.readTable("scy", this.reverseArray(tpCols)[0]);
            dim0 = vector.size();
        }
        Scy escy = Ecad2007.getScy(Globals.ENERCAD_NAME);
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(4);
        for (int ii = 0; ii < dim0; ++ii) {
            Object[] object = vector.get(ii);
            String key = null;
            String value = null;
            if (object[0] != null) {
                key = ((String)object[0]).trim();
            }
            if (object[1] != null) {
                value = (String)object[1];
            }
            if (value == null) {
                value = escy.getValue(key);
            }
            if (value != null) {
                value = value.trim();
            }
            if (key == null || value == null) continue;
            map.put(key, object);
        }
        Object[] value = (Object[])map.get("fLevel");
        if (value == null) {
            map.put("fLevel", new Object[]{"fLevel", Ecad2007.getLicenseLevel()});
        } else if (value.length > 1) {
            if (value[1] == null) {
                map.put("fLevel", new Object[]{"fLevel", Ecad2007.getLicenseLevel()});
            }
        } else {
            map.put("fLevel", new Object[]{"fLevel", Ecad2007.getLicenseLevel()});
        }
        value = (Object[])map.get("buildVER");
        if (value == null) {
            map.put("buildVER", new Object[]{"buildVER", Ecad2007.getProjectVersion()});
        } else if (value.length > 1) {
            if (value[1] == null) {
                map.put("buildVER", new Object[]{"buildVER", Ecad2007.getProjectVersion()});
            }
        } else {
            map.put("buildVER", new Object[]{"buildVER", Ecad2007.getProjectVersion()});
        }
        value = (Object[])map.get("scode");
        if (value == null) {
            map.put("scode", new Object[]{"scode", escy.getValue("scode")});
        } else if (value.length > 1) {
            if (value[1] == null) {
                map.put("scode", new Object[]{"scode", escy.getValue("scode")});
            }
        } else {
            map.put("scode", new Object[]{"scode", escy.getValue("scode")});
        }
        value = (Object[])map.get("mac");
        if (value == null) {
            map.put("mac", new Object[]{"mac", escy.getValue("mac")});
        } else if (value.length > 1) {
            if (value[1] == null) {
                map.put("mac", new Object[]{"mac", escy.getValue("mac")});
            }
        } else {
            map.put("mac", new Object[]{"mac", escy.getValue("mac")});
        }
        map.put("ind_cs", new Object[]{"ind_cs", "-1", "-1", "ligne s\u00e9lectionn\u00e9e pour panneaux chauffage"});
        map.put("ind_pv", new Object[]{"ind_pv", "-1", "-1", "ligne s\u00e9lectionn\u00e9e pour panneaux pv"});
        map.put("capt_inclin_ecs", new Object[]{"capt_inclin_ecs", "0", "0", "inclinaison panneaux ecs"});
        map.put("capt_orient_ecs", new Object[]{"capt_orient_ecs", "0", "0", "orientation panneaux ecs"});
        map.put("m2_occup_ecs", new Object[]{"m2_occup_ecs", "0", "0", "surface panneaux ecs"});
        map.put("num_occup_ecs", new Object[]{"num_occup_ecs", "0", "0", "nombre d'occupants"});
        vector = new Vector(map.values());
        HibernateScyDao hibernateScyDao = new HibernateScyDao(false);
        hibernateScyDao.updateScy(vector);
        Ecad2007.closeSession(Globals.PROJECT_NAME);
        Ecad2007.closeSession("tmp");
        Ecad2007.closeAllConnections();
        return res;
    }

    private String[][] reverseArray(String[][] array) {
        if (array == null) {
            return null;
        }
        int xx = array.length;
        int yy = array[0].length;
        String[][] res = new String[yy][xx];
        for (int ii = 0; ii < yy; ++ii) {
            for (int jj = 0; jj < xx; ++jj) {
                res[ii][jj] = array[jj][ii];
            }
        }
        return res;
    }

    private void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String fn = this.config.getPropertyString("properties", "dir", new String[]{"mf", "pro"});
            File file = new File(fn);
            String filename = file.getParent() + System.getProperty("file.separator") + "error.log";
            this.globals.openURL("file://" + filename);
        }
    }

    private class Vector_MatDb
    extends Vector {
        private Vector_MatDb() {
        }

        @Override
        public boolean contains(Object object) {
            boolean b_res = false;
            if (object == null) {
                return b_res;
            }
            if (object instanceof Object[]) {
                Object[] objects = (Object[])object;
                for (Object[] objs : this) {
                    if (objs == null || objs.length <= 3 || !Globals.getStringValue(objs[2]).equals(Globals.getStringValue(objects[2])) || !Globals.getStringValue(objs[3]).equals(Globals.getStringValue(objects[3]))) continue;
                    b_res = true;
                    break;
                }
            }
            return b_res;
        }

        public void add(Object[] objects) {
            if (objects != null) {
                this.add(objects);
            }
        }
    }

    private class JarFile_HyperlinkAdapter
    implements HyperlinkListener {
        JarFile adaptee;

        JarFile_HyperlinkAdapter(JarFile adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent he) {
            this.adaptee.hyperlinkUpdate(he);
        }
    }

    public class ThreadShowOpenFileDialog
    extends Thread {
        boolean state = false;

        @Override
        public void run() {
            this.state = JarFile.this.showFileDialog(1, "pro");
        }

        public boolean getDialogState() {
            return this.state;
        }
    }

    class MessageCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ArrayList<String> al;
        TreeMap<String, Short> tm;

        public MessageCellRenderer(ArrayList<String> al, TreeMap<String, Short> tm) {
            this.al = al;
            this.tm = tm;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String ref = this.al.get(row);
            int ch_c = this.tm.get(ref).intValue();
            if (ch_c >= 0) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
            String text = (String)value;
            if (value != null) {
                text = text.trim();
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.setText(text);
            return this;
        }
    }
}

