/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.MaterialsDbOrg;
import enercad2007.Globals;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;

public class MatDbOrg
implements Serializable {
    private static final long serialVersionUID = 8533815254467589187L;
    transient Document doc;
    int lan;
    private String http;
    String id;
    String nom_fr;
    String nom_al;
    String nom_it;
    String nom_en;
    String type;
    int floor;
    int wall;
    int roof;
    int door;
    String group;
    float gg;
    float alpha;
    double lambda;
    double cc;
    double rho;
    double vmin;
    double vmax;
    double h2o;
    double por;
    double[] lthw = new double[3];
    double nre;
    double co2;
    long ubp;
    String src;
    String srceco;
    String pattern;
    Date dtstart;
    Date dtstop;
    Date updt;
    String res;
    String fc;
    String fr;
    long flags;
    String companyName;
    String companyNamePI;
    byte[] logo;
    String dirref;
    String dirpos;
    String pos;
    String ref;
    String expl_al;
    String expl_fr;
    String expl_it;
    String expl_en;
    ArrayList<String[]> webinfos;
    String[] web_lan;
    boolean b_loaded;

    public MatDbOrg() {
    }

    public MatDbOrg(String http) {
        this.http = http;
    }

    public MatDbOrg(String companyNamePI, String http) {
        this.companyNamePI = companyNamePI;
        this.http = http;
    }

    public MatDbOrg(MaterialsDbOrg materialsDbOrg, int[] ij) {
        this.id = materialsDbOrg.getId(ij);
        this.nom_al = materialsDbOrg.getNom_al(ij);
        this.nom_fr = materialsDbOrg.getNom_fr(ij);
        this.nom_it = materialsDbOrg.getNom_it(ij);
        this.nom_en = materialsDbOrg.getNom_en(ij);
        this.type = materialsDbOrg.getType(ij);
        this.floor = materialsDbOrg.getFloor(ij);
        this.wall = materialsDbOrg.getWall(ij);
        this.roof = materialsDbOrg.getRoof(ij);
        this.door = materialsDbOrg.getDoor(ij);
        this.group = materialsDbOrg.getGroup(ij);
        this.gg = materialsDbOrg.getGG(ij);
        this.alpha = materialsDbOrg.getAlpha(ij);
        this.lambda = materialsDbOrg.getLambda(ij);
        this.cc = materialsDbOrg.getCC(ij);
        this.rho = materialsDbOrg.getRho(ij);
        this.vmin = materialsDbOrg.getVmin(ij);
        this.vmax = materialsDbOrg.getVmax(ij);
        this.h2o = materialsDbOrg.getH2o(ij);
        this.por = materialsDbOrg.getPor(ij);
        this.lthw[0] = materialsDbOrg.getLength(ij);
        this.lthw[1] = materialsDbOrg.getEp(ij);
        this.lthw[2] = materialsDbOrg.getWidth(ij);
        this.nre = materialsDbOrg.getNre(ij);
        this.co2 = materialsDbOrg.getCo2(ij);
        this.ubp = materialsDbOrg.getUbp(ij);
        this.src = materialsDbOrg.getSrc(ij);
        this.srceco = materialsDbOrg.getSrceco(ij);
        this.pattern = materialsDbOrg.getPattern(ij);
        this.dtstart = materialsDbOrg.getDtstart(ij);
        this.dtstop = materialsDbOrg.getDtstop(ij);
        this.updt = materialsDbOrg.getUpdt(ij);
        this.res = materialsDbOrg.getRes(ij);
        this.fc = materialsDbOrg.getFc(ij);
        this.fr = materialsDbOrg.getFr(ij);
        this.flags = materialsDbOrg.getFlags(ij);
        this.companyName = materialsDbOrg.getCompanyName();
        this.companyNamePI = materialsDbOrg.getCompanyNamePI();
        this.dirref = materialsDbOrg.getDirRef(ij);
        this.dirpos = materialsDbOrg.getDirRef(ij);
        this.pos = materialsDbOrg.getPos(ij);
        this.ref = materialsDbOrg.getRef(ij);
        this.expl_al = materialsDbOrg.getExplanation(0, ij);
        this.expl_fr = materialsDbOrg.getExplanation(1, ij);
        this.expl_it = materialsDbOrg.getExplanation(2, ij);
        this.expl_en = materialsDbOrg.getExplanation(3, ij);
        this.webinfos = materialsDbOrg.getWebInfos(ij);
    }

    public boolean isLoaded() {
        return this.b_loaded;
    }

    public void setLanguage(int lan) {
        this.lan = lan;
    }

    public String getCompanyNamePI() {
        return this.companyNamePI;
    }

    public void setCompanyNamePI(String companyNamePI) {
        this.companyNamePI = companyNamePI;
    }

    public void setLogo(byte[] logo) {
        this.logo = logo;
    }

    public void setLogo(BufferedImage bi) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, "png", baos);
            baos.flush();
            this.logo = baos.toByteArray();
            baos.close();
        }
        catch (IOException ioex) {
            System.out.println("core.MatDbOrg.setLogo: " + ioex.getMessage());
        }
    }

    public byte[] getLogo() {
        return this.logo;
    }

    public BufferedImage getLogo(BufferedImage bi) {
        if (this.logo == null) {
            return bi;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.logo);
        try {
            bi = ImageIO.read(bais);
        }
        catch (IOException ioex) {
            System.out.println("core.MatDbOrg.getLogo: " + ioex.getMessage());
        }
        return bi;
    }

    public String getExplanation() {
        if (this.lan == 0) {
            return this.expl_al;
        }
        if (this.lan == 1) {
            return this.expl_fr;
        }
        if (this.lan == 2) {
            return this.expl_it;
        }
        if (this.lan == 3) {
            return this.expl_en;
        }
        return this.nom_fr;
    }

    public void setExplanation(String explanation) {
        if (this.lan == 0) {
            this.expl_al = explanation;
        } else if (this.lan == 1) {
            this.expl_fr = explanation;
        } else if (this.lan == 2) {
            this.expl_it = explanation;
        } else if (this.lan == 3) {
            this.expl_en = explanation;
        } else {
            this.nom_fr = explanation;
        }
    }

    public ArrayList<String[]> getWebInfos() {
        return this.webinfos;
    }

    public String[] getWebInfos(int lan) {
        String[] res = new String[]{"", ""};
        String[] lang = new String[]{"de", "fr", "it", "en"};
        if (this.webinfos == null) {
            return res;
        }
        for (int ii = 0; ii < this.webinfos.size(); ++ii) {
            String[] tmp = this.webinfos.get(ii);
            if (tmp == null || !tmp[0].equals(lang[lan]) && !tmp[0].equals("")) continue;
            res = new String[]{tmp[1], tmp[2]};
        }
        return res;
    }

    public void setWebInfos(ArrayList<String[]> webinfos) {
        this.webinfos = webinfos;
    }

    public String[] getWebInfosLan() {
        return this.web_lan;
    }

    public void setWebLang(String[] web_lan) {
        this.web_lan = web_lan;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNom(String nom) {
        if (this.lan == 0) {
            this.nom_al = nom;
        } else if (this.lan == 1) {
            this.nom_fr = nom;
        } else if (this.lan == 2) {
            this.nom_it = nom;
        } else if (this.lan == 3) {
            this.nom_en = nom;
        } else {
            this.nom_fr = nom;
        }
    }

    public String getNom() {
        String nom = "";
        if (this.lan == 0) {
            nom = this.nom_al;
        } else if (this.lan == 1) {
            nom = this.nom_fr;
        } else if (this.lan == 2) {
            nom = this.nom_it;
        } else if (this.lan == 3) {
            nom = this.nom_en;
        }
        if (nom == null) {
            nom = "";
        }
        if ((nom.equals("") || nom.equals("-")) && this.nom_al != null && !this.nom_al.equals("") && !this.nom_al.equals("-")) {
            nom = this.nom_al;
        }
        if ((nom.equals("") || nom.equals("-")) && this.nom_fr != null && !this.nom_fr.equals("") && !this.nom_fr.equals("-")) {
            nom = this.nom_fr;
        }
        if ((nom.equals("") || nom.equals("-")) && this.nom_it != null && !this.nom_it.equals("") && !this.nom_it.equals("-")) {
            nom = this.nom_it;
        }
        if ((nom.equals("") || nom.equals("-")) && this.nom_en != null && !this.nom_en.equals("") && !this.nom_en.equals("-")) {
            nom = this.nom_en;
        }
        return nom;
    }

    public String getNom_fr() {
        return this.nom_fr;
    }

    public void setNom_fr(String nom) {
        this.nom_fr = nom;
    }

    public String getNom_al() {
        return this.nom_al;
    }

    public void setNom_al(String nom) {
        this.nom_al = nom;
    }

    public String getNom_it() {
        return this.nom_it;
    }

    public void setNom_it(String nom) {
        this.nom_it = nom;
    }

    public String getNom_en() {
        return this.nom_en;
    }

    public void setNom_en(String nom) {
        this.nom_en = nom;
    }

    public String getType() {
        return this.type;
    }

    public int getFloor() {
        return this.floor;
    }

    public int getWall() {
        return this.wall;
    }

    public int getRoof() {
        return this.roof;
    }

    public int getDoor() {
        return this.door;
    }

    public String getGroup() {
        return this.group;
    }

    public float getGG() {
        return this.gg;
    }

    public void setGG(float gg) {
        this.gg = gg;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getCC() {
        return this.cc;
    }

    public void setCC(double cc) {
        this.cc = cc;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public double getRho() {
        return this.rho;
    }

    public double getVmin() {
        return this.vmin;
    }

    public void setVmin(double vmin) {
        this.vmin = vmin;
    }

    public double getVmax() {
        return this.vmax;
    }

    public void setVmax(double vmax) {
        this.vmax = vmax;
    }

    public double getH2o() {
        return this.h2o;
    }

    public void setH2o(double h2o) {
        this.h2o = h2o;
    }

    public double getPor() {
        return this.por;
    }

    public void setPor(double por) {
        this.por = por;
    }

    public double getLength() {
        return this.lthw[0];
    }

    public double getEp() {
        return this.lthw[1];
    }

    public void setEp(double ep) {
        this.lthw[1] = ep;
    }

    public double getWidth() {
        return this.lthw[2];
    }

    public double getNre() {
        return this.nre;
    }

    public void setNre(double nre) {
        this.nre = nre;
    }

    public double getCo2() {
        return this.co2;
    }

    public void setCo2(double co2) {
        this.co2 = co2;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public long getUbp() {
        return this.ubp;
    }

    public void setUbp(long ubp) {
        this.ubp = ubp;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getSrcPI() {
        String res = this.getSrc();
        if (res == null) {
            res = "";
        }
        if (res.equals("")) {
            res = this.getCompanyNamePI();
        }
        return res;
    }

    public String getSrceco() {
        return this.srceco;
    }

    public void setSrceco(String srceco) {
        this.srceco = srceco;
    }

    public String getPattern() {
        if (this.pattern == null) {
            this.pattern = Globals.getPatternByMatDbOrg(this.group);
        }
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Date getDtstart() {
        return this.dtstart;
    }

    public void setDtstart(Date dtstart) {
        this.dtstart = dtstart;
    }

    public Date getDtstop() {
        return this.dtstop;
    }

    public void setDtstop(Date dtstop) {
        this.dtstop = dtstop;
    }

    public Date getUpdt() {
        return this.updt;
    }

    public void setUpdt(Date updt) {
        this.updt = updt;
    }

    public String getRes() {
        return this.res;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public String getRef() {
        if (this.ref != null) {
            this.ref = this.ref.trim();
        }
        return this.ref;
    }

    public String getDirPos() {
        return this.dirpos;
    }

    public void setRef(String ref) {
        this.ref = ref != null ? ref.trim() : ref;
    }

    public boolean isLeaf() {
        if (this.ref != null) {
            return this.ref.contains(",");
        }
        return false;
    }

    public String getDirRef() {
        return this.dirref;
    }

    public String[] getRow() {
        String[] row = new String[]{this.getNom_al(), this.getNom_fr(), this.getNom_it(), this.getNom_en(), Globals.getStringValue(Float.valueOf(this.getGG())), Globals.getStringValue(Float.valueOf(this.getAlpha())), Globals.getStringValue(this.getLambda()), Globals.getStringValue(this.getCC()), Globals.getStringValue(this.getRho()), Globals.getStringValue(this.getVmin()), Globals.getStringValue(this.getVmax()), Globals.getStringValue(this.getH2o()), Globals.getStringValue(this.getPor()), Globals.getStringValue(this.getEp() / 10.0), Globals.getStringValue(this.getNre()), Globals.getStringValue(this.getCo2()), Globals.getStringValue(this.getUbp()), this.getSrcPI(), this.getSrceco(), this.getPattern(), Globals.getStringValue(this.getDtstart()), Globals.getStringValue(this.getDtstop()), Globals.getStringValue(this.getUpdt()), this.getRes(), Globals.getStringValue(this.getFlags()), this.getPos(), this.getRef()};
        return row;
    }
}

