/*
 * Decompiled with CFR 0.152.
 */
package core;

public class Matrix {
    private int col;
    private int row;
    private double[][] store;

    public Matrix(int row, int col) {
        this.store = new double[row][col];
        this.col = col;
        this.row = row;
    }

    public Matrix(Matrix matrix) {
        this.store = new double[matrix.col][matrix.row];
        this.col = matrix.col;
        this.row = matrix.row;
        for (int ii = 0; ii < this.row; ++ii) {
            for (int jj = 0; jj < this.col; ++jj) {
                this.store[ii][jj] = matrix.get(ii, jj);
            }
        }
    }

    public Matrix times(Matrix matrix) {
        if (this.col != matrix.row) {
            System.out.println("Error in times(): matrices are not the correct dimensions");
            System.exit(1);
        }
        Matrix result = new Matrix(this.row, matrix.col);
        for (int ii = 0; ii < this.row; ++ii) {
            for (int jj = 0; jj < matrix.col; ++jj) {
                double sum = 0.0;
                for (int kk = 0; kk < this.col; ++kk) {
                    sum += this.get(ii, kk) * matrix.get(kk, jj);
                }
                result.set(ii, jj, sum);
            }
        }
        return result;
    }

    public Matrix plus(Matrix matrix) {
        if (matrix.row != this.row || matrix.col != this.col) {
            System.out.println("Error in plus(): matrices are not the same size");
            System.exit(1);
        }
        Matrix result = new Matrix(this.row, this.col);
        for (int ii = 0; ii < this.row; ++ii) {
            for (int jj = 0; jj < this.col; ++jj) {
                double newValue = this.get(ii, jj) + matrix.get(ii, jj);
                result.set(ii, jj, newValue);
            }
        }
        return result;
    }

    public Matrix transpose() {
        Matrix result = new Matrix(this.col, this.row);
        for (int ii = 0; ii < this.row; ++ii) {
            for (int jj = 0; jj < this.col; ++jj) {
                result.set(jj, ii, this.get(ii, jj));
            }
        }
        return result;
    }

    public String toString() {
        String output = "";
        for (int ii = 0; ii < this.row; ++ii) {
            output = output + "[";
            for (int jj = 0; jj < this.col; ++jj) {
                output = output + this.get(ii, jj);
                output = output + " ";
            }
            output = output + "]\n";
        }
        return output;
    }

    public void set(int rr, int cc, double newValue) {
        if (rr < 0 || rr > this.row - 1) {
            System.out.println("Error in set(): got an invalid row index");
            System.exit(1);
        }
        if (cc < 0 || cc > this.col - 1) {
            System.out.println("Error in set(): got an invalid column index");
            System.exit(1);
        }
        this.store[rr][cc] = newValue;
    }

    public void set(int rr, int cc, int newValue) {
        if (rr < 0 || rr > this.row - 1) {
            System.out.println("Error in set(): got an invalid row index");
            System.exit(1);
        }
        if (cc < 0 || cc > this.col - 1) {
            System.out.println("Error in set(): got an invalid column index");
            System.exit(1);
        }
        this.store[rr][cc] = newValue;
    }

    public double get(int rr, int cc) {
        if (rr < 0 || rr > this.row - 1) {
            System.out.println("Error in get(): got an invalid row index: " + this.row);
            System.exit(1);
        }
        if (cc < 0 || cc > this.col - 1) {
            System.out.println("Error in get(): got an invalid column index: " + this.col);
            System.exit(1);
        }
        return this.store[rr][cc];
    }
}

