/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MergePdf {
    public static void main(String[] args) {
        try {
            ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
            pdfs.add(new FileInputStream("flux.pdf"));
            pdfs.add(new FileInputStream("test.pdf"));
            FileOutputStream output = new FileOutputStream("merge.pdf");
            MergePdf.concatPDFs(pdfs, output, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatPDFs(List<InputStream> streamOfPDFFiles, OutputStream outputStream, boolean paginate) {
        Document document = new Document();
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
            }
            PdfWriter writer = PdfWriter.getInstance(document, outputStream);
            document.open();
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    ++currentPageNumber;
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate(page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, "" + currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

