/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import core.Config;
import core.Globals;
import core.ImageFop;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.apps.PageSequenceResults;
import sun.swing.FilePane;

public class PrintUtilities
implements Printable,
Pageable {
    Component glasspane;
    String cname = "";
    private double mScaleX;
    private double mScaleY;
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private PrinterJob pj;
    private Printable printable;
    private PageFormat pageFormat;
    private PrintRequestAttributeSet aset;
    private Map printerSettings = new HashMap(20);
    Config config;
    enercad2007.Globals globals;
    DM_Trad gen_trad;
    DM_Trad print_trad;
    int mediaUnits = 1000;
    private Component component;
    private ArrayList<Component> components;
    private String html;
    private String formFop;
    private ImageFop[] imageFop;
    private String pdfFile;
    private String pdf;
    private Container parent;

    public PrintUtilities(Component component, PageFormat pageFormat) {
        this.component = component;
        this.jbInit();
        this.aset = this.getPrinterSettings();
        this.pageFormat = pageFormat;
        this.setPrintable(this);
        Rectangle rectangle = component.getBounds();
        this.setSize(rectangle.width, rectangle.height);
    }

    public PrintUtilities(JDialog parent) {
        this.parent = parent;
        this.jbInit();
    }

    public PrintUtilities(JFrame parent) {
        this.parent = parent;
        this.jbInit();
    }

    public PrintUtilities(JFrame parent, Component component) {
        this.component = component;
        this.parent = parent;
        this.jbInit();
        if (this.pageFormat == null) {
            this.setDefaultPageFormat();
        }
        Rectangle componentBounds = component.getBounds();
        this.setSize(componentBounds.width, componentBounds.height);
        this.scaleToFit(true);
    }

    public PrintUtilities(JDialog parent, Component component) {
        this.component = component;
        this.parent = parent;
        this.jbInit();
        if (this.pageFormat == null) {
            this.setDefaultPageFormat();
        }
        Rectangle componentBounds = component.getBounds();
        this.setSize(componentBounds.width, componentBounds.height);
        this.scaleToFit(true);
    }

    public PrintUtilities(JFrame parent, ArrayList<Component> components) {
        this.components = components;
        this.parent = parent;
        this.jbInit();
        if (components != null && components.size() > 0) {
            Component component = components.get(0);
            this.setDefaultPageFormat(component);
            Rectangle componentBounds = component.getBounds();
            this.setSize(componentBounds.width, componentBounds.height);
            this.scaleToFit(component, true);
        }
    }

    public PrintUtilities(JDialog parent, ArrayList<Component> components) {
        this.components = components;
        this.parent = parent;
        this.jbInit();
        if (components != null && components.size() > 0) {
            Component component = components.get(0);
            this.setDefaultPageFormat(component);
            Rectangle componentBounds = component.getBounds();
            this.setSize(componentBounds.width, componentBounds.height);
            this.scaleToFit(component, true);
        }
    }

    private void jbInit() {
        this.config = new Config(System.getProperty("conf.file.name"));
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.print_trad = Ecad2007.getTraduction("print");
    }

    private JFileChooser createJFileChooser(String pdfFile) {
        JFileChooser FChprt = new JFileChooser();
        if (this.globals == null) {
            this.globals = new enercad2007.Globals();
        }
        FChprt.setDialogTitle(this.gen_trad.getCodeLan("print"));
        FChprt.setApproveButtonText("Ok");
        File dir = null;
        String extension = "ps";
        Locale locale = Locale.getDefault();
        dir = new File(pdfFile.replaceAll("&#92;", "\\\\"));
        extension = "pdf";
        FChprt.setCurrentDirectory(dir);
        if (!FChprt.getLocale().equals(locale)) {
            FChprt.setLocale(locale);
            SwingUtilities.updateComponentTreeUI(FChprt);
            JOptionPane.setDefaultLocale(locale);
        }
        FChprt.enableInputMethods(false);
        FChprt.setFileSelectionMode(0);
        FChprt.addChoosableFileFilter(new PrtFilter(this.gen_trad.getCodeLan("print") + " (*.*)", new String[]{"*"}));
        PrtFilter prtFilter = new PrtFilter("*." + extension, new String[]{extension});
        FChprt.addChoosableFileFilter(prtFilter);
        FChprt.setFileFilter(prtFilter);
        FChprt.setFont(enercad2007.Globals.FT_STAND1);
        FChprt.setAcceptAllFileFilterUsed(false);
        Config config = new Config(System.getProperty("conf.file.name"));
        int fileviewtype = config.getPropertyInt("properties", "fileviewtype");
        Component[] components = FChprt.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof FilePane)) continue;
            FilePane filePane = (FilePane)components[ii];
            filePane.setViewType(fileviewtype);
            break;
        }
        return FChprt;
    }

    private PrinterJob createPrintJob() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, this.aset);
        if (ps.length > 0) {
            if (this.cname.equals("")) {
                this.cname = this.component.getClass().getName();
            }
            String printService = this.config.getPropertyString("printers", this.cname, new String[]{"printService"});
            this.pj = PrinterJob.getPrinterJob();
            for (int ii = 0; ii < ps.length; ++ii) {
                if (!printService.equals(ps[ii].getName())) continue;
                try {
                    this.pj.setPrintService(ps[ii]);
                    this.pj.setPrintable(this.printable, this.pageFormat);
                }
                catch (PrinterException printerException) {}
                break;
            }
        }
        return this.pj;
    }

    protected void setComponent(Component component) {
        this.component = component;
    }

    protected static void disableDoubleBuffering(Component component) {
        RepaintManager currentManager = RepaintManager.currentManager(component);
        currentManager.setDoubleBufferingEnabled(false);
    }

    protected static void enableDoubleBuffering(Component component) {
        RepaintManager currentManager = RepaintManager.currentManager(component);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public void setScale(double scaleX, double scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    public boolean fileExists(String[] fileList, String file) {
        int index;
        boolean res = false;
        if (file != null && fileList != null && (index = file.lastIndexOf(System.getProperty("file.separator")) + 1) > 1) {
            file = file.substring(index);
            for (int ii = 0; ii < fileList.length; ++ii) {
                if (!fileList[ii].equals(file)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        double originX = (double)(pageIndex % this.mNumPagesX) * this.pageFormat.getImageableWidth();
        double originY = (double)(pageIndex / this.mNumPagesX) * this.pageFormat.getImageableHeight();
        Point2D.Double origin = new Point2D.Double(originX, originY);
        return new TranslatedPrintable(this.printable, origin);
    }

    private float[] getMediaSize(String mediaName) {
        MediaSizeName msn = this.getMediaSizeName(mediaName);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return ms.getSize(this.mediaUnits);
    }

    public MediaSizeName getMediaSizeName(String mediaName) {
        HashMap<String, MediaSizeName> mediaMap = new HashMap<String, MediaSizeName>(100, 10.0f);
        MediaSizeName msn = null;
        mediaMap.put("iso-a0", MediaSizeName.ISO_A0);
        mediaMap.put("iso-a1", MediaSizeName.ISO_A1);
        mediaMap.put("iso-a2", MediaSizeName.ISO_A2);
        mediaMap.put("iso-a3", MediaSizeName.ISO_A3);
        mediaMap.put("iso-a4", MediaSizeName.ISO_A4);
        mediaMap.put("iso-a5", MediaSizeName.ISO_A5);
        mediaMap.put("iso-a6", MediaSizeName.ISO_A6);
        mediaMap.put("iso-a7", MediaSizeName.ISO_A7);
        mediaMap.put("iso-a8", MediaSizeName.ISO_A8);
        mediaMap.put("iso-a9", MediaSizeName.ISO_A9);
        mediaMap.put("iso-a10", MediaSizeName.ISO_A10);
        mediaMap.put("iso-b0", MediaSizeName.ISO_B0);
        mediaMap.put("iso-b1", MediaSizeName.ISO_B1);
        mediaMap.put("iso-b2", MediaSizeName.ISO_B2);
        mediaMap.put("iso-b3", MediaSizeName.ISO_B3);
        mediaMap.put("iso-b4", MediaSizeName.ISO_B4);
        mediaMap.put("iso-b5", MediaSizeName.ISO_B5);
        mediaMap.put("iso-b6", MediaSizeName.ISO_B6);
        mediaMap.put("iso-b7", MediaSizeName.ISO_B7);
        mediaMap.put("iso-b8", MediaSizeName.ISO_B8);
        mediaMap.put("iso-b9", MediaSizeName.ISO_B9);
        mediaMap.put("iso-b10", MediaSizeName.ISO_B10);
        mediaMap.put("jis-b0", MediaSizeName.JIS_B0);
        mediaMap.put("jis-b1", MediaSizeName.JIS_B1);
        mediaMap.put("jis-b2", MediaSizeName.JIS_B2);
        mediaMap.put("jis-b3", MediaSizeName.JIS_B3);
        mediaMap.put("jis-b4", MediaSizeName.JIS_B4);
        mediaMap.put("jis-b5", MediaSizeName.JIS_B5);
        mediaMap.put("jis-b6", MediaSizeName.JIS_B6);
        mediaMap.put("jis-b7", MediaSizeName.JIS_B7);
        mediaMap.put("jis-b8", MediaSizeName.JIS_B8);
        mediaMap.put("jis-b9", MediaSizeName.JIS_B9);
        mediaMap.put("jis-b10", MediaSizeName.JIS_B10);
        mediaMap.put("iso-c0", MediaSizeName.ISO_C0);
        mediaMap.put("iso-c1", MediaSizeName.ISO_C1);
        mediaMap.put("iso-c2", MediaSizeName.ISO_C2);
        mediaMap.put("iso-c3", MediaSizeName.ISO_C3);
        mediaMap.put("iso-c4", MediaSizeName.ISO_C4);
        mediaMap.put("iso-c5", MediaSizeName.ISO_C5);
        mediaMap.put("iso-c6", MediaSizeName.ISO_C6);
        mediaMap.put("na-letter", MediaSizeName.NA_LETTER);
        mediaMap.put("na-legal", MediaSizeName.NA_LEGAL);
        mediaMap.put("executive", MediaSizeName.EXECUTIVE);
        mediaMap.put("ledger", MediaSizeName.LEDGER);
        mediaMap.put("tabloid", MediaSizeName.TABLOID);
        mediaMap.put("invoice", MediaSizeName.INVOICE);
        mediaMap.put("folio", MediaSizeName.FOLIO);
        mediaMap.put("quarto", MediaSizeName.QUARTO);
        mediaMap.put("japanese-postcard", MediaSizeName.JAPANESE_POSTCARD);
        mediaMap.put("oufuko-postcard", MediaSizeName.JAPANESE_DOUBLE_POSTCARD);
        mediaMap.put("a", MediaSizeName.A);
        mediaMap.put("b", MediaSizeName.B);
        mediaMap.put("c", MediaSizeName.C);
        mediaMap.put("d", MediaSizeName.D);
        mediaMap.put("e", MediaSizeName.E);
        mediaMap.put("iso-designated-long", MediaSizeName.ISO_DESIGNATED_LONG);
        mediaMap.put("italian-envelope", MediaSizeName.ITALY_ENVELOPE);
        mediaMap.put("monarch-envelope", MediaSizeName.MONARCH_ENVELOPE);
        mediaMap.put("personal-envelope", MediaSizeName.PERSONAL_ENVELOPE);
        mediaMap.put("na-number-9-envelope", MediaSizeName.NA_NUMBER_9_ENVELOPE);
        mediaMap.put("na-number-10-envelope", MediaSizeName.NA_NUMBER_10_ENVELOPE);
        mediaMap.put("na-number-11-envelope", MediaSizeName.NA_NUMBER_11_ENVELOPE);
        mediaMap.put("na-number-12-envelope", MediaSizeName.NA_NUMBER_12_ENVELOPE);
        mediaMap.put("na-number-14-envelope", MediaSizeName.NA_NUMBER_14_ENVELOPE);
        mediaMap.put("na-6x9-envelope", MediaSizeName.NA_6X9_ENVELOPE);
        mediaMap.put("na-7x9-envelope", MediaSizeName.NA_7X9_ENVELOPE);
        mediaMap.put("na-9x11-envelope", MediaSizeName.NA_9X11_ENVELOPE);
        mediaMap.put("na-9x12-envelope", MediaSizeName.NA_9X12_ENVELOPE);
        mediaMap.put("na-10x13-envelope", MediaSizeName.NA_10X13_ENVELOPE);
        mediaMap.put("na-10x14-envelope", MediaSizeName.NA_10X14_ENVELOPE);
        mediaMap.put("na-10x15-envelope", MediaSizeName.NA_10X15_ENVELOPE);
        mediaMap.put("na-5x7", MediaSizeName.NA_5X7);
        mediaMap.put("na-8x10", MediaSizeName.NA_8X10);
        Object mediaobj = mediaMap.get(mediaName);
        if (mediaobj != null) {
            msn = (MediaSizeName)mediaobj;
        }
        return msn;
    }

    public PrintRequestAttributeSet getPrinterSettings() {
        MediaSizeName msn;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        if (this.cname.equals("")) {
            this.cname = this.component.getClass().getName();
        }
        String mediaSize = "";
        String[] mediaPrintableArea = null;
        int[] mpa = new int[4];
        double dpmm = 72.0;
        if (this.mediaUnits == 1000) {
            dpmm = 2.834645669291339;
        }
        String tmp = "";
        int index = this.cname.lastIndexOf(".");
        if (index > 0) {
            this.cname = this.cname.substring(index).indexOf("Dlg") > 0 || this.cname.substring(index).indexOf("Prt") > 0 ? this.cname.substring(index + 4) : this.cname.substring(index + 1);
        }
        if (this.cname.startsWith("Dlg") || this.cname.startsWith("Prt")) {
            this.cname = this.cname.substring(3);
        }
        if ((tmp = this.config.getPropertyString("printers", this.cname, new String[]{"printableArea"})).split(",").length > 0) {
            mediaPrintableArea = tmp.split(",");
            for (int ii = 0; ii < 4; ++ii) {
                mpa[ii] = Globals.getIntValue(mediaPrintableArea[ii]);
            }
        }
        if ((msn = this.getMediaSizeName(mediaSize = this.config.getPropertyString("printers", this.cname, new String[]{"mediaSize"}))) != null) {
            aset.add(msn);
        }
        float[] msfl = this.getMediaSize(mediaSize);
        mpa[2] = (int)msfl[0] - mpa[0] - mpa[2];
        mpa[3] = (int)msfl[1] - mpa[1] - mpa[3];
        aset.add(new MediaPrintableArea(mpa[0], mpa[1], mpa[2], mpa[3], this.mediaUnits));
        Paper paper = new Paper();
        paper.setSize((double)msfl[0] * dpmm, (double)msfl[1] * dpmm);
        paper.setImageableArea((double)mpa[0] * dpmm, (double)mpa[1] * dpmm, (double)mpa[2] * dpmm, (double)mpa[3] * dpmm);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
        String orientation = this.config.getPropertyString("printers", this.cname, new String[]{"orientation"});
        if (orientation.equals("landscape")) {
            this.pageFormat.setOrientation(0);
        } else {
            this.pageFormat.setOrientation(1);
        }
        aset.add(new Copies(this.config.getPropertyInt("printers", this.cname, new String[]{"copies"})));
        if (this.config.getPropertyInt("printers", this.cname, new String[]{"prn"}) == 1) {
            File file = new File(this.config.getPropertyString("printers", this.cname, new String[]{"file"}));
            aset.add(new Destination(file.toURI()));
        }
        return aset;
    }

    public void setConfigurationName(String cname) {
        this.cname = cname;
    }

    public void scaleToFit(Component comp, boolean useSymmetricScaling) {
        Rectangle componentBounds = comp.getBounds();
        double scaleX = this.pageFormat.getImageableWidth() / (double)componentBounds.width;
        double scaleY = this.pageFormat.getImageableHeight() / (double)componentBounds.height;
        if (scaleX < 1.0 || scaleY < 1.0) {
            if (useSymmetricScaling) {
                if (scaleX < scaleY) {
                    scaleY = scaleX;
                } else {
                    scaleX = scaleY;
                }
            }
            this.setSize((float)((double)componentBounds.width * scaleX), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFit(boolean useSymmetricScaling) {
        this.scaleToFit(this.component, useSymmetricScaling);
    }

    public void scaleToFitX(Component comp) {
        double scaleX;
        Rectangle componentBounds = comp.getBounds();
        double scaleY = scaleX = this.pageFormat.getImageableWidth() / (double)componentBounds.width;
        if (scaleX < 1.0) {
            this.setSize((float)this.pageFormat.getImageableWidth(), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitX() {
        this.scaleToFitX(this.component);
    }

    public void scaleToFitY(Component comp) {
        double scaleY;
        Rectangle componentBounds = comp.getBounds();
        double scaleX = scaleY = this.pageFormat.getImageableHeight() / (double)componentBounds.height;
        if (scaleY < 1.0) {
            this.setSize((float)((double)componentBounds.width * scaleX), (float)this.pageFormat.getImageableHeight());
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitY() {
        this.scaleToFitY(this.component);
    }

    public void openPdf() {
        if (this.globals == null) {
            this.globals = new enercad2007.Globals();
        }
        this.globals.openPDF(this.pdfFile);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.scale(this.mScaleX, this.mScaleY);
        PrintUtilities.disableDoubleBuffering(this.component);
        this.component.paint(g2);
        PrintUtilities.enableDoubleBuffering(this.component);
        return 0;
    }

    public boolean printComponent() {
        return this.printComponent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean printComponent(String pdffn) {
        boolean res = false;
        JFileChooser jfc = null;
        if (pdffn == null) {
            this.pdfFile = this.config.getPropertyString("properties", "dir", new String[]{"mf", "pdf"});
            if (this.pdfFile != null) {
                File pf = new File(this.pdfFile);
                if (pf.exists()) {
                    if (pf.isFile()) {
                        this.pdfFile = pf.getParent();
                    }
                } else {
                    this.pdfFile = this.config.getPropertyString("properties", "dir", new String[]{"mf", "pro"});
                    if (pf.exists() && pf.isFile()) {
                        this.pdfFile = pf.getParent();
                    }
                }
            }
            jfc = this.createJFileChooser(this.pdfFile);
            if (this.pdf != null) {
                jfc.setSelectedFile(new File(this.pdf));
            }
        } else {
            this.pdfFile = pdffn;
        }
        int msg = 1;
        int b_jfc = 1;
        if (jfc != null) {
            b_jfc = jfc.showOpenDialog(this.parent);
            if (b_jfc == 0) {
                String[] files = jfc.getCurrentDirectory().list();
                String file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\");
                if (file.indexOf(".pdf") < file.length() - 4) {
                    file = file + ".pdf";
                }
                while (this.fileExists(files, file) && msg != -1) {
                    Toolkit.getDefaultToolkit().beep();
                    msg = JOptionPane.showConfirmDialog(this.parent, this.print_trad.getCodeLan("overwrite") + "?", this.print_trad.getCodeLan("fileprint"), 0, 3);
                    if (msg == 1 && jfc.showOpenDialog(this.parent) == 0) {
                        files = jfc.getCurrentDirectory().list();
                        if (this.fileExists(files, file = jfc.getSelectedFile().getAbsolutePath().replaceAll("&#92;", "\\\\"))) {
                            msg = -1;
                            continue;
                        }
                        msg = 0;
                    }
                    break;
                }
            } else if (b_jfc == 1) {
                return res;
            }
        }
        if (msg != 0) {
            if (this.pdfFile == null) return res;
        }
        if (jfc != null) {
            this.pdfFile = jfc.getSelectedFile().getAbsolutePath();
        }
        if (this.pdfFile.indexOf(".pdf") < this.pdfFile.length() - 4) {
            this.pdfFile = this.pdfFile + ".pdf";
        }
        int dimpath = this.pdfFile.length();
        String pdfFileName = "dummy.pdf";
        if (dimpath > 0) {
            pdfFileName = this.pdfFile.substring(this.pdfFile.lastIndexOf(System.getProperty("file.separator")) + 1);
        }
        int dimfile = pdfFileName.length();
        String path = this.pdfFile.substring(0, dimpath - dimfile - 1);
        this.config.setPropertyString("properties", "dir", new String[]{"mf", "pdf"}, path);
        if (this.parent instanceof JFrame) {
            this.glasspane = ((JFrame)SwingUtilities.getRoot(this.parent)).getGlassPane();
        } else if (this.parent instanceof JDialog) {
            this.glasspane = ((JDialog)SwingUtilities.getRoot(this.parent)).getGlassPane();
        }
        this.glasspane.setCursor(new Cursor(3));
        this.glasspane.setVisible(true);
        if (this.component != null) {
            Document document = new Document();
            document.setPageCount(2);
            try {
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(this.pdfFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                Graphics2D g2d = cb.createGraphics((float)this.pageFormat.getWidth(), (float)this.pageFormat.getHeight());
                g2d.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
                g2d.scale(this.mScaleX, this.mScaleY);
                PrintUtilities.disableDoubleBuffering(this.component);
                this.component.paint(g2d);
                PrintUtilities.enableDoubleBuffering(this.component);
                g2d.dispose();
            }
            catch (DocumentException de) {
                enercad2007.Globals.println("PrintUtilities.printComponent 1: " + de.getMessage());
            }
            catch (IOException ioe) {
                enercad2007.Globals.println("PrintUtilities.printCompoent 2: " + ioe.getMessage());
            }
            finally {
                this.glasspane.setCursor(new Cursor(0));
                this.glasspane.setVisible(false);
            }
            document.close();
            this.glasspane.setCursor(new Cursor(0));
            this.glasspane.setVisible(false);
            return true;
        }
        if (this.components != null) {
            Document document = new Document();
            document.setPageCount(this.components.size());
            try {
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(this.pdfFile));
                float width = (float)this.pageFormat.getWidth();
                float height = (float)this.pageFormat.getHeight();
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                Graphics2D g2d = cb.createGraphics(width, height);
                g2d.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
                g2d.scale(this.mScaleX, this.mScaleY);
                Component component = this.components.get(0);
                component.paint(g2d);
                g2d.dispose();
                int dim = this.components.size();
                if (dim > 1) {
                    for (int ii = 1; ii < dim; ++ii) {
                        component = this.components.get(ii);
                        this.setDefaultPageFormat(component);
                        this.scaleToFit(component, true);
                        document.newPage();
                        cb = writer.getDirectContent();
                        g2d = cb.createGraphics(width, height);
                        g2d.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
                        g2d.scale(this.mScaleX, this.mScaleY);
                        component.paint(g2d);
                        g2d.dispose();
                    }
                }
            }
            catch (DocumentException de) {
                enercad2007.Globals.println("PrintUtilities.printComponent 1: " + de.getMessage());
            }
            catch (IOException ioe) {
                enercad2007.Globals.println("PrintUtilities.printCompoent 2: " + ioe.getMessage());
            }
            finally {
                this.glasspane.setCursor(new Cursor(0));
                this.glasspane.setVisible(false);
            }
            document.close();
            this.glasspane.setCursor(new Cursor(0));
            this.glasspane.setVisible(false);
            return true;
        }
        if (this.html != null) {
            Document document = new Document();
            try {
                document.open();
                String[] pgr = Ecad2007.getDM_Zone(0).getResumTxt();
                StringBuffer sBuff = new StringBuffer("<html>");
                sBuff.append("<head></head>");
                sBuff.append("<body>");
                for (int ii = 1; ii < 11; ++ii) {
                    sBuff.append(pgr[ii]);
                }
                sBuff.append("</body>");
                sBuff.append("</html>");
                StyleSheet st = new StyleSheet();
                st.loadTagStyle("body", "face", "arial unicode ms");
                st.loadTagStyle("body", "encoding", "Identity-H");
                st.loadTagStyle("body", "leading", "10,0");
                HTMLWorker worker = new HTMLWorker(document);
                StringReader stringReader = new StringReader(sBuff.toString());
                ArrayList p = HTMLWorker.parseToList(stringReader, st);
                for (int k = 0; k < p.size(); ++k) {
                    document.add((Element)p.get(k));
                }
                document.close();
            }
            catch (DocumentException de) {
                enercad2007.Globals.println("PrintUtilities.printComponent 3: " + de.getMessage());
            }
            catch (IOException ioe) {
                enercad2007.Globals.println("PrintUtilities.printComponent 4: " + ioe.getMessage());
            }
            finally {
                this.glasspane.setCursor(new Cursor(0));
                this.glasspane.setVisible(false);
            }
            document.close();
            this.glasspane.setCursor(new Cursor(0));
            this.glasspane.setVisible(false);
            return true;
        }
        FopFactory fopFactory = FopFactory.newInstance();
        OutputStream out = null;
        if (this.imageFop == null) {
            out = new FileOutputStream(this.pdfFile);
            out = new BufferedOutputStream(out);
        } else {
            out = new ByteArrayOutputStream();
        }
        FOUserAgent useragent = fopFactory.newFOUserAgent();
        useragent.setURIResolver(new ClasspathResourceResolver());
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        Fop fop = fopFactory.newFop("application/pdf", useragent, out);
        fopFactory.setStrictValidation(false);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StreamSource srcFop = new StreamSource(new StringReader(this.formFop));
        SAXResult result = new SAXResult(fop.getDefaultHandler());
        transformer.transform(srcFop, result);
        FormattingResults foResults = fop.getResults();
        List pageSequences = foResults.getPageSequences();
        for (PageSequenceResults pageSequenceResults : pageSequences) {
            enercad2007.Globals.println("PageSequence " + (String.valueOf(pageSequenceResults.getID()).length() > 0 ? pageSequenceResults.getID() : "<no id>") + " generated " + pageSequenceResults.getPageCount() + " pages.");
        }
        enercad2007.Globals.println("Generated " + foResults.getPageCount() + " pages in total.");
        res = true;
        try {
            if (this.imageFop != null) {
                try {
                    PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                    PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                    PdfContentByte cbu = stamper.getUnderContent(1);
                    PdfContentByte cbo = stamper.getOverContent(1);
                    int dim = this.imageFop.length;
                    for (int ii = 0; ii < dim; ++ii) {
                        Point pos = this.imageFop[ii].getLocation();
                        java.awt.Image img = this.imageFop[ii].getImage();
                        Image image = Image.getInstance(img, null);
                        image.setAbsolutePosition(pos.x, pos.y);
                        cbo.addImage(image);
                    }
                    stamper.close();
                }
                catch (DocumentException docEx) {
                    enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                }
            } else if (out != null) {
                out.close();
            }
            this.glasspane.setCursor(new Cursor(0));
            this.glasspane.setVisible(false);
            return res;
        }
        catch (IOException ioex) {
            this.glasspane.setCursor(new Cursor(0));
            this.glasspane.setVisible(false);
            enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
            return res;
        }
        catch (FOPException fopex) {
            enercad2007.Globals.println("printFop: " + fopex.getMessage());
            try {
                if (this.imageFop != null) {
                    try {
                        PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                        PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                        PdfContentByte cbu = stamper.getUnderContent(1);
                        PdfContentByte cbo = stamper.getOverContent(1);
                        int dim = this.imageFop.length;
                        for (int ii = 0; ii < dim; ++ii) {
                            Point pos = this.imageFop[ii].getLocation();
                            java.awt.Image img = this.imageFop[ii].getImage();
                            Image image = Image.getInstance(img, null);
                            image.setAbsolutePosition(pos.x, pos.y);
                            cbo.addImage(image);
                        }
                        stamper.close();
                    }
                    catch (DocumentException docEx) {
                        enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                    }
                } else if (out != null) {
                    out.close();
                }
                this.glasspane.setCursor(new Cursor(0));
                this.glasspane.setVisible(false);
                return res;
            }
            catch (IOException ioex) {
                this.glasspane.setCursor(new Cursor(0));
                this.glasspane.setVisible(false);
                enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
                return res;
            }
            catch (TransformerConfigurationException tcex) {
                enercad2007.Globals.println("printFop: " + tcex.getMessage());
                try {
                    if (this.imageFop != null) {
                        try {
                            PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                            PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                            PdfContentByte cbu = stamper.getUnderContent(1);
                            PdfContentByte cbo = stamper.getOverContent(1);
                            int dim = this.imageFop.length;
                            for (int ii = 0; ii < dim; ++ii) {
                                Point pos = this.imageFop[ii].getLocation();
                                java.awt.Image img = this.imageFop[ii].getImage();
                                Image image = Image.getInstance(img, null);
                                image.setAbsolutePosition(pos.x, pos.y);
                                cbo.addImage(image);
                            }
                            stamper.close();
                        }
                        catch (DocumentException docEx) {
                            enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                        }
                    } else if (out != null) {
                        out.close();
                    }
                    this.glasspane.setCursor(new Cursor(0));
                    this.glasspane.setVisible(false);
                    return res;
                }
                catch (IOException ioex) {
                    this.glasspane.setCursor(new Cursor(0));
                    this.glasspane.setVisible(false);
                    enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
                    return res;
                }
                catch (TransformerException tex) {
                    enercad2007.Globals.println("printFop: " + tex.getMessage());
                    try {
                        if (this.imageFop != null) {
                            try {
                                PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                                PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                                PdfContentByte cbu = stamper.getUnderContent(1);
                                PdfContentByte cbo = stamper.getOverContent(1);
                                int dim = this.imageFop.length;
                                for (int ii = 0; ii < dim; ++ii) {
                                    Point pos = this.imageFop[ii].getLocation();
                                    java.awt.Image img = this.imageFop[ii].getImage();
                                    Image image = Image.getInstance(img, null);
                                    image.setAbsolutePosition(pos.x, pos.y);
                                    cbo.addImage(image);
                                }
                                stamper.close();
                            }
                            catch (DocumentException docEx) {
                                enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                            }
                        } else if (out != null) {
                            out.close();
                        }
                        this.glasspane.setCursor(new Cursor(0));
                        this.glasspane.setVisible(false);
                        return res;
                    }
                    catch (IOException ioex) {
                        this.glasspane.setCursor(new Cursor(0));
                        this.glasspane.setVisible(false);
                        enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
                        return res;
                    }
                    catch (FileNotFoundException fnfex) {
                        enercad2007.Globals.println("printFop: " + fnfex.getMessage());
                        JOptionPane.showMessageDialog(this.parent, fnfex.getMessage(), "EnerCAD-info", 0);
                        try {
                            if (this.imageFop != null) {
                                try {
                                    PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                                    PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                                    PdfContentByte cbu = stamper.getUnderContent(1);
                                    PdfContentByte cbo = stamper.getOverContent(1);
                                    int dim = this.imageFop.length;
                                    for (int ii = 0; ii < dim; ++ii) {
                                        Point pos = this.imageFop[ii].getLocation();
                                        java.awt.Image img = this.imageFop[ii].getImage();
                                        Image image = Image.getInstance(img, null);
                                        image.setAbsolutePosition(pos.x, pos.y);
                                        cbo.addImage(image);
                                    }
                                    stamper.close();
                                }
                                catch (DocumentException docEx) {
                                    enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                                }
                            } else if (out != null) {
                                out.close();
                            }
                            this.glasspane.setCursor(new Cursor(0));
                            this.glasspane.setVisible(false);
                            return res;
                        }
                        catch (IOException ioex) {
                            this.glasspane.setCursor(new Cursor(0));
                            this.glasspane.setVisible(false);
                            enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
                            return res;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (this.imageFop != null) {
                                    try {
                                        PdfReader pdf = new PdfReader(((ByteArrayOutputStream)out).toByteArray());
                                        PdfStamper stamper = new PdfStamper(pdf, new FileOutputStream(this.pdfFile));
                                        PdfContentByte cbu = stamper.getUnderContent(1);
                                        PdfContentByte cbo = stamper.getOverContent(1);
                                        int dim = this.imageFop.length;
                                        for (int ii = 0; ii < dim; ++ii) {
                                            Point pos = this.imageFop[ii].getLocation();
                                            java.awt.Image img = this.imageFop[ii].getImage();
                                            Image image = Image.getInstance(img, null);
                                            image.setAbsolutePosition(pos.x, pos.y);
                                            cbo.addImage(image);
                                        }
                                        stamper.close();
                                    }
                                    catch (DocumentException docEx) {
                                        enercad2007.Globals.println("PrintUtilities.printComponent: " + docEx.getMessage());
                                    }
                                } else if (out != null) {
                                    out.close();
                                }
                                this.glasspane.setCursor(new Cursor(0));
                                this.glasspane.setVisible(false);
                                throw throwable;
                            }
                            catch (IOException ioex) {
                                this.glasspane.setCursor(new Cursor(0));
                                this.glasspane.setVisible(false);
                                enercad2007.Globals.println("PrintUtilities :" + ioex.getMessage());
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    public boolean printComponentWithDialog() {
        boolean res = false;
        try {
            this.aset = this.getPrinterSettings();
            this.createPrintJob();
            this.setPrintable(this);
            if (this.pj == null) {
                this.pj = this.createPrintJob();
            }
            if (this.pj != null) {
                this.pj.setPageable(this);
                this.pj.print(this.aset);
                res = true;
            }
        }
        catch (PrinterException ex) {
            enercad2007.Globals.println("PrintUtilities.printComponentWithDialog: " + ex);
        }
        return res;
    }

    public boolean printFop(String formFop) {
        this.component = null;
        this.formFop = formFop;
        this.html = null;
        this.imageFop = null;
        return this.printComponent();
    }

    public boolean printFop(String formFop, String projectFileName) {
        this.pdf = projectFileName;
        this.component = null;
        this.formFop = formFop;
        this.html = null;
        this.imageFop = null;
        return this.printComponent();
    }

    public boolean printHTML(String html) {
        this.component = null;
        this.formFop = null;
        this.imageFop = null;
        this.html = html;
        return this.printComponent();
    }

    public boolean printMergedFop(String formFop, ImageFop[] imageFop, String projectFileName) {
        this.component = null;
        this.html = null;
        this.formFop = formFop;
        this.imageFop = imageFop;
        this.pdf = projectFileName;
        return this.printComponent();
    }

    public void setMediaUnits(int mediaUnits) {
        this.mediaUnits = mediaUnits <= 0 ? 1000 : 25400;
    }

    protected void setPrintable(Printable printable) {
        this.printable = printable;
    }

    private void setDefaultPageFormat() {
        this.setDefaultPageFormat(this.component);
    }

    private void setDefaultPageFormat(Component comp) {
        if (this.cname.equals("")) {
            this.cname = comp.getClass().getName();
        }
        String mediaSize = "";
        String[] mediaPrintableArea = null;
        int[] mpa = new int[4];
        double dpmm = 72.0;
        if (this.mediaUnits == 1000) {
            dpmm = 2.834645669291339;
        }
        String tmp = "";
        int index = this.cname.lastIndexOf(".");
        if (index > 0) {
            this.cname = this.cname.substring(index).indexOf("Dlg") > 0 ? this.cname.substring(index + 4) : this.cname.substring(index + 1);
        }
        if ((tmp = "18,14,11,11").split(",").length > 0) {
            mediaPrintableArea = tmp.split(",");
            for (int ii = 0; ii < 4; ++ii) {
                mpa[ii] = Globals.getIntValue(mediaPrintableArea[ii]);
            }
        }
        mediaSize = "iso-a4";
        float[] msfl = this.getMediaSize(mediaSize);
        mpa[2] = (int)msfl[0] - mpa[0] - mpa[2];
        mpa[3] = (int)msfl[1] - mpa[1] - mpa[3];
        Paper paper = new Paper();
        paper.setSize((double)msfl[0] * dpmm, (double)msfl[1] * dpmm);
        paper.setImageableArea((double)mpa[0] * dpmm, (double)mpa[1] * dpmm, (double)mpa[2] * dpmm, (double)mpa[3] * dpmm);
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
        String orientation = "portrait";
        if (orientation.equals("landscape")) {
            this.pageFormat.setOrientation(0);
        } else {
            this.pageFormat.setOrientation(1);
        }
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    protected void setSize(float width, float height) {
        this.mNumPagesX = (int)(((double)width + this.pageFormat.getImageableWidth() - 1.0) / this.pageFormat.getImageableWidth());
        this.mNumPagesY = (int)(((double)height + this.pageFormat.getImageableHeight() - 1.0) / this.pageFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    public void setPdfToPrint(String pdf) {
        this.pdf = pdf;
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    protected PageFormat getPageFormat() {
        return this.pageFormat;
    }

    class ClasspathResourceResolver
    implements URIResolver {
        ClasspathResourceResolver() {
        }

        public InputStream resolve(String uri) {
            System.out.println("CalsspathResourceResolver.inputStream uri: " + uri);
            return this.getClass().getResourceAsStream(uri);
        }

        @Override
        public Source resolve(String uri, String baseUri) throws TransformerException {
            StreamSource srcFop = new StreamSource(this.getClass().getResourceAsStream(uri));
            enercad2007.Globals.println(10000, "CalsspathResourceResolver.resolve uri: " + uri);
            return srcFop;
        }
    }

    class PrtFilter
    extends FileFilter {
        String description;
        String[] extension;

        public PrtFilter(String description, String[] extension) {
            this.description = description;
            this.extension = extension;
        }

        @Override
        public boolean accept(File file) {
            boolean b_accept = false;
            if (file.isDirectory()) {
                return true;
            }
            String extension = null;
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                extension = s.substring(i + 1).toLowerCase();
            }
            if (extension != null) {
                for (int cter = 0; cter < this.extension.length; ++cter) {
                    if (!extension.equals(this.extension[cter]) && !this.extension[cter].equals("*")) continue;
                    b_accept = true;
                    break;
                }
            }
            return b_accept;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static final class TranslatedPrintable
    implements Printable {
        private Printable printable;
        private Point2D origin;

        public TranslatedPrintable(Printable printable, Point2D origin) {
            this.printable = printable;
            this.origin = origin;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            this.printable.print(g2, pageFormat, 1);
            return 0;
        }
    }
}

