/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Calc_Met;
import core.Globals;
import java.awt.Color;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import privatecomponents.HorizonStereo;
import resources.TestValues;

public class Utility {
    Calc_Met calc_met = new Calc_Met();
    TreeMap<Double, Color> palette;
    double latitude = 0.0;
    double longitude = 0.0;
    double timezone = 0.0;
    boolean b_order = false;
    double ptdiam = 0.6;

    public Utility() {
        this.jbInit();
    }

    public Utility(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    private void jbInit() {
        String hex;
        this.palette = new TreeMap(new PaletteComparator(this.b_order));
        String[] values = TestValues.getDefaultStColors();
        for (int ii = 0; ii < values.length && (hex = values[ii]) != null && !hex.equals(""); ++ii) {
            int rr = Globals.getIntValue(hex.substring(0, 2), 16);
            int gg = Globals.getIntValue(hex.substring(2, 4), 16);
            int bb = Globals.getIntValue(hex.substring(4, 6), 16);
            double tmp = Globals.getDoubleValue(hex.substring(6));
            Color color = new Color(rr, gg, bb);
            this.palette.put(tmp, color);
        }
    }

    public void drawPointsForSunpath(Map<Integer, Object> map, HorizonStereo horizonStereo, int[] doys, int inter) {
        if (map == null) {
            return;
        }
        if (this.ptdiam == 0.0) {
            this.ptdiam = 0.6;
        }
        int dim = map.size();
        String row0 = "";
        String row1 = "";
        for (int ii = 10; ii < dim; ++ii) {
            double hh0;
            double dhh;
            int day;
            int month;
            String[] rows1;
            int year;
            Calendar calendar;
            int doy;
            row1 = (String)map.get(ii);
            if (row1 == null || doys[0] > (doy = (calendar = this.getCalendarInstance(year = Globals.getIntValue((rows1 = row1.split(","))[0]), (month = Globals.getIntValue(rows1[1])) - 1, day = Globals.getIntValue(rows1[2]), 0, 0, 0, 0)).get(6)) || doy > doys[1]) continue;
            int min1 = Globals.getIntValue(rows1[4]);
            if (min1 == 60) {
                min1 = 0;
            }
            double hh1 = this.calc_met.getDecimalHour(Globals.getIntValue(rows1[3]) - 1, min1);
            horizonStereo.setPointDiameter(this.ptdiam);
            if (inter == 0 || inter == 1 || ii == 9) {
                horizonStereo.drawPoint(this.latitude, doy, hh1, this.getColor(Globals.getDoubleValue(rows1[6])));
                continue;
            }
            row0 = (String)map.get(ii - 1);
            String[] rows0 = row0.split(",");
            int min0 = Globals.getIntValue(rows0[4]);
            if (min0 == 60) {
                min0 = 0;
            }
            if ((dhh = (hh1 - (hh0 = this.calc_met.getDecimalHour(Globals.getIntValue(rows0[3]) - 1, min0))) / (double)inter) < 0.0) {
                dhh = (hh1 - hh0 + 24.0) / (double)inter;
            }
            double dtt = (Globals.getDoubleValue(rows1[6]) - Globals.getDoubleValue(rows0[6])) / (double)inter;
            for (double xx = 0.0; xx < (double)inter; xx += 1.0) {
                double hh = hh1 + xx * dhh;
                double tt = Globals.getDoubleValue(rows1[6]) + xx * dtt;
                horizonStereo.drawPoint(this.latitude, doy, hh, this.getColor(tt));
            }
        }
        horizonStereo.drawSolarPathForDoys(this.latitude, Color.black);
        horizonStereo.drawSolarPathForHours(this.latitude, Color.black);
        horizonStereo.drawLabelsForSolarPathForHours(this.latitude, Color.black);
    }

    public void drawPointsForSunpath(Map<Integer, Object> map, HorizonStereo horizonStereo, int type, Date[] date, int inter) {
        if (map == null) {
            return;
        }
        Calendar cal_from = null;
        Calendar cal_to = null;
        if (date != null) {
            if (date[0] != null) {
                cal_from = this.getCalendarInstance(date[0], 0, 0, 0, 0);
            }
            if (date[1] != null) {
                cal_to = this.getCalendarInstance(date[1], 0, 0, 0, 0);
            }
            if (cal_from == null && cal_to != null) {
                cal_from = cal_to;
            }
            if (cal_to == null && cal_from != null) {
                cal_to = cal_from;
            }
        }
        if (this.ptdiam == 0.0) {
            this.ptdiam = 0.6;
        }
        int dim = map.size();
        String row0 = "";
        String row1 = "";
        if (cal_from != null && cal_to != null) {
            for (int ii = 9; ii < dim; ++ii) {
                double hh0;
                double dhh;
                int day;
                int month;
                String[] rows1;
                int year;
                Calendar calendar;
                row1 = (String)map.get(ii);
                if (row1 == null || (calendar = this.getCalendarInstance(year = Globals.getIntValue((rows1 = row1.split(","))[0]), (month = Globals.getIntValue(rows1[1])) - 1, day = Globals.getIntValue(rows1[2]), 0, 0, 0, 0)).compareTo(cal_from) < 0 || calendar.compareTo(cal_to) > 0) continue;
                int doy = calendar.get(6);
                int min1 = Globals.getIntValue(rows1[4]);
                if (min1 == 60) {
                    min1 = 0;
                }
                double hh1 = this.calc_met.getDecimalHour(Globals.getIntValue(rows1[3]) - 1, min1);
                horizonStereo.setPointDiameter(this.ptdiam);
                if (inter == 0 || inter == 1 || ii == 9) {
                    horizonStereo.drawPoint(this.latitude, doy, hh1, this.getColor(Globals.getDoubleValue(rows1[6])));
                    continue;
                }
                row0 = (String)map.get(ii - 1);
                String[] rows0 = row0.split(",");
                int min0 = Globals.getIntValue(rows0[4]);
                if (min0 == 60) {
                    min0 = 0;
                }
                if ((dhh = (hh1 - (hh0 = this.calc_met.getDecimalHour(Globals.getIntValue(rows0[3]) - 1, min0))) / (double)inter) < 0.0) {
                    dhh = (hh1 - hh0 + 24.0) / (double)inter;
                }
                double dtt = (Globals.getDoubleValue(rows1[6]) - Globals.getDoubleValue(rows0[6])) / (double)inter;
                for (double xx = 0.0; xx < (double)inter; xx += 1.0) {
                    double hh = hh0 + xx * dhh;
                    double tt = Globals.getDoubleValue(rows0[6]) + xx * dtt;
                    horizonStereo.drawPoint(this.latitude, doy, hh, this.getColor(tt));
                }
            }
        }
        horizonStereo.drawSolarPathForDoys(this.latitude, Color.black);
        horizonStereo.drawSolarPathForHours(this.latitude, Color.black);
        horizonStereo.drawLabelsForSolarPathForHours(this.latitude, Color.black);
    }

    public void drawPointsForWindrose(Map<Integer, Object> map, HorizonStereo horizonStereo, int[] doys) {
        if (map == null) {
            return;
        }
        if (this.ptdiam == 0.0) {
            this.ptdiam = 0.6;
        }
        int dim = map.size();
        String row = "";
        for (int ii = 9; ii < dim; ++ii) {
            row = (String)map.get(ii);
            if (row == null) continue;
            String[] rows = row.split(",");
            int year = Globals.getIntValue(rows[0]);
            int month = Globals.getIntValue(rows[1]);
            int day = Globals.getIntValue(rows[2]);
            Calendar calendar = this.getCalendarInstance(year, month - 1, day, 0, 0, 0, 0);
            int doy = calendar.get(6);
            int diam = horizonStereo.getWidth() / 120;
            if (diam < 1) {
                diam = 1;
            }
            horizonStereo.setPointDiameter(diam);
            if (doys[0] > doy || doy >= doys[1]) continue;
            double wdir = Globals.getDoubleValue(rows[20]);
            double wspeed = Globals.getDoubleValue(rows[21]) * 3.6;
            double tt = Globals.getDoubleValue(rows[6]);
            Color color = this.getColor(tt);
            horizonStereo.fillPoint(wdir, wspeed, color);
        }
    }

    public Calendar getCalendarInstance(Date date) {
        return this.getCalendarInstance(date, 0, 0, 0, 0);
    }

    public Calendar getCalendarInstance(Date date, int hour_of_day, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour_of_day);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public Calendar getCalendarInstance(int year, int month, int day_of_month, int hour_of_day, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day_of_month, hour_of_day, minute, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public Color getColor(double key) {
        Color color = this.palette.get(this.palette.lastKey());
        for (double tmp : this.palette.keySet()) {
            if (this.b_order) {
                if (!(tmp > key)) continue;
                color = this.palette.get(tmp);
                break;
            }
            if (!(tmp < key)) continue;
            color = this.palette.get(tmp);
            break;
        }
        return color;
    }

    public Date getDateFromRow(String row) {
        Date date = null;
        if (row == null) {
            return date;
        }
        String[] cols = row.split(",");
        int year = Globals.getIntValue(cols[0]);
        int month = Globals.getIntValue(cols[1]);
        int day = Globals.getIntValue(cols[2]);
        Calendar calendar = this.getCalendarInstance(year, month - 1, day, 0, 0, 0, 0);
        date = calendar.getTime();
        return date;
    }

    public Date[] getMinMaxDate(Map<Integer, Object> map) {
        Date min = new Date();
        Date max = new Date(0L);
        if (map == null) {
            return new Date[2];
        }
        for (int ii = 9; ii < map.size(); ++ii) {
            String row = (String)map.get(ii);
            Date date = this.getDateFromRow(row);
            if (date.compareTo(min) < 0) {
                min = date;
            }
            if (date.compareTo(max) <= 0) continue;
            max = date;
        }
        return new Date[]{min, max};
    }

    public TreeMap<Double, Color> getPalette() {
        return this.palette;
    }

    public Comparator getPaletteComparator(boolean order) {
        return new PaletteComparator(order);
    }

    public void setColorPalette(TreeMap<Double, Color> palette) {
        this.palette = palette;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setPointDiameter(double diameter) {
        this.ptdiam = diameter;
    }

    public void setTimeZone(double timezone) {
        this.timezone = timezone;
    }

    private class PaletteComparator
    implements Comparator {
        int res = 0;
        boolean b_order = true;

        public PaletteComparator(boolean order) {
            this.b_order = order;
        }

        public int compare(Object object_01, Object object_02) {
            int res = 0;
            res = this.b_order ? Double.compare(Globals.getDoubleValue(object_01), Globals.getDoubleValue(object_02)) : Double.compare(Globals.getDoubleValue(object_02), Globals.getDoubleValue(object_01));
            return res;
        }
    }
}

