/*
 * Decompiled with CFR 0.152.
 */
package core;

import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static Document createDocument(InputStream inputStream) {
        Document xmlDocument = null;
        boolean b_valid = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (inputStream == null) {
                return null;
            }
            xmlDocument = builder.parse(inputStream);
            xmlDocument.getDocumentElement().normalize();
            b_valid = true;
        }
        catch (ParserConfigurationException pcex) {
            Globals.println("Config: Failed to create DOM document: " + pcex);
        }
        catch (SAXException saxex) {
            Globals.println("Config: Failed to read inputstream." + saxex.getMessage());
        }
        catch (IOException ioex) {
            Globals.println("Config: Failed to read xml file: " + ioex.getMessage());
        }
        return xmlDocument;
    }

    public static Map<String, String> getAllAttributes(Node node) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NamedNodeMap nmm = node.getAttributes();
        for (int j = 0; j < nmm.getLength(); ++j) {
            Node attribute = nmm.item(j);
            if (attribute.getNodeType() != 2) continue;
            attrs.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        return attrs;
    }

    public static String getAttributeValue(Node node, String attrName) {
        NamedNodeMap nmm = node.getAttributes();
        for (int jj = 0; jj < nmm.getLength(); ++jj) {
            String nodeName;
            Node attribute = nmm.item(jj);
            if (attribute.getNodeType() != 2 || !(nodeName = attribute.getNodeName()).equals(attrName)) continue;
            return attribute.getNodeValue();
        }
        return null;
    }

    public static String getAttributeValue(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() == 0) {
            value = null;
        }
        return value;
    }

    public static List filterNodeList(NodeList nodeList, short keepNodeType) {
        return XmlUtil.filterNodeList(nodeList, keepNodeType, null);
    }

    public static List<Node> filterNodeList(NodeList nodeList, short keepNodeType, String nodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int k = 0; k < nodeList.getLength(); ++k) {
            Node node = nodeList.item(k);
            if (node.getNodeType() != keepNodeType || nodeName != null && !node.getNodeName().equals(nodeName)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List filterNodeListElements(NodeList nodeList) {
        return XmlUtil.filterNodeListElements(nodeList, null);
    }

    public static List<Node> filterNodeListElements(NodeList nodeList, String nodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int k = 0; k < nodeList.getLength(); ++k) {
            Node node = nodeList.item(k);
            if (node.getNodeType() != 1 || nodeName != null && !node.getNodeName().equals(nodeName)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List getChildElements(Node node) {
        return XmlUtil.getChildElements(node, null);
    }

    public static List getChildElements(Node node, String nodeName) {
        NodeList childs = node.getChildNodes();
        return XmlUtil.filterNodeListElements(childs, nodeName);
    }

    public static String getFirstChildTextNodeValue(Node node) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 3) continue;
            return n.getNodeValue();
        }
        return null;
    }

    public static String getChildTextNodeValue(Node node) {
        if (node.getChildNodes().getLength() != 1) {
            return null;
        }
        Node item0 = node.getChildNodes().item(0);
        if (item0.getNodeType() != 3) {
            return null;
        }
        return item0.getNodeValue();
    }
}

