/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMetadata {
    static final Logger logger = LoggerFactory.getLogger(Ecad2007.class);
    SessionFactory sessionFactory;
    String dbName;
    boolean b_close = true;

    public DbMetadata() {
    }

    public DbMetadata(String dbName) {
        this.dbName = dbName;
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
    }

    public DbMetadata(String dbName, boolean b_close) {
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
        this.dbName = dbName;
        this.b_close = b_close;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
    }

    public List<String> listTables() {
        List<String> list;
        block7: {
            list = new ArrayList<String>(20);
            Session session = Ecad2007.getCurrentSession(this.dbName);
            Transaction tx = null;
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery("select tablename from sys.systables where tabletype='T'");
                list = sqlQuery.list();
                if (this.b_close) {
                    tx.commit();
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    public List<String> listColumns(String tableName) {
        List<String> list;
        block9: {
            list = new ArrayList<String>(20);
            Session session = Ecad2007.getCurrentSession(this.dbName);
            Transaction tx = null;
            String tableid = null;
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery("select tableid from sys.systables where tablename='" + tableName.toUpperCase() + "'");
                sqlQuery.addScalar("TABLEID", CharArrayType.INSTANCE);
                Object object = sqlQuery.uniqueResult();
                if (object instanceof char[]) {
                    tableid = String.copyValueOf((char[])object);
                }
                if (tableid == null) {
                    return list;
                }
                sqlQuery = session.createSQLQuery("select columnname from sys.syscolumns where referenceid='" + tableid + "' order by COLUMNNUMBER");
                list = sqlQuery.list();
                if (this.b_close) {
                    tx.commit();
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    public Map<String, Integer> listColumnInfo(String tableName) {
        List cn;
        List ctn;
        HashMap<String, Integer> map;
        block35: {
            map = new HashMap<String, Integer>(20);
            ctn = new ArrayList(20);
            cn = new ArrayList(20);
            Session session = Ecad2007.getCurrentSession(this.dbName);
            Transaction tx = null;
            String tableid = null;
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery("select tableid from sys.systables where tablename='" + tableName.toUpperCase() + "'");
                sqlQuery.addScalar("TABLEID", CharArrayType.INSTANCE);
                Object object = sqlQuery.uniqueResult();
                if (object instanceof char[]) {
                    tableid = String.copyValueOf((char[])object);
                }
                if (tableid == null) {
                    return map;
                }
                sqlQuery = session.createSQLQuery("select columnname from sys.syscolumns where referenceid='" + tableid + "' order by COLUMNNUMBER");
                sqlQuery.addScalar("COLUMNNAME", StringType.INSTANCE);
                cn = sqlQuery.list();
                sqlQuery = session.createSQLQuery("select columndatatype  from sys.syscolumns where referenceid='" + tableid + "' order by COLUMNNUMBER");
                sqlQuery.addScalar("COLUMNDATATYPE", StringType.INSTANCE);
                ctn = sqlQuery.list();
                tx.commit();
                if (this.b_close) {
                    Ecad2007.closeSession(this.dbName);
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block35;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (cn == null) {
            return map;
        }
        int dim = cn.size();
        if (dim != ctn.size()) {
            return map;
        }
        for (int ii = 0; ii < dim; ++ii) {
            String type = (String)ctn.get(ii);
            Integer i_type = null;
            if (type.startsWith("SMALLINT")) {
                i_type = 5;
            } else if (type.startsWith("INTEGER")) {
                i_type = 4;
            } else if (type.startsWith("BIGINT")) {
                i_type = -5;
            } else if (type.startsWith("REAL")) {
                i_type = 7;
            } else if (type.startsWith("FLOAT")) {
                i_type = 6;
            } else if (type.startsWith("DOUBLE")) {
                i_type = 8;
            } else if (type.startsWith("DECIMAL")) {
                i_type = 3;
            } else if (type.startsWith("CHAR")) {
                i_type = 1;
            } else if (type.startsWith("VARCHAR")) {
                i_type = 12;
            } else if (type.startsWith("DATE")) {
                i_type = 91;
            } else if (type.startsWith("BLOB")) {
                i_type = 2004;
            } else if (type.startsWith("CLOB")) {
                i_type = 2005;
            }
            map.put((String)cn.get(ii), i_type);
        }
        return map;
    }

    public boolean isColumnInTable(String table, String column) {
        List<String> list = this.listColumns(table);
        return list.contains(column);
    }

    public boolean isTableInDb(String table) {
        if (table == null) {
            return false;
        }
        List<String> list = this.listTables();
        return list.contains(table.toUpperCase());
    }

    public Type sqlType2HibernateType(int sqlType) {
        AbstractSingleColumnStandardBasicType type = null;
        if (sqlType == 5) {
            type = ShortType.INSTANCE;
        } else if (sqlType == 4) {
            type = IntegerType.INSTANCE;
        } else if (sqlType == -5) {
            type = BigIntegerType.INSTANCE;
        } else if (sqlType == 7) {
            type = FloatType.INSTANCE;
        } else if (sqlType == 6) {
            type = FloatType.INSTANCE;
        } else if (sqlType == 8) {
            type = DoubleType.INSTANCE;
        } else if (sqlType == 3) {
            type = DoubleType.INSTANCE;
        } else if (sqlType == 1) {
            type = StringType.INSTANCE;
        } else if (sqlType == 12) {
            type = StringType.INSTANCE;
        } else if (sqlType == 91) {
            type = DateType.INSTANCE;
        } else if (sqlType == 2004) {
            type = BinaryType.INSTANCE;
        } else if (sqlType == 2005) {
            type = TextType.INSTANCE;
        }
        return type;
    }
}

