/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate;

import java.io.File;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;

public class SessionFactoryUtil {
    private SessionFactory sessionFactory;
    private String xml;
    private Properties properties;
    private String[] resources;

    public SessionFactoryUtil(String xml, Properties properties) {
        this.xml = xml;
        this.properties = properties;
        this.jbInit();
    }

    public SessionFactoryUtil(String xml, Properties properties, String[] resources) {
        this.xml = xml;
        this.properties = properties;
        this.resources = resources;
        this.jbInit();
    }

    private void jbInit() {
        if (this.xml == null && this.properties == null) {
            Configuration configuration = new Configuration();
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            builder.applySettings(configuration.getProperties());
            this.sessionFactory = configuration.buildSessionFactory(builder.build());
        } else if (this.xml == null && this.properties != null) {
            Configuration configuration = new Configuration();
            configuration.setProperties(this.properties);
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            builder.applySettings(configuration.getProperties());
            this.sessionFactory = configuration.buildSessionFactory(builder.build());
        } else if (this.xml != null) {
            String fs = System.getProperty("file.separator");
            String xmlPath = System.getProperty("user.dir") + fs + this.xml;
            if (!new File(xmlPath = xmlPath.replaceAll("&#92;", "\\\\")).exists()) {
                xmlPath = this.xml;
            }
            Configuration configuration = new Configuration();
            try {
                configuration.configure(xmlPath);
            }
            catch (HibernateException hex) {
                configuration.configure(this.xml);
            }
            if (this.properties != null) {
                configuration.addProperties(this.properties);
            }
            if (this.resources != null) {
                int dim = this.resources.length;
                for (int ii = 0; ii < dim; ++ii) {
                    configuration.addResource(this.resources[ii]);
                }
            }
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            builder.applySettings(configuration.getProperties());
            this.sessionFactory = configuration.buildSessionFactory(builder.build());
        }
    }

    public SessionFactory getInstance() {
        return this.sessionFactory;
    }

    public Session openSession() {
        return this.sessionFactory.openSession();
    }

    public Session getCurrentSession() {
        return this.sessionFactory.openSession();
    }

    public void close() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        this.sessionFactory = null;
    }

    public static void close(SessionFactory sessionFactory) {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }
}

