/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.enercad.dao;

import core.hibernate.enercad.ScyDao;
import core.hibernate.enercad.db.ScyEcad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.List;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.service.UnknownServiceException;

public class HibernateScyDao
implements ScyDao {
    SessionFactory sessionFactory;
    String dbName = "enercad_" + Globals.int_ver;
    String xml = System.getProperty("hibernate.conf.file.name");
    boolean b_close = true;

    public HibernateScyDao() {
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    public HibernateScyDao(String xml) {
        this.xml = xml;
        this.sessionFactory = Ecad2007.getSession(xml, this.dbName).getSessionFactory();
    }

    public HibernateScyDao(boolean b_close) {
        this.b_close = b_close;
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(ScyEcad.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public List<ScyEcad> getScyList() {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.getScyList usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from ScyEcad as scy").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("HibernateScyDao.getScyList: Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return list;
    }

    private int getFirstFreeId() {
        int res;
        block11: {
            res = 0;
            List list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.getFirstFreeId usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from ScyEcad as scy").list();
                if (this.b_close) {
                    tx.commit();
                }
                if (list == null) {
                    return res;
                }
                int[] ids = new int[list.size()];
                for (int ii = 0; ii < ids.length; ++ii) {
                    ids[ii] = ((ScyEcad)list.get(ii)).getId();
                }
                res = new Globals().getFirstFreeInt(ids);
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block11;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("HibernateScyDao.getScyList: Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return res;
    }

    @Override
    public ScyEcad getScy(String var) {
        ScyEcad scy;
        block9: {
            scy = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.getScy usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            if (var == null) {
                return scy;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from ScyEcad as scy where var=?");
                scy = (ScyEcad)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("HibernateScyDao.getScy: Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return scy;
    }

    @Override
    public int updateScy(ScyEcad scy) {
        int updatedEntities;
        block10: {
            updatedEntities = 1;
            if (scy == null) {
                return updatedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.updateScy(scy) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            String vv = scy.getVar();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from ScyEcad as scy where var=?");
                query.setString(0, vv);
                ScyEcad sy = (ScyEcad)query.uniqueResult();
                if (sy == null) {
                    return 0;
                }
                int id = sy.getId();
                scy.setId(id);
                session.evict(sy);
                session.update(scy);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block10;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("HibernateScyDao.updateScy: Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertScy(ScyEcad scy) {
        int insertedEntities;
        block10: {
            insertedEntities = 0;
            if (scy == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.insertScy(scy) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                this.setCloseBit(false);
                int fid = this.getFirstFreeId();
                scy.setId(fid);
                this.setCloseBit(true);
                session.save(scy);
                if (this.b_close) {
                    tx.commit();
                }
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block10;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return insertedEntities;
    }

    @Override
    public int insertScy(Vector<Object[]> vector) {
        int insertedEntities;
        block16: {
            insertedEntities = 1;
            if (vector == null) {
                return insertedEntities;
            }
            Vector<ScyEcad> v_scy = new Vector<ScyEcad>(vector.size());
            for (Object[] values : vector) {
                ScyEcad scy = new ScyEcad();
                if (values == null) continue;
                if (values.length > 0 && values[0] != null) {
                    scy.setVar(String.valueOf(values[0]));
                }
                if (values.length > 1 && values[1] != null) {
                    scy.setValue(String.valueOf(values[1]));
                }
                if (values.length > 2 && values[2] != null) {
                    scy.setStdvalue(String.valueOf(values[2]));
                }
                if (values.length > 3 && values[3] != null) {
                    scy.setRem(String.valueOf(values[3]));
                }
                v_scy.add(scy);
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.insertScy(vector) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                for (ScyEcad scy : v_scy) {
                    session.save(scy);
                }
                if (this.b_close) {
                    tx.commit();
                }
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block16;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return insertedEntities;
    }

    @Override
    public int deleteScy() {
        int deletedEntities;
        block9: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("enercad.HibernateScyDao.deleteScy usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete ScyEcad scy";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                if (this.b_close) {
                    tx.commit();
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }

    @Override
    public boolean isLocked() {
        boolean b_res = false;
        Transaction tx = null;
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
        }
        catch (UnknownServiceException usex) {
            Globals.println("enercad.HibernateScyDao.isLocked usex: " + usex);
            this.sessionFactory.close();
            session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
        }
        try {
            tx = session.beginTransaction();
        }
        catch (RuntimeException rex) {
            if (tx != null && tx.isActive()) {
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    b_res = true;
                }
            }
            b_res = true;
        }
        return b_res;
    }

    public void setCloseBit(boolean b_close) {
        this.b_close = b_close;
    }
}

