/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.pro.dao;

import core.hibernate.pro.EnvelopeDao;
import core.hibernate.pro.db.Envelope;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.service.UnknownServiceException;

public class HibernateEnvelopeDao
implements EnvelopeDao {
    SessionFactory sessionFactory;
    final String dbName = Globals.PROJECT_NAME;
    boolean b_close = true;

    public HibernateEnvelopeDao() {
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    public HibernateEnvelopeDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(Envelope.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public List<Envelope> getEnvelopeList() {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.getEnvelopeList usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from Envelope as envelope order by id_f").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<Envelope> getEnvelopeList(int id_b, int id_z) {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.getEnvelopeList(id_b, id_z) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Envelope as envelope where id_b=? and id_z=? order by id_f");
                query.setShort(0, (short)id_b);
                query.setShort(1, (short)id_z);
                list = query.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<Object[]> getEnvelopeList(String sql) {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.getEnvelopeList usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                list = session.createSQLQuery(sql).list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public Envelope getEnvelope(int id_e) {
        Envelope envelope;
        block8: {
            envelope = null;
            Transaction tx = null;
            SharedSessionContract session = null;
            try {
                this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.getEnvelope(" + id_e + ") usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    Ecad2007.closeSession(this.dbName);
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Envelope as envelope where id_e=?");
                query.setInteger(0, id_e);
                envelope = (Envelope)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return envelope;
    }

    @Override
    public int updateEnvelope(Envelope envelope) {
        int updatedEntities;
        block8: {
            updatedEntities = 1;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.updateEnvelope(envelope) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Envelope as envelope where id_e=?");
                query.setInteger(0, (int)envelope.getId_e());
                Envelope ev = (Envelope)query.uniqueResult();
                session.clear();
                envelope.setId(ev.getId());
                session.saveOrUpdate(envelope);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int updateEnvelopeByIdCManual(String id_c, String replacement) {
        int updatedEntities;
        block8: {
            updatedEntities = 1;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.updateEnvelope(envelope) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("update Envelope set id_c=? where id_c=?");
                query.setString(0, replacement);
                query.setString(1, id_c);
                updatedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("HiebernateEnvelopeDao.updateEnvelopeByIdCManual error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int updateEnvelope(int id_b, int id_z, Map<String, Object> map, Map<String, Object> cvmap) {
        int updatedEntities;
        block18: {
            updatedEntities = 1;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.updateEnvelope(envelope) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                int ii;
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Object[] ckeys = map.keySet().toArray();
                int cdim = 0;
                cdim = ckeys.length;
                String sql = "UPDATE ENVELOPE SET ";
                for (int ii2 = 0; ii2 < cdim; ++ii2) {
                    if (ckeys[ii2].toString().equals("ID_B") || ckeys[ii2].toString().equals("ID_E") || ckeys[ii2].toString().equals("ID_Z")) continue;
                    sql = sql + ckeys[ii2].toString() + "=?,";
                }
                sql = sql.substring(0, sql.length() - 1);
                sql = sql + " WHERE ID_B=? AND ID_Z=?";
                Object[] wkeys = cvmap.keySet().toArray();
                Object[] values = cvmap.values().toArray();
                int wdim = cvmap.size();
                for (int ii3 = 0; ii3 < wdim; ++ii3) {
                    sql = sql + " AND " + (String)wkeys[ii3] + "=?";
                }
                SQLQuery sqlquery = session.createSQLQuery(sql);
                int fcorr = 1;
                for (ii = 0; ii < cdim; ++ii) {
                    Object value = map.get(ckeys[ii]);
                    if (value == null || ckeys[ii].toString().equals("ID_B") || ckeys[ii].toString().equals("ID_E") || ckeys[ii].toString().equals("ID_Z")) continue;
                    if (value instanceof Integer) {
                        sqlquery.setInteger(ii - fcorr + 1, Globals.getIntValue(value));
                        continue;
                    }
                    if (value instanceof String) {
                        sqlquery.setString(ii - fcorr + 1, (String)value);
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    sqlquery.setDouble(ii - fcorr + 1, Globals.getDoubleValue(value));
                }
                sqlquery.setShort(Globals.getShortValue(cdim - fcorr + 1), Globals.getShortValue(id_b));
                sqlquery.setShort(Globals.getShortValue(cdim - fcorr + 2), Globals.getShortValue(id_z));
                if (cdim > 0) {
                    for (ii = 0; ii < wdim; ++ii) {
                        Object object = values[ii];
                        if (object instanceof Short) {
                            sqlquery.setShort(cdim - fcorr + ii + 3, (short)((Short)values[ii]));
                            continue;
                        }
                        if (object instanceof Integer) {
                            sqlquery.setInteger(cdim - fcorr + ii + 3, Globals.getIntValue(values[ii]));
                            continue;
                        }
                        if (object instanceof Double) {
                            sqlquery.setDouble(cdim - fcorr + ii + 3, Globals.getDoubleValue(values[ii]));
                            continue;
                        }
                        if (!(object instanceof String)) continue;
                        sqlquery.setString(cdim - fcorr + ii + 3, (String)values[ii]);
                    }
                }
                sqlquery.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block18;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertEnvelope(Envelope envelope) {
        int insertedEntities;
        block9: {
            insertedEntities = 1;
            if (envelope == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                this.sessionFactory.close();
                this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    Ecad2007.closeSession(this.dbName);
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                session.save(envelope);
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public boolean insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        int i_res;
        boolean b_res;
        block33: {
            b_res = false;
            i_res = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.insertIntoTable(table, columns, rows) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            int size = rows.size();
            if (size == 0) {
                return false;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < row.length; ++jj) {
                        int nn;
                        int offset;
                        if (row[jj] instanceof Short) {
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Integer) {
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigInteger) {
                            sqlQuery.setBigInteger(jj, (BigInteger)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Long) {
                            sqlQuery.setLong(jj, (long)((Long)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Double) {
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigDecimal) {
                            sqlQuery.setBigDecimal(jj, (BigDecimal)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Float) {
                            sqlQuery.setFloat(jj, ((Float)row[jj]).floatValue());
                            continue;
                        }
                        if (row[jj] instanceof String) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (row[jj] instanceof Date) {
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof byte[]) {
                            sqlQuery.setBinary(jj, ((String)row[jj]).getBytes());
                            continue;
                        }
                        if (row[jj] instanceof Blob) {
                            Blob blob = (Blob)row[jj];
                            try {
                                InputStream is = blob.getBinaryStream();
                                int length = (int)blob.length();
                                byte[] bb = new byte[length];
                                offset = 0;
                                nn = 0;
                                while ((nn = is.read(bb, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setBinary(jj, bb);
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] instanceof Clob) {
                            Clob clob = (Clob)row[jj];
                            try {
                                int length = (int)clob.length();
                                char[] array = new char[length];
                                Reader reader = clob.getCharacterStream();
                                offset = 0;
                                nn = 0;
                                while ((nn = reader.read(array, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setText(jj, String.valueOf(array));
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] != null) continue;
                        sqlQuery.setString(jj, "");
                    }
                    i_res += sqlQuery.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block33;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (i_res > 0) {
            b_res = true;
        }
        return b_res;
    }

    @Override
    public int deleteEnvelope() {
        int deletedEntities;
        block8: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.deleteEnvelope usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete Envelope envelope";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }

    @Override
    public int deleteEnvelope(short id_b, short id_z, int id_e) {
        int deletedEntities;
        block8: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.deleteEnvelope(id_f) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete Envelope envelope where id_b=? and id_z=? and id_e=?";
                Query query = session.createQuery(hqlUpdate);
                query.setShort(0, id_b);
                query.setShort(1, id_z);
                query.setInteger(2, id_e);
                deletedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }

    @Override
    public int deleteEnvelope(short id_b, short id_z, Map<String, Object> map) {
        int deletedEntities;
        block13: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.deleteEnvelope(id_b, id_z, map) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String sql = "DELETE FROM ENVELOPE WHERE ID_B=? AND ID_Z=?";
                Object[] keys = map.keySet().toArray();
                Object[] values = map.values().toArray();
                int dim = map.size();
                for (int ii = 0; ii < dim; ++ii) {
                    sql = sql + " AND " + (String)keys[ii] + "=?";
                }
                SQLQuery sqlquery = session.createSQLQuery(sql);
                sqlquery.setShort(0, id_b);
                sqlquery.setShort(1, id_z);
                deletedEntities = sqlquery.executeUpdate();
                for (int ii = 0; ii < dim; ++ii) {
                    Object object = values[ii];
                    if (object instanceof Short) {
                        sqlquery.setShort(3 + ii, (short)((Short)values[ii]));
                        continue;
                    }
                    if (object instanceof Integer) {
                        sqlquery.setInteger(3 + ii, Globals.getIntValue(values[ii]));
                        continue;
                    }
                    if (object instanceof Double) {
                        sqlquery.setDouble(3 + ii, Globals.getDoubleValue(values[ii]));
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    sqlquery.setString(3 + ii, (String)values[ii]);
                }
                deletedEntities = sqlquery.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block13;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }

    @Override
    public int deleteLostFacades(int id_f) {
        int deletedEntities;
        block8: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateEnvelopeDao.deleteLostFacade usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String sql = "delete from ENVELOPE where id_f=?";
                SQLQuery sqlquery = session.createSQLQuery(sql);
                sqlquery.setInteger(0, id_f);
                deletedEntities = sqlquery.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }
}

