/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.pro.dao;

import core.hibernate.pro.FacadeDao;
import core.hibernate.pro.db.Facade;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.service.UnknownServiceException;

public class HibernateFacadeDao
implements FacadeDao {
    SessionFactory sessionFactory;
    final String dbName = Globals.PROJECT_NAME;
    boolean b_close = true;

    public HibernateFacadeDao() {
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    public HibernateFacadeDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(Facade.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public List<Facade> getFacadeList() {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.getFacadeList usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from Facade as facade order by id_f").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<Facade> getFacadeList(int id_b, int id_z) {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.getFacadeList(id_b, id_z) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Facade as facade where id_b=? and id_z=? order by id_f");
                query.setShort(0, (short)id_b);
                query.setShort(1, (short)id_z);
                list = query.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public Facade getFacade(int id_f) {
        Facade facade;
        block8: {
            facade = null;
            Transaction tx = null;
            SharedSessionContract session = null;
            try {
                this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Ecad2007.closeSession(this.dbName);
                this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                session = this.sessionFactory.getCurrentSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    Ecad2007.closeSession(this.dbName);
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Facade as facade where id_f=?");
                query.setShort(0, (short)id_f);
                facade = (Facade)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return facade;
    }

    @Override
    public int updateFacade(Facade facade) {
        int updatedEntities;
        block9: {
            updatedEntities = 1;
            if (facade == null) {
                return updatedEntities;
            }
            Facade front = this.getFacade(facade.getId_f());
            Integer id = front.getId();
            String rem_f = front.getRem_f();
            facade.setId(id);
            facade.setRem_f(rem_f);
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.updateFacade(facade) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                session.saveOrUpdate(facade);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertFacade(Facade facade) {
        int insertedEntities;
        block9: {
            insertedEntities = 1;
            if (facade == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                this.sessionFactory.close();
                this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    Ecad2007.closeSession(this.dbName);
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                session.save(facade);
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public boolean insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        int i_res;
        boolean b_res;
        block33: {
            b_res = false;
            i_res = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.insertIntoTable(table, columns, rows) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            int size = rows.size();
            if (size == 0) {
                return false;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < row.length; ++jj) {
                        int nn;
                        int offset;
                        if (row[jj] instanceof Short) {
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Integer) {
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigInteger) {
                            sqlQuery.setBigInteger(jj, (BigInteger)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Long) {
                            sqlQuery.setLong(jj, (long)((Long)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Double) {
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigDecimal) {
                            sqlQuery.setBigDecimal(jj, (BigDecimal)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Float) {
                            sqlQuery.setFloat(jj, ((Float)row[jj]).floatValue());
                            continue;
                        }
                        if (row[jj] instanceof String) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (row[jj] instanceof Date) {
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof byte[]) {
                            sqlQuery.setBinary(jj, ((String)row[jj]).getBytes());
                            continue;
                        }
                        if (row[jj] instanceof Blob) {
                            Blob blob = (Blob)row[jj];
                            try {
                                InputStream is = blob.getBinaryStream();
                                int length = (int)blob.length();
                                byte[] bb = new byte[length];
                                offset = 0;
                                nn = 0;
                                while ((nn = is.read(bb, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setBinary(jj, bb);
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] instanceof Clob) {
                            Clob clob = (Clob)row[jj];
                            try {
                                int length = (int)clob.length();
                                char[] array = new char[length];
                                Reader reader = clob.getCharacterStream();
                                offset = 0;
                                nn = 0;
                                while ((nn = reader.read(array, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setText(jj, String.valueOf(array));
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] != null) continue;
                        sqlQuery.setString(jj, "");
                    }
                    i_res += sqlQuery.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block33;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (i_res > 0) {
            b_res = true;
        }
        return b_res;
    }

    @Override
    public int deleteFacade() {
        int deletedEntities;
        block8: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.deleteFacade usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete Facade facade";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }

    @Override
    public int deleteFacade(int id_f) {
        int deletedEntities;
        block8: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateFacadeDao.deleteFacade(id_f) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete Facade facade where id_f=?";
                Query query = session.createQuery(hqlUpdate);
                query.setShort(0, (short)id_f);
                deletedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }
}

