/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.pro.dao;

import core.hibernate.DbMetadata;
import core.hibernate.pro.ProjetDao;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.service.UnknownServiceException;

public class HibernateProjetDao
implements ProjetDao {
    SessionFactory sessionFactory;
    final String dbName = Globals.PROJECT_NAME;
    boolean b_close = true;

    public HibernateProjetDao() {
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    public HibernateProjetDao(boolean b_close) {
        this.b_close = b_close;
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    @Override
    public boolean insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        return this.insertIntoTable(null, table, columns, rows);
    }

    public boolean insertIntoTable(String schema, String table, String[] columns, Vector<Object[]> rows) {
        int i_res;
        boolean b_res;
        block38: {
            b_res = false;
            i_res = 0;
            DbMetadata dbMetadata = new DbMetadata(this.dbName, false);
            Map<String, Integer> map = dbMetadata.listColumnInfo(table);
            Session session = Ecad2007.getCurrentSession(this.dbName);
            Transaction tx = null;
            int size = rows.size();
            if (size == 0) {
                return false;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                if (schema != null) {
                    table = String.format("%s.%s", schema, table);
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < dim; ++jj) {
                        int sql_type = map.get(columns[jj]);
                        if (sql_type == 5) {
                            if (row[jj] == null) {
                                sqlQuery.setShort(jj, (short)0);
                                continue;
                            }
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (sql_type == 4) {
                            if (row[jj] == null) {
                                sqlQuery.setInteger(jj, 0);
                                continue;
                            }
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (sql_type == -5) {
                            if (row[jj] == null) {
                                sqlQuery.setLong(jj, 0L);
                                continue;
                            }
                            sqlQuery.setLong(jj, Globals.getLongValue(row[jj]));
                            continue;
                        }
                        if (sql_type == 8) {
                            if (row[jj] == null) {
                                sqlQuery.setDouble(jj, 0.0);
                                continue;
                            }
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (sql_type == 3) {
                            if (row[jj] == null) {
                                sqlQuery.setDouble(jj, 0.0);
                                continue;
                            }
                            sqlQuery.setDouble(jj, (double)((Double)row[jj]));
                            continue;
                        }
                        if (sql_type == 6) {
                            if (row[jj] == null) {
                                sqlQuery.setFloat(jj, 0.0f);
                                continue;
                            }
                            sqlQuery.setFloat(jj, Globals.getFloatValue(row[jj]));
                            continue;
                        }
                        if (sql_type == 7) {
                            if (row[jj] == null) {
                                sqlQuery.setFloat(jj, 0.0f);
                                continue;
                            }
                            sqlQuery.setFloat(jj, Globals.getFloatValue(row[jj]));
                            continue;
                        }
                        if (sql_type == 1 || sql_type == 12) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (sql_type == 91) {
                            if (row[jj] == null) {
                                sqlQuery.setDate(jj, Ecad2007.getToday().getTime());
                                continue;
                            }
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (sql_type == -2) {
                            if (row[jj] == null) {
                                sqlQuery.setBinary(jj, null);
                                continue;
                            }
                            sqlQuery.setBinary(jj, (byte[])row[jj]);
                            continue;
                        }
                        if (sql_type == 2004) {
                            if (row[jj] == null) {
                                sqlQuery.setBinary(jj, null);
                                continue;
                            }
                            if (row[jj] instanceof byte[]) {
                                sqlQuery.setBinary(jj, (byte[])row[jj]);
                                continue;
                            }
                            byte[] bb = new byte[]{};
                            sqlQuery.setBinary(jj, bb);
                            continue;
                        }
                        if (sql_type != 2005) continue;
                        Clob clob = (Clob)row[jj];
                        try {
                            int length = (int)clob.length();
                            char[] array = new char[length];
                            Reader reader = clob.getCharacterStream();
                            int offset = 0;
                            int nn = 0;
                            while ((nn = reader.read(array, offset, length - offset)) != -1) {
                            }
                            sqlQuery.setText(jj, String.valueOf(array));
                            continue;
                        }
                        catch (SQLException sqlex) {
                            Ecad2007.trace(sqlex);
                            continue;
                        }
                        catch (IOException ioex) {
                            Ecad2007.trace(ioex);
                        }
                    }
                    i_res += sqlQuery.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block38;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (i_res > 0) {
            b_res = true;
        }
        return b_res;
    }

    @Override
    public boolean deleteTable(String table) {
        int i_res;
        boolean b_res;
        block9: {
            b_res = false;
            i_res = 0;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.openSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateProjetDao.deleteTable(table) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "DELETE FROM " + table;
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                i_res = sqlQuery.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (i_res > 0) {
            b_res = true;
        }
        return b_res;
    }

    public void setCloseBit(boolean b_close) {
        this.b_close = b_close;
    }
}

