/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.pro.dao;

import core.hibernate.pro.ZoneDao;
import core.hibernate.pro.db.Zone;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.service.UnknownServiceException;

public class HibernateZoneDao
implements ZoneDao {
    SessionFactory sessionFactory;
    final String dbName = Globals.PROJECT_NAME;
    boolean b_close = true;

    public HibernateZoneDao() {
        this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
    }

    public HibernateZoneDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        if (this.sessionFactory.isClosed()) {
            Ecad2007.closeSession(this.dbName);
            this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
        }
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(Zone.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public List<Zone> getZoneList() {
        List list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.openSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateZoneDao.getZoneList usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from Zone as zone order by id_b, id_z").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<Zone> getZoneList(int id_b) {
        List list;
        block6: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.openSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Zone as zone where id_b=? order by id_b, id_z");
                query.setShort(0, (short)id_b);
                list = query.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public Zone getZone(int id_b, int id_z) {
        Zone zone;
        block9: {
            zone = null;
            Transaction tx = null;
            Session session = null;
            try {
                if (this.sessionFactory == null) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                }
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateMaterialsDao.getZone(id_b, id_z) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from Zone as zone where id_b=? and id_z=?");
                query.setShort(0, (short)id_b);
                query.setShort(1, (short)id_z);
                zone = (Zone)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return zone;
    }

    @Override
    public boolean updateZone(int id_b, int id_z, String column, Object value) {
        boolean res;
        block18: {
            res = false;
            Session session = null;
            Transaction tx = null;
            try {
                if (this.sessionFactory == null) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                }
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateMaterialsDao.updateZone(id_b, id_z, column, value) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("update Zone as zone set " + column + "=? where id_b=? and id_z=?");
                if (value instanceof Short) {
                    query.setShort(0, (short)((Short)value));
                } else if (value instanceof Integer) {
                    query.setInteger(0, (int)((Integer)value));
                } else if (value instanceof Float) {
                    query.setFloat(0, ((Float)value).floatValue());
                } else if (value instanceof Double) {
                    query.setDouble(0, (double)((Double)value));
                } else if (value instanceof String) {
                    query.setString(0, (String)value);
                }
                query.setShort(1, (short)id_b);
                query.setShort(2, (short)id_z);
                res = query.executeUpdate() > 0;
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block18;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return res;
    }

    @Override
    public int updateZone(Zone zone) {
        int updatedEntities;
        block10: {
            updatedEntities = 1;
            if (zone == null) {
                return updatedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                if (this.sessionFactory == null) {
                    this.sessionFactory = Ecad2007.getSession(this.dbName).getSessionFactory();
                }
                session = this.sessionFactory.getCurrentSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateMaterialsDao.updateZone(zone) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                session.saveOrUpdate(zone);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block10;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertZone(Zone zone) {
        int insertedEntities;
        block9: {
            insertedEntities = 1;
            if (zone == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.openSession();
            }
            catch (UnknownServiceException usex) {
                Globals.println("HibernateZoneDao.insertZone(zone) usex: " + usex);
                this.sessionFactory.close();
                session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                session.save(zone);
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public int deleteZones() {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = Ecad2007.getCurrentSession(this.dbName);
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(this.dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete Zone zone";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return deletedEntities;
    }
}

