/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.pro.db;

import core.MatDbOrg;
import enercad2007.Ecad2007;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;

public class MatDb {
    Integer id;
    MatDbOrg matDbOrg;
    byte[] mat;
    String rem;
    String provref;
    String ref;

    public void init() {
        if (this.matDbOrg == null) {
            this.getMatDbOrg();
        }
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public String getNom() {
        String nom = "";
        int lan = Ecad2007.getCodeLan();
        if (this.matDbOrg == null) {
            return "";
        }
        if (lan == 0) {
            nom = this.matDbOrg.getNom_al();
        } else if (lan == 1) {
            nom = this.matDbOrg.getNom_fr();
        } else if (lan == 2) {
            nom = this.matDbOrg.getNom_it();
        } else if (lan == 3) {
            nom = this.matDbOrg.getNom_en();
        }
        return nom;
    }

    public String getNom_fr() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getNom_fr();
    }

    public String getNom_al() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getNom_al();
    }

    public String getNom_it() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getNom_it();
    }

    public String getNom_en() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getNom_en();
    }

    public double getGg() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getGG();
    }

    public double getAlpha() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getAlpha();
    }

    public double getLambda() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getLambda();
    }

    public double getCc() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getCC();
    }

    public double getRho() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getRho();
    }

    public double getVmin() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getVmin();
    }

    public double getVmax() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getVmax();
    }

    public double getH2o() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getH2o();
    }

    public double getPor() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getPor();
    }

    public double getEp() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getEp();
    }

    public double getNre() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getNre();
    }

    public double getCo2() {
        if (this.matDbOrg == null) {
            return 0.0;
        }
        return this.matDbOrg.getCo2();
    }

    public long getUbp() {
        if (this.matDbOrg == null) {
            return 0L;
        }
        return this.matDbOrg.getUbp();
    }

    public String getSrc() {
        if (this.matDbOrg == null) {
            return "";
        }
        if (this.matDbOrg.getSrc() == null) {
            return this.matDbOrg.getSrcPI();
        }
        return this.matDbOrg.getSrc();
    }

    public String getSrceco() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getSrceco();
    }

    public String getPattern() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getPattern();
    }

    public Date getDtstart() {
        if (this.matDbOrg == null) {
            return null;
        }
        return this.matDbOrg.getDtstart();
    }

    public Date getDtstop() {
        if (this.matDbOrg == null) {
            return null;
        }
        return this.matDbOrg.getDtstop();
    }

    public Date getUpdt() {
        if (this.matDbOrg == null) {
            return null;
        }
        return this.matDbOrg.getUpdt();
    }

    public String getRes() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getRes();
    }

    public long getFlags() {
        if (this.matDbOrg == null) {
            return 0L;
        }
        return this.matDbOrg.getFlags();
    }

    public String getPos() {
        if (this.matDbOrg == null) {
            return "";
        }
        return this.matDbOrg.getPos();
    }

    public void setMatDbOrg(MatDbOrg matDbOrg) {
        this.matDbOrg = matDbOrg;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(matDbOrg);
            oos.close();
            baos.close();
            this.mat = baos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MatDbOrg getMatDbOrg() {
        if (this.mat == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.mat);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            MatDbOrg matDbOrg = (MatDbOrg)ois.readObject();
            ois.close();
            this.matDbOrg = matDbOrg;
            return matDbOrg;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.matDbOrg;
    }

    public void setMat(Blob mat) {
        if (mat == null) {
            return;
        }
        try {
            this.mat = mat.getBytes(1L, (int)mat.length());
        }
        catch (SQLException sqlex) {
            System.out.println("core.hibernate.usercat.db.MatDb.setMat: " + sqlex.getMessage());
        }
    }

    public Blob getMat() {
        SerialBlob blob = null;
        if (this.mat == null) {
            return null;
        }
        try {
            blob = new SerialBlob(this.mat);
        }
        catch (SerialException serialException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return blob;
    }

    public void setRem(String rem) {
        this.rem = rem;
    }

    public String getRem() {
        if (this.rem == null) {
            return "";
        }
        return this.rem.trim();
    }

    public void setProvref(String provref) {
        this.provref = provref;
    }

    public String getProvref() {
        if (this.provref == null) {
            return "";
        }
        return this.provref.trim();
    }

    public void setRef(String ref) {
        if (ref != null) {
            ref = ref.trim();
        }
        this.ref = ref;
    }

    public String getRef() {
        if (this.ref == null) {
            return "";
        }
        return this.ref.trim();
    }
}

