/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.tmp.dao;

import core.hibernate.DbMetadata;
import core.hibernate.tmp.TmpDao;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTmpDao
implements TmpDao {
    static final Logger logger = LoggerFactory.getLogger(Ecad2007.class);
    SessionFactory sessionFactory;
    final String dbName = "tmp";
    boolean b_close = true;
    DbMetadata dbMetadata;

    public HibernateTmpDao() {
        this.sessionFactory = Ecad2007.getSession("tmp").getSessionFactory();
    }

    public HibernateTmpDao(boolean b_close) {
        this.b_close = b_close;
        this.sessionFactory = Ecad2007.getSession("tmp").getSessionFactory();
    }

    public Vector<Object[]> listFromTable(String table, String[] columns, Object[] defValues) {
        return this.listFromTable(null, table, columns, defValues);
    }

    public Vector<Object[]> listFromTable(String schema, String table, String[] columns, Object[] defValues) {
        Vector<Object[]> vector;
        block16: {
            vector = new Vector<Object[]>(100);
            ArrayList<String> al = new ArrayList<String>(20);
            if (this.dbMetadata == null) {
                this.dbMetadata = new DbMetadata("tmp", false);
            }
            Map<String, Integer> map = this.dbMetadata.listColumnInfo(table);
            String[] keys = new String[map.size()];
            keys = map.keySet().toArray(keys);
            Session session = Ecad2007.getCurrentSession("tmp");
            Transaction tx = null;
            int dim = columns.length;
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession("tmp").getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "SELECT ";
                for (int ii = 0; ii < dim - 1; ++ii) {
                    if (columns[ii].equals("")) continue;
                    sql = sql + columns[ii] + ", ";
                    al.add(columns[ii]);
                }
                if (schema != null) {
                    table = String.format("%s.%s", schema, table);
                }
                sql = sql + columns[dim - 1] + " FROM " + table;
                if (!columns[dim - 1].equals("")) {
                    al.add(columns[dim - 1]);
                }
                if (sql.endsWith(",  FROM " + table)) {
                    sql = sql.replace(",  FROM " + table, " FROM " + table);
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < al.size(); ++ii) {
                    String column = (String)al.get(ii);
                    Integer value = map.get(column);
                    if (value == null) continue;
                    Type h_type = this.dbMetadata.sqlType2HibernateType(value);
                    sqlQuery.addScalar(column, h_type);
                }
                List list = sqlQuery.list();
                Iterator iterator = list.iterator();
                Object[] row = null;
                while (iterator.hasNext()) {
                    int ii;
                    int corCol = 0;
                    Object object = iterator.next();
                    if (!(object instanceof Object[])) continue;
                    row = (Object[])object;
                    Object[] row_pro = new Object[dim];
                    for (ii = 0; ii < dim; ++ii) {
                        if (al.contains(columns[ii])) {
                            row_pro[ii] = row[ii - corCol];
                            continue;
                        }
                        row_pro[ii] = defValues[ii];
                        ++corCol;
                    }
                    for (ii = 0; ii < row_pro.length; ++ii) {
                        Object ob = row_pro[ii];
                        if (!(ob instanceof Blob)) continue;
                        row_pro[ii] = this.blob2bytes((Blob)row[ii]);
                    }
                    vector.add(row_pro);
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, "Table: " + table + " " + rex.getMessage());
                if (tx == null || !tx.isActive()) break block16;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Ecad2007.trace(hex);
                }
                Ecad2007.trace(rex);
            }
        }
        return vector;
    }

    @Override
    public boolean insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        boolean b_res;
        block29: {
            b_res = false;
            Session session = Ecad2007.getCurrentSession("tmp");
            Transaction tx = null;
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession("tmp").getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int size = rows.size();
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < row.length; ++jj) {
                        int nn;
                        int offset;
                        if (row[jj] instanceof Short) {
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Integer) {
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigInteger) {
                            sqlQuery.setBigInteger(jj, (BigInteger)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Long) {
                            sqlQuery.setLong(jj, (long)((Long)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Double) {
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigDecimal) {
                            sqlQuery.setBigDecimal(jj, (BigDecimal)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Float) {
                            sqlQuery.setFloat(jj, ((Float)row[jj]).floatValue());
                            continue;
                        }
                        if (row[jj] instanceof String) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (row[jj] instanceof Date) {
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof byte[]) {
                            sqlQuery.setBinary(jj, ((String)row[jj]).getBytes());
                            continue;
                        }
                        if (row[jj] instanceof Blob) {
                            Blob blob = (Blob)row[jj];
                            try {
                                InputStream is = blob.getBinaryStream();
                                int length = (int)blob.length();
                                byte[] bb = new byte[length];
                                offset = 0;
                                nn = 0;
                                while ((nn = is.read(bb, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setBinary(jj, bb);
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] instanceof Clob) {
                            Clob clob = (Clob)row[jj];
                            try {
                                int length = (int)clob.length();
                                char[] array = new char[length];
                                Reader reader = clob.getCharacterStream();
                                offset = 0;
                                nn = 0;
                                while ((nn = reader.read(array, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setText(jj, String.valueOf(array));
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] != null) continue;
                        sqlQuery.setString(jj, "");
                    }
                    if (ii != size - 1 || b_res) continue;
                    b_res = true;
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block29;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return b_res;
    }

    private char[] clob2chars(Clob clob) {
        char[] array = null;
        try {
            int length = (int)clob.length();
            array = new char[length];
            Reader reader = clob.getCharacterStream();
            int offset = 0;
            int nn = 0;
            while ((nn = reader.read(array, offset, length - offset)) != -1) {
            }
        }
        catch (SQLException sqlex) {
            Ecad2007.trace(sqlex);
        }
        catch (IOException ioex) {
            Ecad2007.trace(ioex);
        }
        return array;
    }

    private byte[] blob2bytes(Blob blob) {
        byte[] bb = null;
        try {
            InputStream is = blob.getBinaryStream();
            int length = (int)blob.length();
            bb = new byte[length];
            int offset = 0;
            int nn = 0;
            while ((nn = is.read(bb, offset, length - offset)) != -1) {
            }
        }
        catch (SQLException sqlex) {
            Ecad2007.trace(sqlex);
        }
        catch (IOException ioex) {
            Ecad2007.trace(ioex);
        }
        return bb;
    }
}

