/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.usrcat.dao;

import core.hibernate.usrcat.M4_FabDao;
import core.hibernate.usrcat.db.M4_Fab;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.StringType;

public class HibernateM4_FabDao
implements M4_FabDao {
    SessionFactory sessionFactory;
    static final String dbName = "usrcat";
    boolean b_close = true;

    public HibernateM4_FabDao() {
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
    }

    public HibernateM4_FabDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_Fab.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public List<M4_Fab> getM4_FabList() {
        ArrayList list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from M4_Fab as m4_fab order by ref").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        if (list != null) {
            Iterator it = list.iterator();
            HashMap<String, M4_Fab> map = new HashMap<String, M4_Fab>(list.size());
            while (it.hasNext()) {
                M4_Fab m4_fab = (M4_Fab)it.next();
                map.put(m4_fab.getRef(), m4_fab);
            }
            list = new ArrayList(map.values());
        }
        return list;
    }

    public List<Object[]> getM4_FabList(String[] columnNames, String sql) {
        ArrayList list;
        block9: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < columnNames.length; ++ii) {
                    sqlQuery.addScalar(columnNames[ii], StringType.INSTANCE);
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block9;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        if (list != null) {
            Iterator it = list.iterator();
            HashMap<String, Object[]> map = new HashMap<String, Object[]>(list.size());
            while (it.hasNext()) {
                Object[] values = (Object[])it.next();
                map.put((String)values[values.length - 1], values);
            }
            list = new ArrayList(map.values());
        }
        return list;
    }

    @Override
    public M4_Fab getM4_Fab(String ref) {
        M4_Fab m4_fab;
        block6: {
            m4_fab = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from M4_Fab as m4_fab where ref=?");
                query.setString(0, ref);
                m4_fab = (M4_Fab)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return m4_fab;
    }

    @Override
    public int updateM4_Fab(M4_Fab m4_fab) {
        int updatedEntities;
        block7: {
            updatedEntities = 0;
            if (m4_fab == null) {
                return updatedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                session.saveOrUpdate(m4_fab);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertM4_Fab(M4_Fab m4_fab) {
        int insertedEntities;
        block7: {
            insertedEntities = 0;
            if (m4_fab == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                session.save(m4_fab);
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public boolean insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        int i_res;
        boolean b_res;
        block31: {
            b_res = false;
            i_res = 0;
            Session session = this.sessionFactory.getCurrentSession();
            Transaction tx = null;
            int size = rows.size();
            if (size == 0) {
                return false;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < row.length; ++jj) {
                        int nn;
                        int offset;
                        if (row[jj] instanceof Short) {
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Integer) {
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigInteger) {
                            sqlQuery.setBigInteger(jj, (BigInteger)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Long) {
                            sqlQuery.setLong(jj, (long)((Long)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof Double) {
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof BigDecimal) {
                            sqlQuery.setBigDecimal(jj, (BigDecimal)row[jj]);
                            continue;
                        }
                        if (row[jj] instanceof Float) {
                            sqlQuery.setFloat(jj, ((Float)row[jj]).floatValue());
                            continue;
                        }
                        if (row[jj] instanceof String) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (row[jj] instanceof Date) {
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (row[jj] instanceof byte[]) {
                            sqlQuery.setBinary(jj, ((String)row[jj]).getBytes());
                            continue;
                        }
                        if (row[jj] instanceof Blob) {
                            Blob blob = (Blob)row[jj];
                            try {
                                InputStream is = blob.getBinaryStream();
                                int length = (int)blob.length();
                                byte[] bb = new byte[length];
                                offset = 0;
                                nn = 0;
                                while ((nn = is.read(bb, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setBinary(jj, bb);
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] instanceof Clob) {
                            Clob clob = (Clob)row[jj];
                            try {
                                int length = (int)clob.length();
                                char[] array = new char[length];
                                Reader reader = clob.getCharacterStream();
                                offset = 0;
                                nn = 0;
                                while ((nn = reader.read(array, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setText(jj, String.valueOf(array));
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (row[jj] != null) continue;
                        sqlQuery.setString(jj, "");
                    }
                    i_res += sqlQuery.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block31;
                b_res = false;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        if (i_res > 0) {
            b_res = true;
        }
        return b_res;
    }

    @Override
    public boolean isInMaterialTable(M4_Fab m4_fab) {
        boolean res;
        block7: {
            res = false;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Criteria criteria = session.createCriteria(M4_Fab.class);
                this.addEqCriteria(criteria, "nom_al", m4_fab.getNom_al());
                this.addEqCriteria(criteria, "nom_fr", m4_fab.getNom_fr());
                this.addEqCriteria(criteria, "nom_it", m4_fab.getNom_it());
                this.addEqCriteria(criteria, "nom_en", m4_fab.getNom_en());
                criteria.add(Restrictions.eq("gg", m4_fab.getGg()));
                criteria.add(Restrictions.eq("alpha", m4_fab.getAlpha()));
                criteria.add(Restrictions.eq("lamda", m4_fab.getLamda()));
                criteria.add(Restrictions.eq("cc", m4_fab.getCc()));
                criteria.add(Restrictions.eq("rho", m4_fab.getRho()));
                criteria.add(Restrictions.eq("vmin", m4_fab.getVmin()));
                criteria.add(Restrictions.eq("vmax", m4_fab.getVmax()));
                criteria.add(Restrictions.eq("h2o", m4_fab.getH2o()));
                criteria.add(Restrictions.eq("por", m4_fab.getPor()));
                criteria.add(Restrictions.eq("ep", m4_fab.getEp()));
                criteria.add(Restrictions.eq("nre", m4_fab.getNre()));
                criteria.add(Restrictions.eq("co2", m4_fab.getCo2()));
                criteria.add(Restrictions.eq("ubp", m4_fab.getUbp()));
                this.addEqCriteria(criteria, "src", m4_fab.getSrc());
                this.addEqCriteria(criteria, "srceco", m4_fab.getSrceco());
                this.addEqCriteria(criteria, "pattern", m4_fab.getPattern());
                criteria.add(Restrictions.eq("flags", m4_fab.getFlags()));
                M4_Fab test = (M4_Fab)criteria.uniqueResult();
                tx.commit();
                if (test != null) {
                    res = true;
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return res;
    }

    public void addEqCriteria(Criteria criteria, String cName, String value) {
        if (value != null && !value.trim().equals("")) {
            criteria.add(Restrictions.eq(cName, value));
        }
    }

    public List<M4_Fab> executeQuery(String sql) {
        List list;
        block6: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                list = session.createSQLQuery(sql).addEntity("m4_fab", M4_Fab.class).list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    public List<String> executeQuery(String sql, String[] scalar) {
        List list;
        block7: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < scalar.length; ++ii) {
                    sqlQuery.addScalar(scalar[ii], StringType.INSTANCE);
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public int deleteM4_Fab() {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete M4_Fab m4_fab";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteM4_Fab(String ref) {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete M4_Fab m4_fab where m4_fab.ref=?";
                Query query = session.createQuery(hqlUpdate);
                query.setString(0, ref);
                deletedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteM4_Fab(ArrayList<String> rows) {
        int deletedEntities;
        block7: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                for (int ii = 0; ii < rows.size(); ++ii) {
                    String sql = "delete from M4_FAB where REF='" + rows.get(ii) + "'";
                    SQLQuery query = session.createSQLQuery(sql);
                    deletedEntities += query.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }
}

