/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.usrcat.dao;

import core.hibernate.usrcat.M4_UsrDao;
import core.hibernate.usrcat.db.M4_Usr;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.ClobType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class HibernateM4_UsrDao
implements M4_UsrDao {
    SessionFactory sessionFactory;
    boolean b_close = true;
    static final String dbName = "usrcat";

    public HibernateM4_UsrDao() {
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
    }

    public HibernateM4_UsrDao(String xml) {
        this.sessionFactory = Ecad2007.getSession(xml, dbName).getSessionFactory();
    }

    public HibernateM4_UsrDao(Session session) {
        this.sessionFactory = session == null ? Ecad2007.getSession(dbName).getSessionFactory() : session.getSessionFactory();
    }

    public HibernateM4_UsrDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_Usr.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    public Map<String, Type> getColumnTypesByColumnNames() {
        HashMap<String, Type> map = new HashMap<String, Type>();
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_Usr.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        map.put("NOM", StringType.INSTANCE);
        HashMap<String, String> m_alias = new HashMap<String, String>();
        String[] names = step.getPropertyNames();
        for (int ii = 0; ii < names.length; ++ii) {
            m_alias.put(names[ii], step.getPropertyColumnNames(ii)[0]);
        }
        for (AttributeDefinition ad : step.getAttributes()) {
            String key = ad.getName();
            key = (String)m_alias.get(key);
            Type type = ad.getType();
            if (key == null) continue;
            map.put(key, type);
        }
        return map;
    }

    public Map<String, Type> getColumnTypesByColumnAliases() {
        HashMap<String, Type> map = new HashMap<String, Type>();
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_Usr.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        map.put("nom", StringType.INSTANCE);
        for (AttributeDefinition ad : step.getAttributes()) {
            String key = ad.getName();
            Type type = ad.getType();
            map.put(key, type);
        }
        return map;
    }

    @Override
    public int getColumnCount() {
        int dim = 0;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_Usr.class.getName());
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            dim = names.length;
        }
        return dim;
    }

    @Override
    public boolean isInMaterialTable(M4_Usr m4_usr) {
        boolean res;
        block7: {
            res = false;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Criteria criteria = session.createCriteria(M4_Usr.class);
                this.addEqCriteria(criteria, "nom_al", m4_usr.getNom_al());
                this.addEqCriteria(criteria, "nom_fr", m4_usr.getNom_fr());
                this.addEqCriteria(criteria, "nom_it", m4_usr.getNom_it());
                this.addEqCriteria(criteria, "nom_en", m4_usr.getNom_en());
                criteria.add(Restrictions.eq("gg", m4_usr.getGg()));
                criteria.add(Restrictions.eq("alpha", m4_usr.getAlpha()));
                criteria.add(Restrictions.eq("lamda", m4_usr.getLamda()));
                criteria.add(Restrictions.eq("cc", m4_usr.getCc()));
                criteria.add(Restrictions.eq("rho", m4_usr.getRho()));
                criteria.add(Restrictions.eq("vmin", m4_usr.getVmin()));
                criteria.add(Restrictions.eq("vmax", m4_usr.getVmax()));
                criteria.add(Restrictions.eq("h2o", m4_usr.getH2o()));
                criteria.add(Restrictions.eq("por", m4_usr.getPor()));
                criteria.add(Restrictions.eq("ep", m4_usr.getEp()));
                criteria.add(Restrictions.eq("nre", m4_usr.getNre()));
                criteria.add(Restrictions.eq("co2", m4_usr.getCo2()));
                criteria.add(Restrictions.eq("ubp", m4_usr.getUbp()));
                this.addEqCriteria(criteria, "src", m4_usr.getSrc());
                this.addEqCriteria(criteria, "srceco", m4_usr.getSrceco());
                this.addEqCriteria(criteria, "pattern", m4_usr.getPattern());
                criteria.add(Restrictions.eq("flags", m4_usr.getFlags()));
                M4_Usr test = (M4_Usr)criteria.uniqueResult();
                tx.commit();
                if (test != null) {
                    res = true;
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return res;
    }

    public void addEqCriteria(Criteria criteria, String cName, String value) {
        if (value != null && !value.trim().equals("")) {
            criteria.add(Restrictions.eq(cName, value));
        }
    }

    @Override
    public List<M4_Usr> getM4_UsrList() {
        List list;
        block6: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                list = session.createQuery("from M4_Usr as m4_usr order by ref").list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<Object[]> getM4_UsrList(String[] columnNames, String sql) {
        List list;
        block7: {
            list = null;
            Transaction tx = null;
            Map<String, Type> map = this.getColumnTypesByColumnNames();
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < columnNames.length; ++ii) {
                    sqlQuery.addScalar(columnNames[ii], map.get(columnNames[ii]));
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public M4_Usr getM4_Usr(String ref) {
        M4_Usr m4_usr;
        block6: {
            m4_usr = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from M4_Usr as m4_usr where ref=?");
                query.setString(0, ref);
                m4_usr = (M4_Usr)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return m4_usr;
    }

    @Override
    public int getLastRRef() {
        int res;
        block6: {
            res = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "select max(CAST(SUBSTR(REF,LOCATE(',',REF)+1) AS INTEGER)) AS max_rref from m4_usr";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                res = Globals.getIntValue(sqlQuery.uniqueResult(), 0);
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return res;
    }

    @Override
    public int updateM4_Usr(M4_Usr m4_usr) {
        int updatedEntities;
        block7: {
            updatedEntities = 0;
            if (m4_usr == null) {
                return updatedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                session.saveOrUpdate(m4_usr);
                updatedEntities = 1;
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertM4_Usr(M4_Usr m4_usr) {
        int insertedEntities;
        block7: {
            insertedEntities = 0;
            if (m4_usr == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                session.save(m4_usr);
                insertedEntities = 1;
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public int insertIntoTable(String table, String[] columns, Vector<Object[]> rows) {
        int i_res;
        block29: {
            i_res = 0;
            Session session = this.sessionFactory.getCurrentSession();
            Transaction tx = null;
            int size = rows.size();
            if (size == 0) {
                return 0;
            }
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String sql = "INSERT INTO " + table + " (";
                String qm = "";
                int dim = columns.length;
                Object[] row = null;
                for (int ii = 0; ii < dim - 1; ++ii) {
                    sql = sql + columns[ii] + ",";
                    qm = qm + ",?";
                }
                sql = sql + columns[dim - 1] + ") VALUES(?" + qm + ")";
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                Map<String, Type> map = this.getColumnTypesByColumnNames();
                for (int ii = 0; ii < size; ++ii) {
                    row = rows.get(ii);
                    for (int jj = 0; jj < row.length; ++jj) {
                        int nn;
                        int offset;
                        Type type = map.get(columns[jj]);
                        if (type instanceof ShortType) {
                            sqlQuery.setShort(jj, (short)((Short)row[jj]));
                            continue;
                        }
                        if (type instanceof IntegerType) {
                            sqlQuery.setInteger(jj, (int)((Integer)row[jj]));
                            continue;
                        }
                        if (type instanceof BigIntegerType) {
                            sqlQuery.setBigInteger(jj, (BigInteger)row[jj]);
                            continue;
                        }
                        if (type instanceof LongType) {
                            sqlQuery.setLong(jj, (long)((Long)row[jj]));
                            continue;
                        }
                        if (type instanceof DoubleType) {
                            sqlQuery.setDouble(jj, Globals.getDoubleValue(row[jj]));
                            continue;
                        }
                        if (type instanceof BigDecimalType) {
                            sqlQuery.setBigDecimal(jj, (BigDecimal)row[jj]);
                            continue;
                        }
                        if (type instanceof FloatType) {
                            sqlQuery.setFloat(jj, ((Float)row[jj]).floatValue());
                            continue;
                        }
                        if (type instanceof StringType) {
                            String tmp = (String)row[jj];
                            tmp = tmp != null ? tmp.trim() : "";
                            sqlQuery.setString(jj, tmp);
                            continue;
                        }
                        if (type instanceof DateType) {
                            sqlQuery.setDate(jj, (java.util.Date)((Date)row[jj]));
                            continue;
                        }
                        if (type instanceof BinaryType) {
                            sqlQuery.setBinary(jj, ((String)row[jj]).getBytes());
                            continue;
                        }
                        if (type instanceof BlobType) {
                            Blob blob = (Blob)row[jj];
                            try {
                                InputStream is = blob.getBinaryStream();
                                int length = (int)blob.length();
                                byte[] bb = new byte[length];
                                offset = 0;
                                nn = 0;
                                while ((nn = is.read(bb, offset, length - offset)) != -1) {
                                }
                                sqlQuery.setBinary(jj, bb);
                            }
                            catch (SQLException sqlex) {
                                Ecad2007.trace(sqlex);
                            }
                            catch (IOException ioex) {
                                Ecad2007.trace(ioex);
                            }
                            continue;
                        }
                        if (!(type instanceof ClobType)) continue;
                        Clob clob = (Clob)row[jj];
                        try {
                            int length = (int)clob.length();
                            char[] array = new char[length];
                            Reader reader = clob.getCharacterStream();
                            offset = 0;
                            nn = 0;
                            while ((nn = reader.read(array, offset, length - offset)) != -1) {
                            }
                            sqlQuery.setText(jj, String.valueOf(array));
                            continue;
                        }
                        catch (SQLException sqlex) {
                            Ecad2007.trace(sqlex);
                            continue;
                        }
                        catch (IOException ioex) {
                            Ecad2007.trace(ioex);
                        }
                    }
                    i_res += sqlQuery.executeUpdate();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block29;
                i_res = 0;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return i_res;
    }

    @Override
    public int deleteM4_Usr() {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete M4_Usr m4_usr";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteM4_Usr(String ref) {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete M4_Usr m4_usr where m4_usr.ref=?";
                Query query = session.createQuery(hqlUpdate);
                query.setString(0, ref);
                deletedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteM4_Usr(ArrayList<String> rows) {
        int deletedRows;
        block7: {
            deletedRows = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                for (int ii = 0; ii < rows.size(); ++ii) {
                    String sql = "delete from M4_USR where REF='" + rows.get(ii) + "'";
                    SQLQuery query = session.createSQLQuery(sql);
                    deletedRows += query.executeUpdate();
                    if (ii % 20 != 0) continue;
                    session.flush();
                    session.clear();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedRows;
    }

    public List<M4_Usr> executeQuery(String sql) {
        List list;
        block6: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                list = session.createSQLQuery(sql).addEntity("m4_usr", M4_Usr.class).list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    public List<String> executeQuery(String sql, String[] scalar) {
        List list;
        block7: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
                    session = this.sessionFactory.openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < scalar.length; ++ii) {
                    sqlQuery.addScalar(scalar[ii], StringType.INSTANCE);
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }
}

