/*
 * Decompiled with CFR 0.152.
 */
package core.hibernate.usrcat.dao;

import core.hibernate.usrcat.MatDbDao;
import core.hibernate.usrcat.db.M4_MatDb;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.StringType;

public class HibernateMatDbDao
implements MatDbDao {
    SessionFactory sessionFactory;
    boolean b_close = true;
    static final String dbName = "usrcat";

    public HibernateMatDbDao() {
        this.sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
    }

    public HibernateMatDbDao(boolean b_close) {
        this.b_close = b_close;
    }

    @Override
    public String[] getColumnNames() {
        String[] columnNames = null;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_MatDb.class.getName());
        SingleTableEntityPersister step = (SingleTableEntityPersister)cmd;
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            int dim = names.length;
            columnNames = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                columnNames[ii] = step.getPropertyColumnNames(ii)[0].replaceAll("\"", "");
            }
        }
        return columnNames;
    }

    @Override
    public int getColumnCount() {
        int dim = 0;
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(M4_MatDb.class.getName());
        String[] names = cmd.getPropertyNames();
        if (names != null) {
            dim = names.length;
        }
        return dim;
    }

    public List<M4_MatDb> executeQuery(String sql) {
        List list;
        block6: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                list = session.createSQLQuery(sql).addEntity("matdb", M4_MatDb.class).list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    public List<String> executeQuery(String sql, String[] scalar) {
        List list;
        block7: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < scalar.length; ++ii) {
                    sqlQuery.addScalar(scalar[ii], StringType.INSTANCE);
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public boolean isInMaterialTable(M4_MatDb matDb) {
        boolean res;
        block7: {
            res = false;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                Criteria criteria = session.createCriteria(M4_MatDb.class);
                this.addEqCriteria(criteria, "ref", matDb.getRef());
                M4_MatDb test = (M4_MatDb)criteria.uniqueResult();
                tx.commit();
                if (test != null) {
                    res = true;
                }
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return res;
    }

    public void addEqCriteria(Criteria criteria, String cName, String value) {
        if (value != null && !value.trim().equals("")) {
            criteria.add(Restrictions.eq(cName, value));
        }
    }

    @Override
    public List<M4_MatDb> getMatDbList() {
        ArrayList<M4_MatDb> list;
        block8: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                String sql = "select id, mat,rem,pos,ref from M4_MatDb order by ref";
                Query query = session.createQuery(sql);
                ScrollableResults scr = query.scroll();
                scr.last();
                int dim = scr.getRowNumber() + 1;
                scr.first();
                list = new ArrayList<M4_MatDb>(dim);
                if (dim > 0) {
                    do {
                        M4_MatDb m4_MatDb = new M4_MatDb();
                        m4_MatDb.setId(scr.getInteger(0));
                        m4_MatDb.setMat(scr.getBlob(1));
                        m4_MatDb.setRem(scr.getString(2));
                        m4_MatDb.setPos(scr.getString(3));
                        m4_MatDb.setRef(scr.getString(4));
                        list.add(m4_MatDb);
                    } while (scr.next());
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block8;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public List<String[]> getMatDbList(String[] columnNames, String sql) {
        List list;
        block7: {
            list = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                for (int ii = 0; ii < columnNames.length; ++ii) {
                    sqlQuery.addScalar(columnNames[ii], StringType.INSTANCE);
                }
                list = sqlQuery.list();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return list;
    }

    @Override
    public M4_MatDb getMatDb(String ref) {
        M4_MatDb MatDb2;
        block6: {
            MatDb2 = null;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                Query query = session.createQuery("from M4_MatDb as MatDb where ref=?");
                query.setString(0, ref);
                MatDb2 = (M4_MatDb)query.uniqueResult();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return MatDb2;
    }

    @Override
    public int updateMatDb(M4_MatDb MatDb2) {
        int updatedEntities;
        block7: {
            updatedEntities = 0;
            if (MatDb2 == null) {
                return updatedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                session.saveOrUpdate(MatDb2);
                tx.commit();
            }
            catch (RuntimeException rex) {
                updatedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return updatedEntities;
    }

    @Override
    public int insertMatDb(M4_MatDb matDb) {
        int insertedEntities;
        block7: {
            insertedEntities = 0;
            if (matDb == null) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                session.save(matDb);
                tx.commit();
                ++insertedEntities;
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    public int insertMatDb(M4_MatDb[] matDb, boolean b_update) {
        int insertedEntities;
        block12: {
            insertedEntities = 0;
            if (matDb == null) {
                return insertedEntities;
            }
            int size = matDb.length;
            if (size == 0) {
                return insertedEntities;
            }
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                SQLQuery sqlQuery = session.createSQLQuery("select ref from matdb");
                sqlQuery.addScalar("REF", StringType.INSTANCE);
                List list = sqlQuery.list();
                for (int ii = 0; ii < size; ++ii) {
                    if (b_update) {
                        if (!list.contains(matDb[ii].getRef())) {
                            session.save(matDb[ii]);
                            ++insertedEntities;
                        }
                    } else {
                        session.save(matDb[ii]);
                    }
                    if (ii % 20 != 0) continue;
                    session.flush();
                    session.clear();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                insertedEntities = 0;
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block12;
                try {
                    tx.rollback();
                    insertedEntities = 0;
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                    insertedEntities = 0;
                }
                throw rex;
            }
        }
        return insertedEntities;
    }

    @Override
    public int deleteMatDb() {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete MatDb MatDb";
                deletedEntities = session.createQuery(hqlUpdate).executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteMatDb(String ref) {
        int deletedEntities;
        block6: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                String hqlUpdate = "delete M4_MatDb as MatDb where ref=?";
                Query query = session.createQuery(hqlUpdate);
                query.setString(0, ref);
                deletedEntities = query.executeUpdate();
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block6;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }

    public int deleteMatDb(ArrayList<String> rows) {
        int deletedEntities;
        block7: {
            deletedEntities = 0;
            Transaction tx = null;
            Session session = this.sessionFactory.getCurrentSession();
            try {
                try {
                    tx = session.beginTransaction();
                }
                catch (RuntimeException rex) {
                    this.sessionFactory.close();
                    session = Ecad2007.getSession(dbName).getSessionFactory().openSession();
                    tx = session.beginTransaction();
                }
                for (int ii = 0; ii < rows.size(); ++ii) {
                    String sql = "delete from MATDB where REF='" + rows.get(ii) + "'";
                    SQLQuery query = session.createSQLQuery(sql);
                    deletedEntities += query.executeUpdate();
                    if (ii % 20 != 0) continue;
                    session.flush();
                    session.clear();
                }
                tx.commit();
            }
            catch (RuntimeException rex) {
                Globals.println(10000, rex.getMessage());
                if (tx == null || !tx.isActive()) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException hex) {
                    Globals.println("Error rolling back transaction");
                }
                Ecad2007.trace(rex);
            }
        }
        return deletedEntities;
    }
}

