/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import enercad2007.Globals;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractTableModel
implements TableModel {
    String[] names;
    Object[][] data;
    JDialog dialog;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTableModel(String[] names, Object[][] data) {
        this.names = names;
        this.data = data;
    }

    public AbstractTableModel(JDialog dialog, String[] names, Object[][] data) {
        this.dialog = dialog;
        this.names = names;
        this.data = data;
    }

    public AbstractTableModel(String[] dim, String[] strdata) {
        this.data = new Object[strdata.length][1];
        this.names = dim;
        for (int cter = 0; cter < strdata.length; ++cter) {
            this.data[cter][0] = strdata[cter];
        }
    }

    public void addModelListener(TableModelListener tml) {
        this.listenerList.add(TableModelListener.class, tml);
    }

    public void removeModelListener(TableModelListener tml) {
        this.listenerList.remove(TableModelListener.class, tml);
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.dialog == null) {
            if (col < 3) {
                return this.data[row][col];
            }
            return this.data[row][col + 2];
        }
        return this.data[row][col];
    }

    public Object[][] getValues() {
        return this.data;
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column];
    }

    public Class getColumnClass(int c) {
        if (this.getValueAt(0, c) == null) {
            return Object.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.data[row][0] == null) {
            return false;
        }
        return this.data[row][1].equals("-1");
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.data != null) {
            Double dbl = Globals.getDouble(aValue);
            if (dbl != null) {
                this.data[row][column] = Globals.getDouble(aValue).toString();
            } else if (aValue != null) {
                this.data[row][column] = aValue.toString();
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent tme) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(tme);
        }
    }
}

