/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Config;
import core.hibernate.cat.Met_DataDao;
import core.hibernate.cat.Met_SiaDao;
import core.hibernate.cat.dao.HibernateMet_DataDao;
import core.hibernate.cat.dao.HibernateMet_SiaDao;
import core.hibernate.cat.db.Met_Data;
import core.hibernate.cat.db.Met_Sia;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DB_met {
    Config conf = null;
    Globals globals = null;
    String ie = "int";
    String id_met = "";
    String id_src = Globals.getDefaultMeteoSource();
    int[] idi_met;
    Map<String, Object> dmsia;
    Map<String, double[]> dmdata;
    ArrayList<String> al_src = new ArrayList(10);
    String[] rowsia;
    double[] rowdata;
    Met_DataDao hibernateMet_DataDao = new HibernateMet_DataDao();
    List<Met_Data> met_data = null;
    Met_SiaDao hibernateMet_SiaDao = new HibernateMet_SiaDao();
    List<Met_Sia> met_sia = null;
    List<Object> met_sia_bysql = null;
    Met_Sia met_sia_sel = null;
    int errorCode = 0;
    String errorMessage = "";

    public DB_met() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DB_met(String ie, String id_met) {
        try {
            this.ie = ie;
            if (id_met != null) {
                if (id_met.trim().equals("")) {
                    this.id_src = Ecad2007.getIdMet(3);
                } else if (id_met.startsWith("-1,0")) {
                    String[] met = id_met.split(",");
                    this.id_src = met.length > 2 ? met[2] : Ecad2007.getIdMet(3);
                } else {
                    String[] smet = id_met.split(",");
                    this.id_met = smet[0] + "," + smet[1];
                    if (smet.length == 3) {
                        this.id_src = smet[2];
                    }
                    if (id_met.indexOf(",") > 0) {
                        this.idi_met = new int[]{Integer.parseInt(smet[0]), Integer.parseInt(smet[1])};
                    }
                }
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.globals = new Globals();
        this.conf = new Config(System.getProperty("conf.file.name"));
        String sqlMetSrc = "";
        this.dmsia = new HashMap<String, Object>(200);
        this.dmdata = new HashMap<String, double[]>(200);
        String[] col_names = this.hibernateMet_SiaDao.getColumnNames();
        int length = col_names.length;
        if (this.ie.equals("int")) {
            if (!this.id_met.equals("")) {
                this.met_sia_sel = this.hibernateMet_SiaDao.getMet_Sia(String.valueOf(this.idi_met[0]));
                this.met_data = this.hibernateMet_DataDao.getMet_DataList(String.valueOf(this.idi_met[0]));
            } else {
                this.met_sia = this.hibernateMet_SiaDao.getMet_SiaListBySrc(this.id_src);
                sqlMetSrc = Ecad2007.getLicenseLevel() < 3L ? "SELECT DISTINCT cuepe.met_sia.src from cuepe.met_sia where cuepe.met_sia.src != 'SIA 2028' order by met_sia.src" : "SELECT DISTINCT cuepe.met_sia.src from cuepe.met_sia order by met_sia.src";
                this.met_sia_bysql = this.hibernateMet_SiaDao.getMet_SiaBySql(sqlMetSrc);
            }
        }
        try {
            if (this.ie.equals("int")) {
                // empty if block
            }
            if (this.id_met.equals("")) {
                for (Object object : this.met_sia_bysql) {
                    if (object == null) continue;
                    this.al_src.add(Globals.getStringValue(object).trim());
                }
                for (Met_Sia m_sia : this.met_sia) {
                    Object[] row = new Object[length - 1];
                    row[0] = m_sia.getNom_met();
                    row[1] = m_sia.getLat();
                    row[2] = m_sia.getLon();
                    row[3] = m_sia.getAlt();
                    row[4] = m_sia.getPays();
                    row[5] = m_sia.getRc();
                    row[6] = m_sia.getCanton();
                    row[7] = m_sia.getSit();
                    row[8] = m_sia.getTe_min();
                    row[9] = m_sia.getRem();
                    row[10] = m_sia.getSrc();
                    row[11] = m_sia.getFlag();
                    this.dmsia.put(String.format("%d,%d", m_sia.getId_met(), m_sia.getD()), row);
                }
            } else {
                this.dmsia.put("id_met", this.met_sia_sel.getId_met());
                this.dmsia.put("d", this.met_sia_sel.getD());
                this.dmsia.put("nom_met", this.met_sia_sel.getNom_met());
                this.dmsia.put("lat", this.met_sia_sel.getLat());
                this.dmsia.put("lon", this.met_sia_sel.getLon());
                this.dmsia.put("alt", this.met_sia_sel.getAlt());
                this.dmsia.put("pays", this.met_sia_sel.getPays());
                this.dmsia.put("rc", this.met_sia_sel.getRc());
                this.dmsia.put("canton", this.met_sia_sel.getCanton());
                this.dmsia.put("sit", this.met_sia_sel.getSit());
                this.dmsia.put("te_min", this.met_sia_sel.getTe_min());
                this.dmsia.put("rem", this.met_sia_sel.getRem());
                this.dmsia.put("src", this.met_sia_sel.getSrc());
                this.dmsia.put("flag", this.met_sia_sel.getFlag());
                String label = "";
                if (this.met_data != null) {
                    for (Met_Data m_data : this.met_data) {
                        label = m_data.getLabel();
                        this.rowdata = m_data.getData();
                        this.dmdata.put(label, (double[])this.rowdata.clone());
                        if (!label.equals("GH") && !label.equals("GS") && !label.equals("GE") && !label.equals("GW") && !label.equals("GN")) continue;
                        int ii = 0;
                        while (ii < this.rowdata.length) {
                            int n = ii++;
                            this.rowdata[n] = this.rowdata[n] * 0.2777777777777778;
                        }
                        this.dmdata.put(String.format("%s2016", label), this.rowdata);
                    }
                }
            }
        }
        catch (Throwable e) {
            String[] msg;
            this.errorCode = 1;
            if (e.getMessage() != null && (msg = e.getMessage().split("\\n")).length > 0) {
                this.errorMessage = msg[0];
            }
            return;
        }
    }

    public void insertMeteoRow(String dir, String[] columnNames, String[] values) {
    }

    public Map<String, Object> getMetSia() {
        return this.dmsia;
    }

    public ArrayList<String> getMetSrc() {
        return this.al_src;
    }

    public Map<String, double[]> getMetData() {
        return this.dmdata;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

