/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Calculation;
import core.Config;
import core.hibernate.cat.dao.HibernateQueryDao;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;

public class DM_Comp {
    Config conf = null;
    Globals globals = null;
    Calculation calc = new Calculation();
    String ie = "int";
    String projectName = "";
    String url = "";
    String componentCode = "";
    int flags = 7;
    Vector vct_comp;
    Map<String, String[]> m4_mat;
    Map c1_fen;
    Map c2_mur;
    Map c3_pthl;
    Map c4_pthp;
    Object[][] M4data;
    String[][] M4d;
    String[] row;
    DecimalFormat df2;
    Properties props = new Properties();
    String driver;
    String protocol;
    HibernateQueryDao hb_query;
    List<Object[]> listEx;
    protected String tableName;
    protected String[] columnNames = new String[0];
    int lan = 1;
    int numcol = 2;
    int numColFull = 0;
    int errorCode = 0;
    String codeLan = "FR";
    String errorMessage = "";

    public DM_Comp() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Comp(String ie, String[] columnNames) {
        try {
            this.ie = ie;
            this.columnNames = columnNames;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Comp(String ie, String[] columnNames, Map<String, String[]> m4_mat) {
        try {
            this.ie = ie;
            this.columnNames = columnNames;
            this.m4_mat = m4_mat;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Comp(String ie, String[] columnNames, String componentCode, Map<String, String[]> m4_mat) {
        try {
            this.ie = ie;
            this.columnNames = columnNames;
            this.componentCode = componentCode;
            this.m4_mat = m4_mat;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Comp(String ie, String[] columnNames, String componentCode, int flags, Map<String, String[]> m4_mat) {
        try {
            this.ie = ie;
            this.columnNames = columnNames;
            this.componentCode = componentCode;
            this.m4_mat = m4_mat;
            this.flags = flags;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Comp(Map<String, Object> config) {
        try {
            if (config.get("ie") != null) {
                this.ie = (String)config.get("ie");
            }
            if (config.get("columnNames") != null) {
                this.columnNames = (String[])config.get("columnNames");
            }
            if (config.get("datamap") != null) {
                this.m4_mat = (Map)config.get("m4_mat");
            }
            if (config.get("project") != null) {
                this.projectName = (String)config.get("project");
            }
            if (config.get("componentCode") != null) {
                this.componentCode = (String)config.get("componentCode");
            }
            if (config.get("flags") != null) {
                this.flags = Globals.getIntValue(config.get("flags"));
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.conf = new Config(System.getProperty("conf.file.name"));
        this.globals = new Globals();
        this.url = this.conf.getPropertyString("properties", "url", new String[]{"ext"});
        this.df2 = Ecad2007.getDecimalFormat("0.00");
        this.vct_comp = new Vector(100);
        String[] array = null;
        this.numcol = this.columnNames.length;
        if (this.numcol > 0) {
            if (!this.columnNames[this.numcol - 1].equals("REF")) {
                int cter;
                int startPos = 0;
                if (this.columnNames[0].indexOf("NOM_") == 0) {
                    startPos = 1;
                    array = new String[this.numcol + 2];
                } else {
                    array = new String[this.numcol + 2];
                }
                for (cter = startPos; cter < this.numcol; ++cter) {
                    array[cter] = this.columnNames[cter];
                }
                switch (this.conf.getPropertyInt("properties", "lan")) {
                    case 0: {
                        this.codeLan = "GE";
                        break;
                    }
                    case 1: {
                        this.codeLan = "FR";
                        break;
                    }
                    case 2: {
                        this.codeLan = "IT";
                        break;
                    }
                    case 3: {
                        this.codeLan = "EN";
                    }
                }
                array[0] = "NOM_" + this.codeLan;
                array[this.numcol] = "POS";
                array[this.numcol + 1] = "REF";
                this.columnNames = new String[this.numcol + 2];
                this.columnNames[0] = "NOM";
                for (cter = 1; cter < array.length; ++cter) {
                    this.columnNames[cter] = array[cter];
                }
                this.numcol += 2;
            }
            try {
                if (this.ie.equals("int")) {
                    this.loadComponentLibrary(15);
                }
                int typectermax = 1;
                if (!this.ie.equals("int")) {
                    typectermax = 1;
                }
                for (int typecter = 0; typecter < typectermax; ++typecter) {
                    this.loadDefaultDir(this.flags);
                    if (this.hb_query == null) {
                        this.hb_query = new HibernateQueryDao();
                    }
                    this.listEx = this.hb_query.getListBySql(this.createSql(""));
                    for (Object[] objects : this.listEx) {
                        this.row = new String[this.numcol];
                        for (int cter = 0; cter < this.numcol; ++cter) {
                            this.row[cter] = Globals.getStringValue(objects[cter]).trim();
                        }
                        if (this.row[this.numcol - 2] == null) {
                            this.row[this.numcol - 2] = "-";
                        }
                        if (this.row[this.numcol - 2].trim().equals("")) {
                            this.row[this.numcol - 2] = "-";
                        }
                        if ((this.flags & 8) == 8) {
                            this.row[this.numcol - 2] = "-1";
                        }
                        String[] cc = null;
                        if (this.row[3] != null) {
                            this.row[3] = this.row[3].trim();
                            cc = this.row[3].split(",");
                        }
                        if (cc.length > 1) {
                            if (cc[1].equals("1")) {
                                Map<String, Object> map = this.getC2Values(this.row[3]);
                                this.row[1] = this.df2.format(Globals.getDoubleValue(map.get("U_C")));
                            } else if (cc[1].equals("2")) {
                                Map<String, Object> map = this.getC1Values(this.row[3]);
                                this.row[1] = this.df2.format(Globals.getDoubleValue(map.get("U_C")));
                                this.row[2] = this.df2.format(Globals.getDoubleValue(map.get("G_C")));
                            } else if (cc[1].equals("4")) {
                                Map<String, Object> map = this.getC3Values(this.row[3]);
                                this.row[1] = this.df2.format(Globals.getDoubleValue(map.get("U_C")));
                            } else if (cc[1].equals("8")) {
                                Map<String, Object> map = this.getC4Values(this.row[3]);
                                this.row[1] = this.df2.format(Globals.getDoubleValue(map.get("U_C")));
                            }
                        }
                        this.row[0] = this.row[0].substring(0, 1).indexOf(" ") != -1 ? this.row[0].trim() + " " : this.row[0].trim();
                        boolean b_add = true;
                        if (this.row[this.numcol - 1].indexOf(",") == -1 && (this.flags & 8) == 8) {
                            b_add = false;
                        }
                        if (!b_add) continue;
                        this.vct_comp.addElement(this.row);
                    }
                }
            }
            catch (Throwable thr) {
                String[] msg;
                System.out.println("DM_Comp.jbInit " + thr);
                this.errorCode = thr.getClass() == SQLException.class ? 2 : 1;
                if (thr.getMessage() != null && (msg = thr.getMessage().split("\\n")).length > 0) {
                    this.errorMessage = msg[0];
                }
                return;
            }
        } else {
            return;
        }
    }

    private String createSql(String type) {
        String res = "";
        String tp = "";
        String[] cc = null;
        tp = type.equals("fab") ? "_FAB" : (type.equals("usr") ? "_USR" : "");
        if (this.componentCode != null) {
            cc = this.componentCode.split(",");
        }
        if (this.ie.equals("int")) {
            boolean b_full = false;
            if (cc.length == 1) {
                if (cc[0] == null) {
                    b_full = true;
                } else if (cc[0].trim().equals("")) {
                    b_full = true;
                }
            }
            if (b_full) {
                res = "select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,POSITION) AS POS, getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1) as ref FROM C1 ";
                res = res + "union select defineDirFromName(NOM_" + this.codeLan + ",a,b,c,d,e) as NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,POSITION) as POS, getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1) as ref FROM C2 ";
                res = res + "union select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,'') AS POS, getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1) as ref FROM C3 ";
                res = res + "union select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,'') AS POS, getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1) as ref FROM C4 order by ref";
            } else {
                int typeF = Globals.getIntValue(cc[0]);
                int typeC = Globals.getIntValue(cc[1]);
                if ((typeC & 1) == 1) {
                    res = res + "select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,POSITION) as POS, rtrim(getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1)) || char(id) as ref FROM C2 where bool_and(a," + typeF + ")>0";
                }
                if ((typeC & 2) == 2) {
                    res = !res.equals("") ? res + "union " : "select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,POSITION) AS POS, rtrim(getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1)) || char(id) as ref FROM C1 where bool_and(a," + typeF + ")>0";
                }
                if ((typeC & 4) == 4) {
                    res = !res.equals("") ? res + "union " : res + "select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,'') AS POS, rtrim(getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1)) || char(id) as ref FROM C3 where bool_and(a," + typeF + ")>0";
                }
                if ((typeC & 8) == 8) {
                    res = !res.equals("") ? res + "union " : res + "select NOM_" + this.codeLan + " AS NOM,'' as U_C,'' as GG,getRefFromCode(a,b,c,d,e) as CODE, getPosFromCode(a,-b,-1,-1,e,'') AS POS, rtrim(getFirstBitWiseRefFromCode(a,-b,-1,-1,e,1)) || char(id) as ref FROM C4 where bool_and(a," + typeF + ")>0";
                }
            }
        } else {
            res = "select NOM_" + this.codeLan + " AS NOM,CODE, case when POSITION = '' then '-' else POSITION end as pos, case when locate(',',CODE) = 0 then code else substring(code,1,length(code)-locate(',',reverse(code))) end as ref FROM C1_FEN" + tp + " union ";
            res = res + "select NOM_" + this.codeLan + " AS NOM,CODE, case when POSITION = '' then '-' else POSITION end as pos, case when locate(',',CODE) = 0 then code else substring(code,1,length(code)-locate(',',reverse(code))) end as ref FROM C2_MUR" + tp + " union ";
            res = res + "select NOM_" + this.codeLan + " AS NOM,CODE, case when POSITION = '' then '-' else POSITION end as pos, case when locate(',',CODE) = 0 then code else substring(code,1,length(code)-locate(',',reverse(code))) end as ref FROM C3_PTHL" + tp + " union ";
            res = res + "select NOM_" + this.codeLan + " AS NOM,CODE, case when POSITION = '' then '-' else POSITION end as pos, case when locate(',',CODE) = 0 then code else substring(code,1,length(code)-locate(',',reverse(code))) end as ref FROM C4_PTHP" + tp + " ";
            res = res + "order by ref,code";
        }
        return res;
    }

    public void loadComponentLibrary(int f_refresh) {
        List<Object[]> listEx;
        switch (Ecad2007.getCodeLan()) {
            case 0: {
                this.codeLan = "GE";
                break;
            }
            case 1: {
                this.codeLan = "FR";
                break;
            }
            case 2: {
                this.codeLan = "IT";
                break;
            }
            case 3: {
                this.codeLan = "EN";
            }
        }
        if (Ecad2007.c1_fen == null || (f_refresh & 1) == 1) {
            String sqlC1 = "select nom_" + this.codeLan + ", ";
            sqlC1 = sqlC1 + "ui_c, su_c, ref_m1, ref_m2, ref_m3, ref_m6, getRefFromCode(a,b,c,d,e) as code from C1 where a > 0";
            if (this.hb_query == null) {
                this.hb_query = new HibernateQueryDao();
            }
            listEx = this.hb_query.getListBySql(sqlC1);
            Ecad2007.c1_fen = this.getDataCX(listEx);
        } else {
            this.c1_fen = Ecad2007.c1_fen;
        }
        if (Ecad2007.c2_mur == null || (f_refresh & 2) == 2) {
            int cter;
            String sqlC2 = "select NOM_GE,NOM_FR,NOM_IT,NOM_EN,";
            for (cter = 1; cter < 10; ++cter) {
                sqlC2 = sqlC2 + "ref_m4_0" + cter + ",ref_m42_0" + cter + ",d_c_0" + cter + ",";
            }
            for (cter = 10; cter <= 12; ++cter) {
                sqlC2 = sqlC2 + "ref_m4_" + cter + ",ref_m42_" + cter + ",d_c_" + cter + ",";
            }
            sqlC2 = sqlC2 + "d1_c,d2_c,rae,rai,u_c, pt_c, pn_c, getRefFromCode(a,b,c,d,e) as code from C2 where a > 0";
            if (this.hb_query == null) {
                this.hb_query = new HibernateQueryDao();
            }
            listEx = this.hb_query.getListBySql(sqlC2);
            Ecad2007.c2_mur = this.getDataCX(listEx);
        } else {
            this.c2_mur = Ecad2007.c2_mur;
        }
        if (Ecad2007.c3_pthl == null || (f_refresh & 4) == 4) {
            String sqlC3 = "select NOM_GE,NOM_FR,NOM_IT,NOM_EN,";
            sqlC3 = sqlC3 + "BASE,U_C,CODE, getRefFromCode(a,b,c,d,e) as ref from C3 where a > 0";
            if (this.hb_query == null) {
                this.hb_query = new HibernateQueryDao();
            }
            listEx = this.hb_query.getListBySql(sqlC3);
            HashMap<String, ImageIcon> im_pthl = this.globals.getResources("c3_pthl");
            Ecad2007.c3_pthl = this.getDataCX(listEx, im_pthl);
        } else {
            this.c3_pthl = Ecad2007.c3_pthl;
        }
        if (Ecad2007.c4_pthp == null || (f_refresh & 8) == 8) {
            String sqlC4 = "select NOM_GE,NOM_FR,NOM_IT,NOM_EN,";
            sqlC4 = sqlC4 + "BASE,U_LIM,U_C,CODE, getRefFromCode(a,b,c,d,e) as ref from C4 where a > 0";
            if (this.hb_query == null) {
                this.hb_query = new HibernateQueryDao();
            }
            listEx = this.hb_query.getListBySql(sqlC4);
            HashMap<String, ImageIcon> im_pthp = this.globals.getResources("c4_pthp");
            Ecad2007.c4_pthp = this.getDataCX(listEx, im_pthp);
        } else {
            this.c4_pthp = Ecad2007.c4_pthp;
        }
    }

    public void loadDefaultDir(int flags) {
        String[][] names = new String[][]{{"Meine Fabrikanten", "Mes fabricants", "I miei industriali", "My industials"}, {"Mein Projekt", "Mon projet", "I miei projeto", "My project"}, {"Meine Komponenten", "Mes composants", "I miei componenti", "My components"}};
        String ref = "";
        int tmp = 0;
        for (int ii = 0; ii < names.length; ++ii) {
            tmp = (int)Math.pow(2.0, ii);
            if ((flags & tmp) != tmp) continue;
            this.row = new String[this.numcol];
            ref = ref + String.valueOf("0");
            this.row[0] = names[ii][this.lan];
            this.row[this.numcol - 3] = "0,0,0,2," + String.valueOf(ii);
            this.row[this.numcol - 2] = "-";
            this.row[this.numcol - 1] = ref;
            for (int jj = 1; jj < this.numcol - 3; ++jj) {
                this.row[jj] = "";
            }
            this.vct_comp.addElement(this.row);
        }
    }

    public Map<String, Object> getC1Values(String ref) {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        Object[] c1_fen = Ecad2007.c1_fen.get(ref);
        Map<String, String[]> m_ver = Ecad2007.getWinLibrary().getDataMapM16()[0];
        String[] m1_ver = m_ver.get(c1_fen[3]);
        Map<String, String[]> m_cad = Ecad2007.getWinLibrary().getDataMapM16()[1];
        String[] m2_cad = m_cad.get(c1_fen[4]);
        Map<String, String[]> m_voil = Ecad2007.getWinLibrary().getDataMapM16()[2];
        String[] m3_voil = m_voil.get(c1_fen[5]);
        Map<String, String[]> m_icl = Ecad2007.getWinLibrary().getDataMapM16()[3];
        String[] m6_icl = m_icl.get(c1_fen[6]);
        double ug = new Double(m1_ver[4]);
        double g = new Double(m1_ver[5]);
        double uf = new Double(m2_cad[4]);
        double ff = new Double(m2_cad[5]);
        double fc = new Double(m3_voil[4]);
        double ui = new Double(m6_icl[4]);
        double lr = 3.5;
        map.put("NOM_C", c1_fen[0]);
        map.put("UG_C", new Double(ug));
        map.put("G_C", new Double(g));
        map.put("UF_C", new Double(uf));
        map.put("FF_C", new Double(ff));
        map.put("FC_C", new Double(fc));
        map.put("UI_C", new Double(ui));
        map.put("LR_C", new Double(lr));
        map.put("ICA_C", new Double(3.5));
        map.put("ICL_C", new Double(1.0));
        Map wmap = this.calc.getCompFen(uf, ug, ff, fc, g, ui, lr);
        map.put("U_C", wmap.get("U"));
        return map;
    }

    public Map<String, Object> getC2Values(String ref) {
        int cter;
        HashMap<String, Object> map = new HashMap<String, Object>(60);
        Object[] object = Ecad2007.c2_mur.get(ref);
        int dim = 12;
        this.M4data = new Object[dim][10];
        this.M4d = new String[dim][2];
        int nlay = 0;
        int ch_c = -1;
        int st_c = -1;
        double[] rsdim = new double[]{1.0, 0.0};
        double Rmoy = 0.0;
        double[] PontTherm = new double[]{0.0, 0.0};
        float[] raie = new float[]{0.13f, 0.04f};
        int numPT = 0;
        double valPT = 0.0;
        if (object != null) {
            String rr;
            int index;
            for (cter = 0; cter < object.length && (index = (rr = object[3 * cter + 4].toString()).indexOf(",")) > 0; ++cter) {
                int tmpch_c;
                ++nlay;
                if (ch_c == -1 && (tmpch_c = Globals.getIntValue(rr.substring(0, index))) == 20 && ch_c == -1) {
                    ch_c = cter;
                }
                if (st_c != -1 || (tmpch_c = Globals.getIntValue(rr.substring(0, index))) != 21 || st_c != -1) continue;
                st_c = cter;
            }
        }
        for (cter = 0; cter < nlay; ++cter) {
            Object[] row;
            ref = object[3 * cter + 4].toString().trim();
            if (this.m4_mat.get(ref) != null) {
                row = this.m4_mat.get(ref);
                this.M4data[cter][4] = ref;
                this.M4data[cter][0] = row[this.lan].trim();
                this.M4data[cter][1] = row[6];
                this.M4data[cter][2] = row[7];
                this.M4data[cter][3] = row[8];
                String temp = String.valueOf(object[3 * cter + 6]);
                this.M4d[cter][0] = temp.equals("") ? "0" : temp;
                if (row[13] != null && Globals.getDoubleValue(row[13]) != 0.0) {
                    this.M4d[cter][1] = row[13];
                }
            }
            if (this.m4_mat.get(ref = object[3 * cter + 5].toString().trim()) == null) continue;
            row = this.m4_mat.get(ref);
            this.M4data[cter][9] = ref;
            this.M4data[cter][5] = ((String)row[this.lan]).trim();
            this.M4data[cter][6] = row[6];
            this.M4data[cter][7] = row[7];
            this.M4data[cter][8] = row[8];
            this.M4d[cter][0] = String.valueOf(object[3 * cter + 6]);
            if (row[13] == null || Globals.getDoubleValue(row[13]) == 0.0 || this.M4d[cter][1].compareTo("-1") == 0) continue;
            this.M4d[cter][0] = Globals.getStringValue(row[13]);
        }
        this.calc.setData(this.M4data);
        this.calc.setDimData(this.M4d);
        if (object[40] != null && !object[40].equals("")) {
            rsdim[0] = ((Float)object[40]).doubleValue();
        }
        if (object[41] != null && !object[41].equals("")) {
            rsdim[1] = ((Float)object[41]).doubleValue();
        }
        if (object[45] != null && !object[45].equals("")) {
            valPT = ((Float)object[45]).doubleValue();
        }
        if (object[46] != null && !object[46].equals("")) {
            numPT = ((Float)object[46]).intValue();
        }
        PontTherm[0] = numPT;
        PontTherm[1] = valPT;
        if (object[42] != null && !object[42].equals("")) {
            raie[1] = ((Float)object[42]).floatValue();
        }
        if (object[43] != null && !object[43].equals("")) {
            raie[0] = ((Float)object[43]).floatValue();
        }
        this.calc.setRAie(raie);
        Rmoy = this.calc.getRMoy(rsdim, ch_c, st_c, nlay);
        Rmoy = this.calc.getRmoyAvecPontThermique(Rmoy, valPT, numPT);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        for (int ii = 0; ii < 12; ++ii) {
            if (ii < 10) {
                map.put("REF_M4_0" + String.valueOf(ii + 1), object[3 * ii + 4]);
                map.put("REF_M42_0" + String.valueOf(ii + 1), object[3 * ii + 5]);
                map.put("D_C_0" + String.valueOf(ii + 1), object[3 * ii + 6]);
                continue;
            }
            map.put("REF_M4_" + String.valueOf(ii + 1), object[3 * ii + 4]);
            map.put("REF_M42_" + String.valueOf(ii + 1), object[3 * ii + 5]);
            map.put("D_C_" + String.valueOf(ii + 1), object[3 * ii + 6]);
        }
        map.put("N_LAY", new Integer(nlay));
        map.put("D1_C", object[40]);
        map.put("D2_C", object[41]);
        map.put("RSDIM", rsdim);
        map.put("RAE", object[42]);
        map.put("RAI", object[43]);
        map.put("RAIE", raie);
        map.put("CH_C", new Integer(ch_c));
        map.put("U_C", new Double(1.0 / Rmoy));
        map.put("PT_C", object[45]);
        map.put("PT_N", object[46]);
        map.put("PT", PontTherm);
        map.put("REF", object[47]);
        return map;
    }

    public Map<String, Object> getC3Values(String ref) {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        Object[] object = Ecad2007.c3_pthl.get(ref);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        map.put("BASE", object[4]);
        map.put("U_C", object[5]);
        map.put("CODE", object[6]);
        map.put("IMG", object[7]);
        map.put("REF", object[8]);
        return map;
    }

    public Map<String, Object> getC4Values(String ref) {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        Object[] object = Ecad2007.c4_pthp.get(ref);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        map.put("BASE", object[4]);
        map.put("U_LIM", object[5]);
        map.put("U_C", object[6]);
        map.put("CODE", object[7]);
        map.put("IMG", object[8]);
        map.put("REF", object[9]);
        return map;
    }

    private Map<String, Object[]> getDataCX(List<Object[]> listEx) {
        return this.getDataCX(listEx, null);
    }

    private Map<String, Object[]> getDataCX(ResultSet rs) {
        return this.getDataCX(rs, null);
    }

    private Map<String, Object[]> getDataCX(List<Object[]> listEx, Map<String, ImageIcon> images) {
        HashMap<String, Object[]> res = new HashMap<String, Object[]>(100);
        String ref = "";
        int dim = 0;
        int cdim = 0;
        if (listEx == null) {
            return res;
        }
        cdim = dim = listEx.get(0).length;
        if (images != null) {
            ++cdim;
        }
        Iterator<Object[]> itEx = listEx.iterator();
        while (itEx.hasNext()) {
            Object[] rows = new Object[cdim];
            Object[] objects = itEx.next();
            for (int ii = 0; ii < dim; ++ii) {
                rows[ii] = objects[ii] == null ? "" : (objects[ii] instanceof String ? Globals.getStringValue(objects[ii]).trim() : objects[ii]);
            }
            ref = rows[dim - 1].toString();
            if (cdim > dim) {
                rows[cdim - 2] = images.get(ref);
                rows[cdim - 1] = ref;
            }
            res.put(ref, rows);
        }
        return res;
    }

    private Map<String, Object[]> getDataCX(ResultSet rs, Map<String, ImageIcon> images) {
        HashMap<String, Object[]> res = new HashMap<String, Object[]>(100);
        String ref = "";
        int dim = 0;
        int cdim = 0;
        try {
            cdim = dim = rs.getMetaData().getColumnCount();
            if (images != null) {
                ++cdim;
            }
            while (rs.next()) {
                Object[] rows = new Object[cdim];
                for (int cter = 1; cter <= dim; ++cter) {
                    if (rs.getObject(cter) != null) {
                        Object object = rs.getObject(cter);
                        if (object.getClass() == Float.class) {
                            rows[cter - 1] = new Float(rs.getFloat(cter));
                            continue;
                        }
                        if (object.getClass() == Double.class) {
                            rows[cter - 1] = new Double(rs.getDouble(cter));
                            continue;
                        }
                        if (object.getClass() == String.class) {
                            rows[cter - 1] = rs.getString(cter).trim();
                            continue;
                        }
                        if (object.getClass() == Integer.class) {
                            rows[cter - 1] = new Integer(rs.getInt(cter));
                            continue;
                        }
                        if (object.getClass() != BigDecimal.class) continue;
                        rows[cter - 1] = new Double(rs.getBigDecimal(cter).doubleValue());
                        continue;
                    }
                    rows[cter - 1] = "";
                }
                ref = rows[dim - 1].toString();
                if (cdim > dim) {
                    rows[cdim - 2] = images.get(ref);
                    rows[cdim - 1] = ref;
                }
                res.put(ref, rows);
            }
        }
        catch (Throwable thr) {
            Globals.println("DM_Comp.getDataCX: " + thr);
        }
        return res;
    }

    public Map<String, String[]> getDataMap() {
        return this.m4_mat;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Vector getVectorData() {
        return this.vct_comp;
    }
}

