/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Calc_EX;
import core.Calc_EX2016;
import core.hibernate.pro.db.Envelope;
import enercad2007.DB_Element;
import enercad2007.DM_E_NC;
import enercad2007.DM_Facade;
import enercad2007.DM_Fenetre;
import enercad2007.DM_Shade;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DM_Element {
    Calc_EX calcElement;
    Calc_EX2016 calcElement2016;
    DB_Element dbElement;
    DM_E_NC dm_e_nc;
    Map<Integer, Envelope> dmdata;
    Envelope element = new Envelope();
    int ID_Z = 0;
    int type = -1;
    String[] intErrorString = new String[]{"ID_Z", "ID_F", "ID_E", "ID_O", "ID_V", "typeF_E", "typeC_E", "typeV_E", "CH_E"};
    String intErrorMsg = "Sorry, only following variables are avaiable:\nID_Z: id zone (0 par \u00e9faut)\nID_E: id \u00e9l\u00e9ment\nID_F: sur quelle fa\u00e7ade se trouve cet \u00e9l\u00e9ment (associ\u00e9 \u00e0 la fa\u00e7ade ID_F)\nID_O: composant ombrage associ\u00e9 \u00e0 l'\u00e9l\u00e9ment (0 = valeur par d\u00e9faut CRDE)\nID_V: ID de la zone voisine (en r\u00e9serve pour mod\u00e8le multizone / null = pas de zone voisine d\u00e9finie)\n\ntypeF_E: type de fa\u00e7ade     (d\u00e9fini par la r\u00e9f\u00e9rence ID_C)\ntypeC_E: type de composant  (d\u00e9fini par la r\u00e9f\u00e9rence ID_C)\ntypeV_E: type de voisinage\nCH_E: \u00e9l\u00e9ment chauffant [0 = non; 1 = oui]\n\n";
    String[] dblErrorString = new String[]{"U_E", "A_E", "AR_E", "NUM_E", "DCH_E", "PE_E", "UP_E", "DP_E", "TCH_E", "UNE_E", "RSE_E", "ACH_E", "AZ_E", "INC_E", "AOH_E", "ASF_E", "SHM_E"};
    String dblErrorMsg = "Sorry, only following variables are avaiable:\nU_E: valeur U surfacique, lin\u00e9ique, ponctuel \u00e9l\u00e9ment [W/m\u00b2K, W/mlK, W/pcK]\nA_E: surface, longueur, unit\u00e9s \u00e9l\u00e9ment [m\u00b2, ml, pc]\nAR_E: surface radiateur [m\u00b2]\nNUM_E: nombre d'\u00e9l\u00e9ments [n]\n\nDCH_E: profondeur [m]\nPE_E: p\u00e9rim\u00e8tre [m]\nUP_E: valeur U isol p\u00e9riph\u00e9rique [W/m\u00b2K]\nDP_E: profondeur isol p\u00e9riph\u00e9rique [m]\nTCH_E: temp\u00e9rature constante espace voisin [\u00b0C]\nUNE_E: valeur U interface N/E [W/m\u00b2K]\nRSE_E: rapport de surface I/N sur N/E [1/n]\nACH_E: renouvellement d'air N/E [V/h]\n\nAZ_E: azimut [RAD] (0 = N; pi/2 = E; pi = S; pi*3/2 = W)\nINC_E: inclinaison [\u00b0] (0 = horizontal; pi = vertical)\n\nAOH_E: angle 'overhang' (d\u00e9fini par la r\u00e9f\u00e9rence ID_O)\nASF_E: angle 'sidefin'  (d\u00e9fini par la r\u00e9f\u00e9rence ID_O)\nSHM_E: tableau 2D de facteurs d'ombrage mois/mois et h/h  (d\u00e9fini par la r\u00e9f\u00e9rence ID_O)\n\n";
    String[] StringErrorString = new String[]{"ID_C", "NOM_E", "REM_E"};
    String StringErrorMsg = "Sorry, only following variables are avaiable:\nID_C: composant mur, fen\u00e8tre ou pont thermique associ\u00e9 \u00e0 l'\u00e9l\u00e9ment (null = pas de composant s\u00e9lectionn\u00e9)\nNOM_E: nom de l'\u00e9l\u00e9ment [$ : 128 chars]\nREM_E: notes concernant l'\u00e9l\u00e9ment (en r\u00e9serve) [$ : 2048 chars ?]\n\n";

    public DM_Element() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public DM_Element(int ID_Z) {
        this.ID_Z = ID_Z;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public DM_Element(int ID_Z, int type) {
        this.ID_Z = ID_Z;
        this.type = type;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() {
        this.dbElement = this.type == -1 ? new DB_Element("int", this.ID_Z) : new DB_Element(this.ID_Z, this.type);
        this.calcElement = new Calc_EX(this.ID_Z);
        this.calcElement2016 = new Calc_EX2016(this.ID_Z);
        this.dm_e_nc = Ecad2007.getDM_E_NC();
        this.dmdata = this.dbElement.getElementData();
    }

    public Map<String, Object> getCalcE(Envelope element) {
        Object[] component;
        int typeV_E = 0;
        int BL_E = -1;
        double G_C = 0.0;
        double FF_C = 1.0;
        double FC_C = 0.0;
        double AZ_E = 0.0;
        double INC_E = 0.0;
        int ID_F = element.getId_f();
        String ID_C = element.getId_c();
        int ID_O = element.getId_o();
        int ID_V = element.getId_v();
        String NOM_E = element.getNom_e();
        String REM_E = element.getRem_e();
        String[] cc = ID_C.split(",");
        int typeF_E = Globals.getIntValue(cc[0]);
        int typeC_E = Globals.getIntValue(cc[1]);
        String code_nc = this.dm_e_nc.generateKey(Globals.getIntValue(ID_V));
        if (code_nc != null) {
            String[] enc = code_nc.split(",");
            typeV_E = Globals.getIntValue(enc[2]);
        }
        double U_E = element.getU_e();
        int CH_E = element.getCh_e().shortValue();
        Object[] cref = Ecad2007.getDMpr_Comp().getComponentByBitWiseCheck(ID_C, 4);
        if (cref != null) {
            U_E = Ecad2007.getDMpr_Comp().getComponentU_C(ID_C);
            if ((Globals.getIntValue(cc[1]) & 1) == 1) {
                CH_E = Ecad2007.getDMpr_Comp().getCoucheCh(ID_C);
            }
        }
        double A_E = element.getA_e();
        double Ar_E = element.getAr_e();
        double NUM_E = element.getNum_e();
        double Dch_E = element.getDch_e();
        double PE_E = element.getPe_e();
        double UP_E = element.getUp_e();
        double DP_E = element.getDp_e();
        double Tch_E = element.getTch_e();
        double Une_E = element.getUne_e();
        double RS_E = element.getRse_e();
        double ACH_E = element.getAch_e();
        if (typeF_E == 1) {
            AZ_E = 0.0;
            INC_E = 0.0;
        } else if (typeF_E == 2) {
            AZ_E = element.getAz_e();
            INC_E = element.getInc_e();
        } else if (typeF_E == 4) {
            if (Ecad2007.dataF == null) {
                Ecad2007.dataF = new DM_Facade(this.ID_Z);
            }
            AZ_E = Ecad2007.dataF.getAZ(ID_F);
            INC_E = 1.5707963267948966;
        } else if (typeF_E == 8) {
            AZ_E = 0.0;
            INC_E = 0.0;
        }
        if (cc[0].equals("4") && cc[1].equals("1")) {
            BL_E = this.getBlinds(ID_C);
        }
        if (cc[1].equals("2") && (component = Ecad2007.getDMpr_Comp().getComponentByBitWiseCheck(ID_C, 4)) != null) {
            ID_C = component[15].toString() + ",";
            ID_C = ID_C + component[16].toString() + ",";
            ID_C = ID_C + component[17].toString() + ",";
            ID_C = ID_C + component[18].toString() + ",";
            ID_C = ID_C + component[19].toString();
            G_C = Ecad2007.getDMpr_Comp().getComponentG_C(ID_C);
            FF_C = Ecad2007.getDMpr_Comp().getComponentFF_C(ID_C);
            FC_C = Ecad2007.getDMpr_Comp().getComponentFC_C(ID_C);
        }
        if (Ecad2007.dataO == null) {
            Ecad2007.dataO = new DM_Shade();
        }
        double AOH_E = Ecad2007.dataO.getShadeAOH(ID_O);
        double ASF_E = Ecad2007.dataO.getShadeASF(ID_O);
        double[][] res_E = null;
        res_E = Ecad2007.getIntCalcmod() < 7 ? this.calcElement.getQElement(typeF_E, typeC_E, typeV_E, U_E, CH_E, A_E, Ar_E, NUM_E, G_C, FF_C, FC_C, Dch_E, PE_E, UP_E, DP_E, Tch_E, Une_E, RS_E, ACH_E, AZ_E, INC_E, AOH_E, ASF_E) : this.calcElement2016.getQElement(typeF_E, typeC_E, typeV_E, U_E, CH_E, A_E, Ar_E, NUM_E, G_C, FF_C, FC_C, Dch_E, PE_E, UP_E, DP_E, Tch_E, Une_E, RS_E, ACH_E, AZ_E, INC_E, AOH_E, ASF_E);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NOM_E", NOM_E);
        map.put("ID_F", ID_F);
        map.put("AZ_E", AZ_E);
        map.put("INC_E", INC_E);
        map.put("ID_E", element.getId_e());
        map.put("ID_C", element.getId_c());
        map.put("A_E", A_E);
        map.put("Ar_E", Ar_E);
        map.put("AOH_E", AOH_E);
        map.put("ASF_E", ASF_E);
        map.put("CH_E", CH_E);
        map.put("Dch_E", Dch_E);
        map.put("BL_E", BL_E);
        map.put("Tch_E", Tch_E);
        map.put("res_E", res_E);
        map.put("FF_C", FF_C);
        map.put("FC_C", FC_C);
        return map;
    }

    public String getCodeSIA(Envelope envelope) {
        if (envelope == null) {
            return null;
        }
        Object tmp = null;
        tmp = envelope.getId_c();
        if (tmp == null) {
            return null;
        }
        String ID_C = tmp;
        String[] cc = ID_C.split(",");
        int typeF_E = Integer.parseInt(cc[0]);
        int typeC_E = Integer.parseInt(cc[1]);
        int ID_V = envelope.getId_v();
        int typeV_E = 0;
        String code_nc = this.dm_e_nc.generateKey(ID_V);
        if (code_nc != null) {
            String[] enc = code_nc.split(",");
            typeV_E = Globals.getIntValue(enc[2]);
        }
        Object[] composant = Ecad2007.getDMpr_Comp().getComponentByBitWiseCheck(ID_C, 4);
        int BL_E = Ecad2007.getDMpr_Comp().getCoucheChBl(composant)[1];
        tmp = envelope.getA_e();
        if (tmp == null) {
            tmp = new Double(0.0);
        }
        double A_E = (Double)tmp;
        tmp = envelope.getAr_e();
        if (tmp == null) {
            tmp = new Double(0.0);
        }
        double Ar_E = (Double)tmp;
        tmp = envelope.getCh_e();
        if (tmp == null) {
            tmp = new Integer(-1);
        }
        int CH_E = Globals.getIntValue(tmp);
        tmp = envelope.getDch_e();
        if (tmp == null) {
            tmp = new Double(0.0);
        }
        double Dch_E = (Double)tmp;
        tmp = envelope.getTch_e();
        if (tmp == null) {
            tmp = new Double(0.0);
        }
        double Tch_E = (Double)tmp;
        return this.getCodeSIA(ID_C, typeF_E, typeC_E, typeV_E, A_E, Ar_E, CH_E, Dch_E, BL_E, Tch_E);
    }

    public String getCodeSIA(String id_c, int typeF, int typeC, int typeV, double A_E, double Ar_E, int CH_E, double Dch_E, int BL_E, double T_NC) {
        String[] code = null;
        String res = "";
        int calcmod = Ecad2007.getIntCalcmod();
        DecimalFormat df0 = Ecad2007.getDecimalFormat("0");
        if (calcmod == 2 || calcmod >= 4) {
            if (typeC == 1) {
                code = BL_E >= 0 ? (calcmod < 5 ? new String[]{"D5", "D6", "-"} : new String[]{"B5", "B6", "-"}) : (typeF == 1 || typeF == 2 ? (CH_E < 0 ? new String[]{"A1", "A2", "-"} : new String[]{"A3", "A4", "-"}) : (typeF == 4 ? (CH_E < 0 ? new String[]{"B1", "B2", "-"} : new String[]{"B3", "B4", "-"}) : (typeF == 8 ? (CH_E < 0 ? new String[]{"C1", "C2", "-"} : new String[]{"C3", "C4", "-"}) : new String[]{"n/a", "n/a", "n/a"})));
            } else if (typeC == 2) {
                DM_Fenetre dm_fenetre = new DM_Fenetre(id_c);
                double FF_C = dm_fenetre.getFF_C();
                double G_C = dm_fenetre.getG_C();
                code = (FF_C > 0.8 || G_C == 0.0) && A_E > 6.0 ? new String[]{"F1", "F2", "-"} : (Ar_E == 0.0 ? new String[]{"D1", "D2", "-"} : new String[]{"D3", "D4", "-"});
            } else if (typeC == 4) {
                code = new String[]{"L", "L", "-"};
                if (T_NC > 0.0) {
                    code[0] = code[0] + df0.format(T_NC);
                    code[1] = code[1] + df0.format(T_NC);
                }
            } else {
                code = typeC == 8 ? new String[]{"P1", "P1", "-"} : new String[]{"n/a", "n/a", "n/a"};
            }
            res = (typeV & 1) == 1 || (typeV & 0x40) == 64 && Dch_E < 2.0 ? code[0] : ((typeV & 2) == 2 || (typeV & 4) == 4 || (typeV & 0x40) == 64 ? code[1] : ((typeV & 8) == 8 || (typeV & 0x10) == 16 || (typeV & 0x20) == 32 ? code[2] : "n/a"));
        } else {
            res = calcmod == 1 || calcmod == 3 ? "n/a" : "n/a";
        }
        return res;
    }

    public double[] getUlimElement(String code) {
        return this.getUlimElement(code, 0);
    }

    public double[] getUlimElement(String code, int typeV) {
        String[] codeList = new String[30];
        double[] Uli0List = new double[30];
        double[] Uli1List = new double[30];
        double[] Uli2List = new double[30];
        double[] Uli3List = new double[30];
        double[] res = new double[]{-1.0, -1.0, -1.0, -1.0};
        codeList = new String[]{"A1", "A2", "A3", "A4", "B1", "B2", "B3", "B4", "B5", "B6", "C1", "C2", "C3", "C4", "D1", "D2", "D3", "D4", "D5", "D6", "F1", "F2", "L1", "L2", "L3", "L5", "P1", "L", "-", "n/a"};
        if (Ecad2007.getIntCalcmod() == 2 || Ecad2007.getIntCalcmod() == 4) {
            Uli0List = new double[]{0.25, 0.35, 0.25, 0.3, 0.25, 0.35, 0.25, 0.3, 0.6, 0.6, 0.25, 0.35, 0.25, 0.3, 1.5, 1.7, 1.2, 1.5, 0.6, 0.6, 1.7, 2.0, 0.3, 0.2, 0.2, 0.1, 0.3, 0.1, 4.0, -1.0};
            Uli1List = new double[]{0.15, 0.25, 0.15, 0.2, 0.15, 0.25, 0.3, 0.2, 0.4, 0.4, 0.2, 0.1, 0.3, 0.2, 1.0, 1.2, 0.9, 1.1, 0.4, 0.4, 1.4, 1.7, 0.15, 0.1, 0.1, 0.05, 0.15, 0.05, 4.0, -1.0};
        } else if (Ecad2007.getIntCalcmod() == 5) {
            Uli0List = new double[]{0.2, 0.25, 0.2, 0.25, 0.2, 0.28, 0.2, 0.25, 0.5, 0.5, 0.2, 0.28, 0.2, 0.25, 1.3, 1.6, 1.0, 1.3, 0.5, 0.5, 1.7, 2.0, 0.3, 0.2, 0.2, 0.1, 0.3, 0.1, 4.0, -1.0};
            Uli1List = new double[]{0.09, 0.15, 0.09, 0.15, 0.11, 0.15, 0.09, 0.15, 0.3, 0.3, 0.09, 0.15, 0.09, 0.15, 0.9, 1.1, 0.8, 1.0, 0.5, 0.5, 1.2, 1.4, 0.15, 0.1, 0.1, 0.05, 0.15, 0.05, 4.0, -1.0};
        } else if (Ecad2007.getIntCalcmod() == 6) {
            Uli0List = new double[]{0.25, 0.28, 0.25, 0.28, 0.25, 0.3, 0.25, 0.28, 0.5, 0.5, 0.25, 0.28, 0.25, 0.28, 1.3, 1.6, 1.0, 1.3, 0.5, 0.5, 1.7, 2.0, 0.3, 0.2, 0.2, 0.1, 0.3, 0.1, 4.0, -1.0};
            Uli1List = new double[]{0.15, 0.2, 0.15, 0.2, 0.15, 0.2, 0.15, 0.2, 0.3, 0.3, 0.15, 0.2, 0.15, 0.2, 0.9, 1.1, 0.8, 1.0, 0.5, 0.5, 1.7, 1.7, 0.15, 0.1, 0.1, 0.05, 0.15, 0.05, 4.0, -1.0};
        } else if (Ecad2007.getIntCalcmod() == 7) {
            Uli0List = new double[]{0.17, 0.25, 0.17, 0.25, 0.17, 0.25, 0.17, 0.25, 0.5, 0.5, 0.17, 0.25, 0.17, 0.25, 1.0, 1.3, 1.0, 1.3, 1.2, 1.5, 1.7, 2.0, 0.3, 0.2, 0.2, 0.15, 0.3, 0.15, 4.0, -1.0};
            Uli1List = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.3, 0.2, 0.2, 0.15, 0.3, 0.15, 4.0, -1.0};
        } else if (Ecad2007.getIntCalcmod() == 8) {
            Uli0List = new double[]{0.25, 0.28, 0.25, 0.28, 0.25, 0.28, 0.25, 0.28, 0.5, 0.5, 0.25, 0.28, 0.25, 0.28, 1.0, 1.3, 1.0, 1.3, 1.2, 1.5, 1.7, 2.0, 0.3, 0.2, 0.2, 0.15, 0.3, 0.15, 4.0, -1.0};
            Uli1List = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.3, 0.2, 0.2, 0.15, 0.3, 0.15, 4.0, -1.0};
        } else {
            res[0] = -1.0;
            res[1] = -1.0;
            res[2] = -1.0;
        }
        Uli2List = new double[]{0.4, 0.5, 0.4, 0.5, 0.4, 0.6, 0.4, 0.6, 0.4, 0.6, 0.4, 0.6, 0.4, 0.6, 2.4, 2.4, 2.4, 2.4, 0.4, 0.6, 2.4, 2.4, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, -1.0};
        if (Ecad2007.getIntCalcmod() == 7 || Ecad2007.getIntCalcmod() == 8) {
            Uli2List = (typeV & 0x40) == 64 ? new double[]{0.4, 0.5, 0.4, 0.5, 0.4, 0.6, 0.4, 0.6, 2.0, 2.0, 0.4, 0.6, 0.4, 0.6, 2.4, 2.4, 2.4, 2.4, 2.0, 2.0, 2.4, 2.4, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, -1.0} : new double[]{0.4, 0.5, 0.4, 0.5, 0.4, 0.6, 0.4, 0.6, 2.0, 2.0, 0.3, 0.6, 0.3, 0.6, 2.4, 2.4, 2.4, 2.4, 2.0, 2.0, 2.4, 2.4, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, -1.0};
        }
        Uli3List = new double[]{0.17, 0.25, 0.17, 0.25, 0.17, 0.25, 0.17, 0.25, 0.5, 0.5, 0.17, 0.25, 0.17, 0.25, 1.3, 1.6, 1.0, 1.3, 0.5, 0.5, 1.7, 2.0, 0.15, 0.1, 0.1, 0.05, 0.15, 0.05, 4.0, -1.0};
        int ii = 0;
        for (ii = 0; ii < codeList.length; ++ii) {
            if (!codeList[ii].equals(code)) continue;
            res[0] = Uli0List[ii];
            res[1] = Uli1List[ii];
            res[2] = Uli2List[ii];
            res[3] = Uli3List[ii];
            break;
        }
        if (ii < 22) {
            double TI = Ecad2007.getDM_Zone(this.ID_Z).getTI();
            double cTI = 1.0 - 0.05 * (TI - 20.0);
            double cTEm = 1.0;
            if (Ecad2007.getIntCalcmod() == 1 || Ecad2007.getIntCalcmod() == 2 || Ecad2007.getIntCalcmod() == 3 || Ecad2007.getIntCalcmod() == 4) {
                double TEm = Ecad2007.getDM_Met().getTEm();
                cTEm = 1.0;
                if (TEm < 7.0) {
                    cTEm = 1.0 - 0.02 * (7.0 - TEm);
                } else if (TEm > 10.0) {
                    cTEm = 1.0 + 0.02 * (TEm - 10.0);
                }
            }
            res[0] = res[0] * cTI * cTEm;
            res[1] = res[1] * cTI * cTEm;
        }
        return res;
    }

    public boolean deleteFromTable(Map<Integer, Envelope> map) {
        return this.dbElement.deleteFromTable(map);
    }

    public boolean deleteFromTableWithWhereClause(Map<String, Object> cvmap) {
        return this.dbElement.deleteFromTableWithWhereClause(cvmap);
    }

    public void deleteTable() {
        this.dbElement.deleteTable();
    }

    public int getFirstFreeId() {
        return this.dbElement.getFirstFreeId();
    }

    public int getFirstFreeIdByBitWiseCheck(String componentCode) {
        String[] cc = componentCode.split(",");
        String ref = "";
        String[] refs = null;
        Vector<Integer> vector = new Vector<Integer>(10);
        for (Envelope envelope : this.dmdata.values()) {
            ref = envelope.getId_c();
            refs = ref.split(",");
            if (!cc[0].equals(refs[0]) || !cc[1].equals(refs[1])) continue;
            vector.add(envelope.getId_e());
        }
        return vector.size() + 1;
    }

    public boolean insertIntoTable() {
        boolean res = false;
        res = this.dbElement.insertIntoTable(this.element);
        this.dmdata = this.dbElement.getElementData();
        return res;
    }

    public int insertIntoTable(Vector<Envelope> vector, boolean newID_E) {
        int res = -1;
        res = this.dbElement.insertIntoTable(vector, newID_E);
        this.dmdata = this.dbElement.getElementData();
        return res;
    }

    public int getBlinds(String ID_C) {
        int res = -1;
        Object[] objects = Ecad2007.getDMpr_Comp().getComponentByBitWiseCheck(ID_C, 4);
        if (objects == null) {
            return res;
        }
        Object[][] m4_mat = (Object[][])objects[10];
        Object[] row = null;
        String ref = null;
        String[] mat = null;
        int flags = 0;
        if (m4_mat == null) {
            return res;
        }
        for (int ii = 0; ii < m4_mat.length; ++ii) {
            row = null;
            ref = null;
            row = m4_mat[ii];
            if (row == null || row[0] == null && row[3] == null) break;
            for (int jj = 0; jj < 2; ++jj) {
                try {
                    ref = (String)row[3 * jj + 2];
                    mat = Ecad2007.getProjectMatLibrary().get(ref);
                    if (mat == null || ((flags = new Integer(mat[24]).intValue()) & 0x20) != 32) continue;
                    res = ii;
                }
                catch (NullPointerException npEx) {}
                break;
            }
            if (res > -1) break;
        }
        return res;
    }

    public int size() {
        return this.dbElement.size();
    }

    public boolean updateTable() {
        return this.dbElement.updateTable(this.element);
    }

    public Vector<Envelope> turnAllAZOfElements(int ref0, double delta_az) {
        Vector<Envelope> vector = new Vector<Envelope>(10);
        for (Envelope envelope : this.dmdata.values()) {
            String[] ref = envelope.getId_c().split(",");
            Double az_e = envelope.getAz_e();
            if (!ref[0].equals(String.valueOf(ref0))) continue;
            az_e = (az_e + delta_az) % (Math.PI * 2);
            envelope.setAz_e(az_e);
            vector.add(this.element);
        }
        return vector;
    }

    public boolean updateTableWithWhereClause(Map<String, Object> map, Map<String, Object> cvmap) {
        return this.dbElement.updateTableWithWhereClause(map, cvmap);
    }

    public int getIntElementValue(String id) {
        int res = 0;
        boolean test = false;
        for (int ii = 0; ii < this.intErrorString.length; ++ii) {
            if (!this.intErrorString[ii].equals(id)) continue;
            test = true;
            break;
        }
        if (test) {
            if (id == "ID_E") {
                res = this.element.getId_e();
            } else if (id == "ID_O") {
                res = this.element.getId_o();
            } else if (id == "ID_F") {
                res = this.element.getId_f();
            } else if (id == "ID_V") {
                res = this.element.getId_f();
            }
        } else {
            Globals.println(id + ": " + this.intErrorMsg);
        }
        return res;
    }

    public boolean setElementValue(String id, int value) {
        boolean res = false;
        boolean test = false;
        for (int ii = 0; ii < this.intErrorString.length; ++ii) {
            if (!this.intErrorString[ii].equals(id)) continue;
            test = true;
            break;
        }
        if (test) {
            if (id == "ID_E") {
                this.element.setId_e(value);
            } else if (id == "ID_O") {
                this.element.setId_o(value);
            } else if (id == "ID_F") {
                this.element.setId_f(value);
            } else if (id == "ID_V") {
                this.element.setId_v(value);
            } else if (id == "ID_Z") {
                this.element.setId_z(value);
            } else if (id == "CH_E") {
                this.element.setCh_e(value);
            }
        } else {
            Globals.println(this.intErrorMsg);
        }
        return res;
    }

    public int[] getBuildingOrientation() {
        double tmp;
        int ii;
        int[] res = new int[3];
        HashMap<Double, Double> f_2 = new HashMap<Double, Double>();
        HashMap<Double, Double> f_4 = new HashMap<Double, Double>();
        HashMap<Double, Double> bator = new HashMap<Double, Double>();
        if (Ecad2007.dataF == null) {
            Ecad2007.dataF = new DM_Facade(this.ID_Z);
        }
        for (Envelope envelope : this.dmdata.values()) {
            String[] ref = envelope.getId_c().split(",");
            Double az_e = envelope.getAz_e();
            if (ref[0].equals("4")) {
                int id_f = envelope.getId_f();
                az_e = new Double(Ecad2007.dataF.getAZ(id_f));
            }
            if (ref[0].equals("2") || ref[0].equals("4")) {
                if (bator.get(az_e) == null) {
                    bator.put(az_e, envelope.getA_e());
                } else {
                    double a_e = (Double)bator.get(az_e);
                    bator.put(az_e, new Double(a_e += envelope.getA_e().doubleValue()));
                }
            }
            if (ref[0].equals("2")) {
                if (f_2.get(az_e) == null) {
                    f_2.put(az_e, envelope.getA_e());
                    continue;
                }
                double a_e = (Double)f_2.get(az_e);
                f_2.put(az_e, new Double(a_e += envelope.getA_e().doubleValue()));
                continue;
            }
            if (!ref[0].equals("4")) continue;
            if (f_4.get(az_e) == null) {
                f_4.put(az_e, envelope.getA_e());
                continue;
            }
            double a_e = (Double)f_4.get(az_e);
            f_4.put(az_e, new Double(a_e += envelope.getA_e().doubleValue()));
        }
        Object[] keys = bator.keySet().toArray();
        double a_e = 0.0;
        double az_f = 0.0;
        for (ii = 0; ii < keys.length; ++ii) {
            tmp = (Double)bator.get(keys[ii]);
            if (!(tmp > a_e)) continue;
            a_e = tmp;
            az_f = Globals.getDoubleValue(keys[ii]);
        }
        res[0] = Ecad2007.getIntCalcmod() < 7 ? (int)(az_f / 0.7853981633974483 + 0.1) + 1 : (int)(az_f / 0.39269908169872414 + 0.1) + 1;
        keys = f_2.keySet().toArray();
        a_e = 0.0;
        az_f = 0.0;
        for (ii = 0; ii < keys.length; ++ii) {
            tmp = (Double)f_2.get(keys[ii]);
            if (!(tmp > a_e)) continue;
            a_e = tmp;
            az_f = Globals.getDoubleValue(keys[ii]);
        }
        res[1] = Ecad2007.getIntCalcmod() < 7 ? (int)(az_f / 0.7853981633974483 + 0.1) + 1 : (int)(az_f / 0.39269908169872414 + 0.1) + 1;
        keys = f_4.keySet().toArray();
        a_e = 0.0;
        az_f = 0.0;
        for (ii = 0; ii < keys.length; ++ii) {
            tmp = (Double)f_4.get(keys[ii]);
            if (!(tmp > a_e)) continue;
            a_e = tmp;
            az_f = Globals.getDoubleValue(keys[ii]);
        }
        res[2] = Ecad2007.getIntCalcmod() < 7 ? (int)(az_f / 0.7853981633974483 + 0.1) + 1 : (int)(az_f / 0.7853981633974483 + 0.1) + 1;
        return res;
    }

    public Map<Integer, Envelope> getElementData() {
        return this.dmdata;
    }

    public Map<Integer, Envelope> getElementDataByBitWiseCheck(String componentCode) {
        HashMap<Integer, Envelope> map = null;
        if (this.dmdata == null) {
            return map;
        }
        if (this.dmdata.size() == 0) {
            return map;
        }
        map = new HashMap<Integer, Envelope>(this.dmdata.size());
        String[] cc = componentCode.split(",");
        String[] cc0 = null;
        int cols = (int)Math.pow(2.0, cc.length) - 1;
        int COLDIM = cc.length;
        for (Envelope envelope : this.dmdata.values()) {
            int i_res = 0;
            String ref = envelope.getId_c();
            cc0 = ref.split(",");
            if (COLDIM > cc0.length) {
                COLDIM = cc0.length;
            }
            for (int jj = 0; jj < COLDIM; ++jj) {
                if (((int)Math.pow(2.0, jj) & cols) <= 0 || (Globals.getIntValue(cc0[jj]) & Globals.getIntValue(cc[jj])) <= 0) continue;
                ++i_res;
            }
            if (i_res != COLDIM) continue;
            map.put(envelope.getId_e(), envelope);
        }
        return map;
    }

    public Envelope getElement() {
        return this.element;
    }

    public boolean setElementValue(String id, double value) {
        boolean res = false;
        boolean test = false;
        for (int ii = 0; ii < this.dblErrorString.length; ++ii) {
            if (!this.dblErrorString[ii].equals(id)) continue;
            test = true;
            break;
        }
        if (test) {
            if (id == "A_E") {
                this.element.setA_e(value);
            } else if (id == "NUM_E") {
                this.element.setNum_e(value);
            } else if (id == "U_E") {
                this.element.setU_e(value);
            } else if (id == "TCH_E") {
                this.element.setTch_e(value);
            } else if (id == "UNE") {
                this.element.setUne_e(value);
            } else if (id == "RSE_E") {
                this.element.setRse_e(value);
            } else if (id == "DCH_E") {
                this.element.setDch_e(value);
            } else if (id == "ACH_E") {
                this.element.setAch_e(value);
            } else if (id == "AR_E") {
                this.element.setAr_e(value);
            } else if (id == "AZ_E") {
                this.element.setAz_e(value);
            } else if (id == "INC_E") {
                this.element.setInc_e(value);
            } else if (id == "PE_E") {
                this.element.setPe_e(value);
            } else if (id == "UP_E") {
                this.element.setUp_e(value);
            } else if (id == "DP_E") {
                this.element.setDp_e(value);
            }
        } else {
            Globals.println(this.dblErrorMsg);
        }
        return res;
    }

    public boolean setElementValue(String id, String value) {
        boolean res = false;
        boolean test = false;
        for (int ii = 0; ii < this.StringErrorString.length; ++ii) {
            if (!this.StringErrorString[ii].equals(id)) continue;
            test = true;
            break;
        }
        if (test) {
            if (id == "ID_C") {
                this.element.setId_c(value);
            } else if (id == "NOM_E") {
                this.element.setNom_e(value);
            }
        } else {
            Globals.println(this.StringErrorMsg);
        }
        return res;
    }
}

