/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.hibernate.pro.db.Envelope;
import enercad2007.DB_Facade;
import enercad2007.DM_Element;
import enercad2007.DM_Shade;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.Map;
import java.util.Set;

public class DM_Facade {
    int idZ = 0;
    double rTSRE;
    DB_Facade db_facade;

    public DM_Facade() {
        this.db_facade = new DB_Facade(this.idZ);
    }

    public DM_Facade(int idZ) {
        this.idZ = idZ;
        this.db_facade = new DB_Facade(this.idZ);
    }

    public int[] getFacadeIds() {
        Map<Integer, Object[]> rows = this.db_facade.getRows();
        int dim = rows.size();
        int[] table = null;
        if (dim > 0) {
            table = new int[dim];
            Object[] keys = rows.keySet().toArray();
            for (int ii = 0; ii < dim; ++ii) {
                table[ii] = Globals.getIntValue(keys[ii]);
            }
        }
        return table;
    }

    public int getAZId(int id_F) {
        Map<Integer, Object[]> rows = this.db_facade.getRows();
        Object[] object = rows.get(id_F);
        int res = -1;
        if (object != null) {
            if (Ecad2007.getIntCalcmod() < 7) {
                res = Globals.getIntValue(object[1]);
                if (res > 8) {
                    res -= 8;
                }
            } else {
                int idDlgNewFront = Globals.getIntValue(object[1]);
                res = Globals.DLGNEWF2DMF[idDlgNewFront];
            }
        }
        return res;
    }

    public void turnAllAZId(int deltaAZ_F) {
        Map<Integer, Object[]> rows = this.db_facade.getRows();
        Set<Integer> set = rows.keySet();
        Object[] objects = set.toArray();
        int az = 8;
        if (Ecad2007.getIntCalcmod() >= 7) {
            az = 16;
        }
        for (int ii = 0; ii < set.size(); ++ii) {
            Integer Id_F = (Integer)objects[ii];
            Object[] object = rows.remove(Id_F);
            if (object[1] == null) continue;
            int az_f = Globals.getIntValue(object[1]);
            if ((az_f = (az_f + deltaAZ_F) % az) < 0) {
                az_f = az + az_f;
            }
            if (az_f == 0) {
                az_f = az;
            } else if (az_f == az) {
                az_f = deltaAZ_F > 0 ? az : 1;
            }
            object[1] = new Integer(az_f);
            rows.put(Id_F, object);
        }
        if (set.size() > 0) {
            this.db_facade.setRows(rows);
        }
    }

    public double getAZ(int Id_F) {
        Map<Integer, Object[]> rows = this.db_facade.getRows();
        Object[] object = rows.get(new Integer(Id_F));
        if (object == null) {
            return 0.0;
        }
        if (Ecad2007.getIntCalcmod() < 7) {
            return 0.7853981633974483 * (double)(Globals.getIntValue(object[1]) - 1);
        }
        int idDlgNewFront = Globals.getIntValue(object[1]);
        int idDf = Globals.DLGNEWF2DMF[idDlgNewFront];
        return 0.39269908169872414 * (double)(idDf - 1);
    }

    public String getName(int id_f) {
        Map<Integer, Object[]> rows = this.db_facade.getRows();
        Object[] object = rows.get(id_f);
        if (object == null) {
            return null;
        }
        return object[0].toString();
    }

    public double getFs1TxVitMax() {
        double Fs1VitMax = 0.0;
        double txVitMax = 0.0;
        int id_az = 9;
        double[][] res = null;
        if (Ecad2007.getIntCalcmod() < 7) {
            res = this.getSIA_T3();
        } else {
            res = this.getSIA2016_T3();
            id_az = 17;
        }
        for (int ii = 0; ii < id_az; ++ii) {
            if (!(res[3][ii] > txVitMax)) continue;
            txVitMax = res[3][ii];
            Fs1VitMax = res[4][ii];
        }
        return Fs1VitMax;
    }

    public double[] getRES_F(int ID_F) {
        if (Ecad2007.getDM_Element(this.idZ) == null) {
            Ecad2007.setDM_Element(this.idZ, new DM_Element(this.idZ));
        }
        Map<Integer, Envelope> dmdata = Ecad2007.getDM_Element(this.idZ).getElementData();
        double sumA_opaque = 0.0;
        double sumA_translucide = 0.0;
        double sumFs2 = 0.0;
        double sumFs3 = 0.0;
        for (Envelope envelope : dmdata.values()) {
            int selectedID_F = envelope.getId_f();
            if (selectedID_F != ID_F) continue;
            String selectedID_C = envelope.getId_c();
            String[] cc = selectedID_C.split(",");
            int selectedTYPE_F = Integer.parseInt(cc[0]);
            int selectedTYPE_C = Integer.parseInt(cc[1]);
            int selectedTYPE_V = Integer.parseInt(cc[2]);
            double selectedA_E = envelope.getA_e();
            double selectedNUM_E = envelope.getNum_e();
            double selectedAZ_E = envelope.getAz_e();
            double selectedINC_E = envelope.getInc_e();
            int selectedID_O = envelope.getId_o();
            double selectedFs2_E = Ecad2007.dataO.getShadeAOH(selectedID_O);
            double selectedFs3_E = Ecad2007.dataO.getShadeASF(selectedID_O);
            if (selectedTYPE_C == 1) {
                sumA_opaque += selectedA_E * selectedNUM_E;
                continue;
            }
            sumA_translucide += selectedA_E * selectedNUM_E;
            sumFs2 += selectedA_E * selectedNUM_E * selectedFs2_E;
            sumFs3 += selectedA_E * selectedNUM_E * selectedFs3_E;
        }
        double[] res = new double[8];
        res[0] = sumA_opaque;
        res[1] = sumA_translucide;
        res[2] = sumA_translucide + sumA_opaque;
        res[3] = sumA_translucide / (sumA_translucide + sumA_opaque);
        Map<Integer, Object[]> map = this.db_facade.getRows();
        int AZ_F = Globals.getIntValue(map.get(new Integer(ID_F)));
        double[] FS_B = Ecad2007.getDM_Pro().getFs1();
        res[4] = FS_B[AZ_F];
        res[5] = sumFs2 / sumA_translucide;
        res[6] = sumFs3 / sumA_translucide;
        res[7] = res[4] * res[5] * res[6];
        Globals.println("Fa\u00e7ade " + ID_F + " tableau 3: surface = " + res[2] + " taux de vitrage = " + res[3] + " Fs1: " + res[4]);
        return res;
    }

    public double[][] getSIA_T3() {
        if (Ecad2007.getDM_Element(this.idZ) == null) {
            Ecad2007.setDM_Element(this.idZ, new DM_Element(this.idZ));
        }
        Map<Integer, Envelope> dmdata = Ecad2007.getDM_Element(this.idZ).getElementData();
        double[][] res = new double[8][11];
        int iAZ = 0;
        double[] sumA_opaque = new double[10];
        double[] sumA_translucide = new double[10];
        double[] sumFs2 = new double[10];
        double[] sumFs3 = new double[10];
        for (Envelope envelope : dmdata.values()) {
            int selectedID_F = envelope.getId_f();
            String selectedID_C = envelope.getId_c();
            String[] cc = selectedID_C.split(",");
            int selectedTYPE_F = Integer.parseInt(cc[0]);
            int selectedTYPE_C = Integer.parseInt(cc[1]);
            int selectedTYPE_V = Integer.parseInt(cc[2]);
            double selectedA_E = envelope.getA_e();
            double selectedNUM_E = envelope.getNum_e();
            double selectedAZ_E = envelope.getAz_e();
            if (selectedTYPE_F == 1 || selectedTYPE_F == 2) {
                iAZ = 0;
            } else if (selectedTYPE_F == 4) {
                iAZ = Ecad2007.dataF.getAZId(selectedID_F);
            } else if (selectedTYPE_F == 8) {
                iAZ = 9;
            }
            if (selectedTYPE_C == 1) {
                int n = iAZ;
                sumA_opaque[n] = sumA_opaque[n] + selectedA_E * selectedNUM_E;
                continue;
            }
            if (selectedTYPE_C != 2) continue;
            int n = iAZ;
            sumA_translucide[n] = sumA_translucide[n] + selectedA_E * selectedNUM_E;
            if (selectedTYPE_F == 4) {
                if (Ecad2007.dataO == null) {
                    Ecad2007.dataO = new DM_Shade();
                }
                int selectedID_O = envelope.getId_o();
                double selectedFs2_E = Ecad2007.dataO.getFs2(Ecad2007.dataO.getShadeAOH(selectedID_O), selectedAZ_E, 1.5707963267948966);
                double selectedFs3_E = Ecad2007.dataO.getFs3(Ecad2007.dataO.getShadeASF(selectedID_O), selectedAZ_E, 1.5707963267948966);
                int n2 = iAZ;
                sumFs2[n2] = sumFs2[n2] + selectedA_E * selectedNUM_E * selectedFs2_E;
                int n3 = iAZ;
                sumFs3[n3] = sumFs3[n3] + selectedA_E * selectedNUM_E * selectedFs3_E;
                continue;
            }
            if (selectedTYPE_F != 1 && selectedTYPE_F != 2) continue;
            int n4 = iAZ;
            sumFs2[n4] = sumFs2[n4] + selectedA_E * selectedNUM_E;
            int n5 = iAZ;
            sumFs3[n5] = sumFs3[n5] + selectedA_E * selectedNUM_E;
        }
        double[] FS_B = Ecad2007.getDM_Pro().getFs1();
        for (iAZ = 0; iAZ < 10; ++iAZ) {
            res[0][iAZ] = sumA_opaque[iAZ];
            res[1][iAZ] = sumA_translucide[iAZ];
            res[2][iAZ] = sumA_translucide[iAZ] + sumA_opaque[iAZ];
            res[3][iAZ] = sumA_translucide[iAZ] + sumA_opaque[iAZ] > 0.0 ? sumA_translucide[iAZ] / (sumA_translucide[iAZ] + sumA_opaque[iAZ]) : 0.0;
            if (iAZ >= 9) continue;
            res[4][iAZ] = FS_B[iAZ];
            if (sumA_translucide[iAZ] > 0.0) {
                res[5][iAZ] = sumFs2[iAZ] / sumA_translucide[iAZ];
                res[6][iAZ] = sumFs3[iAZ] / sumA_translucide[iAZ];
            } else {
                res[5][iAZ] = 0.0;
                res[6][iAZ] = 0.0;
            }
            res[7][iAZ] = res[4][iAZ] * res[5][iAZ] * res[6][iAZ];
        }
        for (iAZ = 0; iAZ < 10; ++iAZ) {
            double[] dArray = res[0];
            dArray[10] = dArray[10] + res[0][iAZ];
            double[] dArray2 = res[1];
            dArray2[10] = dArray2[10] + res[1][iAZ];
            double[] dArray3 = res[2];
            dArray3[10] = dArray3[10] + res[2][iAZ];
            double[] dArray4 = res[3];
            dArray4[10] = dArray4[10] + res[3][iAZ] * res[2][iAZ];
            double[] dArray5 = res[4];
            dArray5[10] = dArray5[10] + res[4][iAZ] * res[1][iAZ];
            double[] dArray6 = res[5];
            dArray6[10] = dArray6[10] + res[5][iAZ] * res[1][iAZ];
            double[] dArray7 = res[6];
            dArray7[10] = dArray7[10] + res[6][iAZ] * res[1][iAZ];
            double[] dArray8 = res[7];
            dArray8[10] = dArray8[10] + res[7][iAZ] * res[1][iAZ];
        }
        if (res[2][10] > 0.0) {
            res[3][10] = res[3][10] / res[2][10];
        }
        if (res[1][10] > 0.0) {
            res[4][10] = res[4][10] / res[1][10];
            res[5][10] = res[5][10] / res[1][10];
            res[6][10] = res[6][10] / res[1][10];
            res[7][10] = res[7][10] / res[1][10];
        }
        this.rTSRE = res[1][10] / Ecad2007.getDM_Zone(0).getSRE();
        return res;
    }

    public double[][] getSIA2016_T3() {
        if (Ecad2007.getDM_Element(this.idZ) == null) {
            Ecad2007.setDM_Element(this.idZ, new DM_Element(this.idZ));
        }
        Map<Integer, Envelope> dmdata = Ecad2007.getDM_Element(this.idZ).getElementData();
        double[][] res = new double[11][19];
        int iAZ = 0;
        double[] sumA_opaque_ext = new double[18];
        double[] sumA_translucide_ext = new double[18];
        double[] sumA_translucide = new double[18];
        double[] sumA_nonchauffe = new double[18];
        double[] sumA_terrain = new double[18];
        double[] sumA_mitoyens = new double[18];
        double[] sumFs2 = new double[18];
        double[] sumFs3 = new double[18];
        double[] pond_b = new double[18];
        for (Envelope envelope : dmdata.values()) {
            int selectedID_F = envelope.getId_f();
            String selectedID_C = envelope.getId_c();
            String[] cc = selectedID_C.split(",");
            int selectedTYPE_F = Globals.getIntValue(cc[0]);
            int selectedTYPE_C = Globals.getIntValue(cc[1]);
            int selectedTYPE_V = Globals.getIntValue(cc[2]);
            double selectedA_E = envelope.getA_e();
            double selectedNUM_E = envelope.getNum_e();
            double selectedAZ_E = envelope.getAz_e();
            Map<String, Object> map = Ecad2007.getDM_Element(this.idZ).getCalcE(envelope);
            double[][] res_E = (double[][])map.get("res_E");
            if (selectedTYPE_F == 1 || selectedTYPE_F == 2) {
                iAZ = 0;
            } else if (selectedTYPE_F == 4) {
                iAZ = Ecad2007.dataF.getAZId(selectedID_F);
            } else if (selectedTYPE_F == 8) {
                iAZ = 17;
            } else {
                System.out.println("aha");
            }
            if (selectedTYPE_C == 1) {
                Globals.println("DM_Facade.getSIA2016_T3 selectedTypeC: 1 iAZ: " + iAZ + " selectedID_F: " + selectedID_F);
                if (selectedTYPE_V == 1) {
                    int n = iAZ;
                    sumA_opaque_ext[n] = sumA_opaque_ext[n] + selectedA_E * selectedNUM_E;
                    continue;
                }
                if (selectedTYPE_V == 2 || selectedTYPE_V == 4) {
                    int n = iAZ;
                    sumA_nonchauffe[n] = sumA_nonchauffe[n] + selectedA_E * selectedNUM_E;
                    pond_b[iAZ] = res_E[2][1] * selectedA_E * selectedNUM_E;
                    continue;
                }
                if (selectedTYPE_V == 8) {
                    int n = iAZ;
                    sumA_mitoyens[n] = sumA_mitoyens[n] + selectedA_E * selectedNUM_E;
                    continue;
                }
                if (selectedTYPE_V != 64) continue;
                int n = iAZ;
                sumA_terrain[n] = sumA_terrain[n] + selectedA_E * selectedNUM_E;
                pond_b[iAZ] = res_E[2][1] * selectedA_E * selectedNUM_E;
                continue;
            }
            if (selectedTYPE_C != 2) continue;
            Globals.println("DM_Facade.getSIA2016_T3 selectedTypeC: 2 iAZ: " + iAZ + " selectedID_F: " + selectedID_F);
            if (selectedTYPE_V == 1) {
                int n = iAZ;
                sumA_translucide_ext[n] = sumA_translucide_ext[n] + selectedA_E * selectedNUM_E;
            } else if (selectedTYPE_V == 2 || selectedTYPE_V == 4) {
                int n = iAZ;
                sumA_nonchauffe[n] = sumA_nonchauffe[n] + selectedA_E * selectedNUM_E;
                pond_b[iAZ] = res_E[2][1] * selectedA_E * selectedNUM_E;
            } else if (selectedTYPE_V == 8) {
                int n = iAZ;
                sumA_mitoyens[n] = sumA_mitoyens[n] + selectedA_E * selectedNUM_E;
            }
            if (selectedTYPE_V != 1) continue;
            if (selectedTYPE_F == 4) {
                int n = iAZ;
                sumA_translucide[n] = sumA_translucide[n] + selectedA_E * selectedNUM_E;
                if (Ecad2007.dataO == null) {
                    Ecad2007.dataO = new DM_Shade();
                }
                int selectedID_O = envelope.getId_o();
                double selectedFs2_E = Ecad2007.dataO.getFs2(Ecad2007.dataO.getShadeAOH(selectedID_O), selectedAZ_E, 1.5707963267948966);
                double selectedFs3_E = Ecad2007.dataO.getFs3(Ecad2007.dataO.getShadeASF(selectedID_O), selectedAZ_E, 1.5707963267948966);
                int n2 = iAZ;
                sumFs2[n2] = sumFs2[n2] + selectedA_E * selectedNUM_E * selectedFs2_E;
                int n3 = iAZ;
                sumFs3[n3] = sumFs3[n3] + selectedA_E * selectedNUM_E * selectedFs3_E;
                continue;
            }
            if (selectedTYPE_F != 1 && selectedTYPE_F != 2) continue;
            int n = iAZ;
            sumA_translucide[n] = sumA_translucide[n] + selectedA_E * selectedNUM_E;
            int n4 = iAZ;
            sumFs2[n4] = sumFs2[n4] + selectedA_E * selectedNUM_E;
            int n5 = iAZ;
            sumFs3[n5] = sumFs3[n5] + selectedA_E * selectedNUM_E;
        }
        double[] FS_B = Ecad2007.getDM_Pro().getFs1();
        for (iAZ = 0; iAZ < 18; ++iAZ) {
            res[0][iAZ] = sumA_opaque_ext[iAZ];
            res[1][iAZ] = sumA_translucide_ext[iAZ];
            res[2][iAZ] = sumA_nonchauffe[iAZ];
            res[3][iAZ] = sumA_terrain[iAZ];
            res[4][iAZ] = sumA_mitoyens[iAZ];
            res[5][iAZ] = sumA_opaque_ext[iAZ] + sumA_terrain[iAZ] + sumA_translucide_ext[iAZ] + sumA_nonchauffe[iAZ] + sumA_mitoyens[iAZ];
            if (iAZ < 17) {
                res[6][iAZ] = sumA_translucide_ext[iAZ] + sumA_opaque_ext[iAZ] > 0.0 ? sumA_translucide_ext[iAZ] / (sumA_translucide_ext[iAZ] + sumA_opaque_ext[iAZ]) : 0.0;
                res[7][iAZ] = FS_B[iAZ];
                if (sumA_translucide[iAZ] > 0.0) {
                    res[8][iAZ] = sumFs2[iAZ] / sumA_translucide[iAZ];
                    res[9][iAZ] = sumFs3[iAZ] / sumA_translucide[iAZ];
                } else {
                    res[8][iAZ] = 1.0;
                    res[9][iAZ] = 1.0;
                }
            }
            res[10][iAZ] = pond_b[iAZ] > 0.0 ? pond_b[iAZ] / (sumA_nonchauffe[iAZ] + sumA_terrain[iAZ]) : 0.0;
        }
        for (iAZ = 0; iAZ < 18; ++iAZ) {
            double[] dArray = res[0];
            dArray[18] = dArray[18] + res[0][iAZ];
            double[] dArray2 = res[1];
            dArray2[18] = dArray2[18] + res[1][iAZ];
            double[] dArray3 = res[2];
            dArray3[18] = dArray3[18] + res[2][iAZ];
            double[] dArray4 = res[3];
            dArray4[18] = dArray4[18] + res[3][iAZ];
            double[] dArray5 = res[4];
            dArray5[18] = dArray5[18] + res[4][iAZ];
            double[] dArray6 = res[5];
            dArray6[18] = dArray6[18] + res[5][iAZ];
        }
        this.rTSRE = res[1][18] / Ecad2007.getDM_Zone(0).getSRE();
        return res;
    }

    public double getRTSRE() {
        return this.rTSRE;
    }

    public Map<Integer, Object[]> getRows() {
        return this.db_facade.getRows();
    }

    public boolean insertValue(int idFacade, String facadeName, int orientation) {
        return this.db_facade.insertIntoTable(facadeName, this.idZ, idFacade, orientation);
    }

    public boolean updateValue(int idFacade, String facadeName, int orientation) {
        return this.db_facade.updateTable(facadeName, this.idZ, idFacade, orientation);
    }

    public boolean updateRows() {
        return this.db_facade.updateTable();
    }

    public boolean deleteFront(int idF) {
        return this.db_facade.deleteFront(idF);
    }

    public boolean deleteTable() {
        return this.db_facade.deleteTable();
    }
}

