/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.hibernate.cat.dao.HibernateHelpDao;
import core.hibernate.cat.db.Help;
import enercad2007.Ecad2007;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DM_Help
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String groupe;
    protected int code;
    protected int lan = Ecad2007.getCodeLan();
    TreeMap<String, Object[]> tm_help = new TreeMap();
    String xml = System.getProperty("hibernate.conf.file.name");

    public DM_Help() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DM_Help(String group, int code) {
        this.groupe = group;
        this.code = code;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Help(String groupe) {
        this.groupe = groupe;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String path = System.getProperty("ecad.home.dir");
        File cat = new File(path + "data" + File.separator + "cat");
        if (cat.exists()) {
            HibernateHelpDao hb_help = null;
            hb_help = this.xml == null ? new HibernateHelpDao() : new HibernateHelpDao(this.xml);
            List<Help> list = null;
            list = this.groupe == null ? hb_help.getHelpList() : (this.groupe.trim().equals("") ? hb_help.getHelpList() : hb_help.getHelpList(this.groupe));
            if (list == null) {
                return;
            }
            for (Help help : list) {
                Object[] row = new Object[]{help.getGe(), help.getFr(), help.getIt(), help.getEn()};
                this.tm_help.put(help.getCdelan(), row);
            }
        }
    }

    public String getCodeLan(String code) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
        }
        return res;
    }

    public String getCodeLan(String code, Object defaultValue) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null) {
            return (String)defaultValue;
        }
        res = (String)object[this.lan];
        res = res != null ? res.replaceAll("\\\\n", "\n") : (String)defaultValue;
        return res;
    }

    public String getCodeLan(String code, String replacement) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
            res = res.replaceAll("\\\\s", replacement);
        }
        return res;
    }

    public String getCodeLan(String code, String[] replacement) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
            for (int cter = 0; cter < replacement.length; ++cter) {
                res = res.replaceFirst("\\\\s", replacement[cter]);
            }
        }
        return res;
    }

    public String getCodeLan(String code, String replacement, boolean b_all) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[Ecad2007.getCodeLan()];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
            res = b_all ? res.replaceAll("\\\\s", replacement) : res.replaceFirst("\\\\s", replacement);
        }
        return res;
    }

    public String getCodeLan(String code, String def, String[] replacement) {
        String res = "";
        Object[] object = this.tm_help.get(code);
        if (object == null && def != null) {
            res = def;
        }
        if (res.equals("")) {
            res = (String)object[this.lan];
        }
        res = res.replaceAll("\\\\n", "\n");
        for (int cter = 0; cter < replacement.length; ++cter) {
            res = res.replaceFirst("\\\\s", replacement[cter]);
        }
        return res;
    }

    public Map<String, Object[]> getTreeMap() {
        return this.tm_help;
    }

    public int getLan() {
        return this.lan;
    }

    public void setLan(int lan) {
        this.lan = lan;
    }

    public int size() {
        return this.tm_help.size();
    }
}

