/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Calc_Met;
import enercad2007.DB_met;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DM_Met {
    int lan = Ecad2007.getCodeLan();
    int[] jj = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    int ID_MET;
    String NOM_M;
    double LAT;
    double LON;
    double ALT_M;
    String CANTON;
    double TMin;
    double[] TE = new double[12];
    double TEm;
    double[][] Gs = new double[9][12];
    double[][] Gs2016 = new double[17][12];
    String SRC_M;
    DB_met db_met;
    Calc_Met calc_met;
    ArrayList<String> al_src;
    Map dm_sia;
    Map<String, double[]> dm_data;
    Map<String, int[][]> map_minids = new HashMap<String, int[][]>(27);
    Map<String, Integer> map_minct = new HashMap<String, Integer>(27);

    public DM_Met() {
        this.calc_met = new Calc_Met();
        int size = this.map_minids.size();
        if (size == 0) {
            this.loadMinergieData();
        }
    }

    public DM_Met(String ID_MET) {
        this.db_met = new DB_met("int", ID_MET);
        this.calc_met = new Calc_Met();
        this.al_src = this.db_met.getMetSrc();
        this.dm_sia = this.db_met.getMetSia();
        this.dm_data = this.db_met.getMetData();
        int size = this.loadMet();
        if (size == 0) {
            this.db_met = new DB_met("int", "");
            this.al_src = this.db_met.getMetSrc();
            this.dm_sia = this.db_met.getMetSia();
            this.dm_data = null;
        }
        if ((size = this.map_minids.size()) == 0) {
            this.loadMinergieData();
        }
    }

    public DM_Met(String ie, String ID_MET) {
        this.db_met = new DB_met(ie, ID_MET);
        this.calc_met = new Calc_Met();
        this.al_src = this.db_met.getMetSrc();
        this.dm_sia = this.db_met.getMetSia();
        if (!ID_MET.equals("") && !ID_MET.startsWith("-1,0")) {
            this.dm_data = this.db_met.getMetData();
            this.loadMet();
        }
    }

    public int loadMet() {
        int res = 0;
        if (this.dm_sia != null) {
            res = this.dm_sia.size();
            if (this.dm_sia.get("id_met") != null) {
                this.ID_MET = Globals.getIntValue(this.dm_sia.get("id_met"), -1);
                this.CANTON = (String)this.dm_sia.get("canton");
                this.LAT = Globals.getDoubleValue(this.dm_sia.get("lat"));
                this.LON = Globals.getDoubleValue(this.dm_sia.get("lon"));
                this.ALT_M = Globals.getDoubleValue(this.dm_sia.get("alt"));
                this.TMin = Globals.getDoubleValue(this.dm_sia.get("te_min"));
                this.SRC_M = (String)this.dm_sia.get("src");
            }
        }
        if (this.dm_data != null && this.dm_data.size() > 0) {
            this.TE = this.dm_data.get("TE");
            this.Gs[0] = this.dm_data.get("GH");
            this.Gs[1] = this.dm_data.get("GN");
            this.Gs[3] = this.dm_data.get("GE");
            this.Gs[5] = this.dm_data.get("GS");
            this.Gs[7] = this.dm_data.get("GW");
            for (int ii = 2; ii < 9; ii += 2) {
                for (int mm = 0; mm < 12; ++mm) {
                    this.Gs[ii][mm] = Math.sqrt(this.Gs[(ii - 1) % 8][mm] * this.Gs[(ii + 1) % 8][mm]);
                }
            }
            this.Gs2016[0] = this.dm_data.get("GH2016");
            this.Gs2016[1] = this.dm_data.get("GN2016");
            this.Gs2016[5] = this.dm_data.get("GE2016");
            this.Gs2016[9] = this.dm_data.get("GS2016");
            this.Gs2016[13] = this.dm_data.get("GW2016");
            for (int mm = 0; mm < 12; ++mm) {
                this.Gs2016[2][mm] = Math.sqrt(this.Gs2016[1][mm] * Math.sqrt(this.Gs2016[1][mm] * this.Gs2016[5][mm]));
                this.Gs2016[3][mm] = Math.sqrt(this.Gs2016[1][mm] * this.Gs2016[5][mm]);
                this.Gs2016[4][mm] = Math.sqrt(this.Gs2016[5][mm] * Math.sqrt(this.Gs2016[1][mm] * this.Gs2016[5][mm]));
                this.Gs2016[6][mm] = Math.sqrt(this.Gs2016[5][mm] * Math.sqrt(this.Gs2016[5][mm] * this.Gs2016[9][mm]));
                this.Gs2016[7][mm] = Math.sqrt(this.Gs2016[5][mm] * this.Gs2016[9][mm]);
                this.Gs2016[8][mm] = Math.sqrt(this.Gs2016[9][mm] * Math.sqrt(this.Gs2016[9][mm] * this.Gs2016[5][mm]));
                this.Gs2016[10][mm] = Math.sqrt(this.Gs2016[9][mm] * Math.sqrt(this.Gs2016[9][mm] * this.Gs2016[13][mm]));
                this.Gs2016[11][mm] = Math.sqrt(this.Gs2016[9][mm] * this.Gs2016[13][mm]);
                this.Gs2016[12][mm] = Math.sqrt(this.Gs2016[13][mm] * Math.sqrt(this.Gs2016[9][mm] * this.Gs2016[13][mm]));
                this.Gs2016[14][mm] = Math.sqrt(this.Gs2016[13][mm] * Math.sqrt(this.Gs2016[1][mm] * this.Gs2016[13][mm]));
                this.Gs2016[15][mm] = Math.sqrt(this.Gs2016[13][mm] * this.Gs2016[1][mm]);
                this.Gs2016[16][mm] = Math.sqrt(this.Gs2016[1][mm] * Math.sqrt(this.Gs2016[1][mm] * this.Gs2016[13][mm]));
            }
        }
        return res;
    }

    private void loadMinergieData() {
        this.map_minids.put("AG", new int[][]{{65, 63}, {2, 3}});
        this.map_minids.put("AI", new int[][]{{90}, {2}});
        this.map_minids.put("AR", new int[][]{{90}, {2}});
        this.map_minids.put("BE", new int[][]{{64, 60}, {2, 3}});
        this.map_minids.put("BL", new int[][]{{63}, {2}});
        this.map_minids.put("BS", new int[][]{{63}, {2}});
        this.map_minids.put("FR", new int[][]{{64, 60}, {2, 3}});
        this.map_minids.put("GE", new int[][]{{70}, {2}});
        this.map_minids.put("GL", new int[][]{{71}, {2}});
        this.map_minids.put("GR", new int[][]{{66, 65, 66, 84, 90, 86}, {2, 3, 4, 5, 6, 7}});
        this.map_minids.put("JU", new int[][]{{75}, {2}});
        this.map_minids.put("LU", new int[][]{{79}, {2}});
        this.map_minids.put("NE", new int[][]{{82, 73}, {2, 3}});
        this.map_minids.put("NW", new int[][]{{79}, {2, 3}});
        this.map_minids.put("OW", new int[][]{{79, 67}, {2, 3}});
        this.map_minids.put("SG", new int[][]{{90}, {2}});
        this.map_minids.put("SH", new int[][]{{91}, {2}});
        this.map_minids.put("SO", new int[][]{{96}, {2}});
        this.map_minids.put("SZ", new int[][]{{99}, {2}});
        this.map_minids.put("TG", new int[][]{{73}, {2}});
        this.map_minids.put("TI", new int[][]{{77, 78, 80, 86, 89}, {2, 3, 4, 5, 6}});
        this.map_minids.put("UR", new int[][]{{62}, {2}});
        this.map_minids.put("VD", new int[][]{{83, 75, 60}, {2, 3, 4}});
        this.map_minids.put("VS", new int[][]{{93, 97, 81, 72}, {2, 3, 4, 5}});
        this.map_minids.put("ZG", new int[][]{{79}, {2}});
        this.map_minids.put("ZH", new int[][]{{99}, {2}});
        this.map_minids.put("LI", new int[][]{{95, 69}, {2, 3}});
        this.map_minct.put("AG", 2);
        this.map_minct.put("AI", 3);
        this.map_minct.put("AR", 4);
        this.map_minct.put("BE", 5);
        this.map_minct.put("BL", 6);
        this.map_minct.put("BS", 7);
        this.map_minct.put("FR", 8);
        this.map_minct.put("GE", 9);
        this.map_minct.put("GL", 10);
        this.map_minct.put("GR", 11);
        this.map_minct.put("JU", 12);
        this.map_minct.put("LU", 13);
        this.map_minct.put("NE", 14);
        this.map_minct.put("NW", 15);
        this.map_minct.put("OW", 16);
        this.map_minct.put("SG", 17);
        this.map_minct.put("SH", 18);
        this.map_minct.put("SO", 19);
        this.map_minct.put("SZ", 20);
        this.map_minct.put("TG", 21);
        this.map_minct.put("TI", 22);
        this.map_minct.put("UR", 23);
        this.map_minct.put("VD", 24);
        this.map_minct.put("VS", 25);
        this.map_minct.put("ZG", 26);
        this.map_minct.put("ZH", 27);
        this.map_minct.put("LI", 28);
    }

    public String[] getNomMois() {
        return this.getNomMois(this.lan);
    }

    public String[] getNomMois(int lan) {
        String[][] nomMois = new String[][]{{"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"}, {"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"}, {"G", "F", "M", "A", "M", "J", "L", "A", "S", "O", "N", "D"}, {"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"}};
        return nomMois[lan];
    }

    public String[] getNomMoisLong() {
        return this.getNomMoisLong(this.lan);
    }

    public String[] getNomMoisLong(int lan) {
        String[][] MoisLong = new String[][]{{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"}, {"Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre"}, {"Gennaio", "Febbraio", "Marzo", "Aprile", "Mai", "Jiugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"}, {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}};
        return MoisLong[lan];
    }

    public String[] getNomMoisShort() {
        String[][] MoisShort = new String[][]{{"Jan", "Feb", "M\u00e4r", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"}, {"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c"}, {"Gen", "Feb", "Mar", "Apr", "Mai", "Jiu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"}, {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}};
        return MoisShort[this.lan];
    }

    public double getGs(int nn, int mm) {
        if (Ecad2007.getIntCalcmod() < 7) {
            return this.Gs[nn][mm];
        }
        return this.Gs2016[nn][mm];
    }

    public int[] getJ() {
        return this.jj;
    }

    public double[] getTE() {
        return this.TE;
    }

    public double getTMin() {
        return this.TMin;
    }

    public int getID_MET() {
        int res = Globals.getIntValue(this.dm_sia.get("id_met"), -1);
        return res;
    }

    public String getNOM_MET() {
        String res = (String)this.dm_sia.get("nom_met");
        return res;
    }

    public String getCanton() {
        String res = Globals.getStringValue(this.dm_sia.get("canton"));
        return res;
    }

    public String getSRC_M() {
        String res = (String)this.dm_sia.get("src");
        return res;
    }

    public double getTEm() {
        this.TEm = 0.0;
        for (int mm = 0; mm < 12; ++mm) {
            this.TEm += (double)this.jj[mm] * this.TE[mm];
        }
        this.TEm /= 365.0;
        return this.TEm;
    }

    public double getfC() {
        if (Ecad2007.getIntCalcmod() == 5 || Ecad2007.getIntCalcmod() == 6) {
            return 1.0 - 0.08 * (this.TEm - 8.5);
        }
        if (Ecad2007.getIntCalcmod() == 7 || Ecad2007.getIntCalcmod() == 8) {
            return 1.0 - 0.06 * (this.TEm - 9.4);
        }
        return 1.0 - 0.04 * (this.TEm - 8.5);
    }

    public double getLAT() {
        return this.LAT;
    }

    public double getLATrad() {
        return this.LAT * Math.PI / 180.0;
    }

    public double getALT_M() {
        return this.ALT_M;
    }

    public void testG_E() {
        System.out.println("DM_Met : Rayonnements et transposition");
        int i = 0;
        for (double AZ = 0.0; AZ <= Math.PI * 2; AZ += 0.7853981633974483) {
            for (double INC = 0.0; INC <= 1.5707963267948966; INC += 0.7853981633974483) {
                i = (int)(Math.round(AZ * 180.0 / Math.PI / 45.0) % 8L) + 1;
                Globals.print("az: " + Math.round(AZ * 180.0 / Math.PI) + " inc: " + Math.round(INC * 180.0 / Math.PI) + " Fs1: " + Ecad2007.getDM_Pro().getFs1()[i] + " G_E: ");
                for (int m = 0; m < 12; ++m) {
                    System.out.print(Math.round(this.getG_E(AZ, INC)[m]) + " ");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public double[] getG_E(double paz, double inc) {
        double[] G_E = new double[12];
        double[] Fs1 = Ecad2007.getDM_Pro().getFs1();
        int calcmod = Ecad2007.getIntCalcmod();
        if (inc < 0.17453292519943295) {
            if (calcmod < 7) {
                for (int mm = 0; mm < 12; ++mm) {
                    G_E[mm] = this.Gs[0][mm] * Fs1[0];
                }
            } else {
                for (int mm = 0; mm < 12; ++mm) {
                    G_E[mm] = this.Gs2016[0][mm] * Fs1[0];
                }
            }
        } else if (inc > 1.3962634015954636) {
            if (calcmod < 7) {
                int ii = (int)(Math.round(paz * 180.0 / Math.PI / 45.0) % 8L) + 1;
                for (int mm = 0; mm < 12; ++mm) {
                    G_E[mm] = this.Gs[ii][mm] * Fs1[ii];
                }
            } else {
                int ii = (int)(Math.round(paz * 180.0 / Math.PI / 22.5) % 16L) + 1;
                for (int mm = 0; mm < 12; ++mm) {
                    G_E[mm] = this.Gs2016[ii][mm] * Fs1[ii];
                }
            }
        } else {
            double albedo = 0.2;
            int[] DOY = new int[]{17, 47, 75, 105, 135, 162, 198, 228, 258, 288, 318, 344};
            double ahs = 0.0;
            double Oz = 0.0;
            Map<Object, Object> res = new HashMap(10);
            double alt = Ecad2007.getDM_Pro().getALT_B() / 1000.0;
            double lat = Ecad2007.getDM_Met().getLATrad();
            for (int mm = 0; mm < 12; ++mm) {
                int doy = DOY[mm];
                double I0 = 1353.0 * (1.0 + 0.033 * Math.cos((double)(doy * 2) * Math.PI / 365.25));
                double dec = this.calc_met.getDEC(doy);
                res = this.calc_met.getLCTS(lat, dec);
                ahs = (Double)res.get("ahs");
                double lts = (Double)res.get("lts");
                double cts = (Double)res.get("cts");
                double Ho = 7.639437268410976 * I0 * Math.cos(lat) * Math.cos(dec) * (Math.sin(ahs) - ahs * Math.cos(ahs)) / 1000.0;
                double Hh = calcmod < 7 ? this.Gs[0][mm] * 0.2777777777777778 : this.Gs2016[0][mm];
                double Kh = Hh / (Ho * (double)this.jj[mm]);
                double Kd = Kh * (0.9 - 0.9 * Kh);
                double Hd = Kd * (Ho * (double)this.jj[mm]);
                double Hb = Hh - Hd;
                double SUM_Hbh = 0.0;
                double SUM_Hdh = 0.0;
                double SUM_Hbi = 0.0;
                double SUM_Hdi = 0.0;
                for (double hh = Math.ceil(lts); hh <= Math.floor(cts); hh += 1.0) {
                    double diri;
                    double hih;
                    double gloh;
                    double difh;
                    double dirh;
                    double mair;
                    res = this.calc_met.getHCAZ(lat, dec, hh);
                    double az = (Double)res.get("az");
                    double hc = (Double)res.get("hc");
                    Oz = (Double)res.get("Oz");
                    if (hc > 0.0) {
                        mair = (1.0 - 0.1 * alt) / (Math.sin(hc) + 0.15 * Math.pow(hc + 3.885, -1.253));
                        dirh = I0 * Math.sin(hc) * Math.exp(-0.16 - 0.22 * mair);
                        difh = 160.0 * Math.pow(Math.sin(hc), 0.8) * (1.0 - 0.17 * (Math.sin(dec) / Math.sin(0.3987)));
                        gloh = dirh + difh;
                    } else {
                        mair = 0.0;
                        dirh = 0.0;
                        difh = 0.0;
                        gloh = 0.0;
                    }
                    SUM_Hbh += dirh;
                    SUM_Hdh += difh;
                    double ioh = hc > 0.0 ? I0 * Math.sin(hc) : 0.0;
                    double hi = this.calc_met.getHiPlan(Oz, az, inc, paz);
                    if (hi > 0.0) {
                        hih = Math.sin(hi) / Math.sin(hc);
                        diri = dirh * hih;
                    } else {
                        hih = 0.0;
                        diri = 0.0;
                        gloh = difh;
                    }
                    SUM_Hbi += diri;
                    double refi = albedo * gloh * 0.5 * (1.0 - Math.cos(inc));
                    double k = dirh / I0;
                    double difi = difh * (k * hih + (1.0 - k) * 0.5 * (1.0 + Math.cos(inc))) + refi;
                    SUM_Hdi += difi;
                }
                double Gbi = Hb * SUM_Hbi / SUM_Hbh;
                double Gdi = Hd * SUM_Hdi / SUM_Hdh;
                G_E[mm] = calcmod < 7 ? (Gbi + Gdi) * 3.6 * this.getFs1(paz, inc) : (Gbi + Gdi) * this.getFs1(paz, inc);
            }
        }
        return G_E;
    }

    private double getFs1(double paz, double inc) {
        int ii;
        double[] Fs1 = Ecad2007.getDM_Pro().getFs1();
        double FSpaz = 0.0;
        if (Ecad2007.getIntCalcmod() < 7) {
            ii = (int)(Math.round(Math.abs(paz) * 180.0 / Math.PI / 45.0) % 8L) + 1;
            double i0 = (double)(ii - 1) * Math.PI / 4.0;
            double i1 = (double)ii * Math.PI / 4.0;
            FSpaz = (Math.abs(paz) - i0) / (i1 - i0) * (Fs1[(ii + 1) % 8] - Fs1[ii]) + Fs1[ii];
        } else {
            ii = (int)(Math.round(Math.abs(paz) * 180.0 / Math.PI / 45.0) % 16L) + 1;
            double i0 = (double)(ii - 1) * Math.PI / 8.0;
            double i1 = (double)ii * Math.PI / 8.0;
            FSpaz = (Math.abs(paz) - i0) / (i1 - i0) * (Fs1[(ii + 1) % 16] - Fs1[ii]) + Fs1[ii];
        }
        double FS = inc / 1.5707963267948966 * (FSpaz - Fs1[0]) + Fs1[0];
        return FS;
    }

    private int getDOY(int dd, int mm) {
        int nn = 0;
        if (mm > 1) {
            for (int ii = 0; ii < mm - 1; ++ii) {
                nn += this.jj[mm];
            }
        }
        return nn + dd;
    }

    public int getDoy(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return calendar.get(6);
    }

    public Map<String, Object[]> getMetSia() {
        return this.dm_sia;
    }

    public ArrayList<String> getMetSrc() {
        return this.al_src;
    }

    public Map getMetData() {
        return this.dm_data;
    }

    public int[] translateMinergieIds() {
        int[] res = null;
        int[][] mge = this.map_minids.get(this.CANTON);
        if (mge == null) {
            return res;
        }
        int idct = this.map_minct.get(this.CANTON);
        for (int ii = 0; ii < mge[0].length; ++ii) {
            int id_met = mge[0][ii];
            if (id_met != this.ID_MET) continue;
            res = new int[]{idct, mge[1][ii]};
            break;
        }
        return res;
    }
}

