/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.hibernate.pro.db.Pro;
import core.hibernate.pro.db.ProHelper;
import enercad2007.DB_Pro;
import enercad2007.DM_Facade;
import enercad2007.DM_Met;
import enercad2007.DM_Trad;
import enercad2007.DM_Trad_SIA;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.util.TreeMap;

public class DM_Pro {
    DB_Pro db_pro;
    Pro pro;
    ProHelper proHelper;
    DM_Met dm_met;
    DM_Trad trad_mf = Ecad2007.getTraduction("mf");
    protected int lan = Ecad2007.getCodeLan();
    int errorCode = 1;
    final double[][] FQ2016 = new double[][]{{0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9}, {1.0, 1.0, 0.97, 0.94, 0.9, 0.86, 0.82, 0.78}, {1.0, 0.985, 0.93, 0.875, 0.825, 0.77, 0.715, 0.66}, {1.0, 0.97, 0.89, 0.81, 0.75, 0.68, 0.61, 0.54}, {1.0, 0.955, 0.85, 0.745, 0.675, 0.59, 0.505, 0.42}, {1.0, 0.94, 0.81, 0.68, 0.6, 0.5, 0.4, 0.3}, {1.0, 0.945, 0.813, 0.658, 0.563, 0.465, 0.368, 0.273}, {1.0, 0.95, 0.815, 0.635, 0.525, 0.43, 0.335, 0.245}, {1.0, 0.955, 0.82, 0.613, 0.488, 0.395, 0.303, 0.218}, {1.0, 0.96, 0.82, 0.59, 0.45, 0.36, 0.27, 0.19}, {1.0, 0.955, 0.82, 0.613, 0.488, 0.395, 0.303, 0.218}, {1.0, 0.95, 0.815, 0.635, 0.525, 0.43, 0.335, 0.245}, {1.0, 0.945, 0.813, 0.658, 0.563, 0.465, 0.368, 0.273}, {1.0, 0.94, 0.81, 0.68, 0.6, 0.5, 0.4, 0.3}, {1.0, 0.955, 0.85, 0.745, 0.675, 0.59, 0.505, 0.42}, {1.0, 0.97, 0.89, 0.81, 0.75, 0.68, 0.61, 0.54}, {1.0, 0.985, 0.93, 0.875, 0.825, 0.77, 0.715, 0.66}, {1.0, 1.0, 0.97, 0.94, 0.9, 0.86, 0.82, 0.78}};
    final double[][] FQ2009 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.97, 0.94, 0.9, 0.86, 0.82, 0.78}, {1.0, 0.97, 0.89, 0.81, 0.75, 0.7, 0.65, 0.6}, {1.0, 0.94, 0.81, 0.68, 0.6, 0.5, 0.4, 0.3}, {1.0, 0.95, 0.82, 0.64, 0.53, 0.45, 0.38, 0.3}, {1.0, 0.96, 0.82, 0.59, 0.45, 0.36, 0.27, 0.19}, {1.0, 0.95, 0.82, 0.64, 0.53, 0.45, 0.38, 0.3}, {1.0, 0.94, 0.81, 0.68, 0.6, 0.5, 0.4, 0.3}, {1.0, 0.97, 0.89, 0.81, 0.75, 0.7, 0.65, 0.6}, {1.0, 1.0, 0.97, 0.94, 0.9, 0.86, 0.82, 0.78}};
    TreeMap<String, String[]> tm_trad = new TreeMap();
    String txt_bilan_mod0;
    String txt_bilan_mod1;
    String txt_bilan_mod2;
    String txt_bilan_mod3;
    String txt_bilan_mod4;
    String txt_bilan_mod5;
    String txt_bilan_mod6;
    String txt_bilan_mod7;
    String txt_bilan_mod8;
    String txt_sonde_ext = "R\u00e9gulation par pi\u00e8ce (thermostat)";
    String txt_reg_ref = "R\u00e9gulation par espace de r\u00e9f\u00e9rence";
    String txt_reg_room = "Sonde ext\u00e9rieure et autres cas";

    public DM_Pro() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DM_Pro(DM_Met dm_met) {
        this.dm_met = dm_met;
        Ecad2007.setDM_Met(dm_met);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.db_pro = new DB_Pro("int");
        this.errorCode = this.db_pro.getErrorCode();
        if (this.errorCode == 30000) {
            Ecad2007.setErrorCode(this.errorCode);
            return;
        }
        this.pro = this.db_pro.getPro();
        short calcmod = this.pro.getCalcmod();
        if (Ecad2007.getIntCalcmod() != calcmod) {
            Ecad2007.setCalcmod(Integer.valueOf(calcmod));
        }
        this.proHelper = this.pro.getProHelper();
        if (this.proHelper == null) {
            this.proHelper = new ProHelper();
        }
        if (Ecad2007.getDM_Met() == null) {
            String id_met = this.pro.getMet_b();
            if (id_met == null) {
                id_met = Globals.getDefaultMeteo();
            } else if (id_met.equals("")) {
                id_met = Globals.getDefaultMeteo();
            }
            this.loadMeteo(id_met);
        } else {
            this.setMET_B(Ecad2007.getIdMet());
            this.setALT_B(Ecad2007.getDM_Met().getALT_M());
        }
        DM_Trad_SIA dm_Trad_SIA = Ecad2007.getTraduction_SIA("resume");
        this.tm_trad = dm_Trad_SIA.getTreeMap();
        this.txt_bilan_mod0 = this.getCodeLan("txt_bilan_mod0");
        this.txt_bilan_mod1 = this.getCodeLan("txt_bilan_mod1");
        this.txt_bilan_mod2 = this.getCodeLan("txt_bilan_mod2");
        this.txt_bilan_mod3 = this.getCodeLan("txt_bilan_mod3");
        this.txt_bilan_mod4 = this.getCodeLan("txt_bilan_mod4");
        this.txt_bilan_mod5 = this.getCodeLan("txt_bilan_mod5");
        this.txt_bilan_mod6 = this.getCodeLan("txt_bilan_mod6");
        this.txt_bilan_mod7 = this.getCodeLan("txt_bilan_mod7");
        this.txt_bilan_mod8 = this.getCodeLan("txt_bilan_mod8");
        this.txt_sonde_ext = this.trad_mf.getCodeLan("sonde_ext");
        this.txt_reg_ref = this.trad_mf.getCodeLan("reg_ref");
        this.txt_reg_room = this.trad_mf.getCodeLan("reg_room");
    }

    public void loadMeteo(String id_met) {
        this.dm_met = new DM_Met(id_met);
        Ecad2007.setIdMet(id_met);
        Ecad2007.setDM_Met(this.dm_met);
    }

    public void loadMeteo(DM_Met dm_met) {
        this.dm_met = dm_met;
    }

    public int getCalcBat() {
        if (this.dm_met == null) {
            return 0;
        }
        Globals.println("");
        Globals.println("Projet " + this.pro.getNo_b());
        Globals.println("Mode de calcul: " + this.getCalcMod());
        Globals.println("Altitude: " + this.getALT_B());
        Globals.println("Station m\u00e9t\u00e9o: " + this.getMET_B() + " = " + Ecad2007.getDM_Met().getNOM_MET());
        String tmp = "Horizont: ";
        double[] hor = this.getFs1();
        int dim = hor.length;
        for (int ii = 0; ii < dim; ++ii) {
            tmp = tmp + hor[ii] + " ";
        }
        tmp = tmp + "\n";
        Globals.println(tmp);
        this.dm_met.loadMet();
        return 0;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void updateProRow() {
        this.pro.setProHelper(this.proHelper);
        this.db_pro.updateRow(this.pro);
    }

    public boolean isProLoaded() {
        if (this.db_pro == null) {
            return false;
        }
        return this.db_pro.getPro() != null;
    }

    public void initTable() {
        this.db_pro.initTable();
    }

    public double getALT_B() {
        return this.pro.getAlt_b();
    }

    public void setALT_B(Double ALT_B) {
        this.pro.setAlt_b(ALT_B);
    }

    public String getMET_B() {
        return this.pro.getMet_b();
    }

    public void setMET_B(String MET_B) {
        this.pro.setMet_b(MET_B);
    }

    public double[] getAS_B() {
        double[] as_b = null;
        int calcmod = Ecad2007.getIntCalcmod();
        as_b = calcmod >= 7 ? new double[]{0.9, this.pro.getFa_b1(), this.proHelper.getFa_nne(), this.pro.getFa_b2(), this.proHelper.getFa_ene(), this.pro.getFa_b3(), this.proHelper.getFa_ese(), this.pro.getFa_b4(), this.proHelper.getFa_sse(), this.pro.getFa_b5(), this.proHelper.getFa_ssw(), this.pro.getFa_b6(), this.proHelper.getFa_wsw(), this.pro.getFa_b7(), this.proHelper.getFa_wnw(), this.pro.getFa_b8(), this.proHelper.getFa_nnw()} : new double[]{0.0, this.pro.getFa_b1(), this.pro.getFa_b2(), this.pro.getFa_b3(), this.pro.getFa_b4(), this.pro.getFa_b5(), this.pro.getFa_b6(), this.pro.getFa_b7(), this.pro.getFa_b8()};
        return as_b;
    }

    public double[] getFs1() {
        Object qq;
        double AS_B1 = this.pro.getFa_b1();
        double AS_B2 = this.pro.getFa_b2();
        double AS_B3 = this.pro.getFa_b3();
        double AS_B4 = this.pro.getFa_b4();
        double AS_B5 = this.pro.getFa_b5();
        double AS_B6 = this.pro.getFa_b6();
        double AS_B7 = this.pro.getFa_b7();
        double AS_B8 = this.pro.getFa_b8();
        double FS_B0 = 1.0;
        Object FS_B1 = 1.0;
        Object FS_B2 = 1.0;
        Object FS_B3 = 1.0;
        Object FS_B4 = 1.0;
        Object FS_B5 = 1.0;
        Object FS_B6 = 1.0;
        Object FS_B7 = 1.0;
        Object FS_B8 = 1.0;
        int calcmod = Ecad2007.getIntCalcmod();
        if (calcmod == 7 || calcmod == 8) {
            double AS_Bnne = this.proHelper.getFa_nne();
            double AS_Bene = this.proHelper.getFa_ene();
            double AS_Bese = this.proHelper.getFa_ese();
            double AS_Bsse = this.proHelper.getFa_sse();
            double AS_Bssw = this.proHelper.getFa_ssw();
            double AS_Bwsw = this.proHelper.getFa_wsw();
            double AS_Bwnw = this.proHelper.getFa_wnw();
            double AS_Bnnw = this.proHelper.getFa_nnw();
            double[][] qq2 = this.FQ2016;
            int[] indexes = new int[]{(int)Math.round(Math.min(AS_B1 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bnne * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B2 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bene * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B3 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bese * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B4 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bsse * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B5 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bssw * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B6 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bwsw * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B7 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bwnw * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_B8 * 180.0 / Math.PI / 10.0, 7.0)), (int)Math.round(Math.min(AS_Bnnw * 180.0 / Math.PI / 10.0, 7.0))};
            double[] angles = new double[]{AS_B1 * 180.0 / Math.PI, AS_Bnne * 180.0 / Math.PI, AS_B2 * 180.0 / Math.PI, AS_Bene * 180.0 / Math.PI, AS_B3 * 180.0 / Math.PI, AS_Bese * 180.0 / Math.PI, AS_B4 * 180.0 / Math.PI, AS_Bsse * 180.0 / Math.PI, AS_B5 * 180.0 / Math.PI, AS_Bssw * 180.0 / Math.PI, AS_B6 * 180.0 / Math.PI, AS_Bwsw * 180.0 / Math.PI, AS_B7 * 180.0 / Math.PI, AS_Bwnw * 180.0 / Math.PI, AS_B8 * 180.0 / Math.PI, AS_Bnnw * 180.0 / Math.PI};
            double[] FS_B = new double[17];
            FS_B[0] = this.getFS1h();
            double delta = 0.0;
            for (int ii = 0; ii < angles.length; ++ii) {
                angles[ii] = Math.round(angles[ii] * 10000.0 / 10000.0);
                delta = angles[ii] / 10.0 - (double)((int)(angles[ii] / 10.0));
                if (delta > 0.0) {
                    double q_high;
                    double q_low = q_high = qq2[ii + 1][indexes[ii]];
                    if (indexes[ii] > 0) {
                        q_high = qq2[ii + 1][indexes[ii] - 1];
                    }
                    FS_B[ii + 1] = q_low + delta * (q_high - q_low);
                    continue;
                }
                FS_B[ii + 1] = qq2[ii + 1][indexes[ii]];
            }
            return FS_B;
        }
        if (calcmod == 0 || calcmod == 2 || calcmod == 4 || calcmod == 5 || calcmod == 6) {
            qq = this.FQ2009;
            for (int i = 2; i <= 8; i += 2) {
                int k = 0;
                while (k < 5) {
                    qq[i][k] = Math.round(100.0 * Math.sqrt(qq[i - 1][k] * qq[i + 1][k]));
                    double[] dArray = qq[i];
                    int n = k++;
                    dArray[n] = dArray[n] / 100.0;
                }
            }
            int I1 = (int)Math.round(Math.min(AS_B1 * 180.0 / Math.PI / 10.0, 4.0));
            int I2 = (int)Math.round(Math.min(AS_B2 * 180.0 / Math.PI / 10.0, 4.0));
            int I3 = (int)Math.round(Math.min(AS_B3 * 180.0 / Math.PI / 10.0, 4.0));
            int I4 = (int)Math.round(Math.min(AS_B4 * 180.0 / Math.PI / 10.0, 4.0));
            int I5 = (int)Math.round(Math.min(AS_B5 * 180.0 / Math.PI / 10.0, 4.0));
            int I6 = (int)Math.round(Math.min(AS_B6 * 180.0 / Math.PI / 10.0, 4.0));
            int I7 = (int)Math.round(Math.min(AS_B7 * 180.0 / Math.PI / 10.0, 4.0));
            int I8 = (int)Math.round(Math.min(AS_B8 * 180.0 / Math.PI / 10.0, 4.0));
            FS_B0 = 0.85;
            FS_B1 = qq[1][I1];
            FS_B2 = qq[2][I2];
            FS_B3 = qq[3][I3];
            FS_B4 = qq[4][I4];
            FS_B5 = qq[5][I5];
            FS_B6 = qq[6][I6];
            FS_B7 = qq[7][I7];
            FS_B8 = qq[8][I8];
        } else if (calcmod == 1 || calcmod == 3) {
            System.out.println("Conversion AS > FS selon SIA:2001 | calcmod: " + calcmod);
            qq = new double[]{0.9, 0.9, 0.9, 0.9, 0.8, 0.7, 0.6};
            int I1 = (int)Math.round(Math.min(AS_B1 * 180.0 / Math.PI / 5.0, 6.0));
            int I2 = (int)Math.round(Math.min(AS_B2 * 180.0 / Math.PI / 5.0, 6.0));
            int I3 = (int)Math.round(Math.min(AS_B3 * 180.0 / Math.PI / 5.0, 6.0));
            int I4 = (int)Math.round(Math.min(AS_B4 * 180.0 / Math.PI / 5.0, 6.0));
            int I5 = (int)Math.round(Math.min(AS_B5 * 180.0 / Math.PI / 5.0, 6.0));
            int I6 = (int)Math.round(Math.min(AS_B6 * 180.0 / Math.PI / 5.0, 6.0));
            int I7 = (int)Math.round(Math.min(AS_B7 * 180.0 / Math.PI / 5.0, 6.0));
            int I8 = (int)Math.round(Math.min(AS_B8 * 180.0 / Math.PI / 5.0, 6.0));
            FS_B1 = qq[I1];
            FS_B2 = qq[I2];
            FS_B3 = qq[I3];
            FS_B4 = qq[I4];
            FS_B5 = qq[I5];
            FS_B6 = qq[I6];
            FS_B7 = qq[I7];
            FS_B8 = qq[I8];
            FS_B0 = 1.0;
        }
        double[] FS_B = new double[]{FS_B0, FS_B1, FS_B2, FS_B3, FS_B4, FS_B5, FS_B6, FS_B7, FS_B8};
        return FS_B;
    }

    public double[] getFsH() {
        if (Globals.int_ver < 510 || Ecad2007.getLicenseLevel() <= 2L || Ecad2007.getCalcmod() < 7) {
            return new double[]{this.getFs1()[0], 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        }
        double AS_hw_n = this.proHelper.getFa_hw_n();
        double AS_hw_ne = this.proHelper.getFa_hw_ne();
        double AS_hw_e = this.proHelper.getFa_hw_e();
        double AS_hw_se = this.proHelper.getFa_hw_se();
        double AS_hw_s = this.proHelper.getFa_hw_s();
        double AS_hw_sw = this.proHelper.getFa_hw_sw();
        double AS_hw_w = this.proHelper.getFa_hw_w();
        double AS_hw_nw = this.proHelper.getFa_hw_nw();
        double[][] qq = this.FQ2009;
        int[] II = new int[]{(int)Math.round(Math.min(AS_hw_n * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_ne * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_e * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_se * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_s * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_sw * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_w * 180.0 / Math.PI / 10.0, 4.0)), (int)Math.round(Math.min(AS_hw_nw * 180.0 / Math.PI / 10.0, 4.0))};
        double FS_hw_B0 = qq[1][II[0]];
        double tmp = qq[1][II[0]];
        for (int ii = 2; ii < 8; ++ii) {
            FS_hw_B0 *= qq[ii + 1][II[ii]];
            FS_hw_B0 = Math.sqrt(FS_hw_B0);
            if (ii % 2 != 1) continue;
            tmp *= qq[ii + 1][II[ii]];
        }
        double[] FSH = new double[9];
        FSH[0] = FS_hw_B0;
        for (int ii = 1; ii < 9; ++ii) {
            FSH[ii] = qq[ii][II[ii - 1]];
        }
        return FSH;
    }

    public double getFS1h() {
        double res = 0.0;
        if (Globals.int_ver < 510 || Ecad2007.getLicenseLevel() <= 2L || Ecad2007.getCalcmod() < 7) {
            return 1.0;
        }
        double[] FS_B0 = Ecad2007.getDM_Pro().getFsH();
        res = FS_B0[0];
        return res;
    }

    public double getFs1(double AZ, double INC) {
        double Fs1 = 0.0;
        if (Globals.int_ver < 510 || Ecad2007.getLicenseLevel() <= 2L || Ecad2007.getCalcmod() < 7) {
            if (INC < 0.5235987755982988) {
                Fs1 = this.getFs1()[0];
            } else {
                int index = (int)(Math.round(Math.abs(AZ) * 180.0 / Math.PI / 45.0) % 8L) + 1;
                Fs1 = this.getFs1()[index];
            }
        } else if (INC < 1.0471975511965976) {
            Fs1 = Globals.getIntDebug() < 0 ? 0.848 : this.getFs1()[0];
        } else {
            int index = (int)(Math.round(Math.abs(AZ) * 180.0 / Math.PI / 22.5) % 16L) + 1;
            Fs1 = this.getFs1()[index];
        }
        return Fs1;
    }

    public int getCalcMod() {
        return this.pro.getCalcmod().shortValue();
    }

    public void setCalcMod(int calcmod) {
        this.pro.setCalcmod((short)calcmod);
    }

    public String getCalcModtxt() {
        String[] txt = new String[]{this.txt_bilan_mod0, this.txt_bilan_mod1, this.txt_bilan_mod2, this.txt_bilan_mod3, this.txt_bilan_mod4, this.txt_bilan_mod5, this.txt_bilan_mod6, this.txt_bilan_mod7, this.txt_bilan_mod8};
        return txt[this.getCalcMod()];
    }

    public String getdTItxt(int id_z) {
        String[] txt_regul = new String[]{this.txt_reg_room, this.txt_reg_ref, this.txt_sonde_ext};
        return txt_regul[(int)Ecad2007.getDM_Zone(id_z).getdTI_Z()];
    }

    public double getFs1TxVitMax() {
        if (Ecad2007.dataF == null) {
            Ecad2007.dataF = new DM_Facade();
        }
        double Fs1VitMax = Ecad2007.dataF.getFs1TxVitMax();
        return Fs1VitMax;
    }

    public void setFA_B1(double FA_B1) {
        this.pro.setFa_b1(FA_B1 * Math.PI / 180.0);
    }

    public double getFA_B1() {
        return Math.round(this.pro.getFa_b1() * 180.0 / Math.PI);
    }

    public void setFA_B2(double FA_B2) {
        this.pro.setFa_b2(FA_B2 * Math.PI / 180.0);
    }

    public double getFA_B2() {
        return Math.round(this.pro.getFa_b2() * 180.0 / Math.PI);
    }

    public void setFA_B3(double FA_B3) {
        this.pro.setFa_b3(FA_B3 * Math.PI / 180.0);
    }

    public double getFA_B3() {
        return Math.round(this.pro.getFa_b3() * 180.0 / Math.PI);
    }

    public void setFA_B4(double FA_B4) {
        this.pro.setFa_b4(FA_B4 * Math.PI / 180.0);
    }

    public double getFA_B4() {
        return Math.round(this.pro.getFa_b4() * 180.0 / Math.PI);
    }

    public void setFA_B5(double FA_B5) {
        this.pro.setFa_b5(FA_B5 * Math.PI / 180.0);
    }

    public double getFA_B5() {
        return Math.round(this.pro.getFa_b5() * 180.0 / Math.PI);
    }

    public void setFA_B6(double FA_B6) {
        this.pro.setFa_b6(FA_B6 * Math.PI / 180.0);
    }

    public double getFA_B6() {
        return Math.round(this.pro.getFa_b6() * 180.0 / Math.PI);
    }

    public void setFA_B7(double FA_B7) {
        this.pro.setFa_b7(FA_B7 * Math.PI / 180.0);
    }

    public double getFA_B7() {
        return Math.round(this.pro.getFa_b7() * 180.0 / Math.PI);
    }

    public void setFA_B8(double FA_B8) {
        this.pro.setFa_b8(FA_B8 * Math.PI / 180.0);
    }

    public double getFA_B8() {
        return Math.round(this.pro.getFa_b8() * 180.0 / Math.PI);
    }

    public void setFA_NNE(double fa_nne) {
        this.proHelper.setFa_nne(fa_nne * Math.PI / 180.0);
    }

    public double getFA_NNE() {
        return Math.round(this.proHelper.getFa_nne() * 180.0 / Math.PI);
    }

    public void setFA_ENE(double fa_ene) {
        this.proHelper.setFa_ene(fa_ene * Math.PI / 180.0);
    }

    public double getFA_ENE() {
        return Math.round(this.proHelper.getFa_ene() * 180.0 / Math.PI);
    }

    public void setFA_ESE(double fa_ese) {
        this.proHelper.setFa_ese(fa_ese * Math.PI / 180.0);
    }

    public double getFA_ESE() {
        return Math.round(this.proHelper.getFa_ese() * 180.0 / Math.PI);
    }

    public void setFA_SSE(double fa_sse) {
        this.proHelper.setFa_sse(fa_sse * Math.PI / 180.0);
    }

    public double getFA_SSE() {
        return Math.round(this.proHelper.getFa_sse() * 180.0 / Math.PI);
    }

    public void setFA_SSW(double fa_ssw) {
        this.proHelper.setFa_ssw(fa_ssw * Math.PI / 180.0);
    }

    public double getFA_SSW() {
        return Math.round(this.proHelper.getFa_ssw() * 180.0 / Math.PI);
    }

    public void setFA_WSW(double fa_wsw) {
        this.proHelper.setFa_wsw(fa_wsw * Math.PI / 180.0);
    }

    public double getFA_WSW() {
        return Math.round(this.proHelper.getFa_wsw() * 180.0 / Math.PI);
    }

    public void setFA_WNW(double fa_wnw) {
        this.proHelper.setFa_wnw(fa_wnw * Math.PI / 180.0);
    }

    public double getFA_WNW() {
        return Math.round(this.proHelper.getFa_wnw() * 180.0 / Math.PI);
    }

    public void setFA_NNW(double fa_nnw) {
        this.proHelper.setFa_nnw(fa_nnw * Math.PI / 180.0);
    }

    public double getFA_NNW() {
        return Math.round(this.proHelper.getFa_nnw() * 180.0 / Math.PI);
    }

    public void setFA_hw_N(double fa_hw_n) {
        this.proHelper.setFa_hw_n(fa_hw_n * Math.PI / 180.0);
    }

    public double getFA_hw_N() {
        return Math.round(this.proHelper.getFa_hw_n() * 180.0 / Math.PI);
    }

    public void setFA_hw_NE(double fa_hw_ne) {
        this.proHelper.setFa_hw_ne(fa_hw_ne * Math.PI / 180.0);
    }

    public double getFA_hw_NE() {
        return Math.round(this.proHelper.getFa_hw_ne() * 180.0 / Math.PI);
    }

    public void setFA_hw_E(double fa_hw_e) {
        this.proHelper.setFa_hw_e(fa_hw_e * Math.PI / 180.0);
    }

    public double getFA_hw_E() {
        return Math.round(this.proHelper.getFa_hw_e() * 180.0 / Math.PI);
    }

    public void setFA_hw_SE(double fa_hw_se) {
        this.proHelper.setFa_hw_se(fa_hw_se * Math.PI / 180.0);
    }

    public double getFA_hw_SE() {
        return Math.round(this.proHelper.getFa_hw_se() * 180.0 / Math.PI);
    }

    public void setFA_hw_S(double fa_hw_s) {
        this.proHelper.setFa_hw_s(fa_hw_s * Math.PI / 180.0);
    }

    public double getFA_hw_S() {
        return Math.round(this.proHelper.getFa_hw_s() * 180.0 / Math.PI);
    }

    public void setFA_hw_SW(double fa_hw_sw) {
        this.proHelper.setFa_hw_sw(fa_hw_sw * Math.PI / 180.0);
    }

    public double getFA_hw_SW() {
        return Math.round(this.proHelper.getFa_hw_sw() * 180.0 / Math.PI);
    }

    public void setFA_hw_W(double fa_hw_w) {
        this.proHelper.setFa_hw_w(fa_hw_w * Math.PI / 180.0);
    }

    public double getFA_hw_W() {
        return Math.round(this.proHelper.getFa_hw_w() * 180.0 / Math.PI);
    }

    public void setFA_hw_NW(double fa_hw_nw) {
        this.proHelper.setFa_hw_nw(fa_hw_nw * Math.PI / 180.0);
    }

    public double getFA_hw_NW() {
        return Math.round(this.proHelper.getFa_hw_nw() * 180.0 / Math.PI);
    }

    public void setNOM_B(String NOM_B) {
        this.pro.setNom_b(NOM_B);
    }

    public String getNOM_B() {
        return this.pro.getNom_b();
    }

    public void setNO_B(String NO_B) {
        this.pro.setNo_b(NO_B);
    }

    public String getNO_B() {
        return this.pro.getNo_b();
    }

    public void setTR_B(short TR_B) {
        this.pro.setTr_b(TR_B);
    }

    public int getTR_B() {
        return this.pro.getTr_b().shortValue();
    }

    public void setREM_B(String REM_B) {
        this.pro.setRem_b(REM_B);
    }

    public String getREM_B() {
        return this.pro.getRem_b();
    }

    public void setA1_B(String A1_B) {
        this.pro.setA1_b(A1_B);
    }

    public String getA1_B() {
        return this.pro.getA1_b();
    }

    public void setA2_B(String A2_B) {
        this.pro.setA2_b(A2_B);
    }

    public String getA2_B() {
        return this.pro.getA2_b();
    }

    public void setA3_B(String A3_B) {
        this.pro.setA3_b(A3_B);
    }

    public String getA3_B() {
        return this.pro.getA3_b();
    }

    public void setAC_B(Integer AC_B) {
        this.pro.setAc_b(AC_B);
    }

    public int getAC_B() {
        return this.pro.getAc_b();
    }

    public void setREN_B(Integer REN_B) {
        this.pro.setRen_b(REN_B);
    }

    public Integer getREN_B() {
        return this.pro.getRen_b();
    }

    public void setPE_B(int pe_b) {
        this.pro.setPe_b(new Short((short)pe_b));
    }

    public int getPE_B() {
        return this.pro.getPe_b().intValue();
    }

    public void setNOM_MO(String NOM_MO) {
        this.pro.setNom_mo(NOM_MO);
    }

    public String getNOM_MO() {
        return this.pro.getNom_mo();
    }

    public void setCOL_MO(String COL_MO) {
        this.pro.setCol_mo(COL_MO);
    }

    public String getCOL_MO() {
        return this.pro.getCol_mo();
    }

    public void setA1_MO(String A1_MO) {
        this.pro.setA1_mo(A1_MO);
    }

    public String getA1_MO() {
        return this.pro.getA1_mo();
    }

    public void setA2_MO(String A2_MO) {
        this.pro.setA2_mo(A2_MO);
    }

    public String getA2_MO() {
        return this.pro.getA3_mo();
    }

    public void setA3_MO(String A3_MO) {
        this.pro.setA3_mo(A3_MO);
    }

    public String getA3_MO() {
        return this.pro.getA3_mo();
    }

    public void setT_MO(String T_MO) {
        this.pro.setT_mo(T_MO);
    }

    public String getT_MO() {
        return this.pro.getT_mo();
    }

    public void setF_MO(String F_MO) {
        this.pro.setF_mo(F_MO);
    }

    public double getF_LIM() {
        double f_lim = this.pro.getF_lim();
        Globals.println("DM_Pro.getF_LIM: " + f_lim);
        if (f_lim <= 0.0 || f_lim > 1.0) {
            f_lim = 1.0;
        }
        return f_lim;
    }

    public void setF_LIM(double F_LIM) {
        this.pro.setF_lim(F_LIM);
        Globals.println("DM_Pro.setF_LIM: " + F_LIM);
    }

    public String getF_MO() {
        return this.pro.getF_mo();
    }

    public void setM_MO(String M_MO) {
        this.pro.setM_mo(M_MO);
    }

    public String getM_MO() {
        return this.pro.getM_mo();
    }

    public void setNOM_AP(String NOM_AP) {
        this.pro.setNom_ap(NOM_AP);
    }

    public String getNOM_AP() {
        return this.pro.getNom_ap();
    }

    public void setCOL_AP(String COL_AP) {
        this.pro.setCol_ap(COL_AP);
    }

    public String getCOL_AP() {
        return this.pro.getCol_ap();
    }

    public void setA1_AP(String A1_AP) {
        this.pro.setA1_ap(A1_AP);
    }

    public String getA1_AP() {
        return this.pro.getA1_ap();
    }

    public void setA2_AP(String A2_AP) {
        this.pro.setA2_ap(A2_AP);
    }

    public String getA2_AP() {
        return this.pro.getA2_ap();
    }

    public void setA3_AP(String A3_AP) {
        this.pro.setA3_ap(A3_AP);
    }

    public String getA3_AP() {
        return this.pro.getA3_ap();
    }

    public void setT_AP(String T_AP) {
        this.pro.setT_ap(T_AP);
    }

    public String getT_AP() {
        return this.pro.getT_ap();
    }

    public void setF_AP(String F_AP) {
        this.pro.setF_ap(F_AP);
    }

    public String getF_AP() {
        return this.pro.getF_ap();
    }

    public void setM_AP(String M_AP) {
        this.pro.setM_ap(M_AP);
    }

    public String getM_AP() {
        return this.pro.getM_ap();
    }

    public void setNOM_AJ(String NOM_AJ) {
        this.pro.setNom_aj(NOM_AJ);
    }

    public String getNOM_AJ() {
        return this.pro.getNom_aj();
    }

    public void setCOL_AJ(String COL_AJ) {
        this.pro.setCol_aj(COL_AJ);
    }

    public String getCOL_AJ() {
        return this.pro.getCol_aj();
    }

    public void setA1_AJ(String A1_AJ) {
        this.pro.setA1_aj(A1_AJ);
    }

    public String getA1_AJ() {
        return this.pro.getA1_aj();
    }

    public void setA2_AJ(String A2_AJ) {
        this.pro.setA2_aj(A2_AJ);
    }

    public String getA2_AJ() {
        return this.pro.getA2_aj();
    }

    public void setA3_AJ(String A3_AJ) {
        this.pro.setA3_aj(A3_AJ);
    }

    public String getA3_AJ() {
        return this.pro.getA3_aj();
    }

    public void setT_AJ(String T_AJ) {
        this.pro.setT_aj(T_AJ);
    }

    public String getT_AJ() {
        return this.pro.getT_aj();
    }

    public void setF_AJ(String F_AJ) {
        this.pro.setF_aj(F_AJ);
    }

    public String getF_AJ() {
        return this.pro.getF_aj();
    }

    public void setM_AJ(String M_AJ) {
        this.pro.setM_aj(M_AJ);
    }

    public String getM_AJ() {
        return this.pro.getM_aj();
    }

    public String getCodeLan(String code) {
        String res = "";
        String[] object = this.tm_trad.get(code);
        if (object == null) {
            return null;
        }
        res = object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
        }
        return res;
    }
}

