/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.hibernate.cat.dao.HibernateTraductionDao;
import core.hibernate.cat.db.Traduction;
import enercad2007.Ecad2007;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DM_Trad
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String groupe;
    protected int code;
    protected int lan = Ecad2007.getCodeLan();
    TreeMap<String, Object[]> tm_trad = new TreeMap();
    String xml = System.getProperty("hibernate.conf.file.name");

    public DM_Trad() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DM_Trad(String group, int code) {
        this.groupe = group;
        this.code = code;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DM_Trad(String groupe) {
        this.groupe = groupe;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String path = System.getProperty("ecad.home.dir");
        File cat = new File(path + "data" + File.separator + "cat");
        if (cat.exists()) {
            HibernateTraductionDao hb_trad = null;
            hb_trad = this.xml == null ? new HibernateTraductionDao() : new HibernateTraductionDao(this.xml);
            List<Traduction> list = null;
            list = this.groupe == null ? hb_trad.getTraductionList() : (this.groupe.trim().equals("") ? hb_trad.getTraductionList() : hb_trad.getTraductionList(this.groupe));
            if (list == null) {
                return;
            }
            for (Traduction trad : list) {
                Object[] row = new Object[]{trad.getGe(), trad.getFr(), trad.getIt(), trad.getEn()};
                this.tm_trad.put(trad.getCdelan(), row);
            }
        }
    }

    public String getCodeLan(String code) {
        String res = "";
        Object[] object = this.tm_trad.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
        }
        return res;
    }

    public String getCodeLan(String code, Object defaultValue) {
        String res = "";
        Object[] object = this.tm_trad.get(code);
        if (object == null) {
            return (String)defaultValue;
        }
        res = (String)object[this.lan];
        res = res != null ? res.replaceAll("\\\\n", "\n") : (String)defaultValue;
        return res;
    }

    public String getCodeLan(String code, String replacement) {
        String res = "";
        Object[] object = this.tm_trad.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
            res = res.replaceFirst("\\\\s", replacement);
        }
        return res;
    }

    public String getCodeLan(String code, String[] replacement) {
        String res = "";
        Object[] object = this.tm_trad.get(code);
        if (object == null) {
            return null;
        }
        res = (String)object[this.lan];
        if (res != null) {
            res = res.replaceAll("\\\\n", "\n");
            for (int cter = 0; cter < replacement.length; ++cter) {
                res = res.replaceFirst("\\\\s", replacement[cter]);
            }
        }
        return res;
    }

    public String getCodeLan(String code, String def, String[] replacement) {
        String res = "";
        Object[] object = this.tm_trad.get(code);
        if (object == null && def != null) {
            res = def;
        }
        if (res.equals("")) {
            res = (String)object[this.lan];
        }
        res = res.replaceAll("\\\\n", "\n");
        for (int cter = 0; cter < replacement.length; ++cter) {
            res = res.replaceFirst("\\\\s", replacement[cter]);
        }
        return res;
    }

    public Map<String, Object[]> getTreeMap() {
        return this.tm_trad;
    }

    public int getLan() {
        return this.lan;
    }

    public void setLan(int lan) {
        this.lan = lan;
    }

    public int size() {
        return this.tm_trad.size();
    }
}

