/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Config;
import core.hibernate.pro.dao.HibernateComposant_MDao;
import core.hibernate.pro.dao.HibernateComposant_PDao;
import core.hibernate.pro.dao.HibernateComposant_WDao;
import core.hibernate.pro.dao.HibernateM1_verDao;
import core.hibernate.pro.dao.HibernateM2_cadDao;
import core.hibernate.pro.dao.HibernateM3_voilDao;
import core.hibernate.pro.dao.HibernateM6_iclDao;
import core.hibernate.pro.dao.HibernateMaterialsDao;
import core.hibernate.pro.db.Composant_M;
import core.hibernate.pro.db.Composant_P;
import core.hibernate.pro.db.Composant_W;
import core.hibernate.pro.db.M1_ver;
import core.hibernate.pro.db.M2_cad;
import core.hibernate.pro.db.M3_voil;
import core.hibernate.pro.db.M6_icl;
import core.hibernate.pro.db.MatDb;
import core.hibernate.pro.db.Materials;
import enercad2007.DBpr_Comp;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DMpr_Comp {
    private static DMpr_Comp myDM;
    Globals globals = new Globals();
    DBpr_Comp dbpr_comp;
    Map<String, String[]> dataM4P;
    String projectName = Globals.PROJECT_NAME;
    String componentCode;
    String[] cc;
    HibernateM1_verDao hibernateM1_verDao = new HibernateM1_verDao();
    HibernateM2_cadDao hibernateM2_cadDao = new HibernateM2_cadDao();
    HibernateM3_voilDao hibernateM3_voilDao = new HibernateM3_voilDao();
    HibernateMaterialsDao hibernateMaterialsDao = new HibernateMaterialsDao();
    HibernateM6_iclDao hibernateM6_iclDao = new HibernateM6_iclDao();
    HibernateComposant_PDao hibernateComposant_PDao = new HibernateComposant_PDao();
    HibernateComposant_WDao hibernateComposant_WDao = new HibernateComposant_WDao();
    Object[] M1data;
    Object[] M2data;
    Object[] M3data;
    Object[][] M4data;
    String[][] M4d;
    Object[] M6data;
    HashMap<String, String[]> m1_ver = new HashMap(20);
    HashMap<String, String[]> m2_cad = new HashMap(20);
    HashMap<String, String[]> m3_voil = new HashMap(20);
    TreeMap<String, Object[]> tm_catm4 = new TreeMap();
    TreeMap<String, String> tm_r2pr = new TreeMap();
    HashMap<String, String[]> m6_icl = new HashMap(20);
    HashMap<String, Object[]> mapM4 = new HashMap(20);
    String CompName;
    double[] PontTherm = new double[2];
    double ValeurU = 0.0;
    float[] RAie = new float[2];
    double[] DimRS = new double[2];
    int CoucheCh = 0;
    int n_lay = 0;
    int dim = 12;
    int lan = 0;
    String codeLan = "";

    public static DMpr_Comp getDataModule() {
        if (myDM == null) {
            myDM = new DMpr_Comp();
        }
        return myDM;
    }

    public DMpr_Comp() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        HibernateComposant_MDao hibernateComposant_MDao;
        List<Composant_M> list;
        block38: {
            Config conf = new Config(System.getProperty("conf.file.name"));
            String driver = "org.apache.derby.jdbc.EmbeddedDriver";
            String protocol = "jdbc:derby:";
            this.lan = conf.getPropertyInt("properties", "lan");
            if (this.lan == 0) {
                this.codeLan = "GE";
            } else if (this.lan == 1) {
                this.codeLan = "FR";
            } else if (this.lan == 2) {
                this.codeLan = "EN";
            } else if (this.lan == 3) {
                this.codeLan = "EN";
            }
            Properties props = new Properties();
            String[] row = null;
            props.put("user", Ecad2007.cd1);
            props.put("password", Ecad2007.cd2);
            props.put("name", "cn_cat");
            try {
                List<M1_ver> li1 = this.hibernateM1_verDao.getM1_verList();
                for (M1_ver m1 : li1) {
                    row = new String[]{m1.getNom_ge(), m1.getNom_fr(), m1.getNom_it(), m1.getNom_en(), String.valueOf(m1.getUu()), String.valueOf(m1.getGg()), String.valueOf(m1.getTt()), String.valueOf(m1.getAa()), String.valueOf(m1.getProvref())};
                    this.m1_ver.put(m1.getRef(), row);
                }
                List<M2_cad> li2 = this.hibernateM2_cadDao.getM2_cadList();
                for (M2_cad m2 : li2) {
                    row = new String[]{m2.getNom_ge(), m2.getNom_fr(), m2.getNom_it(), m2.getNom_en(), String.valueOf(m2.getUu()), String.valueOf(m2.getFf()), m2.getProvref()};
                    this.m2_cad.put(m2.getRef(), row);
                }
                List<M3_voil> li3 = this.hibernateM3_voilDao.getM3_voilList();
                for (M3_voil m3 : li3) {
                    row = new String[]{m3.getNom_ge(), m3.getNom_fr(), m3.getNom_it(), m3.getNom_en(), String.valueOf(m3.getFc()), String.valueOf(m3.getFa()), m3.getProvref()};
                    this.m3_voil.put(m3.getRef(), row);
                }
                List<Materials> li4 = this.hibernateMaterialsDao.getMaterialList();
                for (Materials m4 : li4) {
                    row = new String[]{m4.getNom_ge(), m4.getNom_fr(), m4.getNom_it(), m4.getNom_en(), String.valueOf(m4.getEpaisseur()), String.valueOf(m4.getLambda()), String.valueOf(m4.getVmin()), String.valueOf(m4.getVmax()), String.valueOf(m4.getFlags()), m4.getRef()};
                    this.tm_r2pr.put(m4.getProvref(), m4.getRef());
                    this.tm_catm4.put(m4.getRef(), row);
                }
                HibernateMaterialsDao hibernateMaterialsDao = new HibernateMaterialsDao();
                List<MatDb> library = hibernateMaterialsDao.getMatDbList();
                for (MatDb matDb : library) {
                    matDb.init();
                    row = new String[]{matDb.getNom_al(), matDb.getNom_fr(), matDb.getNom_it(), matDb.getNom_en(), String.valueOf(matDb.getEp() / 10.0), Globals.format("%.3f", matDb.getLambda()), String.valueOf(matDb.getVmin()), String.valueOf(matDb.getVmax()), String.valueOf(matDb.getFlags()), matDb.getRef()};
                    this.tm_r2pr.put(matDb.getProvref(), matDb.getRef());
                    this.tm_catm4.put(matDb.getRef(), row);
                }
                List<M6_icl> li6 = this.hibernateM6_iclDao.getM6_iclList();
                for (M6_icl m6 : li6) {
                    row = new String[]{m6.getNom_ge(), m6.getNom_fr(), m6.getNom_it(), m6.getNom_en(), String.valueOf(m6.getUu()), m6.getProvref()};
                    this.m6_icl.put(m6.getRef(), row);
                }
            }
            catch (Throwable ex) {
                if (((SQLException)ex).getErrorCode() == 50000) break block38;
                Globals.println("Message: " + ex.getMessage());
            }
        }
        if ((list = (hibernateComposant_MDao = new HibernateComposant_MDao()).getComposant_MList()) != null) {
            for (Composant_M composant_m : list) {
                String code = String.valueOf(composant_m.getA()) + ",";
                code = code + String.valueOf(composant_m.getB()) + ",";
                code = code + String.valueOf(composant_m.getC()) + ",";
                code = code + String.valueOf(composant_m.getD()) + ",";
                code = code + String.valueOf(composant_m.getE());
                this.mapM4.put(code, this.getM4data(composant_m));
            }
        }
        List<Composant_W> list_w = this.hibernateComposant_WDao.getComposant_WList();
        for (Composant_W composant_w : list_w) {
            String code = String.valueOf(composant_w.getA()) + ",";
            code = code + String.valueOf(composant_w.getB()) + ",";
            code = code + String.valueOf(composant_w.getC()) + ",";
            code = code + String.valueOf(composant_w.getD()) + ",";
            code = code + String.valueOf(composant_w.getE());
            this.mapM4.put(code, this.getW4data(composant_w));
        }
        List<Composant_P> list_p = this.hibernateComposant_PDao.getComposant_PList();
        for (Composant_P composant_p : list_p) {
            String code = String.valueOf(composant_p.getA()) + ",";
            code = code + String.valueOf(composant_p.getB()) + ",";
            code = code + String.valueOf(composant_p.getC()) + ",";
            code = code + String.valueOf(composant_p.getD()) + ",";
            code = code + String.valueOf(composant_p.getE());
            this.mapM4.put(code, this.getP4data(composant_p));
        }
        this.dbpr_comp = new DBpr_Comp("int");
        Vector<Object[]> materials = this.dbpr_comp.getRows("MATERIALS");
        int dim = materials.size();
        boolean b_data = false;
        if (this.dataM4P == null) {
            this.dataM4P = new HashMap<String, String[]>(20);
        }
        DecimalFormat df = Ecad2007.getDecimalFormat("#0.########");
        DecimalFormat df2 = Ecad2007.getDecimalFormat("#0.##");
        DecimalFormat df3 = Ecad2007.getDecimalFormat("#0.###");
        DecimalFormat df4 = Ecad2007.getDecimalFormat("#0.####");
        for (int ii = 0; ii < dim; ++ii) {
            if (this.dataM4P.get(materials.get(ii)[25]) == null) {
                b_data = true;
            }
            if (!b_data) continue;
            String[] data = new String[27];
            data[0] = Globals.getStringValue(materials.get(ii)[0]).trim();
            data[1] = Globals.getStringValue(materials.get(ii)[1]).trim();
            data[2] = Globals.getStringValue(materials.get(ii)[2]).trim();
            data[3] = Globals.getStringValue(materials.get(ii)[3]).trim();
            for (int jj = 0; jj < 4; ++jj) {
                if (data[jj] == null) continue;
                data[jj] = data[jj].trim();
            }
            data[4] = df2.format(materials.get(ii)[4]);
            data[5] = df2.format(materials.get(ii)[5]);
            data[6] = df3.format(materials.get(ii)[6]).toString();
            data[7] = df2.format(materials.get(ii)[7]).toString();
            data[8] = Globals.getInteger(materials.get(ii)[8]).toString();
            data[9] = df4.format(materials.get(ii)[9]).toString();
            data[10] = df4.format(materials.get(ii)[10]).toString();
            data[11] = df.format(materials.get(ii)[11]).toString();
            data[12] = df.format(materials.get(ii)[12]).toString();
            data[13] = df2.format(materials.get(ii)[13]).toString();
            data[14] = df.format(materials.get(ii)[14]).toString();
            data[15] = materials.get(ii)[15].toString();
            data[16] = materials.get(ii)[16].toString();
            data[17] = (String)materials.get(ii)[17];
            if (data[17] != null) {
                data[17] = data[17].trim();
            }
            data[18] = (String)materials.get(ii)[18];
            if (data[18] != null) {
                data[18] = data[18].trim();
            }
            data[19] = (String)materials.get(ii)[19];
            if (data[19] != null) {
                data[19] = data[19].trim();
            }
            data[20] = materials.get(ii)[20] == null ? "" : ((Date)materials.get(ii)[20]).toString();
            data[21] = materials.get(ii)[21] == null ? "" : ((Date)materials.get(ii)[21]).toString();
            data[22] = materials.get(ii)[22] == null ? "" : ((Date)materials.get(ii)[22]).toString();
            data[23] = "-";
            data[24] = materials.get(ii)[23].toString();
            data[25] = "";
            data[26] = (String)materials.get(ii)[24];
            if (data[26] != null) {
                data[26] = data[26].trim();
            }
            this.dataM4P.put(((String)materials.get(ii)[25]).trim(), data);
            b_data = false;
        }
        HibernateMaterialsDao hibernateMaterialsDao = new HibernateMaterialsDao();
        List<MatDb> library = hibernateMaterialsDao.getMatDbList();
        Iterator<MatDb> it_matDb = library.iterator();
        b_data = false;
        while (it_matDb.hasNext()) {
            MatDb matDb = it_matDb.next();
            matDb.init();
            if (this.dataM4P.get(matDb.getProvref()) == null) {
                b_data = true;
            }
            double dd = matDb.getEp();
            if (!b_data) continue;
            String[] data = new String[27];
            data[0] = Globals.getMatDbNom(matDb.getNom_fr(), dd, 1.0);
            data[1] = Globals.getMatDbNom(matDb.getNom_al(), dd, 1.0);
            data[2] = Globals.getMatDbNom(matDb.getNom_it(), dd, 1.0);
            data[3] = Globals.getMatDbNom(matDb.getNom_en(), dd, 1.0);
            for (int jj = 0; jj < 4; ++jj) {
                if (data[jj] == null) continue;
                data[jj] = data[jj].trim();
            }
            data[4] = df2.format(matDb.getGg());
            data[5] = df2.format(matDb.getAlpha());
            data[6] = df3.format(matDb.getLambda());
            data[7] = df2.format(matDb.getCc());
            data[8] = df.format(matDb.getRho());
            data[9] = df4.format(matDb.getVmin());
            data[10] = df4.format(matDb.getVmax());
            data[11] = df.format(matDb.getH2o());
            data[12] = df.format(matDb.getPor());
            data[13] = df2.format(dd / 10.0);
            data[14] = df.format(matDb.getNre());
            data[15] = df.format(matDb.getCo2());
            data[16] = df.format(matDb.getUbp());
            data[17] = matDb.getSrc();
            if (data[17] != null) {
                data[17] = data[17].trim();
            }
            data[18] = matDb.getSrceco();
            if (data[18] != null) {
                data[18] = data[18].trim();
            }
            data[19] = matDb.getPattern();
            if (data[19] != null) {
                data[19] = data[19].trim();
            }
            if (matDb.getDtstart() != null) {
                data[20] = matDb.getDtstart().toString();
            }
            if (matDb.getDtstop() != null) {
                data[21] = matDb.getDtstop().toString();
            }
            if (matDb.getUpdt() != null) {
                data[22] = matDb.getUpdt().toString();
            }
            data[23] = "-";
            data[24] = df.format(matDb.getFlags());
            data[25] = "";
            data[26] = matDb.getProvref();
            if (data[26] != null) {
                data[26] = data[26].trim();
            }
            this.dataM4P.put(matDb.getRef(), data);
            b_data = false;
        }
        if (this.dataM4P != null) {
            Ecad2007.setProjectMatLibrary(this.dataM4P);
        }
    }

    public String getFirstFreeComponentRef(String componentCode) {
        int ii;
        String res = "";
        String[] cc = componentCode.split(",");
        String[] tmp = null;
        int[] ccnew = new int[5];
        int dim = 0;
        int dimcc = cc.length;
        String[] refs = this.getComponentCodes();
        dim = refs.length;
        int[] tblRef = new int[dim];
        int prev = 1;
        for (ii = 0; ii < dim; ++ii) {
            tmp = refs[ii].split(",");
            if (!tmp[0].equals(cc[0]) || !tmp[1].equals(cc[1])) continue;
            tblRef[ii] = Integer.parseInt(tmp[4]);
        }
        if (dim > 0) {
            prev = this.globals.getFirstFreeInt(tblRef);
        }
        dim = cc.length;
        for (ii = 0; ii < dim; ++ii) {
            ccnew[ii] = Integer.parseInt(cc[ii]);
        }
        if (dimcc == 3) {
            ccnew[2] = -1;
        }
        ccnew[4] = prev;
        res = String.valueOf(ccnew[0]) + ",";
        res = res + String.valueOf(ccnew[1]) + ",";
        res = res + String.valueOf(ccnew[2]) + ",";
        res = res + String.valueOf(ccnew[3]) + ",";
        res = res + String.valueOf(ccnew[4]);
        return res;
    }

    public String getFirstFreeRefInDataMxP(String table, String filtreLRef) {
        int cter;
        ArrayList<Integer> al = new ArrayList<Integer>(20);
        HashMap<String, String[]> data = null;
        if (table.equals("m1_ver")) {
            data = this.m1_ver;
        } else if (table.equals("m2_cad")) {
            data = this.m2_cad;
        } else if (table.equals("m3_voil")) {
            data = this.m3_voil;
        } else if (table.equals("m6_icl")) {
            data = this.m6_icl;
        }
        Set col = data.keySet();
        Iterator it = col.iterator();
        int rref = 0;
        String lref = "";
        String tmp = "";
        String res = "";
        int prev = 0;
        while (it.hasNext()) {
            tmp = ((String)it.next()).trim();
            if (tmp.indexOf(",") == -1 || !(lref = tmp.substring(0, tmp.indexOf(","))).equals(filtreLRef)) continue;
            if (tmp.length() > tmp.indexOf(",")) {
                rref = Globals.getIntValue(tmp.substring(tmp.indexOf(",") + 1));
            }
            al.add(new Integer(rref));
        }
        int[] tblRef = new int[al.size()];
        for (cter = 0; cter < tblRef.length; ++cter) {
            tblRef[cter] = Globals.getIntValue(al.get(cter));
        }
        Arrays.sort(tblRef);
        prev = 1;
        for (cter = 0; cter < tblRef.length && prev >= tblRef[cter]; ++cter) {
            prev = tblRef[cter] + 1;
        }
        res = String.valueOf(filtreLRef) + "," + String.valueOf(prev);
        return res;
    }

    private final Object[] getM4data(Composant_M composant_m) {
        Object[] values = new Object[20];
        this.M4data = new Object[this.dim][6];
        this.M4d = new String[this.dim][2];
        values[9] = new Integer(-1);
        String tempdata = null;
        int itmp = 0;
        for (int cter = 0; cter < this.dim; ++cter) {
            this.M4d[cter][1] = "-1";
        }
        values[0] = composant_m.getN_lay();
        values[1] = composant_m.getNom();
        values[2] = composant_m.getPt_c();
        values[3] = composant_m.getPn_c();
        values[4] = composant_m.getU_c();
        values[5] = composant_m.getRai();
        values[6] = composant_m.getRae();
        values[7] = composant_m.getD1_c();
        values[8] = composant_m.getD2_c();
        int n_lay = Globals.getIntValue(values[0]);
        String[][] refs_m4 = composant_m.getRefs_m4();
        Float[] dcs = composant_m.getDcs();
        for (int cter = 0; cter < n_lay; ++cter) {
            String pr_ref;
            if (refs_m4[0][cter] == null) continue;
            tempdata = refs_m4[0][cter];
            Object[] row = this.tm_catm4.get(tempdata);
            if (row == null && tempdata != null && !tempdata.trim().equals("") && (pr_ref = this.tm_r2pr.get(tempdata)) != null) {
                row = this.tm_catm4.get(this.tm_r2pr.get(tempdata));
            }
            if (row != null) {
                if (row[8] != null && ((itmp = Globals.getIntValue((String)row[8])) & 0x10) == 16) {
                    values[9] = new Integer(cter);
                }
                this.M4data[cter][2] = tempdata;
                this.M4data[cter][0] = row[this.lan];
                this.M4data[cter][1] = row[5];
                if (((String)row[4]).compareTo("0.0") != 0) {
                    this.M4d[cter][1] = (String)row[4];
                }
            }
            if ((row = this.tm_catm4.get(tempdata = refs_m4[1][cter] == null ? "" : refs_m4[1][cter])) == null && tempdata != null && !tempdata.trim().equals("") && (pr_ref = this.tm_r2pr.get(tempdata)) != null) {
                row = this.tm_catm4.get(this.tm_r2pr.get(tempdata));
            }
            if (row == null) continue;
            if (row[8] != null && ((itmp = Integer.parseInt((String)row[8])) & 0x10) == 16) {
                values[9] = new Integer(cter);
            }
            this.M4data[cter][5] = tempdata;
            this.M4data[cter][3] = row[this.lan];
            this.M4data[cter][4] = row[5];
            this.M4d[cter][0] = String.valueOf(dcs[cter]);
            if (((String)row[4]).compareTo("0.0") == 0 || this.M4d[cter][1].compareTo("-1") == 0) continue;
            this.M4d[cter][0] = (String)row[4];
        }
        values[10] = this.M4data;
        values[11] = this.M4d;
        values[12] = composant_m.getDtstart();
        values[13] = composant_m.getDtstop();
        values[14] = composant_m.getUpdt();
        values[15] = composant_m.getA();
        values[16] = composant_m.getB();
        values[17] = composant_m.getC();
        values[18] = composant_m.getD();
        values[19] = composant_m.getE();
        return values;
    }

    public Map<String, String[]> getDataM1P() {
        return this.m1_ver;
    }

    public Map<String, String[]> getDataM2P() {
        return this.m2_cad;
    }

    public Map<String, String[]> getDataM3P() {
        return this.m3_voil;
    }

    public Map<String, String[]> getDataM4P() {
        return this.dataM4P;
    }

    public Map<String, String[]> getDataM6P() {
        return this.m6_icl;
    }

    public void deleteTable() {
        if (this.dbpr_comp != null) {
            this.dbpr_comp.deleteTable();
        }
    }

    public boolean equals(String componentcode, int[] situation) {
        boolean res = false;
        int[] cc = new int[5];
        String tmp = componentcode;
        int index = 0;
        index = tmp.indexOf(",");
        cc[0] = Integer.parseInt(tmp.substring(0, index));
        for (int ii = 1; ii < 5; ++ii) {
            if (index > 0) {
                if ((index = (tmp = tmp.substring(index + 1)).indexOf(",")) > 0) {
                    cc[ii] = Integer.parseInt(tmp.substring(0, index));
                    continue;
                }
                cc[ii] = Integer.parseInt(tmp);
                continue;
            }
            cc[ii] = -1;
        }
        int dim = 0;
        int dim2 = 0;
        if (situation != null) {
            dim = situation.length;
        }
        for (int ii = 0; ii < dim; ++ii) {
            if (cc[ii] != situation[ii]) continue;
            ++dim2;
        }
        if (dim != 0 && dim == dim2) {
            res = true;
        }
        return res;
    }

    public boolean componentExists(String componentCode) {
        boolean res = false;
        if (this.getComponent(componentCode) != null) {
            res = true;
        }
        return res;
    }

    public Object[] getComponent(String componentCode) {
        return this.mapM4.get(componentCode);
    }

    public Object[] getComponentByBitWiseCheck(String componentCode, int cols) {
        String[] refs = this.getComponentCodes();
        String[] cc = componentCode.split(",");
        String[] ref = null;
        String code = "";
        int COLDIM = 5;
        int res = 0;
        int dim = refs.length;
        boolean b_res = false;
        for (int ii = 0; ii < dim; ++ii) {
            code = refs[ii];
            ref = refs[ii].split(",");
            if (COLDIM != ref.length) {
                COLDIM = ref.length;
            }
            for (int jj = 0; jj < COLDIM; ++jj) {
                if (((int)Math.pow(2.0, jj) & cols) > 0) {
                    if ((Globals.getIntValue(ref[jj]) & Globals.getIntValue(cc[jj])) <= 0) continue;
                    ++res;
                    continue;
                }
                if (jj >= cc.length) {
                    ++res;
                    continue;
                }
                if (!ref[jj].equals(cc[jj])) continue;
                ++res;
            }
            if (res == COLDIM) {
                b_res = true;
                break;
            }
            res = 0;
        }
        if (b_res) {
            return this.mapM4.get(code);
        }
        return null;
    }

    public String getComponentName(String componentCode) {
        String res = "";
        Object[] object = this.mapM4.get(componentCode);
        String[] cc = null;
        if (object == null) {
            return Ecad2007.getTraduction("gen").getCodeLan("comp") + ":";
        }
        if (componentCode != null && (cc = componentCode.split(",")).length > 0) {
            res = cc[1].equals("2") ? (String)object[0] : (String)object[1];
        }
        return res.trim();
    }

    public double getComponentU_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        String[] cc = componentcode.split(",");
        if (object == null) {
            object = this.getComponentByBitWiseCheck(componentcode, 4);
        }
        if (object == null) {
            return 0.0;
        }
        if (cc[1].equals("1")) {
            return Globals.getDoubleValue(object[4]);
        }
        if (cc[1].equals("2")) {
            return Globals.getDoubleValue(object[1]);
        }
        if (cc[1].equals("4")) {
            return Globals.getDoubleValue(object[4]);
        }
        if (cc[1].equals("8")) {
            return Globals.getDoubleValue(object[4]);
        }
        return 0.0;
    }

    public double getComponentUG_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return Globals.getDoubleValue(object[2]);
        }
        return 0.0;
    }

    public double getComponentG_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        String[] cc = componentcode.split(",");
        if (object != null) {
            if (cc[1].equals("2")) {
                return (Double)object[3];
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getComponentG_C(String componentcode, int columns) {
        Iterator<Object[]> iterator = this.mapM4.values().iterator();
        Object[] object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            object = this.getComponentByBitWiseCheck(componentcode, columns);
            if (object == null) continue;
        }
        if (object != null) {
            if (object[16].equals(new Integer(2))) {
                return (Double)object[3];
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getComponentLR_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[7];
        }
        return 0.0;
    }

    public double getComponentUF_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[11];
        }
        return 0.0;
    }

    public double getComponentFF_C(String componentCode) {
        Object[] object = this.mapM4.get(componentCode);
        String[] cc = null;
        if (object == null) {
            return 0.0;
        }
        cc = componentCode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[4];
        }
        return 0.0;
    }

    public String[][] getComponentFlags(String componentcode) {
        String[][] flags = new String[12][2];
        Object[] objects = this.mapM4.get(componentcode);
        String[] cc = componentcode.split(",");
        if (!cc[1].equals("1")) {
            return flags;
        }
        if (objects == null) {
            return flags;
        }
        Map<String, String[]> map = Ecad2007.getProjectMatLibrary();
        Object[][] mats = (Object[][])objects[10];
        int n_lay = Globals.getIntValue(objects[0]);
        for (int ii = 0; ii < n_lay; ++ii) {
            String[] re = map.get(mats[ii][2]);
            String[] st = map.get(mats[ii][5]);
            flags[ii][0] = re == null ? "0" : (re[24] == null ? re[24] : re[24]);
            flags[ii][1] = st == null ? "0" : (st[24] == null ? "0" : st[24]);
        }
        return flags;
    }

    public double getComponentD1_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        String[] cc = componentcode.split(",");
        if (object == null) {
            return -1.0;
        }
        if (!cc[1].equals("1")) {
            return -1.0;
        }
        return Globals.getDoubleValue(object[7]);
    }

    public double getComponentD2_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        String[] cc = componentcode.split(",");
        if (object == null) {
            return -1.0;
        }
        if (!cc[1].equals("1")) {
            return -1.0;
        }
        return Globals.getDoubleValue(object[8]);
    }

    public double getComponentFC_C(String componentCode) {
        Object[] object = this.mapM4.get(componentCode);
        String[] cc = null;
        if (object == null) {
            return 0.0;
        }
        cc = componentCode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[5];
        }
        return 0.0;
    }

    public double getComponentUI_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[6];
        }
        return 0.0;
    }

    public double getComponentICA_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[8];
        }
        return 0.0;
    }

    public double getComponentICL_C(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0.0;
        }
        String[] cc = componentcode.split(",");
        if (cc[1].equals("2")) {
            return (Double)object[9];
        }
        return 0.0;
    }

    public String[] getComponentRefs(String componentCode) {
        Object[] object = this.mapM4.get(componentCode);
        return (String[])object[10];
    }

    public String[] getComponentRefsByBitWiseCheck(String componentCode) {
        ArrayList<String> al = new ArrayList<String>();
        String[] refs = this.getComponentCodes();
        String[] cc = componentCode.split(",");
        String[] cc0 = null;
        String code = "";
        int cols = 15;
        int COLDIM = (int)Math.pow(cols + 1, 0.5);
        int dim = refs.length;
        for (int ii = 0; ii < dim; ++ii) {
            int i_res = 0;
            code = refs[ii];
            cc0 = refs[ii].split(",");
            if (COLDIM > cc0.length) {
                COLDIM = cc0.length;
            }
            for (int jj = 0; jj < COLDIM; ++jj) {
                if (((int)Math.pow(2.0, jj) & cols) <= 0 || (Globals.getIntValue(cc0[jj]) & Globals.getIntValue(cc[jj])) <= 0) continue;
                ++i_res;
            }
            if (i_res != COLDIM) continue;
            al.add(code);
        }
        String[] array = new String[al.size()];
        al.toArray(array);
        return array;
    }

    public Object[][] getComponents(String partcomponentcode) {
        Object[][] res = null;
        Object[] component2 = null;
        HashMap<String, Object[]> compmap = new HashMap<String, Object[]>(20);
        if (partcomponentcode == null) {
            partcomponentcode = "";
        }
        String[] code = partcomponentcode.split(",");
        int length = 0;
        int length2 = 0;
        if (code != null) {
            length = code.length;
        }
        String componentcode = "";
        Iterator<Object> iterator = null;
        for (Object[] component2 : this.mapM4.values()) {
            for (int jj = 0; jj < length; ++jj) {
                if ((Integer.parseInt(code[jj]) & Globals.getShortValue(component2[15 + jj])) > 0) {
                    ++length2;
                    continue;
                }
                if (Integer.parseInt(code[jj]) != Globals.getShortValue(component2[18])) continue;
                ++length2;
            }
            componentcode = String.valueOf(Globals.getShortValue(component2[15])) + ",";
            componentcode = componentcode + String.valueOf(Globals.getShortValue(component2[16])) + ",";
            componentcode = componentcode + String.valueOf(Globals.getShortValue(component2[17])) + ",";
            componentcode = componentcode + String.valueOf(Globals.getShortValue(component2[18])) + ",";
            componentcode = componentcode + String.valueOf(Globals.getShortValue(component2[19]));
            if (length == length2) {
                compmap.put(componentcode, component2);
            }
            length2 = 0;
        }
        int size = compmap.size();
        int cter = 0;
        if (size > 0) {
            res = new Object[size][20];
            iterator = compmap.values().iterator();
            while (iterator.hasNext()) {
                res[cter] = (Object[])iterator.next();
                ++cter;
            }
        }
        return res;
    }

    private final Object[] getW4data(Composant_W composant_w) throws Exception {
        String rm6_icl;
        String rm3_voil;
        String rm2_cad;
        Object[] values = new Object[20];
        values[0] = composant_w.getNom_c();
        if (values[0] != null) {
            values[0] = ((String)values[0]).trim();
        }
        values[1] = composant_w.getU_c();
        values[2] = composant_w.getUg_c();
        values[3] = composant_w.getG_c();
        values[4] = composant_w.getFf_c();
        values[5] = composant_w.getFc_c();
        values[6] = composant_w.getUi_c();
        values[7] = composant_w.getLr_c();
        values[8] = composant_w.getIca_c();
        values[9] = composant_w.getIcl_c();
        String rm1_ver = composant_w.getRef_m1();
        if (rm1_ver != null) {
            rm1_ver = rm1_ver.trim();
        }
        if ((rm2_cad = composant_w.getRef_m2()) != null) {
            rm2_cad = rm2_cad.trim();
        }
        if ((rm3_voil = composant_w.getRef_m3()) != null) {
            rm3_voil = rm3_voil.trim();
        }
        if ((rm6_icl = composant_w.getRef_m6()) != null) {
            rm6_icl = rm6_icl.trim();
        }
        values[10] = new String[]{rm1_ver, rm2_cad, rm3_voil, rm6_icl};
        values[11] = composant_w.getUf_c();
        values[12] = composant_w.getDtstart();
        values[13] = composant_w.getDtstop();
        values[14] = composant_w.getUpdt();
        values[15] = composant_w.getA();
        values[16] = composant_w.getB();
        values[17] = composant_w.getC();
        values[18] = composant_w.getD();
        values[19] = composant_w.getE();
        return values;
    }

    public double[] getWindowValues(String componentcode) {
        double[] wvalue = new double[]{this.getComponentUG_C(componentcode), this.getComponentG_C(componentcode), this.getComponentUI_C(componentcode), this.getComponentLR_C(componentcode), this.getComponentUF_C(componentcode), this.getComponentFF_C(componentcode), this.getComponentFC_C(componentcode)};
        return wvalue;
    }

    private final Object[] getP4data(Composant_P composant_p) throws Exception {
        Object[] values = new Object[20];
        values[0] = composant_p.getNom_ge();
        if (values[0] != null) {
            values[0] = ((String)values[0]).trim();
        }
        values[1] = composant_p.getNom_fr();
        if (values[1] != null) {
            values[1] = ((String)values[1]).trim();
        }
        values[2] = composant_p.getNom_it();
        if (values[2] != null) {
            values[2] = ((String)values[2]).trim();
        }
        values[3] = composant_p.getNom_en();
        if (values[3] != null) {
            values[3] = ((String)values[3]).trim();
        }
        values[4] = composant_p.getU_c();
        values[6] = composant_p.getBase();
        if (values[6] != null) {
            values[6] = ((String)values[6]).trim();
        }
        values[7] = composant_p.getImageIcon();
        values[8] = composant_p.getProvref();
        if (values[8] != null) {
            values[8] = ((String)values[8]).trim();
        }
        values[12] = composant_p.getDtstart();
        values[13] = composant_p.getDtstop();
        values[14] = composant_p.getUpdt();
        values[15] = composant_p.getA();
        values[16] = composant_p.getB();
        values[17] = composant_p.getC();
        values[18] = composant_p.getD();
        values[19] = composant_p.getE();
        return values;
    }

    public double[] getPontTherm(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        return new double[]{Globals.getDoubleValue(object[2]), Globals.getDoubleValue(object[3])};
    }

    public double getValeurU(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        return Globals.getDoubleValue(object[4]);
    }

    public float[] getRAie(String componentcode) {
        if (this.mapM4 == null) {
            return new float[]{0.0f, 0.0f};
        }
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return Globals.getDefaultRAie(componentcode);
        }
        return new float[]{Globals.getFloatValue(object[5]), Globals.getFloatValue(object[6])};
    }

    public int getCoucheCh(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            object = this.getComponentByBitWiseCheck(componentcode, 4);
        }
        if (object == null) {
            return -1;
        }
        return Globals.getIntValue(object[9]);
    }

    public int[] getCoucheChBl(Object[] composant) {
        int coucheCh = -1;
        int coucheSt = -1;
        if (composant == null) {
            return new int[]{-1, -1};
        }
        if (composant[0] == null) {
            return new int[]{-1, -1};
        }
        short bb = Globals.getShortValue(composant[16]);
        if ((bb & 1) != 1) {
            return new int[]{-1, -1};
        }
        int n_lay = Globals.getShortValue(composant[0]);
        Object[][] m4data = (Object[][])composant[10];
        String[] ref_m4 = new String[]{"", ""};
        for (int cter = 0; cter < n_lay; ++cter) {
            ref_m4[0] = (String)m4data[cter][2];
            ref_m4[1] = (String)m4data[cter][5];
            Map<String, String[]> dataM4 = Ecad2007.getMatLibrary();
            for (int ii = 0; ii < 2; ++ii) {
                Object[] row;
                if (dataM4.get(ref_m4[ii]) == null || (row = (Object[])dataM4.get(ref_m4[ii]))[24] == null || ((String)row[24]).equals("") || ((String)row[24]).equals("-")) continue;
                int flags = Integer.parseInt((String)row[24]);
                if ((flags & 0x10) == 16) {
                    coucheCh = new Integer(cter);
                }
                if ((flags & 0x20) != 32) continue;
                coucheSt = new Integer(cter);
            }
        }
        return new int[]{coucheCh, coucheSt};
    }

    public double[] getDimRS(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        return new double[]{Globals.getDoubleValue(object[7]), Globals.getDoubleValue(object[8])};
    }

    public Object getMatData(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        return object[10];
    }

    public String[][] getDimData(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        Object[][] dd = (Object[][])object[11];
        String[][] dimdata = new String[12][2];
        for (int ii = 0; ii < 12 && dd[ii][0] != null; ++ii) {
            dimdata[ii][0] = (String)dd[ii][0];
            dimdata[ii][1] = (String)dd[ii][1];
        }
        return dimdata;
    }

    public Object[][] getMatDataExt(String componentcode) {
        Object[][] mats = new String[12][10];
        Object[][] rows = (Object[][])this.getMatData(componentcode);
        Map<String, String[]> map = this.getDataM4P();
        for (int row = 0; row < rows.length; ++row) {
            String[] mat = map.get(rows[row][2]);
            mats[row][0] = rows[row][0];
            mats[row][1] = rows[row][1];
            if (mat != null) {
                mats[row][2] = mat[7];
                mats[row][3] = mat[8];
            }
            mats[row][4] = rows[row][2];
            mat = map.get(rows[row][5]);
            mats[row][5] = rows[row][3];
            mats[row][6] = rows[row][4];
            if (mat != null) {
                mats[row][7] = mat[7];
                mats[row][8] = mat[8];
            }
            mats[row][9] = rows[row][5];
        }
        return mats;
    }

    public String[][] getMatThickness(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        return (String[][])object[11];
    }

    public int getNumbersOfLayers(String componentcode) {
        Object[] object = this.mapM4.get(componentcode);
        if (object == null) {
            return 0;
        }
        return Globals.getIntValue(object[0]);
    }

    public String[] getComponentCodes() {
        Object[] refs = this.mapM4.keySet().toArray();
        int dim = 0;
        String[] res = null;
        if (refs != null) {
            dim = refs.length;
            res = new String[dim];
            for (int ii = 0; ii < dim; ++ii) {
                res[ii] = (String)refs[ii];
            }
        }
        return res;
    }

    public TreeMap<String, Object[]> getCatalogueM4() {
        return this.tm_catm4;
    }

    public TreeMap<String, String> getRef2ProvRef() {
        return this.tm_r2pr;
    }

    public void insertMaterialIntoTable(Map<String, String[]> data) {
        int dim = data.size();
        Object[] keys = data.keySet().toArray();
        String[] material = null;
        for (int ii = 0; ii < dim; ++ii) {
            material = data.get(keys[ii]);
            if (this.isInMaterialTable("materials", material)) continue;
            this.dbpr_comp.insertIntoTable("materials", material, (String)keys[ii]);
        }
    }

    public void insertMaterialIntoWindowTable(Map<String, String[]> data) {
        String[] keys = new String[]{"m1_ver", "m2_cad", "m3_voil", "m6_icl"};
        for (int ii = 0; ii < keys.length; ++ii) {
            this.dbpr_comp.insertRowIntoWindowBibl(keys[ii], data.get(keys[ii]));
        }
    }

    public String insertComponentIntoHeatBridgeTable(String componentCode, Map<String, Object> values) {
        String[] cc = componentCode.split(",");
        values.put("DTSTART", null);
        values.put("DTSTOP", null);
        values.put("UPDT", null);
        values.put("A", new Integer(cc[0]));
        values.put("B", new Integer(cc[1]));
        values.put("C", new Integer(cc[2]));
        values.put("D", new Integer(cc[3]));
        values.put("E", new Integer(cc[4]));
        return this.dbpr_comp.insertComponentIntoHeatBridgeBibl(values);
    }

    public boolean insertComponentIntoWindowTable(String componentCode, Map<String, String[]> mat, Map<String, Object> data) {
        HashMap<String, Object> values = new HashMap<String, Object>(23);
        String[] cc = componentCode.split(",");
        String[] val = new String[]{"NOM_C", "U_C", "UG_C", "G_C", "UF_C", "FF_C", "FC_C", "UI_C", "LR_C", "ICA_C", "ICL_C"};
        for (int ii = 0; ii < val.length; ++ii) {
            values.put(val[ii], data.get(val[ii]));
        }
        values.put("REF_M1", mat.get("m1_ver")[11]);
        values.put("REF_M2", mat.get("m2_cad")[9]);
        values.put("REF_M3", mat.get("m3_voil")[9]);
        values.put("REF_M6", mat.get("m6_icl")[9]);
        values.put("DTSTART", null);
        values.put("DTSTOP", null);
        values.put("UPDT", null);
        values.put("A", new Integer(cc[0]));
        values.put("B", new Integer(cc[1]));
        values.put("C", new Integer(cc[2]));
        values.put("D", new Integer(cc[3]));
        values.put("E", new Integer(cc[4]));
        return this.dbpr_comp.insertComponentIntoWindowTable(values);
    }

    public boolean checkComponent(String componentCode) {
        Object[] object = this.mapM4.get(componentCode);
        return object != null;
    }

    private boolean isInMaterialTable(String table, String[] data) {
        boolean res = false;
        String[] columnNames = new String[]{"NOM_AL", "NOM_FR", "NOM_IT", "NOM_EN", "GG", "ALPHA", "LAMBDA", "CC", "DD", "VMIN", "VMAX", "H2O", "POROSITE", "EPAISSEUR", "NRE", "CO2", "UBP", "SRC", "SRCECO", "PATTERN", "FLAGS"};
        String clause = "";
        int dim = columnNames.length;
        int cols = data.length;
        for (int ii = 4; ii < 17; ++ii) {
            clause = Globals.getDouble(data[ii]) == null ? clause + columnNames[ii] + "=0 AND " : clause + columnNames[ii] + "=" + data[ii] + " AND ";
        }
        clause = data[19] == null ? clause + columnNames[19] + "='' AND " : clause + columnNames[19] + "='" + data[19].trim() + "' AND ";
        clause = Globals.getDouble(data[24]) == null ? clause + columnNames[20] + "=0" : clause + columnNames[20] + "=" + data[24];
        if (this.dbpr_comp == null) {
            this.dbpr_comp = new DBpr_Comp("int");
        }
        if (this.dbpr_comp.getRows(table, columnNames, clause).size() > 0) {
            res = true;
        }
        return res;
    }

    public Map refreshDataM4P(Map dataM4P) {
        if (dataM4P != null && dataM4P.size() > 0) {
            dataM4P.putAll(dataM4P);
            Ecad2007.addToProjectMatLibrary(dataM4P);
        }
        return this.dataM4P;
    }

    public boolean updateComponentWindowTable(String componentCode, Map<String, String[]> mat, Map<String, Object> data) {
        String[] cc = componentCode.split(",");
        Composant_W composant_w = new Composant_W();
        composant_w.setNom_c(Globals.getStringValue(data.get("NOM_C")));
        composant_w.setU_c(Globals.getDoubleValue(data.get("U_C")));
        composant_w.setUg_c(Globals.getDoubleValue(data.get("UG_C")));
        composant_w.setG_c(Globals.getDoubleValue(data.get("G_C")));
        composant_w.setUf_c(Globals.getDoubleValue(data.get("UF_C")));
        composant_w.setFf_c(Globals.getDoubleValue(data.get("FF_C")));
        composant_w.setFc_c(Globals.getDoubleValue(data.get("FC_C")));
        composant_w.setUi_c(Globals.getDoubleValue(data.get("UI_C")));
        composant_w.setLr_c(Globals.getDoubleValue(data.get("LR_C")));
        composant_w.setIca_c(Globals.getDoubleValue(data.get("ICA_C")));
        composant_w.setIcl_c(Globals.getDoubleValue(data.get("ICL_C")));
        composant_w.setRef_m1(mat.get("m1_ver")[11]);
        composant_w.setRef_m2(mat.get("m2_cad")[9]);
        composant_w.setRef_m3(mat.get("m3_voil")[9]);
        composant_w.setRef_m6(mat.get("m6_icl")[9]);
        composant_w.setA(new Integer(cc[0]));
        composant_w.setB(new Integer(cc[1]));
        composant_w.setC(new Integer(cc[2]));
        composant_w.setD(new Integer(cc[3]));
        composant_w.setE(new Integer(cc[4]));
        return this.dbpr_comp.updateComponentWindowTable(composant_w);
    }
}

