/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import core.Calculation;
import core.hibernate.cat.dao.HibernateC2Dao;
import core.hibernate.cat.db.C2;
import core.hibernate.pro.dao.HibernateComposant_MDao;
import core.hibernate.pro.db.Composant_M;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DMpr_ValU
implements Cloneable {
    private static DMpr_ValU DMpr;
    private static HashMap<String, Object> datamap;
    Globals globals = new Globals();
    HibernateComposant_MDao hibernateComposant_MDao = new HibernateComposant_MDao();
    String base = "cat";
    Statement st_catm4 = null;
    Statement st_comp = null;
    ResultSet rs_catm4 = null;
    String componentCode = "-0,0,0";
    String[] cc;
    Object[][] M4data;
    Map<String, String[]> dataM4;
    Map<String, String[]> dataM4P = new HashMap<String, String[]>(100);
    String[][] M4d;
    String[][] M4flags;
    String componentName;
    String errormsg = null;
    double[] PontTherm = new double[2];
    double ValeurU = 0.0;
    float[] RAie = new float[2];
    double[] DimRS = new double[2];
    int coucheCh = -1;
    int coucheSt = -1;
    String Position = "";
    int n_lay = 0;
    int dim = 12;
    int lan = 1;
    String codeLan = "";

    public DMpr_ValU() {
        if (Ecad2007.getMatLibrary() != null) {
            this.dataM4 = Ecad2007.getMatLibrary();
        }
        if (Ecad2007.getProjectMatLibrary() != null) {
            this.dataM4P = Ecad2007.getProjectMatLibrary();
        }
    }

    public DMpr_ValU(String componentCode) {
        this.componentCode = componentCode;
        if (componentCode != null) {
            this.cc = componentCode.split(",");
            if (this.cc[0].indexOf("-") == 0) {
                this.cc[0] = this.cc[0].substring(1);
            }
            if (!componentCode.startsWith("-")) {
                try {
                    this.jbInit();
                }
                catch (Exception ex) {
                    Ecad2007.trace(ex);
                }
            } else {
                if (Ecad2007.getMatLibrary() != null) {
                    this.dataM4 = Ecad2007.getMatLibrary();
                }
                if (Ecad2007.getProjectMatLibrary() != null) {
                    this.dataM4P = Ecad2007.getProjectMatLibrary();
                }
            }
        }
    }

    public DMpr_ValU(String base, String componentCode) {
        this.componentCode = componentCode;
        this.base = base;
        if (componentCode != null) {
            this.cc = componentCode.split(",");
            if (this.cc[0].indexOf("-") == 0) {
                this.cc[0] = this.cc[0].substring(1);
            }
            if (!componentCode.startsWith("-")) {
                try {
                    this.jbInit();
                }
                catch (Exception ex) {
                    Ecad2007.trace(ex);
                }
            } else {
                if (Ecad2007.getMatLibrary() != null) {
                    this.dataM4 = Ecad2007.getMatLibrary();
                }
                if (Ecad2007.getProjectMatLibrary() != null) {
                    this.dataM4P = Ecad2007.getProjectMatLibrary();
                }
            }
        }
    }

    public DMpr_ValU(HashMap<String, Object> datamap) {
        DMpr_ValU.datamap = datamap;
        this.lan = Ecad2007.getCodeLan();
        if (this.lan == 0) {
            this.codeLan = "GE";
        } else if (this.lan == 1) {
            this.codeLan = "FR";
        } else if (this.lan == 2) {
            this.codeLan = "IT";
        } else if (this.lan == 3) {
            this.codeLan = "EN";
        }
        this.getM4DataP();
    }

    private void jbInit() throws Exception {
        if (Ecad2007.getMatLibrary() != null) {
            this.dataM4 = Ecad2007.getMatLibrary();
        }
        if (Ecad2007.getProjectMatLibrary() != null) {
            this.dataM4P = Ecad2007.getProjectMatLibrary();
        }
        this.lan = Ecad2007.getCodeLan();
        if (this.lan == 0) {
            this.codeLan = "GE";
        } else if (this.lan == 1) {
            this.codeLan = "FR";
        } else if (this.lan == 2) {
            this.codeLan = "IT";
        } else if (this.lan == 3) {
            this.codeLan = "EN";
        }
        if (!this.componentCode.startsWith("-")) {
            if (this.base.equals(Globals.PROJECT_NAME)) {
                this.getM4Data(new HibernateComposant_MDao());
            } else {
                this.getM4Data(new HibernateC2Dao());
            }
        }
    }

    public DMpr_ValU clone() {
        DMpr_ValU dmpr_ValU = null;
        try {
            dmpr_ValU = (DMpr_ValU)super.clone();
        }
        catch (CloneNotSupportedException cnsex) {
            cnsex.printStackTrace(System.err);
        }
        return dmpr_ValU;
    }

    private void getM4DataP() {
        int cter;
        int ii;
        String tempdata;
        String[][] refM4 = new String[3][12];
        this.M4data = new Object[this.dim][10];
        this.M4d = new String[this.dim][2];
        String[] temp = null;
        int valint = 0;
        int vernr = Globals.getIntValue(datamap.get("versionC2"));
        int dim = 12;
        this.errormsg = null;
        if (vernr <= 218) {
            dim = 10;
        }
        for (int jj = 0; jj < dim; ++jj) {
            tempdata = (String)datamap.get("REF" + String.valueOf(jj + 1));
            String[] tbl = tempdata.split(" ");
            for (ii = 0; ii < 3; ++ii) {
                refM4[ii][jj] = vernr > 218 || ii < 1 ? tbl[ii].trim() : tbl[ii - 1].trim();
            }
        }
        for (cter = 0; cter < dim; ++cter) {
            this.M4d[cter][1] = "-1";
        }
        if (datamap.get("REC1") != null) {
            for (cter = 1; cter < 25 && datamap.get("REC" + String.valueOf(cter)) != null; ++cter) {
                temp = (String[])datamap.get("REC" + String.valueOf(cter));
                if (Globals.getIntValue(datamap.get("versionC2")) < 250) {
                    String[] tempold = (String[])temp.clone();
                    temp = new String[27];
                    for (ii = 0; ii < 4; ++ii) {
                        temp[ii] = tempold[0].trim();
                    }
                    temp[4] = tempold[2].trim();
                    temp[5] = tempold[3].trim();
                    temp[6] = tempold[4].trim();
                    temp[7] = tempold[5].trim();
                    temp[8] = tempold[6].trim();
                    temp[9] = tempold[7].trim();
                    temp[10] = tempold[8].trim();
                    temp[11] = tempold[9].trim();
                    temp[12] = tempold[10].trim();
                    temp[13] = tempold[11].trim();
                    temp[14] = "";
                    temp[15] = "";
                    temp[16] = "";
                    temp[17] = tempold[1].trim();
                    temp[18] = "";
                    temp[19] = "";
                    temp[20] = "";
                    temp[21] = "";
                    temp[22] = "";
                    temp[23] = "";
                    temp[24] = "";
                    temp[25] = "";
                    temp[26] = tempold[12].trim();
                }
                this.setDataM4P(temp);
            }
        } else {
            TreeSet<Integer> ts = new TreeSet<Integer>();
            for (int ii2 = 0; ii2 < refM4[0].length; ++ii2) {
                for (int jj = 0; jj < 2; ++jj) {
                    if (refM4[jj][ii2] == null || refM4[jj][ii2].equals("-")) continue;
                    tempdata = refM4[jj][ii2];
                    temp = new String[27];
                    if (tempdata.substring(0, tempdata.indexOf(",")).equals("1")) {
                        ts.add(new Integer(ii2 + 1));
                        temp = Globals.dummyMat;
                    } else {
                        temp = this.dataM4.get(tempdata);
                    }
                    this.setDataM4P(temp);
                }
            }
            if (ts.size() > 0) {
                Iterator it = ts.iterator();
                this.errormsg = "";
                while (it.hasNext()) {
                    this.errormsg = this.errormsg + String.valueOf(it.next()) + ", ";
                }
                if (this.errormsg.endsWith(", ")) {
                    this.errormsg = this.errormsg.substring(0, this.errormsg.length() - 2);
                }
            }
        }
        Ecad2007.setProjectMatLibrary(new HashMap<String, String[]>(this.dataM4P));
        this.n_lay = Globals.getIntValue(datamap.get("N_LAY"));
        this.componentName = (String)datamap.get("NOM_C");
        this.PontTherm[0] = Globals.getDoubleValue(datamap.get("PT_C"));
        this.PontTherm[1] = Globals.getDoubleValue(datamap.get("PN_C"));
        this.ValeurU = Globals.getDoubleValue(datamap.get("U_C"));
        this.RAie[0] = Globals.getFloatValue(datamap.get("RAi"));
        this.RAie[1] = Globals.getFloatValue(datamap.get("RAe"));
        this.DimRS[0] = Globals.getDoubleValue(datamap.get("D1_C"));
        this.DimRS[1] = Globals.getDoubleValue(datamap.get("D2_C"));
        this.coucheCh = Globals.getIntValue(datamap.get("CH_C"));
        valint = Globals.getIntValue(datamap.get("TF"));
        if (valint == 2) {
            this.Position = "6";
        } else if (valint == 1) {
            this.Position = "7";
        } else if (valint == 3) {
            this.Position = "8";
        }
        for (int ii3 = 0; ii3 < 2; ++ii3) {
            block9: for (int jj = 0; jj < this.n_lay; ++jj) {
                Set<String> col = this.dataM4P.keySet();
                Iterator it = col.iterator();
                tempdata = refM4[ii3][jj];
                while (it.hasNext()) {
                    String[] datas;
                    String ref;
                    String refP = (String)it.next();
                    String lref = refP.substring(0, refP.indexOf(","));
                    if (!lref.equals("00") || !(ref = (datas = this.dataM4P.get(refP))[datas.length - 1]).equals(tempdata) && !ref.equals("0,0")) continue;
                    refM4[ii3][jj] = refP;
                    continue block9;
                }
            }
        }
        for (int cter2 = 0; cter2 < this.n_lay; ++cter2) {
            if (refM4[0][cter2].compareTo("") == 0 || refM4[0][cter2].compareTo("-") == 0) continue;
            tempdata = refM4[0][cter2];
            if (this.dataM4P.get(tempdata) != null) {
                Object[] row = new Object[6];
                row = this.dataM4P.get(tempdata);
                this.M4data[cter2][4] = tempdata;
                this.M4data[cter2][0] = ((String)row[this.lan]).trim();
                this.M4data[cter2][1] = row[6];
                this.M4data[cter2][2] = row[7];
                this.M4data[cter2][3] = row[8];
                this.M4d[cter2][0] = refM4[2][cter2];
                if (Globals.getDouble(row[13]) != null && Globals.getDoubleValue(row[13]) != 0.0) {
                    this.M4d[cter2][1] = (String)row[13];
                }
            }
            if (refM4[1][cter2].compareTo("") == 0 || refM4[1][cter2].compareTo("-") == 0 || this.dataM4P.get(tempdata = refM4[1][cter2]) == null) continue;
            Object[] row = new Object[6];
            row = this.dataM4P.get(tempdata);
            this.M4data[cter2][9] = tempdata;
            this.M4data[cter2][5] = ((String)row[this.lan]).trim();
            this.M4data[cter2][6] = row[6];
            this.M4data[cter2][7] = row[7];
            this.M4data[cter2][8] = row[8];
            this.M4d[cter2][0] = refM4[2][cter2];
            if (Globals.getDouble(row[13]) == null || this.M4d[cter2][1].compareTo("-1") == 0 || Globals.getDoubleValue(row[13].toString()) == 0.0) continue;
            this.M4d[cter2][0] = (String)row[13];
        }
    }

    private final void getM4Data(Object hibernateDao) {
        String[][] refs = null;
        Float[] dcs = null;
        String ref = null;
        this.M4data = new Object[this.dim][10];
        this.M4d = new String[this.dim][2];
        this.M4flags = new String[this.dim][2];
        for (int cter = 0; cter < this.dim; ++cter) {
            this.M4d[cter][1] = "-1";
        }
        if (hibernateDao instanceof HibernateComposant_MDao) {
            List<Composant_M> list = ((HibernateComposant_MDao)hibernateDao).getComposant_MList(this.componentCode);
            if (list.size() == 0) {
                return;
            }
            Composant_M composant_m = list.get(0);
            this.n_lay = composant_m.getN_lay().shortValue();
            this.componentName = composant_m.getNom().trim();
            this.PontTherm[0] = composant_m.getPt_c().floatValue();
            this.PontTherm[1] = composant_m.getPn_c().floatValue();
            this.ValeurU = composant_m.getU_c().floatValue();
            this.RAie[0] = composant_m.getRai().floatValue();
            this.RAie[1] = composant_m.getRae().floatValue();
            this.DimRS[0] = composant_m.getD1_c().floatValue();
            this.DimRS[1] = composant_m.getD2_c().floatValue();
            if (this.DimRS[1] < 0.0) {
                this.DimRS[1] = 0.0;
            }
            this.Position = String.valueOf(composant_m.getA());
            refs = composant_m.getRefs_m4();
            dcs = composant_m.getDcs();
        } else if (hibernateDao instanceof HibernateC2Dao) {
            List<C2> list = ((HibernateC2Dao)hibernateDao).getC2List(this.componentCode);
            if (list.size() == 0) {
                return;
            }
            C2 c2 = list.get(0);
            this.M4data = new Object[this.dim][10];
            this.M4d = new String[this.dim][2];
            this.M4flags = new String[this.dim][2];
            for (int cter = 0; cter < this.dim; ++cter) {
                this.M4d[cter][1] = "-1";
            }
            this.n_lay = Globals.getIntValue(c2.getN_lay());
            this.componentName = c2.getNom().trim();
            this.PontTherm[0] = Globals.getFloatValue(c2.getPt_c());
            this.PontTherm[1] = Globals.getFloatValue(c2.getPn_c());
            this.ValeurU = Globals.getDoubleValue(c2.getU_c());
            this.RAie[0] = Globals.getFloatValue(c2.getRai());
            this.RAie[1] = Globals.getFloatValue(c2.getRae());
            this.DimRS[0] = Globals.getDoubleValue(c2.getD1_c());
            this.DimRS[1] = Globals.getDoubleValue(c2.getD2_c());
            if (this.DimRS[1] < 0.0) {
                this.DimRS[1] = 0.0;
            }
            this.Position = String.valueOf(c2.getA());
            refs = c2.getRefs_m4();
            dcs = c2.getDcs();
        }
        for (int ii = 0; ii < this.n_lay; ++ii) {
            if (refs[0][ii] != null) {
                for (int jj = 0; jj < 2; ++jj) {
                    ref = refs[jj][ii];
                    if (ref == null && jj == 1) {
                        ref = refs[0][ii];
                    } else if (ref.trim().equals("") && jj == 1) {
                        ref = refs[0][ii];
                    }
                    this.fillArray(jj, ii, ref);
                }
                this.M4d[ii][0] = String.valueOf(dcs[ii]);
                continue;
            }
            --this.n_lay;
        }
    }

    private int generateComponentNumber() {
        int res = -1;
        int temp = -1;
        List<Composant_M> list = this.hibernateComposant_MDao.getComposant_MList(this.cc[0] + " ," + this.cc[1] + "," + this.cc[2] + "," + this.cc[3]);
        ArrayList<Integer> al = new ArrayList<Integer>(list.size());
        for (Composant_M composant_m : list) {
            al.add(Globals.getIntValue(composant_m.getE()));
        }
        Collections.sort(al);
        Object[] values = al.toArray();
        if (values != null) {
            int dim = values.length;
            if (dim > 2) {
                for (int ii = 0; ii < dim - 1; ++ii) {
                    temp = Globals.getIntValue(values[ii]);
                    if (temp + 1 >= Globals.getIntValue(values[ii + 1])) continue;
                    res = temp + 1;
                    break;
                }
            }
            if (res == -1 && dim > 1) {
                res = Globals.getIntValue(values[dim - 1]) + 1;
            }
        }
        return res;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getErrorMessage() {
        return this.errormsg;
    }

    public String getFirstFreeRefInDataM4P(String dirRef) {
        int cter;
        String res = dirRef + ",1";
        ArrayList<Integer> al = new ArrayList<Integer>(20);
        if (this.dataM4P.size() == 0) {
            this.dataM4P = Ecad2007.getProjectMatLibrary();
        }
        if (this.dataM4P == null) {
            return res;
        }
        Set<String> col = this.dataM4P.keySet();
        Iterator it = col.iterator();
        int rref = 0;
        String lref = "";
        String tmp = "";
        int prev = 0;
        while (it.hasNext()) {
            tmp = (String)it.next();
            if (tmp.indexOf(",") == -1 || !(lref = tmp.substring(0, tmp.indexOf(","))).equals(dirRef)) continue;
            if (tmp.length() > tmp.indexOf(",")) {
                rref = Globals.getIntValue(tmp.substring(tmp.indexOf(",") + 1));
            }
            al.add(rref);
        }
        int[] tblRef = new int[al.size()];
        for (cter = 0; cter < tblRef.length; ++cter) {
            tblRef[cter] = Globals.getIntValue(al.get(cter));
        }
        Arrays.sort(tblRef);
        prev = 1;
        for (cter = 0; cter < tblRef.length && prev >= tblRef[cter]; ++cter) {
            prev = tblRef[cter] + 1;
        }
        res = String.valueOf(dirRef) + "," + String.valueOf(prev);
        return res;
    }

    private void fillArray(int rs, int couche, String ref) {
        Object[] row = this.dataM4.get(ref);
        if (row != null) {
            if (row[24] != null) {
                if (!row[24].equals("") && !row[24].equals("-")) {
                    int flag = Globals.getIntValue(row[24]);
                    if ((flag & 0x10) == 16) {
                        this.coucheCh = new Integer(couche);
                    }
                    if ((flag & 0x20) == 32) {
                        this.coucheSt = new Integer(couche);
                    }
                }
                this.M4flags[couche][0] = (String)row[24];
            }
            if (rs == 0) {
                this.M4data[couche][4] = ref;
                this.M4data[couche][0] = ((String)row[this.lan]).trim();
                this.M4data[couche][1] = row[6];
                this.M4data[couche][2] = row[7];
                this.M4data[couche][3] = row[8];
            } else if (rs == 1 && ref != null) {
                this.M4data[couche][9] = ref;
                this.M4data[couche][5] = ((String)row[this.lan]).trim();
                this.M4data[couche][6] = row[6];
                this.M4data[couche][7] = row[7];
                this.M4data[couche][8] = row[8];
            }
            if (rs == 1 && ref == null) {
                this.M4data[couche][9] = this.M4data[couche][4];
                this.M4data[couche][5] = this.M4data[couche][0];
                this.M4data[couche][6] = this.M4data[couche][1];
                this.M4data[couche][7] = this.M4data[couche][2];
                this.M4data[couche][8] = this.M4data[couche][3];
            }
            if (Globals.getDouble(row[13]) != null && Globals.getDoubleValue(row[13].toString()) != 0.0) {
                this.M4d[couche][1] = (String)row[13];
            }
        }
    }

    public double[] getPontTherm() {
        return this.PontTherm;
    }

    public double getValeurU() {
        int iu = (int)(100.0 * (this.ValeurU + 0.005));
        this.ValeurU = (double)iu / 100.0;
        return this.ValeurU;
    }

    public double[][] getValeurUTWD() {
        double[][] res = new double[2][4];
        int dim = this.M4data.length;
        String[][] data_M4 = new String[dim][27];
        String[][] data_M42 = new String[dim][27];
        for (int ii = 0; ii < dim; ++ii) {
            String ref_M4 = (String)this.M4data[ii][4];
            String ref_M42 = (String)this.M4data[ii][9];
            if (ref_M4 == null) {
                dim = ii;
                data_M4 = (String[][])Arrays.copyOf(data_M4, ii);
                data_M42 = (String[][])Arrays.copyOf(data_M42, ii);
                break;
            }
            data_M4[ii] = this.dataM4.get(ref_M4);
            if (data_M4[ii] == null) {
                data_M4[ii] = this.dataM4P.get(ref_M4);
            }
            data_M42[ii] = this.dataM4.get(ref_M42);
            if (data_M42[ii] != null) continue;
            data_M42[ii] = this.dataM4P.get(ref_M42);
        }
        Object[][] data_TWD = new String[dim][10];
        boolean[] b_twd = new boolean[]{true, true};
        double[] gg_4 = new double[]{1.0, 1.0};
        double[] alpha_4 = new double[]{0.9, 0.9};
        block1: for (int ii = 0; ii < dim; ++ii) {
            for (int jj = 0; jj < 2; ++jj) {
                double gg = 0.0;
                if (jj == 0) {
                    gg = Globals.getDoubleValue(data_M4[ii][4]);
                } else if (jj == 1) {
                    gg = Globals.getDoubleValue(data_M42[ii][4]);
                }
                if (gg == 0.0 && ii == 0) {
                    res[jj][0] = this.ValeurU;
                    res[jj][1] = this.ValeurU;
                    res[jj][2] = 0.9;
                    res[jj][3] = gg;
                    b_twd[jj] = false;
                    continue;
                }
                if (gg > 0.0 && b_twd[jj]) {
                    int n = jj;
                    gg_4[n] = gg_4[n] * gg;
                    for (int ll = 0; ll < 5; ++ll) {
                        data_TWD[ii][jj * 5 + ll] = (String)this.M4data[ii][ll];
                    }
                    continue;
                }
                if (gg == 0.0 && b_twd[jj] && ii < dim - 1) {
                    b_twd[jj] = false;
                    String ref = (String)this.M4data[ii][jj * 5 + 4];
                    alpha_4[jj] = this.dataM4.get(ref) != null ? Globals.getDoubleValue(this.dataM4.get(ref)[5]) : Globals.getDoubleValue(this.dataM4P.get(ref)[5]);
                    data_TWD = (String[][])Arrays.copyOf(data_TWD, ii);
                    continue;
                }
                if (!b_twd[0] && !b_twd[1]) continue block1;
            }
        }
        for (int jj = 0; jj < 2; ++jj) {
            if (res[jj][0] != 0.0) continue;
            Calculation calculation = new Calculation();
            calculation.setData(data_TWD);
            calculation.setDimData(this.M4d);
            calculation.setRAie(new float[]{this.RAie[0], 0.0f});
            double rmoy = 0.0;
            dim = data_TWD.length;
            if (jj == 0) {
                rmoy = calculation.getRMoy(new double[]{this.DimRS[0], 0.0}, this.coucheCh, this.coucheSt, dim);
            } else if (jj == 1) {
                rmoy = calculation.getRMoy(new double[]{0.0, this.DimRS[1]}, this.coucheCh, this.coucheSt, dim);
            }
            res[jj][0] = this.ValeurU;
            res[jj][1] = 1.0 / rmoy;
            res[jj][2] = alpha_4[jj];
            res[jj][3] = gg_4[jj];
        }
        return res;
    }

    public boolean equals(DMpr_ValU dmpr_valu) {
        boolean res = false;
        if (dmpr_valu == null) {
            return false;
        }
        if (this.n_lay != dmpr_valu.getNLAY()) {
            res = true;
        } else if (this.coucheCh != dmpr_valu.getCoucheCh()) {
            res = true;
        } else if (this.coucheSt != dmpr_valu.getCoucheSt()) {
            res = true;
        } else if (!this.globals.equals(this.ValeurU, dmpr_valu.getValeurU(), 2)) {
            res = true;
        } else if (!this.componentCode.equals(dmpr_valu.getComponentCode())) {
            res = true;
        }
        if (!res) {
            Object[][] tempM4data = (Object[][])dmpr_valu.getDlgData();
            String[][] tempM4d = dmpr_valu.getDlgd();
            block0: for (int ii = 0; ii < this.dim; ++ii) {
                if (this.M4d == null && tempM4d == null) {
                    res = true;
                } else if (this.M4d[ii][0] == null && tempM4d[ii][0] != null) {
                    res = true;
                } else if (this.M4d[ii][0] != null && tempM4d[ii][0] == null) {
                    res = true;
                }
                if (res) break;
                if (this.M4d[ii][0] != null && tempM4d[ii][0] != null && !this.M4d[ii][0].equals(tempM4d[ii][0])) {
                    res = true;
                    break;
                }
                if (this.M4data == null && tempM4data == null) {
                    res = true;
                }
                for (int jj = 0; jj < 10 && !res; ++jj) {
                    if (this.M4data[ii][0] == null && tempM4data[ii][0] != null) {
                        res = true;
                    } else if (this.M4data[ii][jj] != null && tempM4data[ii][jj] == null) {
                        res = true;
                    }
                    if (res) continue block0;
                    if (this.M4data[ii][jj] == null || tempM4data[ii][jj] == null || this.M4data[ii][jj].equals(tempM4data[ii][jj])) continue;
                    res = true;
                    continue block0;
                }
            }
        }
        if (!res) {
            if (this.PontTherm[0] == dmpr_valu.getPontTherm()[0]) {
                res = true;
            } else if (this.PontTherm[1] == dmpr_valu.getPontTherm()[1]) {
                res = true;
            }
        }
        if (!res) {
            if (this.RAie[0] == dmpr_valu.getRAie()[0]) {
                res = true;
            } else if (this.RAie[1] == dmpr_valu.getRAie()[1]) {
                res = true;
            }
        }
        if (!res) {
            if (this.DimRS[0] == dmpr_valu.getDimRS()[0]) {
                res = true;
            } else if (this.DimRS[1] == dmpr_valu.getDimRS()[1]) {
                res = true;
            }
        }
        return !res;
    }

    public boolean insertRowsInProjectTable() {
        return this.insertRowsInProjectTable("", 0);
    }

    public boolean insertRowsInProjectTable(String componentCode, int bc) {
        boolean res = false;
        res = false;
        for (int ii = 0; ii < this.M4data.length; ++ii) {
            if (this.M4data[ii][0] == null) continue;
            for (int jj = 0; jj < 2; ++jj) {
                if (((String)this.M4data[ii][4 + jj * 5]).substring(0, 2).equals("00")) continue;
                this.M4data[ii][4 + jj * 5] = this.getProvRef((String)this.M4data[ii][4 + jj * 5]);
            }
        }
        if (this.isRowsInProjectTable(componentCode, bc) == null) {
            Composant_M composant_m = new Composant_M();
            composant_m.setId_proj(1);
            String componentName = this.getComponentName();
            composant_m.setNom(new String[]{componentName, componentName, componentName, componentName});
            String[][] refs_m4 = new String[2][12];
            Float[] dcs = new Float[12];
            for (int ii = 0; ii < 12; ++ii) {
                if (this.M4data[ii][0] == null) continue;
                refs_m4[0][ii] = (String)this.M4data[ii][4];
                refs_m4[1][ii] = (String)this.M4data[ii][9];
                dcs[ii] = Float.valueOf(Globals.getFloatValue(this.M4d[ii][0]));
            }
            composant_m.setRefs_m4(refs_m4);
            composant_m.setDcs(dcs);
            composant_m.setN_lay((short)this.getNLAY());
            composant_m.setPt_c(Float.valueOf((float)this.getPontTherm()[0]));
            composant_m.setPn_c(Float.valueOf((float)this.getPontTherm()[1]));
            composant_m.setU_c(Float.valueOf((float)this.getValeurU()));
            composant_m.setCh_c((short)this.getCoucheCh());
            composant_m.setSt_c((short)this.getCoucheSt());
            composant_m.setD1_c(Float.valueOf((float)this.getDimRS()[0]));
            composant_m.setD2_c(Float.valueOf((float)this.getDimRS()[1]));
            composant_m.setRai(Float.valueOf(this.getRAie()[0]));
            composant_m.setRae(Float.valueOf(this.getRAie()[1]));
            composant_m.setDtstart(new Date());
            composant_m.setUpdt(new Date());
            composant_m.setA(Short.parseShort(this.cc[0]));
            composant_m.setB(Short.parseShort(this.cc[1]));
            composant_m.setC(Short.parseShort(this.cc[2]));
            int num = this.generateComponentNumber();
            if (this.cc.length == 3) {
                composant_m.setD(-1);
                composant_m.setE(num);
            } else if (this.cc.length == 4) {
                composant_m.setD(Short.parseShort(this.cc[3]));
                composant_m.setE(num);
            } else if (this.cc.length == 5) {
                composant_m.setD(Short.parseShort(this.cc[3]));
                composant_m.setE(Short.parseShort(this.cc[4]));
            }
            int rows = this.hibernateComposant_MDao.insertComposant_M(composant_m);
            if (rows > 0) {
                res = true;
            }
        }
        return res;
    }

    private String isRowsInProjectTable(String componentCode, int bc) {
        String res = this.isRowsInProjectTable();
        String[] refs = null;
        if (componentCode.equals("")) {
            return res;
        }
        String[] cc = componentCode.split(",");
        int bcter = 0;
        int cter = 0;
        if (res == null) {
            return null;
        }
        refs = res.split(",");
        for (int ii = 0; ii < 5; ++ii) {
            if ((bc & (int)Math.pow(2.0, ii)) != (int)Math.pow(2.0, ii)) continue;
            ++bcter;
            if (!cc[ii].equals(refs[ii])) continue;
            ++cter;
        }
        if (bcter != cter) {
            res = null;
        }
        return res;
    }

    private String isRowsInProjectTable() {
        String res = null;
        Object[][] composants = Ecad2007.getDMpr_Comp().getComponents("15,1");
        Object[][] materials = null;
        String[][] dims = null;
        int cter = 0;
        if (composants == null) {
            return res;
        }
        for (int ii = 0; ii < composants.length; ++ii) {
            if (this.n_lay == Globals.getShortValue(composants[ii][0])) {
                ++cter;
            }
            if (this.componentName.equals(composants[ii][1])) {
                ++cter;
            }
            if (this.PontTherm[0] == (double)Globals.getFloatValue(composants[ii][2])) {
                ++cter;
            }
            if (this.PontTherm[1] == (double)Globals.getShortValue(composants[ii][3])) {
                ++cter;
            }
            if (Math.round(this.ValeurU * 100.0) == (long)Math.round(Globals.getFloatValue(composants[ii][4]) * 100.0f)) {
                ++cter;
            }
            if (this.RAie[0] == Globals.getFloatValue(composants[ii][5])) {
                ++cter;
            }
            if (this.RAie[1] == Globals.getFloatValue(composants[ii][6])) {
                ++cter;
            }
            if (this.DimRS[0] == (double)Globals.getFloatValue(composants[ii][7])) {
                ++cter;
            }
            if (this.DimRS[1] == (double)Globals.getFloatValue(composants[ii][8])) {
                ++cter;
            }
            if (this.coucheCh == Globals.getShortValue(composants[ii][9])) {
                ++cter;
            }
            materials = (Object[][])composants[ii][10];
            dims = (String[][])composants[ii][11];
            for (int jj = 0; jj < this.n_lay; ++jj) {
                if (materials[jj][2] == null || materials[jj][5] == null || !materials[jj][2].equals(this.M4data[jj][4]) || !materials[jj][5].equals(this.M4data[jj][9]) || !dims[jj][0].equals(this.M4d[jj][0])) continue;
                ++cter;
            }
            if (cter == 10 + this.n_lay) {
                res = String.valueOf(Globals.getShortValue(composants[ii][15])) + ",";
                res = res + String.valueOf(Globals.getShortValue(composants[ii][16])) + ",";
                res = res + String.valueOf(Globals.getShortValue(composants[ii][17])) + ",";
                res = res + String.valueOf(Globals.getShortValue(composants[ii][18])) + ",";
                this.componentCode = res = res + String.valueOf(Globals.getShortValue(composants[ii][19]));
                break;
            }
            cter = 0;
        }
        return res;
    }

    public boolean isInDataM4P(String[] comp) {
        boolean res = false;
        int ecter = 0;
        if (this.dataM4P == null) {
            return res;
        }
        Collection<String[]> collection = this.dataM4P.values();
        Iterator<String[]> it = collection.iterator();
        String[] tmp = null;
        double valb = 0.0;
        double vale = 0.0;
        while (it.hasNext()) {
            tmp = it.next();
            ecter = 0;
            vale = 0.0;
            valb = 0.0;
            if (tmp[Ecad2007.getCodeLan()].equals(comp[Ecad2007.getCodeLan()])) {
                ++ecter;
            }
            for (int ii = 4; ii < 20; ++ii) {
                if (tmp[ii] != null && !tmp[ii].equals("-") && !tmp[ii].equals("")) {
                    valb = Globals.isNumeric(tmp[ii]) ? Globals.getDoubleValue(tmp[ii]) : (double)tmp[ii].hashCode();
                }
                if (comp[ii] == null && tmp[ii] != null && tmp[ii].equals("0")) {
                    comp[ii] = "0";
                }
                if (comp[ii] != null && tmp[ii] != null && !comp[ii].equals("-") && !tmp[ii].equals("")) {
                    vale = Globals.isNumeric(comp[ii]) ? Globals.getDoubleValue(comp[ii]) : (double)comp[ii].hashCode();
                }
                if (Math.abs(valb - vale) < 1.0E-5) {
                    ++ecter;
                }
                vale = 0.0;
                valb = 0.0;
            }
            if (ecter < 17) continue;
            res = true;
            break;
        }
        return res;
    }

    private String getProvRef(String ref) {
        String res = null;
        Object[] values = this.dataM4P.values().toArray();
        Object[] keys = this.dataM4P.keySet().toArray();
        String[] row = null;
        String key = "";
        if (values == null) {
            return null;
        }
        if (ref == null) {
            return null;
        }
        if (ref.substring(0, 2).equals("00")) {
            return ref;
        }
        for (int ii = 0; ii < values.length; ++ii) {
            row = (String[])values[ii];
            key = (String)keys[ii];
            if (!row[26].equals(ref)) continue;
            res = key;
            break;
        }
        return res;
    }

    public float[] getRAie() {
        return this.RAie;
    }

    public void setRAie(String[] RAie) {
        try {
            this.RAie[0] = Float.parseFloat(RAie[0]);
            this.RAie[1] = Float.parseFloat(RAie[1]);
        }
        catch (NumberFormatException nfe) {
            System.out.println("N'a pas pu d\u00e9finir RAi ou RAe.");
        }
    }

    public String setDataM4P(Object[] datas) {
        String[] table = new String[datas.length];
        String firstFreeRef = this.getFirstFreeRefInDataM4P("00");
        for (int cter = 0; cter < datas.length; ++cter) {
            table[cter] = (String)datas[cter];
        }
        if (!this.isInDataM4P(table)) {
            if (this.dataM4P == null) {
                this.dataM4P = new HashMap<String, String[]>(100);
            }
            this.dataM4P.put(firstFreeRef, table);
        } else {
            firstFreeRef = null;
        }
        return firstFreeRef;
    }

    public String setDataM4P(String[] datas) {
        String firstFreeRef = null;
        if (this.isInDataM4P(datas)) {
            firstFreeRef = this.getFirstFreeRefInDataM4P("00");
        } else {
            firstFreeRef = this.getFirstFreeRefInDataM4P("00");
            if (this.dataM4P == null) {
                this.dataM4P = new HashMap<String, String[]>(100);
            }
            this.dataM4P.put(firstFreeRef, datas);
        }
        return firstFreeRef;
    }

    public void setDimRS(double[] DimRS) {
        if (DimRS.length == 2) {
            this.DimRS[0] = DimRS[0];
            this.DimRS[1] = DimRS[1];
        }
    }

    public void setCoucheCh(int coucheCh) {
        this.coucheCh = coucheCh;
    }

    public void setCoucheSt(int coucheSt) {
        this.coucheSt = coucheSt;
    }

    public void setDlgData(Object[][] data) {
        this.M4data = data;
    }

    public void setDlgd(String[][] dimdata) {
        this.M4d = dimdata;
    }

    public void setDlgFlags(String[][] flags) {
        this.M4flags = flags;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String[][] getDlgFlags() {
        return this.M4flags;
    }

    public void setNLay(int nlay) {
        this.n_lay = nlay;
    }

    public void setValeurU(double ValeurU) {
        this.ValeurU = ValeurU;
    }

    public void reloadM4data(Object[][] data) {
        this.M4data = data;
    }

    public void reloadM4d(String[][] dimdata) {
        this.M4d = dimdata;
    }

    public void setComponentCode(String componentCode) {
        this.componentCode = componentCode;
        if (componentCode != null) {
            this.cc = componentCode.split(",");
            if (this.cc[0].indexOf("-") == 0) {
                this.cc[0] = this.cc[0].substring(1);
            }
        }
    }

    public String getComponentCode() {
        return this.componentCode;
    }

    public void setPontTherm(double[] PontTherm) {
        if (PontTherm.length == 2) {
            this.PontTherm[0] = PontTherm[0];
            this.PontTherm[1] = PontTherm[1];
        }
    }

    public void setRAie(float[] RAie) {
        this.RAie = RAie;
    }

    public int getCoucheCh() {
        if (this.M4flags == null) {
            return this.coucheCh;
        }
        int flag = 0;
        for (int ii = 0; ii < this.M4flags.length; ++ii) {
            if (this.M4flags[ii][0] == null || this.M4flags[ii][0].equals("") || this.M4flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.M4flags[ii][0])) & 0x10) != 16) continue;
            this.coucheCh = ii;
            break;
        }
        return this.coucheCh;
    }

    public int getCoucheSt() {
        if (this.M4flags == null) {
            return this.coucheSt;
        }
        int flag = 0;
        for (int ii = 0; ii < this.M4flags.length; ++ii) {
            if (this.M4flags[ii][0] == null || this.M4flags[ii][0].equals("") || this.M4flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.M4flags[ii][0])) & 0x20) != 32) continue;
            this.coucheSt = ii;
            break;
        }
        return this.coucheSt;
    }

    public double[] getDimRS() {
        return this.DimRS;
    }

    public Object getDlgData() {
        return this.M4data;
    }

    public void setDataM4(Map<String, String[]> dataM4) {
        this.dataM4 = dataM4;
        Ecad2007.setMatLibrary(dataM4);
    }

    public Map<String, String[]> getDataM4() {
        if (this.dataM4 == null && Ecad2007.getMatLibrary() != null) {
            this.dataM4 = Ecad2007.getMatLibrary();
        }
        return this.dataM4;
    }

    public Map<String, String[]> getDataM4P() {
        if (this.dataM4P == null && Ecad2007.getProjectMatLibrary() != null) {
            this.dataM4P = Ecad2007.getProjectMatLibrary();
        }
        return this.dataM4P;
    }

    public String[][] getDlgd() {
        return this.M4d;
    }

    public static DMpr_ValU getDataModule() {
        if (DMpr == null) {
            DMpr = new DMpr_ValU();
        }
        return DMpr;
    }

    public int getNLAY() {
        return this.n_lay;
    }

    public double[][] getWeights(double area) {
        double[][] weights = new double[this.n_lay][2];
        double[] rs = this.getDimRS();
        double div1 = rs[0] / (rs[0] + rs[1]);
        double div2 = rs[1] / (rs[0] + rs[1]);
        if (this.M4data != null && this.M4d != null) {
            for (int ii = 0; ii < this.n_lay; ++ii) {
                double rho1 = Globals.getDoubleValue(this.M4data[ii][3]);
                double rho2 = Globals.getDoubleValue(this.M4data[ii][8]);
                double dd = Globals.getDoubleValue(this.M4d[ii][0]);
                weights[ii][0] = div1 * rho1 * dd * area / 100.0;
                weights[ii][1] = div2 * rho2 * dd * area / 100.0;
            }
        }
        return weights;
    }

    public double[][] getCO2s(double area) {
        double[][] co2s = new double[this.n_lay][2];
        double[] rs = this.getDimRS();
        double div1 = rs[0] / (rs[0] + rs[1]);
        double div2 = rs[1] / (rs[0] + rs[1]);
        if (this.M4data != null && this.M4d != null) {
            for (int ii = 0; ii < this.n_lay; ++ii) {
                String[] data2;
                String ref1 = (String)this.M4data[ii][4];
                String ref2 = (String)this.M4data[ii][9];
                double dd = Globals.getDoubleValue(this.M4d[ii][0]);
                String[] data1 = this.dataM4.get(ref1);
                if (data1 == null) {
                    data1 = this.dataM4P.get(ref1);
                }
                if (data1 != null) {
                    double co21 = Globals.getDoubleValue(data1[15]);
                    double rho1 = Globals.getDoubleValue(data1[8]);
                    co2s[ii][0] = div1 * co21 * rho1 * dd * area / 100.0;
                }
                if ((data2 = this.dataM4.get(ref2)) == null) {
                    data2 = this.dataM4P.get(ref2);
                }
                if (data2 == null) continue;
                double co22 = Globals.getDoubleValue(data2[15]);
                double rho2 = Globals.getDoubleValue(data2[8]);
                co2s[ii][1] = div2 * co22 * dd * rho2 * area / 100.0;
            }
        }
        return co2s;
    }

    public double[][] getNREs(double area) {
        double[][] nres = new double[this.n_lay][2];
        double[] rs = this.getDimRS();
        double div1 = rs[0] / (rs[0] + rs[1]);
        double div2 = rs[1] / (rs[0] + rs[1]);
        if (this.M4data != null && this.M4d != null) {
            for (int ii = 0; ii < this.n_lay; ++ii) {
                String[] data2;
                String ref1 = (String)this.M4data[ii][4];
                String ref2 = (String)this.M4data[ii][9];
                double dd = Globals.getDoubleValue(this.M4d[ii][0]);
                String[] data1 = this.dataM4.get(ref1);
                if (data1 == null) {
                    data1 = this.dataM4P.get(ref1);
                }
                if (data1 != null) {
                    double co21 = Globals.getDoubleValue(data1[14]);
                    double rho1 = Globals.getDoubleValue(data1[8]);
                    nres[ii][0] = div1 * co21 * rho1 * dd * area / 100.0;
                }
                if ((data2 = this.dataM4.get(ref2)) == null) {
                    data2 = this.dataM4P.get(ref2);
                }
                if (data2 == null) continue;
                double co22 = Globals.getDoubleValue(data2[14]);
                double rho2 = Globals.getDoubleValue(data2[8]);
                nres[ii][1] = div2 * co22 * dd * rho2 * area / 100.0;
            }
        }
        return nres;
    }

    public double[][] getUBPs(double area) {
        double[][] nres = new double[this.n_lay][2];
        double[] rs = this.getDimRS();
        double div1 = rs[0] / (rs[0] + rs[1]);
        double div2 = rs[1] / (rs[0] + rs[1]);
        if (this.M4data != null && this.M4d != null) {
            for (int ii = 0; ii < this.n_lay; ++ii) {
                String[] data2;
                String ref1 = (String)this.M4data[ii][4];
                String ref2 = (String)this.M4data[ii][9];
                double dd = Globals.getDoubleValue(this.M4d[ii][0]);
                String[] data1 = this.dataM4.get(ref1);
                if (data1 == null) {
                    data1 = this.dataM4P.get(ref1);
                }
                if (data1 != null) {
                    double ubp1 = Globals.getDoubleValue(data1[16]);
                    double rho1 = Globals.getDoubleValue(data1[8]);
                    nres[ii][0] = div1 * ubp1 * rho1 * dd * area / 100.0;
                }
                if ((data2 = this.dataM4.get(ref2)) == null) {
                    data2 = this.dataM4P.get(ref2);
                }
                if (data2 == null) continue;
                double ubp2 = Globals.getDoubleValue(data2[14]);
                double rho2 = Globals.getDoubleValue(data2[8]);
                nres[ii][1] = div2 * ubp2 * dd * rho2 * area / 100.0;
            }
        }
        return nres;
    }

    public Map<String, Double> getWeightsByMaterial(double area) {
        TreeMap<String, Double> tm = new TreeMap<String, Double>();
        double[][] wg = this.getWeights(area);
        if (this.M4data != null) {
            for (int ii = 0; ii < this.n_lay; ++ii) {
                for (int jj = 0; jj < 2; ++jj) {
                    String ref = (String)this.M4data[ii][jj * 5 + 4];
                    if (ref == null) continue;
                    Double value = tm.get(ref);
                    if (value == null) {
                        tm.put(ref, wg[ii][jj]);
                        continue;
                    }
                    value = new Double(value + wg[ii][jj]);
                }
            }
        }
        return tm;
    }

    public double getWeight(double area) {
        double weight = 0.0;
        double[][] wg = this.getWeights(area);
        for (int ii = 0; ii < this.n_lay; ++ii) {
            for (int jj = 0; jj < 2; ++jj) {
                weight += wg[ii][jj];
            }
        }
        return weight;
    }

    public double getCO2(double area) {
        double co2 = 0.0;
        double[][] cc = this.getCO2s(area);
        for (int ii = 0; ii < this.n_lay; ++ii) {
            for (int jj = 0; jj < 2; ++jj) {
                co2 += cc[ii][jj];
            }
        }
        return co2;
    }

    public double getNRE(double area) {
        double nre = 0.0;
        double[][] cc = this.getNREs(area);
        for (int ii = 0; ii < this.n_lay; ++ii) {
            for (int jj = 0; jj < 2; ++jj) {
                nre += cc[ii][jj];
            }
        }
        return nre;
    }

    public double getUBP(double area) {
        double ubp = 0.0;
        double[][] cc = this.getUBPs(area);
        for (int ii = 0; ii < this.n_lay; ++ii) {
            for (int jj = 0; jj < 2; ++jj) {
                ubp += cc[ii][jj];
            }
        }
        return ubp;
    }

    public boolean updateRowsInProjectTable() {
        int rows;
        boolean res = false;
        for (int ii = 0; ii < this.M4data.length; ++ii) {
            if (this.M4data[ii][0] == null) continue;
            for (int jj = 0; jj < 2; ++jj) {
                if (this.M4data[ii][4 + jj * 5] == null || ((String)this.M4data[ii][4 + jj * 5]).substring(0, 2).equals("00")) continue;
                this.M4data[ii][4 + jj * 5] = this.getProvRef((String)this.M4data[ii][4 + jj * 5]);
            }
        }
        Composant_M composant_m = new Composant_M();
        composant_m.setId_proj(1);
        String componentName = this.getComponentName();
        composant_m.setNom(new String[]{componentName, componentName, componentName, componentName});
        String[][] refs_m4 = new String[2][12];
        Float[] dcs = new Float[12];
        for (int ii = 0; ii < 12; ++ii) {
            if (this.M4data[ii][0] == null) continue;
            refs_m4[0][ii] = (String)this.M4data[ii][4];
            refs_m4[1][ii] = (String)this.M4data[ii][9];
            dcs[ii] = Float.valueOf(Globals.getFloatValue(this.M4d[ii][0]));
        }
        composant_m.setRefs_m4(refs_m4);
        composant_m.setDcs(dcs);
        composant_m.setN_lay((short)this.getNLAY());
        composant_m.setPt_c(Float.valueOf((float)this.getPontTherm()[0]));
        composant_m.setPn_c(Float.valueOf((float)this.getPontTherm()[1]));
        composant_m.setU_c(Float.valueOf((float)this.getValeurU()));
        composant_m.setCh_c((short)this.getCoucheCh());
        composant_m.setD1_c(Float.valueOf((float)this.getDimRS()[0]));
        composant_m.setD2_c(Float.valueOf((float)this.getDimRS()[1]));
        composant_m.setRai(Float.valueOf(this.getRAie()[0]));
        composant_m.setRae(Float.valueOf(this.getRAie()[1]));
        composant_m.setDtstart(new Date());
        composant_m.setUpdt(new Date());
        composant_m.setA(Short.parseShort(this.cc[0]));
        composant_m.setB(Short.parseShort(this.cc[1]));
        composant_m.setC(Short.parseShort(this.cc[2]));
        composant_m.setA(Short.parseShort(this.cc[0]));
        composant_m.setB(Short.parseShort(this.cc[1]));
        composant_m.setC(Short.parseShort(this.cc[2]));
        if (this.cc.length >= 4) {
            composant_m.setD(Short.parseShort(this.cc[3]));
        }
        if (this.cc.length >= 5) {
            composant_m.setE(Short.parseShort(this.cc[4]));
        }
        if ((rows = this.hibernateComposant_MDao.updateComposant_M(composant_m)) > 1) {
            res = true;
        }
        return res;
    }
}

