/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import com.caucho.hessian.client.HessianConnectionException;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import core.Calc_Ceb;
import core.Config;
import core.FileUtilities;
import core.MatDbOrg;
import core.MaterialsDbOrg;
import core.hibernate.SessionFactoryUtil;
import core.hibernate.cat.dao.HibernateCeb_D1Dao;
import core.hibernate.cat.db.Ceb_D1;
import core.hibernate.pro.dao.HibernatePro_CebDao;
import core.hibernate.pro.db.Pro_Ceb;
import core.hibernate.usrcat.dao.HibernateMatDbDao;
import core.hibernate.usrcat.db.M4_MatDb;
import core.remote.ManufacturerService;
import enercad2007.DB_cat;
import enercad2007.DM_E_NC;
import enercad2007.DM_Element;
import enercad2007.DM_Facade;
import enercad2007.DM_Help;
import enercad2007.DM_Met;
import enercad2007.DM_Pro;
import enercad2007.DM_SRE;
import enercad2007.DM_Shade;
import enercad2007.DM_Trad;
import enercad2007.DM_Trad_SIA;
import enercad2007.DM_Zone;
import enercad2007.DMpr_Comp;
import enercad2007.Globals;
import enercad2007.MainFrame;
import enercad2007.dialogs.DlgCeb;
import enercad2007.dialogs.DlgKBOB;
import enercad2007.dialogs.DlgLogin;
import enercad2007.dialogs.DlgOutCeb;
import enercad2007.dialogs.DlgOutFlux;
import enercad2007.dialogs.DlgOutGraph;
import enercad2007.dialogs.DlgOutQh;
import enercad2007.dialogs.DlgOutTableau;
import enercad2007.dialogs.DlgResume;
import enercad2007.dialogs.DlgStart;
import enercad2007.dialogs.InternalActiveSolarFrame;
import enercad2007.dialogs.InternalMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jecadcomp.DlgCompassCard;
import jecadcomp.DlgCompassCard2016;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.xerces.impl.dv.util.Base64;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import privatecomponents.HTMLMessageDialog;
import scy.AddressMACInfo;
import scy.Scy;
import security.DecryptGenerator;
import sun.swing.FilePane;

public class Ecad2007 {
    boolean packFrame = false;
    static long cpuTime;
    static DM_Trad gen_trad;
    static DM_Trad symbol_trad;
    static DM_Trad imf_trad;
    static DM_Trad mf_trad;
    static DM_Trad valu_trad;
    static DM_Trad oce_trad;
    static DM_Trad admin_trad;
    static DM_Trad canton_trad;
    static DM_Trad sre_trad;
    static DM_Trad shade_trad;
    static DM_Trad print_trad;
    static DM_Trad hor_trad;
    static DM_Trad c1_trad;
    static DM_Trad c2_trad;
    static DM_Trad biblio_trad;
    static DM_Trad comp_trad;
    static DM_Trad prefs_trad;
    static DM_Trad out_trad;
    static DM_Trad ceb_trad;
    static DM_Trad min_trad;
    static DM_Trad_SIA ceb_trad_sia;
    static DM_Trad_SIA jflux_trad_sia;
    static DM_Trad_SIA jglobal_trad_sia;
    static DM_Trad_SIA jponctuel_trad_sia;
    static DM_Trad_SIA jtable_trad_sia;
    static DM_Trad_SIA kbob_trad_sia;
    static DM_Trad_SIA resume_trad_sia;
    private static DMpr_Comp pr_composants;
    public static HashMap<String, ImageIcon> icGen;
    private static Map<String, MaterialsDbOrg> fabMatLibraries;
    private static Map<String, BufferedImage[]> materialsDbLogos;
    private static Map<String, String> fabMatLogos;
    private static Map<String, DB_cat> m_dbCat_start;
    private static Map<String, DB_cat> m_dbCat_valeurUDef;
    private static Map<String, DB_cat> m_dbCat_valeurU;
    private static DB_cat db_fen;
    private static Map<String, String[]> m4_proj;
    private static Map<String, MatDbOrg> m4_proj510;
    private static Map<String, String[]> m4_mat;
    private static List<M4_MatDb> privateMatDb;
    public static Map<String, Object[]> c1_fen;
    public static Map<String, Object[]> c2_mur;
    public static Map<String, Object[]> c3_pthl;
    public static Map<String, Object[]> c4_pthp;
    static final Calendar today;
    private static Session se_cat;
    private static Session se_enercad;
    private static Session se_projet;
    private static Session se_tmp;
    private static Session se_usrcat;
    private static boolean b_session;
    private static Map<String, Connection> cn_comp;
    private static Globals globals;
    Config config;
    private static Logger logger;
    FileAppender appender;
    static Map<String, Scy> m_scy;
    static long lLevel;
    static int lCount;
    static int lVersion;
    static String userNAME;
    static String macAddress;
    static String h2_url;
    static boolean b_clientCheck;
    static int saveVER;
    public static HashMap ic_gen;
    public static HashMap ic_imf;
    public static HashMap ic_shade;
    private static DM_Pro dm_pro;
    private static DM_Met meteO;
    public static DM_SRE dataSRE;
    private static String ID_MET;
    public static int ID_B;
    private static Integer calcmod;
    private static int rapportMode;
    private static TreeMap<Integer, InternalMainFrame> tm_imf;
    static DM_Facade dataF;
    static int id_z;
    private static Map<Integer, DM_Element> m_dmElement;
    static DM_E_NC dataE_NC;
    public static DM_Shade dataO;
    private static DM_Help imfhelp;
    private static DM_Help imfhelp2016;
    private static DM_Help mfhelp;
    private static DlgOutQh dlgOutQh;
    private static DlgOutGraph dlgOutGraph;
    public static DlgOutFlux dlgOutFlux;
    public static DlgOutTableau dlgOutTableau;
    private static DlgOutCeb dlgOutCeb;
    private static DlgCeb dlgCeb;
    private static Calc_Ceb calc_ceb;
    static DlgKBOB dlgKbob;
    static InternalActiveSolarFrame iasf;
    public static DlgCompassCard dlgCompassCard;
    public static DlgCompassCard2016 dlgCompassCard2016;
    private static DlgResume dlgResume;
    private static DlgLogin dlgLogin;
    private static MainFrame frame;
    public static DlgStart dlgStart;
    private static int lan;
    public static String land;
    static String cd1;
    static String cd2;
    static String cd3;
    public static String startError;
    private static int errorCode;
    private static boolean b_writetest;
    static Preferences prefs;
    static DecimalFormatSymbols dfs;
    static DecimalFormat df0;
    static DecimalFormat df00;
    static DecimalFormat df1;
    static DecimalFormat df2;
    static DecimalFormat df3;
    static DecimalFormat df4;
    static DecimalFormat df8;
    static DecimalFormat df1d;
    static DecimalFormat df2d;
    static DecimalFormat df3d;
    static DecimalFormat df4d;
    static DecimalFormat df8d;
    static DecimalFormat df1d1;

    public Ecad2007() {
        globals = new Globals();
        String fs = System.getProperty("file.separator");
        String homeDir = System.getProperty("user.dir") + fs + ".enercad" + fs;
        System.setProperty("conf.file.name", homeDir + "enercad2007.xml");
        System.setProperty("ecad.home.dir", homeDir);
        System.setProperty("debug", Globals.getDebug());
        this.config = new Config(System.getProperty("conf.file.name"));
        Date date = new Date();
        cpuTime = date.getTime();
        if (!this.config.isValid()) {
            File xml = new File(System.getProperty("conf.file.name"));
            File xml_update = new File(homeDir + "enercad2007_update.xml");
            if (xml_update.exists()) {
                Config config_update = new Config(homeDir + "enercad2007_update.xml");
                lan = config_update.getPropertyInt("properties", "lan");
                boolean b_read = xml_update.renameTo(xml);
                this.showReadWriteErrorMessage(!b_read);
            } else {
                homeDir = System.getProperty("user.home") + fs + ".enercad" + fs;
                System.setProperty("conf.file.name", homeDir + "enercad2007.xml");
                System.setProperty("ecad.home.dir", homeDir);
                xml = new File(System.getProperty("conf.file.name"));
                if (!xml.exists()) {
                    this.showReadWriteErrorMessage(true);
                }
            }
            this.config = new Config(System.getProperty("conf.file.name"));
        }
        Globals.setProjectAbsolutePath(this.config.getPropertyString("properties", "dir", new String[]{"mf", "pro"}).replaceAll("&#92;", "\\\\"));
        prefs = Preferences.userNodeForPackage(Ecad2007.class);
        lan = this.config.getPropertyInt("properties", "lan");
        land = this.config.getPropertyString("properties", "land");
        h2_url = "jdbc:h2://";
        h2_url = h2_url + "%s";
        h2_url = h2_url + fs + "usrcat";
        if (lan == 0) {
            startError = "Sie haben EnerCAD bereits ge\u00f6ffnet.";
            Locale.setDefault(new Locale("de", land));
        } else if (lan == 1) {
            startError = "EnerCAD est d\u00e9j\u00e0 ouvert.";
            Locale.setDefault(new Locale("fr", land));
        } else if (lan == 2) {
            startError = "Gi\u00e0 avete aperto EnerCAD.";
            Locale.setDefault(new Locale("it", land));
        } else if (lan == 3) {
            startError = "You have already opened EnerCAD.";
            Locale.setDefault(new Locale("en", land));
        }
        int writecheck = this.config.getPropertyInt("properties", "flags", new String[]{"writecheck"});
        boolean b_error = false;
        if (writecheck == 0) {
            this.config.setPropertyInt("properties", "flags", new String[]{"writecheck"}, 1);
            this.config = new Config(System.getProperty("conf.file.name"));
            if (this.config.getPropertyInt("properties", "flags", new String[]{"writecheck"}) == 0) {
                b_error = true;
            }
        } else {
            this.config.setPropertyInt("properties", "flags", new String[]{"writecheck"}, 0);
            this.config = new Config(System.getProperty("conf.file.name"));
            if (this.config.getPropertyInt("properties", "flags", new String[]{"writecheck"}) == 1) {
                b_error = true;
            }
        }
        this.showReadWriteErrorMessage(b_error);
        File fileUpdate = new File(homeDir + "enercad2007_update.xml");
        if (fileUpdate.exists()) {
            File xml = new File(homeDir + "enercad2007.xml");
            xml.renameTo(new File(homeDir + "enercad2007_tmp.xml"));
            fileUpdate.renameTo(new File(homeDir + "enercad2007.xml"));
            this.config = new Config(System.getProperty("conf.file.name"));
        }
        File updateEnercad = new File(homeDir + "data" + File.separator + "enercad_update");
        File oldEnercad = new File(homeDir + "data" + File.separator + "enercad_" + Globals.int_ver);
        if (updateEnercad.exists()) {
            if (oldEnercad.exists()) {
                String scode = Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("scode");
                String fLevel = Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("fLevel");
                Ecad2007.removeScy("enercad");
                Ecad2007.closeAllConnections();
                globals.deleteFiles(oldEnercad.listFiles());
                oldEnercad.delete();
                updateEnercad.renameTo(oldEnercad);
                Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                scy.setValue("scode", scode);
                scy.setValue("fLevel", fLevel);
            } else {
                updateEnercad.renameTo(oldEnercad);
            }
        }
        File dirCat = new File(homeDir + "data" + File.separator + "cat_update");
        File oldCat = new File(homeDir + "data" + File.separator + "cat");
        if (dirCat.exists()) {
            if (oldCat.exists()) {
                globals.deleteFiles(oldCat.listFiles());
                oldCat.delete();
            }
            dirCat.renameTo(oldCat);
        }
        File dirDefault = new File(homeDir + "data" + File.separator + "var" + File.separator + "default_update");
        File oldDefault = new File(homeDir + "data" + File.separator + "var" + File.separator + Globals.DEFAULT_NAME);
        if (dirDefault.exists()) {
            if (oldDefault.exists()) {
                globals.deleteFiles(oldDefault.listFiles());
                oldDefault.delete();
            }
            dirDefault.renameTo(oldDefault);
        }
        File dirProjet = new File(homeDir + "data" + File.separator + "var" + File.separator + "projet_update");
        File oldProjet = new File(homeDir + "data" + File.separator + "var" + File.separator + Globals.PROJECT_NAME);
        if (dirProjet.exists()) {
            if (oldProjet.exists()) {
                globals.deleteFiles(oldProjet.listFiles());
                oldProjet.delete();
            }
            dirProjet.renameTo(oldProjet);
        }
        File dirTmp = new File(homeDir + "data" + File.separator + "var" + File.separator + "tmp_update");
        File oldTmp = new File(homeDir + "data" + File.separator + "var" + File.separator + "tmp");
        if (dirTmp.exists()) {
            if (oldTmp.exists()) {
                globals.deleteFiles(dirTmp.listFiles());
                dirTmp.delete();
            } else {
                dirTmp.renameTo(oldTmp);
            }
        }
        String version = this.config.getPropertyString("constants", "version");
        String usrcat = this.config.getPropertyString("properties", "serverdata");
        if (usrcat.trim().equals("")) {
            usrcat = System.getProperty("ecad.home.dir") + fs + "common" + fs + "usrcat";
        }
        File file = new File(usrcat);
        if (version.trim().equals("") && file.exists()) {
            if (!file.getName().endsWith("usrcat")) {
                file = new File(file.getAbsolutePath() + File.separator + "usrcat");
            }
            FileUtilities fu = new FileUtilities();
            fu.importUsrDb(file);
            this.config.setPropertyString("constants", "version", Globals.EXT_NUMVER);
        }
        File updateAddons = new File(homeDir + "common" + File.separator + "addons_update");
        File oldAddons = new File(homeDir + "common" + File.separator + "addons");
        if (updateAddons.exists() && oldAddons.exists()) {
            String scode;
            String puk1hex;
            DecryptGenerator decryptGenerator = new DecryptGenerator();
            String prk2hex = Ecad2007.getPrk2Hex(Globals.int_ver);
            String[] code = decryptGenerator.getSCParameters(prk2hex, puk1hex = Ecad2007.getPuk1Hex(Globals.int_ver), scode = Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("scode"));
            if (code != null && code.length > 4) {
                long fLevel = Long.parseLong(code[2]);
                String cdate = code[3];
                String cperiod = code[4];
                if (cperiod == null) {
                    fLevel = 0L;
                } else {
                    int iperiod = Integer.parseInt(cperiod);
                    Calendar cal = globals.getDate(cdate);
                    cal.add(5, iperiod);
                    if (iperiod > 0 && Ecad2007.getToday().compareTo(cal) > 0) {
                        fLevel = 0L;
                    }
                }
                if (fLevel > 0L) {
                    String dir = "common" + File.separator + "addons";
                    File addons = new File(homeDir + dir);
                    File tmp = new File(homeDir + "common" + File.separator + "addons_tmp");
                    addons.renameTo(tmp);
                    updateAddons.renameTo(new File(homeDir + dir));
                    globals.copyFiles(tmp, addons);
                    globals.deleteFiles(new File[]{tmp});
                }
            }
        } else if (updateAddons.exists() && !oldAddons.exists()) {
            updateAddons.renameTo(oldAddons);
        }
        if (updateAddons.exists()) {
            globals.deleteFiles(updateAddons.listFiles());
            updateAddons.delete();
        }
        this.setLogger();
        dlgStart = new DlgStart(null, Globals.getGenericName(), false);
        dlgStart.setSize(512, 280);
        dlgStart.setVisible(true);
        dlgStart.updateBackgroundImage();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Globals.println("Thread 2 has started.");
                Ecad2007.startCSServer();
            }
        });
        thread2.start();
        Thread thread3 = new Thread(new Runnable(){

            @Override
            public void run() {
                int timeout;
                Globals.println("Thread 3 has started.");
                int cter = 0;
                if (Ecad2007.this.config == null) {
                    Ecad2007.this.config = new Config(System.getProperty("conf.file.name"));
                }
                if ((timeout = Ecad2007.this.config.getPropertyInt("constants", "timeout")) < 20) {
                    timeout = 20;
                }
                if (cter > timeout) {
                    JOptionPane.showMessageDialog(null, "EnerCAD-info", "Loading Error: Timout has elapsed.", 2);
                    System.exit(0);
                }
                ++cter;
                dlgStart.loadAll();
                frame = dlgStart.getMainFrame();
                if (frame == null) {
                    frame = new MainFrame();
                }
                if (Ecad2007.this.packFrame) {
                    frame.pack();
                } else {
                    frame.validate();
                }
                while (dlgStart.isValid()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ie) {
                        Globals.println("Ecad2007.thread3.InteruptedException: " + ie.getMessage());
                    }
                }
                frame.setVisible(true);
            }
        });
        thread3.start();
        Config conf = new Config(System.getProperty("conf.file.name"));
        int autoconnect = conf.getPropertyInt("properties", "autoconnect");
        Ecad2007.loadMatDb(autoconnect);
    }

    private static JFileChooser createJFileChooser(String file, String title) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setApproveButtonText("Ok");
        File dir = null;
        File selDir = new File(file.replaceAll("&#92;", "\\\\"));
        Locale locale = Locale.getDefault();
        dir = new File(file.replaceAll("&#92;", "\\\\"));
        fileChooser.setCurrentDirectory(selDir);
        fileChooser.setSelectedFile(selDir);
        if (!fileChooser.getLocale().equals(locale)) {
            fileChooser.setLocale(locale);
            SwingUtilities.updateComponentTreeUI(fileChooser);
            JOptionPane.setDefaultLocale(locale);
        }
        fileChooser.enableInputMethods(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFont(Globals.FT_STAND1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        Config config = new Config(System.getProperty("conf.file.name"));
        int fileviewtype = config.getPropertyInt("properties", "fileviewtype");
        Component[] components = fileChooser.getComponents();
        for (int ii = 0; ii < components.length; ++ii) {
            if (!(components[ii] instanceof FilePane)) continue;
            FilePane filePane = (FilePane)components[ii];
            filePane.setViewType(fileviewtype);
            break;
        }
        return fileChooser;
    }

    public static int getCodeLan() {
        return lan;
    }

    public static void setCodeLan(int code) {
        lan = code;
    }

    public static String getLand() {
        return land;
    }

    public static void setLand(String iso) {
        land = iso;
    }

    public static double[] calculateEnergyFactors() {
        HibernatePro_CebDao hp_ceb = new HibernatePro_CebDao();
        HibernateCeb_D1Dao hceb_d1 = new HibernateCeb_D1Dao();
        Pro_Ceb pro_ceb = hp_ceb.getPro_Ceb();
        Ceb_D1[] ceb_D1 = new Ceb_D1[3];
        Config config = new Config(System.getProperty("conf.file.name"));
        int units = config.getPropertyInt("properties", "units");
        calc_ceb = Ecad2007.getCalcCeb(units);
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        double[] part = new double[3];
        double[] fep = new double[3];
        String[] refs = new String[3];
        double lossQHWgen = 0.0;
        double recupQgen = 0.0;
        if (pro_ceb == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
        part[0] = pro_ceb.getFa_generator_part1().floatValue();
        part[1] = pro_ceb.getFa_generator_part2().floatValue();
        part[2] = pro_ceb.getFa_generator_part3().floatValue();
        refs[0] = pro_ceb.getRef_d11();
        refs[1] = pro_ceb.getRef_d12();
        refs[2] = pro_ceb.getRef_d13();
        for (int ii = 0; ii < 3; ++ii) {
            ceb_D1[ii] = hceb_d1.getCeb_D1(refs[ii]);
            if (ceb_D1[ii] == null) continue;
            fep[ii] = Globals.getDoubleValue(ceb_D1[ii].getFep());
        }
        lossQHWgen = Globals.getDoubleValue(pro_ceb.getGenerator_qh1());
        lossQHWgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh2());
        lossQHWgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh3());
        recupQgen = Globals.getDoubleValue(pro_ceb.getFa_generator_recup1()) * part[0] / 100.0;
        recupQgen += Globals.getDoubleValue(pro_ceb.getFa_generator_recup2()) * part[1] / 100.0;
        recupQgen += Globals.getDoubleValue(pro_ceb.getFa_generator_recup3()) * part[2] / 100.0;
        double lossQH = pro_ceb.getDistrib_qhli();
        map.put("lossQH", Globals.getDoubleValue(lossQH));
        double lossQW = pro_ceb.getDistrib_qwli();
        map.put("lossQW", Globals.getDoubleValue(lossQW));
        map.put("lossQHWgen", lossQHWgen);
        double flossQH = pro_ceb.getFa_distrib_hrec().floatValue() / 100.0f;
        map.put("flossQH", Globals.getDoubleValue(flossQH));
        double flossQW = pro_ceb.getFa_distrib_wrec().floatValue() / 100.0f;
        map.put("flossQW", Globals.getDoubleValue(flossQW));
        map.put("recupQgen", recupQgen);
        map.put("part", part);
        map.put("fep", fep);
        double prim_tot = calc_ceb.getPrimTot(map);
        double ae = 0.0;
        TreeMap<Integer, InternalMainFrame> imfs = Ecad2007.getInternalMainFrames();
        for (int ii = 0; ii < imfs.size(); ++ii) {
            ae += imfs.get(ii).getZone().getAE();
        }
        double consumEl = 0.0;
        double eel = Globals.getDoubleValue(pro_ceb.getFa_elaux());
        eel += Globals.getDoubleValue(pro_ceb.getFa_elhaux());
        eel += Globals.getDoubleValue(pro_ceb.getFa_elwaux());
        consumEl += (eel *= ae / 1000.0);
        consumEl += Globals.getDoubleValue(pro_ceb.getConsum_eev());
        consumEl += Globals.getDoubleValue(pro_ceb.getConsum_eel());
        consumEl += Globals.getDoubleValue(pro_ceb.getConsum_easc());
        double[] elCH = calc_ceb.getEletricityCH();
        double prim_El_tot = (consumEl += Globals.getDoubleValue(pro_ceb.getConsum_eap())) * elCH[0];
        double sum_tco2 = 0.0;
        double sum_pren = 0.0;
        String[] ref_d1 = new String[3];
        double[] fren = new double[3];
        double[] tco2 = new double[3];
        double[] eps = new double[3];
        double[] pren = new double[3];
        ref_d1[0] = pro_ceb.getRef_d11();
        ref_d1[1] = pro_ceb.getRef_d12();
        ref_d1[2] = pro_ceb.getRef_d13();
        double[] consom = new double[3];
        double sum_consom = calc_ceb.getQtot(lossQH, lossQW, lossQHWgen, flossQH, flossQW, recupQgen);
        HibernateCeb_D1Dao hibernateCeb_D1Dao = new HibernateCeb_D1Dao();
        for (int ii = 0; ii < ref_d1.length; ++ii) {
            Ceb_D1 ceb_d1 = hibernateCeb_D1Dao.getCeb_D1(ref_d1[ii]);
            consom[ii] = part[ii] * sum_consom / 100.0;
            if (ceb_d1 == null) continue;
            fren[ii] = Globals.getDoubleValue(ceb_d1.getFren());
            tco2[ii] = Globals.getDoubleValue((double)ceb_d1.getKco2() * consom[ii]);
            eps[ii] = consom[ii] * fep[ii];
            pren[ii] = eps[ii] * fren[ii] / 100.0;
            sum_pren += pren[ii];
            sum_tco2 += tco2[ii];
        }
        double epStd2009 = calc_ceb.getEpStd();
        double ep = (prim_tot + prim_El_tot) * 1000.0 / ae;
        double rp = ep / epStd2009;
        double ind_co2 = (sum_tco2 += elCH[2] * consumEl) / ae * 1000.0;
        double rco2 = ind_co2 / (calc_ceb.getKCO2Std() * epStd2009);
        double fren_tot = sum_pren / sum_consom;
        double epr = fren_tot * prim_tot + prim_El_tot * elCH[1] / 100.0;
        if (epr < 0.0) {
            epr = 0.0;
        }
        double fepr = epr / (prim_tot + prim_El_tot);
        return new double[]{ep, rp, ind_co2, rco2, epr, fepr};
    }

    private static void initializeDlgOutCeb(DM_Zone dm_zone) {
        double ae = dm_zone.getAE();
        Map<String, Object> map = dm_zone.calculate(0);
        double CHli = Globals.getDoubleValue(map.get("CHli"));
        double qh = Globals.getDoubleValue(map.get("sumQH")) / ae;
        double rqh = qh / CHli;
        Globals.println("Ecad2007.updateGraphs " + String.format("qh: %#.1f Ecad2007.getDM_Zone().getQh(): %#.1f", qh, dm_zone.getQh()));
        double[] ef = Ecad2007.calculateEnergyFactors();
        boolean units = false;
        if (Ecad2007.getCalcmod() >= 7) {
            units = true;
        }
        if (units && Ecad2007.getIntCalcmod() < 7) {
            ef[0] = ef[0] * 0.2777777777777778;
        }
        if (dlgOutCeb == null) {
            String txt_dlg_Cecb = Ecad2007.getTraduction("mf").getCodeLan("dlg_outCecb");
            dlgOutCeb = new DlgOutCeb((Frame)frame, txt_dlg_Cecb, false, new double[]{qh, rqh, ef[0], ef[1], ef[2], ef[3], ef[4], ef[5]});
        } else {
            dlgOutCeb.setValues(new double[]{qh, rqh, ef[0], ef[1], ef[2], ef[3], ef[4], ef[5]});
        }
    }

    public static boolean closeAllConnections() {
        boolean b_res = false;
        try {
            Set<String> keys = cn_comp.keySet();
            if (keys != null) {
                String[] kks = keys.toArray(new String[0]);
                for (int ii = 0; ii < keys.size(); ++ii) {
                    try {
                        String key = kks[ii];
                        Ecad2007.closeConnection(key);
                        continue;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            }
            cn_comp = new HashMap<String, Connection>(10);
            b_res = true;
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sqlex) {
            System.out.println("Ecad2007 sqlex: " + sqlex.getMessage());
        }
        return b_res;
    }

    public static boolean closeConnection(String dbName) {
        boolean res = false;
        try {
            Connection connection;
            if (cn_comp != null && (connection = cn_comp.get(dbName)) != null) {
                if (connection.isClosed()) {
                    connection = null;
                } else {
                    connection.close();
                    connection = null;
                }
                cn_comp.remove(dbName);
            }
            res = true;
        }
        catch (SQLException sqlex) {
            Globals.println("Ecad2007.closeConnection(): " + sqlex);
        }
        return res;
    }

    public static Connection getConnection(String dbName) {
        block20: {
            Properties props = new Properties();
            Connection connection = null;
            String fileSeparator = System.getProperty("file.separator");
            if (cn_comp.get(dbName) == null) {
                String protocol = "jdbc:derby:";
                String driver = "org.apache.derby.jdbc.EmbeddedDriver";
                String ecadDataDir = System.getProperty("ecad.home.dir");
                try {
                    if (dbName.equals("cat")) {
                        Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                        cd1 = scy.getValue("cd1");
                        cd2 = scy.getValue("cd2");
                        props.put("user", cd1);
                        props.put("password", cd2);
                        props.put("name", "cn_cat");
                        connection = DriverManager.getConnection(protocol + ecadDataDir + "data" + fileSeparator + dbName, props);
                    } else if (dbName.startsWith("usrcat")) {
                        Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                        String cd3 = scy.getValue("cd3");
                        String cd4 = scy.getValue("cd4");
                        Config config = new Config(System.getProperty("conf.file.name"));
                        String usrcatdir = config.getPropertyString("properties", "serverdata");
                        if (usrcatdir == null) {
                            usrcatdir = "";
                        }
                        if (usrcatdir.equals("")) {
                            usrcatdir = System.getProperty("ecad.home.dir");
                            usrcatdir = usrcatdir.substring(0, usrcatdir.length() - 1);
                        }
                        props.put("user", cd3);
                        props.put("password", cd4);
                        if (usrcatdir == null) {
                            usrcatdir = "";
                        }
                        connection = usrcatdir.trim().equals("") ? DriverManager.getConnection(protocol + ecadDataDir + "common" + fileSeparator + dbName, props) : (usrcatdir.endsWith(dbName) ? DriverManager.getConnection(protocol + usrcatdir, props) : DriverManager.getConnection(protocol + usrcatdir + fileSeparator + dbName, props));
                    } else if (new File(Globals.getProjectDBDir(false)).exists()) {
                        Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                        cd1 = scy.getValue("cd1");
                        cd2 = scy.getValue("cd2");
                        props.put("user", cd1);
                        props.put("password", cd2);
                        props.put("name", dbName);
                        connection = DriverManager.getConnection(protocol + ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + dbName, props);
                        connection.setAutoCommit(false);
                    }
                    if (connection != null) {
                        cn_comp.put(dbName, connection);
                    }
                }
                catch (Throwable ex) {
                    int error;
                    if (!(((SQLException)ex).getErrorCode() == 50000 || (error = ((SQLException)ex).getErrorCode()) != 40000 || dbName.equals("enercad_" + Globals.int_ver) || dbName.equals("cat") || dbName.equals("usrcat_tmp"))) {
                        String dir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.PROJECT_NAME;
                        String defdir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.DEFAULT_NAME;
                        boolean b_repair = false;
                        File f_dir = new File(dir);
                        if (f_dir.listFiles().length == 0) {
                            b_repair = true;
                        }
                        if (!(new File(dir + fileSeparator + "log").exists() && new File(dir + fileSeparator + "seg0").exists() && new File(dir + fileSeparator + "service.properties").exists())) {
                            b_repair = true;
                        }
                        if (b_repair) {
                            globals.deleteFiles(new File(dir).listFiles());
                            globals.copyFiles(defdir, dir);
                            try {
                                connection = DriverManager.getConnection(protocol + ecadDataDir + "data/var/" + dbName, props);
                                Scy escy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                                Scy pscy = Ecad2007.getScy(Globals.PROJECT_NAME);
                                Globals.println("Ecad2007.getConnection: pscy level: " + Ecad2007.getLicenseLevel());
                                pscy.setValue("fLevel", String.valueOf(Ecad2007.getLicenseLevel()));
                                pscy.setValue("buildVER", String.valueOf(Globals.int_ver));
                                pscy.setValue("scode", escy.getValue("scode"));
                            }
                            catch (SQLException sqlEx) {
                                Globals.println("Ecad2007.getConnection: " + sqlEx.getMessage());
                            }
                        }
                    }
                    if (connection != null) break block20;
                    if (dbName.startsWith("usrcat")) {
                        return null;
                    }
                    if (dlgStart != null) {
                        dlgStart.dispose();
                        dlgStart = null;
                    }
                    globals.beep();
                    JOptionPane.showMessageDialog(null, startError, "EnerCAD-info", 2);
                    Globals.println("Corrupted " + dbName + " db, system will close down.");
                    System.exit(0);
                }
            }
        }
        return cn_comp.get(dbName);
    }

    public static Session getSession(String dbName) {
        String xml = "enercad.cfg.xml";
        if (Globals.int_ver >= 510 && "dbName".equals("usrcat")) {
            xml = "enercad_h2.cfg.xml";
        }
        return Ecad2007.getSession(xml, dbName);
    }

    public static Session getCurrentSession(String dbName) {
        SessionFactory sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
        if (sessionFactory.isClosed()) {
            Ecad2007.closeSession(dbName);
            sessionFactory = Ecad2007.getSession(dbName).getSessionFactory();
        }
        return sessionFactory.openSession();
    }

    public static Session getSession(String xml, String dbName) {
        Session session = null;
        Properties props = new Properties();
        String protocol = "jdbc:derby:";
        String userdir = System.getProperty("ecad.home.dir");
        if (!b_session) {
            Globals.println("Ecad2007.getSession userdir: " + userdir + " xml: " + xml + " dbName: " + dbName);
            b_session = true;
        }
        if (dbName.equals("cat")) {
            if (se_cat == null) {
                Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                cd1 = scy.getValue("cd1");
                cd2 = scy.getValue("cd2");
                props.put("hibernate.connection.username", cd1);
                props.put("hibernate.connection.password", cd2);
                String url = protocol + userdir + "data/" + dbName;
                props.put("hibernate.connection.url", url);
                SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props);
                se_cat = session = sessionFactoryUtil.getCurrentSession();
            } else {
                session = se_cat;
            }
        } else if (dbName.equals(Globals.PROJECT_NAME)) {
            if (se_projet == null) {
                Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                cd1 = scy.getValue("cd1");
                cd2 = scy.getValue("cd2");
                props.put("hibernate.connection.username", cd1);
                props.put("hibernate.connection.password", cd2);
                String url = protocol + userdir + "data/var/" + dbName;
                props.put("hibernate.connection.url", url);
                SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props);
                se_projet = session = sessionFactoryUtil.getCurrentSession();
            } else {
                session = se_projet;
            }
        } else if (dbName.equals("enercad_" + Globals.int_ver)) {
            if (se_enercad == null) {
                Scy scy = new Scy();
                cd3 = scy.ScrPlus(26, "blabla", Globals.STR_cd3, false);
                props.put("hibernate.connection.bootPassword", cd3);
                String url = protocol + userdir + "data/" + dbName;
                props.put("hibernate.connection.url", url);
                SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props);
                se_enercad = session = sessionFactoryUtil.getCurrentSession();
            } else {
                session = se_enercad;
            }
        } else if (dbName.equals("tmp")) {
            if (se_tmp == null) {
                Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                cd1 = scy.getValue("cd1");
                cd2 = scy.getValue("cd2");
                props.put("hibernate.connection.username", cd1);
                props.put("hibernate.connection.password", cd2);
                String url = protocol + userdir + "data/var/" + dbName;
                props.put("hibernate.connection.url", url);
                SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props);
                se_tmp = session = sessionFactoryUtil.openSession();
            } else {
                session = se_tmp;
            }
        } else if (dbName.equals("usrcat")) {
            if (se_usrcat == null) {
                Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
                String cd3 = scy.getValue("cd3");
                String cd4 = scy.getValue("cd4");
                String cd5 = scy.getValue("cd5");
                props.put("hibernate.connection.username", cd3);
                if (xml.contains("_h2")) {
                    props.put("hibernate.connection.password", cd5);
                } else {
                    props.put("hibernate.connection.password", cd4);
                    props.put("hibernate.connection.driver_class", "org.apache.derby.jdbc.ClientDriver");
                }
                Config config = new Config(System.getProperty("conf.file.name"));
                String serverdata = config.getPropertyString("properties", "serverdata");
                String fileSeparator = File.separator;
                boolean b_default = false;
                if (serverdata == null) {
                    serverdata = userdir + fileSeparator + "h2";
                    serverdata = System.getProperty("os.name").startsWith("Windows") ? serverdata.replace("/", fileSeparator) : serverdata.replace("\\\\", fileSeparator);
                    b_default = true;
                    Globals.println("Error in server connection: took default data location: " + serverdata);
                } else if (serverdata.trim().equals("")) {
                    serverdata = Globals.int_ver < 510 ? userdir + "common" : (userdir.endsWith("\\") ? userdir + "h2" : (userdir.endsWith("/") ? userdir + "h2" : userdir + fileSeparator + "h2"));
                    serverdata = System.getProperty("os.name").startsWith("Windows") ? serverdata.replace("/", fileSeparator) : serverdata.replace("\\\\", fileSeparator);
                    b_default = true;
                    Globals.println("Error in server connection: took default data location: " + serverdata);
                }
                String[] resources = null;
                String url = "";
                if (xml.contains("_h2")) {
                    url = userdir.endsWith("\\") ? "jdbc:h2://" + userdir + "h2\\" + dbName : (userdir.endsWith("/") ? "jdbc:h2://" + userdir + "h2/" + dbName : userdir + fileSeparator + "h2");
                } else {
                    String port = config.getPropertyString("properties", "serverport");
                    String derby_client_url = "jdbc:derby://localhost:";
                    derby_client_url = derby_client_url + port + "/";
                    derby_client_url = derby_client_url + "%s";
                    if (!serverdata.endsWith("usrcat")) {
                        derby_client_url = derby_client_url + fileSeparator + "usrcat";
                    }
                    url = derby_client_url.replaceFirst("%s", serverdata.replaceAll("\\\\", "\\\\\\\\"));
                    resources = new String[]{"core/hibernate/usrcat509.hbm.xml"};
                }
                props.put("hibernate.connection.url", url);
                SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props, resources);
                se_usrcat = session = sessionFactoryUtil.getCurrentSession();
            } else {
                session = se_usrcat;
            }
        }
        return session;
    }

    public static Session getSession(String url, String xml, String dbName, String[] resources) {
        Session session = null;
        Properties props = new Properties();
        if (dbName.equals("usrcat")) {
            Scy scy = Ecad2007.getScy(Globals.ENERCAD_NAME);
            String cd3 = scy.getValue("cd3");
            String cd4 = scy.getValue("cd4");
            String cd5 = scy.getValue("cd5");
            props.put("hibernate.connection.username", cd3);
            if (xml.contains("_h2")) {
                props.put("hibernate.connection.password", cd5);
            } else {
                props.put("hibernate.connection.password", cd4);
                if (Globals.int_ver >= 510) {
                    props.put("hibernate.connection.driver_class", "org.apache.derby.jdbc.EmbeddedDriver");
                } else {
                    props.put("hibernate.connection.driver_class", "org.apache.derby.jdbc.ClientDriver");
                }
            }
            props.put("hibernate.connection.url", url);
            SessionFactoryUtil sessionFactoryUtil = new SessionFactoryUtil(xml, props, resources);
            session = sessionFactoryUtil.getCurrentSession();
        }
        return session;
    }

    public static void closeSession(String dbName) {
        SessionFactory sessionFactory;
        if (dbName.equals("enercad_" + Globals.int_ver)) {
            SessionFactory sessionFactory2;
            if (se_enercad != null && (sessionFactory2 = se_enercad.getSessionFactory()) != null) {
                if (se_enercad.isOpen()) {
                    se_enercad.clear();
                    se_enercad.close();
                }
                sessionFactory2.close();
                se_enercad = null;
            }
        } else if (dbName.equals("cat")) {
            SessionFactory sessionFactory3;
            if (se_cat != null && (sessionFactory3 = se_cat.getSessionFactory()) != null) {
                if (se_cat.isOpen()) {
                    se_cat.clear();
                    se_cat.close();
                }
                sessionFactory3.close();
                se_cat = null;
            }
        } else if (dbName.equals(Globals.PROJECT_NAME)) {
            SessionFactory sessionFactory4;
            if (se_projet != null && (sessionFactory4 = se_projet.getSessionFactory()) != null) {
                if (se_projet.isOpen()) {
                    try {
                        se_projet.clear();
                    }
                    catch (HibernateException hex) {
                        Globals.println("Ecad2007.closeSession: " + hex.getMessage());
                    }
                    se_projet.close();
                }
                sessionFactory4.close();
                se_projet = null;
            }
        } else if (dbName.equals("tmp") && se_tmp != null && (sessionFactory = se_tmp.getSessionFactory()) != null) {
            if (se_tmp.isOpen()) {
                se_tmp.close();
            }
            sessionFactory.close();
            se_tmp = null;
        }
    }

    public static void resetDialog(String dialogName) {
        if (dialogName.equals("Ceb")) {
            dlgCeb = null;
        } else if (dialogName.equals("Qh")) {
            dlgOutQh = null;
        }
    }

    public static DlgOutCeb getDlgOutCecb() {
        if (dlgOutCeb == null) {
            Ecad2007.initializeDlgOutCeb(Ecad2007.getDM_Zone(0));
        }
        return dlgOutCeb;
    }

    public static boolean isDlgKbob() {
        return dlgKbob != null;
    }

    public static DlgKBOB getDlgKbob() {
        if (dlgKbob == null) {
            String txt_dlg_kbob = Ecad2007.getTraduction("mf").getCodeLan("dlg_kbob");
            dlgKbob = new DlgKBOB(frame, txt_dlg_kbob, false);
        }
        return dlgKbob;
    }

    public static DlgOutGraph getDlgOutGraph() {
        if (dlgOutGraph == null) {
            String txt_dlg_graph = Ecad2007.getTraduction("mf").getCodeLan("dlg_outGraph");
            dlgOutGraph = new DlgOutGraph(frame, txt_dlg_graph, false);
            dlgOutGraph.setToolTipMode(true);
        }
        return dlgOutGraph;
    }

    public static boolean isDlgOutGraph() {
        return dlgOutGraph != null;
    }

    public static DlgOutQh getDlgOutQh() {
        if (dlgOutQh == null) {
            String txt_dlg_qh = Ecad2007.getTraduction("mf").getCodeLan("dlg_outQh");
            dlgOutQh = new DlgOutQh(frame, txt_dlg_qh, false);
        }
        return dlgOutQh;
    }

    public static boolean isDlgOutQh() {
        return dlgOutQh != null;
    }

    public static DlgCeb getDlgCeb() {
        if (dlgCeb == null) {
            dlgCeb = new DlgCeb(frame, Ecad2007.getTraduction("mf").getCodeLan("dlg_outCecb"), false);
        }
        return dlgCeb;
    }

    public static void setDlgCeb(DlgCeb dlgCeb) {
        Ecad2007.dlgCeb = dlgCeb;
    }

    public static boolean isNullDlgCeb() {
        return dlgCeb == null;
    }

    public static InternalActiveSolarFrame getInternalActiveSolarFrame() {
        if (iasf == null) {
            Config config = new Config(System.getProperty("conf.file.name"));
            String tmp = config.getPropertyString("properties", "pos", new String[]{"Iasf"});
            String[] tt = tmp.split(",");
            Point iasfPt = new Point(Globals.getIntValue(tt[0]), Globals.getIntValue(tt[1]));
            iasf = new InternalActiveSolarFrame(new Rectangle(iasfPt.x, iasfPt.y, 760, 600));
        }
        return iasf;
    }

    public static void setInternalActiveSolarFrame(InternalActiveSolarFrame iasf) {
        Ecad2007.iasf = iasf;
    }

    public static boolean isInternalActiveSolarFrameVisible() {
        if (iasf == null) {
            return false;
        }
        return iasf.isVisible();
    }

    public static boolean isDlgResume() {
        return dlgResume != null;
    }

    public static boolean isNullDlgOutCeb() {
        return dlgOutCeb == null;
    }

    public static long getCpuTime() {
        return cpuTime;
    }

    public static DecimalFormat getDecimalFormat(String format) {
        if (dfs == null) {
            dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            dfs.setGroupingSeparator('\'');
        }
        if (format.equals("0")) {
            if (df0 == null) {
                df0 = new DecimalFormat(format, dfs);
                df0.setGroupingSize(3);
                df0.setGroupingUsed(true);
            }
            return df0;
        }
        if (format.equals("00")) {
            if (df00 == null) {
                df00 = new DecimalFormat(format, dfs);
            }
            return df00;
        }
        if (format.equals("0.0")) {
            if (df1 == null) {
                df1 = new DecimalFormat(format, dfs);
            }
            return df1;
        }
        if (format.equals("0.00")) {
            if (df2 == null) {
                df2 = new DecimalFormat(format, dfs);
            }
            return df2;
        }
        if (format.equals("0.000")) {
            if (df3 == null) {
                df3 = new DecimalFormat(format, dfs);
            }
            return df3;
        }
        if (format.equals("0.0000")) {
            if (df4 == null) {
                df4 = new DecimalFormat(format, dfs);
            }
            return df3;
        }
        if (format.equals("0.00000000")) {
            if (df8 == null) {
                df8 = new DecimalFormat(format, dfs);
            }
            return df8;
        }
        if (format.equals("0.0#######")) {
            if (df8 == null) {
                df8 = new DecimalFormat(format, dfs);
            }
            return df8;
        }
        if (format.equals("#0.#")) {
            if (df1d == null) {
                df1d = new DecimalFormat(format, dfs);
            }
            return df1d;
        }
        if (format.equals("#0.0#")) {
            if (df1d1 == null) {
                df1d1 = new DecimalFormat(format, dfs);
            }
            return df1d1;
        }
        if (format.equals("#0.##")) {
            if (df2d == null) {
                df2d = new DecimalFormat(format, dfs);
            }
            return df2d;
        }
        if (format.equals("#0.###")) {
            if (df3d == null) {
                df3d = new DecimalFormat(format, dfs);
            }
            return df3d;
        }
        if (format.equals("#0.####")) {
            if (df4d == null) {
                df4d = new DecimalFormat(format, dfs);
            }
            return df4d;
        }
        if (format.equals("#0.########")) {
            if (df8d == null) {
                df8d = new DecimalFormat(format, dfs);
            }
            return df8d;
        }
        if (df2 == null) {
            df2 = new DecimalFormat("0.00", dfs);
        }
        return df2;
    }

    public static DlgLogin getDlgLogin() {
        return dlgLogin;
    }

    public static DlgResume getDlgResume() {
        return dlgResume;
    }

    public static Calc_Ceb getCalcCeb(int units) {
        if (calc_ceb == null) {
            calc_ceb = new Calc_Ceb(units);
        } else if (calc_ceb.getUnits() != units) {
            calc_ceb = new Calc_Ceb(units);
        }
        return calc_ceb;
    }

    public static DM_E_NC getDM_E_NC() {
        if (dataE_NC == null) {
            dataE_NC = new DM_E_NC();
        }
        return dataE_NC;
    }

    public static boolean isDM_E_NC() {
        return dataE_NC != null;
    }

    public static DM_Pro getDM_Pro() {
        boolean b_pro = true;
        if (dm_pro == null) {
            b_pro = false;
        } else if (!dm_pro.isProLoaded()) {
            String fileSeparator = System.getProperty("file.separator");
            String ecadDataDir = System.getProperty("ecad.home.dir");
            String dir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.PROJECT_NAME;
            String defdir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.DEFAULT_NAME;
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            globals.closeDb(dir);
            Ecad2007.removeScy(Globals.PROJECT_NAME);
            globals.deleteFiles(new File(dir).listFiles());
            globals.copyFiles(defdir, dir);
            Scy escy = Ecad2007.getScy(Globals.ENERCAD_NAME);
            Scy pscy = Ecad2007.getScy(Globals.PROJECT_NAME);
            Globals.println("Ecad2007.getDMPro: pscy level: " + Ecad2007.getLicenseLevel());
            pscy.setValue("fLevel", String.valueOf(Ecad2007.getLicenseLevel()));
            pscy.setValue("buildVER", String.valueOf(Globals.int_ver));
            pscy.setValue("scode", escy.getValue("scode"));
            errorCode = 2500;
            b_pro = false;
        }
        if (!b_pro) {
            if (meteO == null) {
                meteO = new DM_Met(Ecad2007.getIdMet());
            }
            try {
                dm_pro = new DM_Pro(meteO);
            }
            catch (NullPointerException npe) {
                Globals.println("Ecad2007.getDM_Pro: " + npe);
            }
        }
        return dm_pro;
    }

    public static DM_Facade getDM_Facade() {
        if (dataF == null) {
            dataF = new DM_Facade();
        }
        return dataF;
    }

    public static void eraseDM_Facade() {
        dataF = null;
    }

    public static boolean isDM_Facade() {
        return dataF != null;
    }

    public static void eraseDM_Pro() {
        dm_pro = null;
    }

    public static boolean isDM_Pro() {
        return dm_pro != null;
    }

    public static void setDM_Pro(DM_Pro dmPro) {
        dm_pro = dmPro;
    }

    public static DMpr_Comp getDMpr_Comp() {
        if (pr_composants == null) {
            pr_composants = new DMpr_Comp();
        }
        return pr_composants;
    }

    public static void eraseDMpr_Comp() {
        pr_composants = null;
    }

    public static DM_Zone getActiveZone() {
        if (tm_imf.size() == 0) {
            return null;
        }
        if (tm_imf.get(id_z) == null) {
            return null;
        }
        DM_Zone dm_zone = tm_imf.get(id_z).getZone();
        return dm_zone;
    }

    public static DM_Zone getDM_Zone(int id_z) {
        if (tm_imf.size() == 0) {
            return null;
        }
        if (tm_imf.get(id_z) == null) {
            return null;
        }
        DM_Zone dm_zone = tm_imf.get(id_z).getZone();
        return dm_zone;
    }

    public static void eraseDM_Zone(int id_z) {
        tm_imf.get(id_z).setZone(null);
    }

    public static boolean isDM_Zone(int id_z) {
        return tm_imf.get(id_z).getZone() != null;
    }

    public static DM_Element getDM_Element(int id_z) {
        if (m_dmElement.size() == 0) {
            return null;
        }
        if (m_dmElement.get(id_z) == null) {
            return null;
        }
        DM_Element dm_element = m_dmElement.get(id_z);
        return dm_element;
    }

    public static Map<Integer, DM_Element> getDM_Elements() {
        return m_dmElement;
    }

    public static Integer[] getDM_ElementKeys() {
        if (m_dmElement == null) {
            return new Integer[]{0};
        }
        if (m_dmElement.size() == 0) {
            return new Integer[]{0};
        }
        Integer[] keys = new Integer[m_dmElement.size()];
        keys = m_dmElement.keySet().toArray(keys);
        return keys;
    }

    public static Integer[] getDM_ZoneKeys() {
        return Ecad2007.getDM_ElementKeys();
    }

    public static void clearDM_Elements() {
        m_dmElement.clear();
    }

    public static void setDM_Element(int id_z, DM_Element dm_Element) {
        m_dmElement.put(id_z, dm_Element);
    }

    public static void eraseDM_Element(int id_z) {
        m_dmElement.remove(id_z);
    }

    public static boolean isDM_Element(int id_z) {
        return m_dmElement.get(id_z) != null;
    }

    public static boolean isWindowsOS() {
        String osname = System.getProperty("os.name");
        if (osname == null) {
            return false;
        }
        osname = osname.toLowerCase();
        return osname.startsWith("windows");
    }

    public static boolean isMacOS() {
        String osname = System.getProperty("os.name");
        if (osname == null) {
            return false;
        }
        osname = osname.toLowerCase();
        return osname.startsWith("mac os");
    }

    public static void setDM_Zone(DM_Zone dm_zone) {
        if (dm_zone == null) {
            return;
        }
        id_z = dm_zone.getId();
        if (tm_imf.get(id_z) != null) {
            tm_imf.get(id_z).setZone(dm_zone);
        }
    }

    public static InternalMainFrame getActiveInternalMainFrame() {
        return tm_imf.get(id_z);
    }

    public static InternalMainFrame getInternalMainFrame(int id) {
        return tm_imf.get(id);
    }

    public static TreeMap<Integer, InternalMainFrame> getInternalMainFrames() {
        return tm_imf;
    }

    public static TreeMap<Integer, InternalMainFrame> removeInternalMainFrame(int id) {
        tm_imf.remove(id);
        return tm_imf;
    }

    public static void clearInternalMainFrame() {
        tm_imf.clear();
    }

    public static void addInternalMainFrame(InternalMainFrame imf) {
        id_z = imf.getIdZone();
        tm_imf.put(id_z, imf);
    }

    public static void setDlgLogin(DlgLogin dlgLogin) {
        Ecad2007.dlgLogin = dlgLogin;
    }

    public static void setDlgResume(DlgResume dlgResume) {
        Ecad2007.dlgResume = dlgResume;
    }

    public static HashMap<String, ImageIcon> getIcons(String iconClass) {
        if (iconClass.equals("gen") && icGen == null) {
            icGen = Globals.getResources();
        }
        return icGen;
    }

    public static DM_Met getDM_Met() {
        return meteO;
    }

    public static void setDM_Met(DM_Met dm_Met) {
        meteO = dm_Met;
    }

    public static void eraseDM_Met() {
        meteO = null;
    }

    public static boolean isDM_Met() {
        return meteO != null;
    }

    public static String getIdMet() {
        return Ecad2007.getIdMet(123);
    }

    public static String getIdMet(int sms) {
        String res = "";
        String[] smet = null;
        int dim = 0;
        if (sms == 3) {
            if (ID_MET == null) {
                return Globals.getDefaultMeteoSource();
            }
            if (lLevel < 3L && ID_MET.endsWith("SIA 2028")) {
                ID_MET = Globals.getDefaultMeteoId() + ",SIA 381/2";
            }
        }
        if (ID_MET == null) {
            return Globals.getDefaultMeteo();
        }
        smet = ID_MET.split(",");
        dim = smet.length;
        if (sms == 1) {
            if (smet.length > 0) {
                res = smet[0];
            } else {
                String[] def = Globals.getDefaultMeteo().split(",");
                if (def.length > 0) {
                    res = def[0];
                }
            }
        } else if (sms == 12) {
            res = smet.length > 1 ? smet[0] + "," + smet[1] : Globals.getDefaultMeteo();
        } else if (sms == 123) {
            res = ID_MET;
        } else if (sms == 3) {
            if (dim == 3) {
                res = smet[2];
            } else if (dim == 2) {
                res = Globals.getDefaultMeteoSource();
            }
        }
        return res;
    }

    public static void setIdMet(String id_met) {
        int dim;
        ID_MET = id_met;
        if (id_met != null && (dim = id_met.split(",").length) == 2) {
            ID_MET = ID_MET + "," + Globals.getDefaultMeteoSource();
        }
    }

    public static Integer getCalcmod() {
        return calcmod;
    }

    public static int getIdActiveZone() {
        return id_z;
    }

    public static int getIntCalcmod() {
        if (calcmod == null) {
            return -1;
        }
        return calcmod;
    }

    public static String getStringCalcmod() {
        if (calcmod == null) {
            return "";
        }
        return calcmod.toString();
    }

    public static void setCalcmod(Integer calcmod) {
        Ecad2007.calcmod = calcmod;
    }

    public boolean getClientCheck() {
        return b_clientCheck;
    }

    public static void setClientCheck(boolean clientCheck) {
        b_clientCheck = clientCheck;
    }

    public static void setIdMet(int sms, String id_met) {
        String[] smet = null;
        int dim = 0;
        if (ID_MET == null) {
            return;
        }
        if (id_met == null) {
            return;
        }
        smet = ID_MET.split(",");
        dim = smet.length;
        if (sms == 12) {
            ID_MET = id_met;
            if (dim == 3) {
                ID_MET = ID_MET + "," + smet[2];
            }
        } else if (sms == 123) {
            ID_MET = id_met;
        } else if (sms == 3) {
            ID_MET = smet[0] + "," + smet[1] + "," + id_met;
        }
    }

    public static Scy getScy(String db) {
        return Ecad2007.getScy("int", db);
    }

    public static Scy getScy(String ie, String db) {
        Scy res = null;
        if (db == null) {
            db = Globals.ENERCAD_NAME;
        }
        if ((res = m_scy.get(db)) == null) {
            res = new Scy(ie, db);
            if (res.getErrorCode() == 2 && db == Globals.PROJECT_NAME) {
                String ecadDataDir = System.getProperty("ecad.home.dir");
                String fileSeparator = System.getProperty("file.separator");
                String dir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.PROJECT_NAME;
                String defdir = ecadDataDir + "data" + fileSeparator + "var" + fileSeparator + Globals.DEFAULT_NAME;
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                Ecad2007.removeScy(Globals.PROJECT_NAME);
                globals.deleteFiles(new File(dir).listFiles());
                globals.copyFiles(defdir, dir);
                res = new Scy(ie, db);
            } else {
                m_scy.put(db, res);
            }
        }
        return res;
    }

    public static boolean removeScy(String db) {
        boolean res = false;
        Scy scy = m_scy.remove(db);
        Ecad2007.closeSession(db);
        if (scy != null) {
            res = true;
        }
        return true;
    }

    public static Calendar getToday() {
        if (today.get(14) != 0) {
            today.set(10, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
        }
        return (Calendar)today.clone();
    }

    public static void inactivateLicense(Component parent) {
        Config config = new Config(System.getProperty("conf.file.name"));
        userNAME = "";
        config.setPropertyString("properties", "userNAME", " ");
        Ecad2007.getScy(Globals.ENERCAD_NAME).setValue("mac", "");
        Ecad2007.getScy(Globals.ENERCAD_NAME).setValue("scode", "");
        Ecad2007.getScy(Globals.ENERCAD_NAME).setValue("fLevel", "-1");
        prefs.put("fLevel", "-1");
        JOptionPane.showMessageDialog(parent, new DM_Trad("login").getCodeLan("lic_date_inactivate", "EnerCAD"), "EnerCAD-info", 1);
    }

    public static DM_Trad getTraduction(String group) {
        DM_Trad res = null;
        if (group.equals("gen")) {
            if (gen_trad == null) {
                gen_trad = new DM_Trad(group);
            } else if (gen_trad.getLan() != lan) {
                gen_trad = new DM_Trad(group);
            }
            res = gen_trad;
        } else if (group.equals("imf")) {
            if (imf_trad == null) {
                imf_trad = new DM_Trad(group);
            } else if (imf_trad.getLan() != lan) {
                imf_trad = new DM_Trad(group);
            }
            res = imf_trad;
        } else if (group.equals("mf")) {
            if (mf_trad == null) {
                mf_trad = new DM_Trad(group);
            } else if (mf_trad.getLan() != lan) {
                mf_trad = new DM_Trad(group);
            }
            res = mf_trad;
        } else if (group.equals("symbol")) {
            if (symbol_trad == null) {
                symbol_trad = new DM_Trad(group);
            } else if (symbol_trad.getLan() != lan) {
                symbol_trad = new DM_Trad(group);
            }
            res = symbol_trad;
        } else if (group.equals("valu")) {
            if (valu_trad == null) {
                valu_trad = new DM_Trad(group);
            }
            res = valu_trad;
        } else if (group.equals("oce")) {
            if (oce_trad == null) {
                oce_trad = new DM_Trad(group);
            } else if (oce_trad.getLan() != lan) {
                oce_trad = new DM_Trad(group);
            }
            res = oce_trad;
        } else if (group.equals("admin")) {
            if (admin_trad == null) {
                admin_trad = new DM_Trad(group);
            } else if (admin_trad.getLan() != lan) {
                admin_trad = new DM_Trad(group);
            }
            res = admin_trad;
        } else if (group.equals("CH")) {
            if (canton_trad == null) {
                canton_trad = new DM_Trad(group);
            } else if (canton_trad.getLan() != lan) {
                canton_trad = new DM_Trad(group);
            }
            res = canton_trad;
        } else if (group.equals("sre")) {
            if (sre_trad == null) {
                sre_trad = new DM_Trad(group);
            } else if (sre_trad.getLan() != lan) {
                sre_trad = new DM_Trad(group);
            }
            res = sre_trad;
        } else if (group.equals("shade")) {
            if (shade_trad == null) {
                shade_trad = new DM_Trad(group);
            } else if (shade_trad.getLan() != lan) {
                shade_trad = new DM_Trad(group);
            }
            res = shade_trad;
        } else if (group.equals("print")) {
            if (print_trad == null) {
                print_trad = new DM_Trad(group);
            } else if (print_trad.getLan() != lan) {
                print_trad = new DM_Trad(group);
            }
            res = print_trad;
        } else if (group.equals("horizon")) {
            if (hor_trad == null) {
                hor_trad = new DM_Trad(group);
            } else if (hor_trad.getLan() != lan) {
                hor_trad = new DM_Trad(group);
            }
            res = hor_trad;
        } else if (group.equals("c1")) {
            if (c1_trad == null) {
                c1_trad = new DM_Trad(group);
            } else if (c1_trad.getLan() != lan) {
                c1_trad = new DM_Trad(group);
            }
            res = c1_trad;
        } else if (group.equals("c2")) {
            if (c2_trad == null) {
                c2_trad = new DM_Trad(group);
            } else if (c2_trad.getLan() != lan) {
                c2_trad = new DM_Trad(group);
            }
            res = c2_trad;
        } else if (group.equals("biblio")) {
            if (biblio_trad == null) {
                biblio_trad = new DM_Trad(group);
            } else if (biblio_trad.getLan() != lan) {
                biblio_trad = new DM_Trad(group);
            }
            res = biblio_trad;
        } else if (group.equals("comp")) {
            if (comp_trad == null) {
                comp_trad = new DM_Trad(group);
            } else if (comp_trad.getLan() != lan) {
                comp_trad = new DM_Trad(group);
            }
            res = comp_trad;
        } else if (group.equals("prefs")) {
            if (prefs_trad == null) {
                prefs_trad = new DM_Trad(group);
            } else if (prefs_trad.getLan() != lan) {
                prefs_trad = new DM_Trad(group);
            }
            res = prefs_trad;
        } else if (group.equals("out")) {
            if (out_trad == null) {
                out_trad = new DM_Trad(group);
            } else if (out_trad.getLan() != lan) {
                out_trad = new DM_Trad(group);
            }
            res = out_trad;
        } else if (group.equals("ceb")) {
            if (ceb_trad == null) {
                ceb_trad = new DM_Trad(group);
            } else if (ceb_trad.getLan() != lan) {
                ceb_trad = new DM_Trad(group);
            }
            res = ceb_trad;
        } else if (group.equals("minergie")) {
            if (min_trad == null) {
                min_trad = new DM_Trad(group);
            } else if (min_trad.getLan() != lan) {
                min_trad = new DM_Trad(group);
            }
            res = min_trad;
        }
        return res;
    }

    public static DM_Trad_SIA getTraduction_SIA(String group) {
        DM_Trad_SIA res = null;
        if (group.equals("cecb")) {
            if (ceb_trad_sia == null) {
                ceb_trad_sia = new DM_Trad_SIA(group);
            } else if (ceb_trad_sia.getLan() != lan) {
                ceb_trad_sia = new DM_Trad_SIA(group);
            }
            res = ceb_trad_sia;
        } else if (group.equals("ceb")) {
            if (ceb_trad_sia == null) {
                ceb_trad_sia = new DM_Trad_SIA("cecb");
            } else if (ceb_trad_sia.getLan() != lan) {
                ceb_trad_sia = new DM_Trad_SIA("cecb");
            }
            res = ceb_trad_sia;
        } else if (group.equals("jflux")) {
            if (jflux_trad_sia == null) {
                jflux_trad_sia = new DM_Trad_SIA(group);
            } else if (jflux_trad_sia.getLan() != lan) {
                jflux_trad_sia = new DM_Trad_SIA(group);
            }
            res = jflux_trad_sia;
        } else if (group.equals("jglobal")) {
            if (jglobal_trad_sia == null) {
                jglobal_trad_sia = new DM_Trad_SIA(group);
            } else if (jglobal_trad_sia.getLan() != lan) {
                jglobal_trad_sia = new DM_Trad_SIA(group);
            }
            res = jglobal_trad_sia;
        } else if (group.equals("jponctuel")) {
            if (jponctuel_trad_sia == null) {
                jponctuel_trad_sia = new DM_Trad_SIA(group);
            } else if (jponctuel_trad_sia.getLan() != lan) {
                jponctuel_trad_sia = new DM_Trad_SIA(group);
            }
            res = jponctuel_trad_sia;
        } else if (group.equals("jtable")) {
            if (jtable_trad_sia == null) {
                jtable_trad_sia = new DM_Trad_SIA(group);
            } else if (jtable_trad_sia.getLan() != lan) {
                jtable_trad_sia = new DM_Trad_SIA(group);
            }
            res = jtable_trad_sia;
        } else if (group.equals("kbob")) {
            if (kbob_trad_sia == null) {
                kbob_trad_sia = new DM_Trad_SIA(group);
            } else if (kbob_trad_sia.getLan() != lan) {
                kbob_trad_sia = new DM_Trad_SIA(group);
            }
            res = kbob_trad_sia;
        } else if (group.equals("resume")) {
            if (resume_trad_sia == null) {
                resume_trad_sia = new DM_Trad_SIA(group);
            } else if (resume_trad_sia.getLan() != lan) {
                resume_trad_sia = new DM_Trad_SIA(group);
            }
            res = resume_trad_sia;
        }
        return res;
    }

    public static void setErrorCode(int ec) {
        Globals.println("Error " + ec);
        errorCode = ec;
    }

    public static int getErrorCode() {
        int res = errorCode;
        errorCode = 0;
        return res;
    }

    public static DM_Help getHelpTraduction(String group) {
        DM_Help res = null;
        if (group.equals("imf")) {
            if (imfhelp == null) {
                imfhelp = new DM_Help(group);
            }
            res = imfhelp;
        } else if (group.equals("imf2016")) {
            if (imfhelp2016 == null) {
                imfhelp2016 = new DM_Help(group);
            }
            res = imfhelp2016;
        } else if (group.equals("mf")) {
            if (mfhelp == null) {
                mfhelp = new DM_Help("mf");
            }
            res = mfhelp;
        }
        return res;
    }

    public static long getLicenseLevel() {
        return lLevel;
    }

    public static String getUserName() {
        return userNAME;
    }

    public static void setUserName(String username) {
        userNAME = username;
    }

    public static int getProjectVersion() {
        return saveVER;
    }

    public static int getRapportMode() {
        return rapportMode;
    }

    public static void setRapportMode(int modus) {
        rapportMode = modus;
    }

    public static MainFrame getMainFrame() {
        return frame;
    }

    public static String getUserPreference(String key, String def_value) {
        return prefs.get(key, def_value);
    }

    public static Preferences getUserPreferences() {
        return prefs;
    }

    public static void setLicenseLevel(long licenseLevel) {
        if (Globals.int_ver == 515) {
            lLevel = 4L;
        } else {
            boolean b_match;
            long res = licenseLevel;
            DecryptGenerator decryptGenerator = new DecryptGenerator();
            String prk2hex = Ecad2007.getPrk2Hex(Globals.int_ver);
            String puk1hex = Ecad2007.getPuk1Hex(Globals.int_ver);
            String scode = Ecad2007.getScy(Globals.ENERCAD_NAME).getValue("scode");
            String[] code = null;
            if (scode != null) {
                code = decryptGenerator.getSCParameters(prk2hex, puk1hex, scode);
            }
            if (code != null) {
                for (int ii = 0; ii < code.length; ++ii) {
                    Globals.println(ii + ": " + code[ii]);
                }
            }
            if (code != null && code.length == 5 && (b_match = code[1].matches("(([0]{2}+:){5}|([0]{2}+-){5})+([0]{2})"))) {
                res = 2L;
                Globals.println("Licence edu: " + code[1]);
            }
            lLevel = res;
        }
    }

    private void setLogger() {
        SimpleLayout layout = new SimpleLayout();
        try {
            String separator = System.getProperty("file.separator");
            String path = System.getProperty("ecad.home.dir") + "data" + separator + "var" + separator + Globals.PROJECT_NAME + separator + "log" + separator + "ecad.log";
            this.appender = new FileAppender(layout, path, true);
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
        logger.addAppender(this.appender);
        if (Globals.getIntDebug() == 0) {
            logger.setLevel(Level.TRACE);
        } else if (Globals.getIntDebug() == -1) {
            logger.setLevel(Level.FATAL);
        } else if (Globals.getIntDebug() == -2) {
            logger.setLevel(Level.ERROR);
        } else if (Globals.getIntDebug() == -3) {
            logger.setLevel(Level.WARN);
        } else if (Globals.getIntDebug() == -4) {
            logger.setLevel(Level.INFO);
        } else if (Globals.getIntDebug() == -5) {
            logger.setLevel(Level.DEBUG);
        } else if (Globals.getIntDebug() == -6) {
            logger.setLevel(Level.ALL);
        }
    }

    public static void trace(Exception exception) {
        int ii;
        if (logger == null) {
            return;
        }
        if (exception == null) {
            return;
        }
        StackTraceElement[] ste = exception.getStackTrace();
        if (ste == null) {
            return;
        }
        String tmp = "";
        for (ii = 0; ii < 80; ++ii) {
            tmp = tmp + "-";
        }
        if (logger.getLevel().equals(Level.DEBUG)) {
            exception.printStackTrace();
        } else {
            logger.assertLog(false, tmp);
            logger.assertLog(false, exception.getMessage());
            for (ii = 0; ii < ste.length; ++ii) {
                logger.assertLog(false, ste[ii].toString());
            }
            logger.assertLog(false, tmp);
        }
    }

    public static void trace(Object object) {
        logger.trace(object);
    }

    public static void trace(int level, Object object) {
        if (level >= logger.getLevel().toInt()) {
            logger.trace(object);
        }
    }

    public static void setProjectVersion(int version) {
        saveVER = version;
    }

    public static void startCSServer() {
        if (Globals.int_ver < 510) {
            Thread thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    Globals.println("Thread 2 (startCSServer()) has started.");
                    PrintWriter pw = new PrintWriter(System.out, true);
                    Config config = new Config(System.getProperty("conf.file.name"));
                    int port = config.getPropertyInt("properties", "serverport");
                }
            });
            thread2.start();
        }
    }

    public static TreeMap<Integer, InternalMainFrame> getImf() {
        return tm_imf;
    }

    public static Map<String, String[]> getMatLibrary() {
        return m4_mat;
    }

    public static void setMatLibrary(Map<String, String[]> cat) {
        m4_mat = new HashMap<String, String[]>(cat);
    }

    public static void addToMatLibrary(Map<String, String[]> cat) {
        if (m4_mat == null) {
            m4_mat = new HashMap<String, String[]>(cat);
        } else {
            m4_mat.putAll(cat);
        }
    }

    public static void eraseMatLibrary() {
        m4_mat = null;
    }

    public static List<M4_MatDb> getPrivateMatDb() {
        if (privateMatDb == null) {
            HibernateMatDbDao matDbDao = new HibernateMatDbDao();
            privateMatDb = matDbDao.getMatDbList();
        }
        return privateMatDb;
    }

    public static void erasePrivateMatDb() {
        privateMatDb = null;
    }

    public static String getPrk2Hex(int version) {
        String prk2 = "prk2";
        if (version == 427) {
            prk2 = prk2 + "_427";
        } else if (version >= 500 && version < 510) {
            prk2 = prk2 + "_500";
        } else if (version >= 510) {
            prk2 = prk2 + "_510";
        }
        return Ecad2007.getScy(Globals.ENERCAD_NAME).getValue(prk2);
    }

    public static String getPuk1Hex(int version) {
        String puk1 = "puk1";
        if (version == 427) {
            puk1 = puk1 + "_427";
        } else if (version >= 500 && version < 510) {
            puk1 = puk1 + "_500";
        } else if (version >= 510) {
            puk1 = puk1 + "_510";
        }
        return Ecad2007.getScy(Globals.ENERCAD_NAME).getValue(puk1);
    }

    public static Map<String, String[]> getProjectMatLibrary() {
        return m4_proj;
    }

    public static void setProjectMatLibrary(Map<String, String[]> lib) {
        if (lib != null) {
            m4_proj = new HashMap<String, String[]>(lib);
        }
    }

    public static void addToProjectMatLibrary(Map<String, String[]> lib) {
        if (m4_proj == null) {
            m4_proj = new HashMap<String, String[]>(lib);
        } else {
            m4_proj.putAll(lib);
        }
    }

    public static void eraseProjectMatLibrary() {
        m4_proj = null;
    }

    static Map<String, MatDbOrg> getProjectMat510Library() {
        return m4_proj510;
    }

    public static void setProjectMat510Library(Map<String, MatDbOrg> matLib) {
        if (matLib != null) {
            m4_proj510 = new HashMap<String, MatDbOrg>(matLib);
        }
    }

    public static void addToProjectMat510Library(Map<String, MatDbOrg> matLib) {
        if (m4_proj510 == null) {
            m4_proj510 = new HashMap<String, MatDbOrg>(matLib);
        } else {
            m4_proj510.putAll(matLib);
        }
    }

    public static void addToProjectMat510Library(MatDbOrg matdborg) {
        if (matdborg != null) {
            if (m4_proj510 == null) {
                m4_proj510 = new HashMap<String, MatDbOrg>();
            }
            m4_proj510.put(matdborg.getRef(), matdborg);
        }
    }

    public static void eraseProjectMat510Library() {
        m4_proj510 = null;
    }

    public static void defineMatLibraryMap(String dlg, DB_cat db_cat) {
        if (dlg == null) {
            return;
        }
        if (db_cat == null) {
            return;
        }
        String tableName = db_cat.getTableName();
        if (dlg.equals("DlgStart")) {
            m_dbCat_start.put(tableName, db_cat);
        } else if (dlg.equals("DlgValeurUDef")) {
            m_dbCat_valeurUDef.put(tableName, db_cat);
        } else if (dlg.equals("DlgValeurU")) {
            m_dbCat_valeurU.put(tableName, db_cat);
        }
    }

    public static Map<String, DB_cat> defineMatLibraryMap(String dlg, String libName, DB_cat db_cat) {
        Map<String, DB_cat> res = null;
        if (dlg == null) {
            return res;
        }
        if (dlg.equals("DlgStart")) {
            m_dbCat_start.put(libName, db_cat);
            res = m_dbCat_start;
        } else if (dlg.equals("DlgValeurUDef")) {
            m_dbCat_valeurUDef.put(libName, db_cat);
            res = m_dbCat_valeurUDef;
        } else if (dlg.equals("DlgValeurU")) {
            m_dbCat_valeurU.put(libName, db_cat);
            res = m_dbCat_valeurU;
        }
        return res;
    }

    public static DB_cat getMatLibraryMap(String dlg, String libName) {
        DB_cat res = null;
        if (dlg == null || libName == null) {
            return res;
        }
        if (dlg.equals("DlgStart")) {
            res = m_dbCat_start.get(libName);
        } else if (dlg.equals("DlgValeurUDef")) {
            res = m_dbCat_valeurUDef.get(libName);
        } else if (dlg.equals("DlgValeurU")) {
            res = m_dbCat_valeurU.get(libName);
        }
        return res;
    }

    public static String getMacAddress() {
        if (macAddress == null) {
            macAddress = AddressMACInfo.getUniqueMacAddress();
        } else if (Globals.getStringValue(macAddress) == "") {
            macAddress = AddressMACInfo.getUniqueMacAddress();
        }
        if (Globals.getStringValue(macAddress).isEmpty()) {
            macAddress = AddressMACInfo.getUniqueMacAddress();
        }
        return macAddress;
    }

    public static DB_cat getWinLibrary() {
        if (db_fen == null) {
            HashMap<String, String[]> columnNamesAsMap = new HashMap<String, String[]>(5);
            String[] cn_ver = new String[]{"NOM_FR", "UU", "GG"};
            String[] cn_cad = new String[]{"NOM_FR", "UU", "FF"};
            String[] cn_voil = new String[]{"NOM_FR", "FC"};
            String[] cn_icl = new String[]{"NOM_FR", "UU"};
            columnNamesAsMap.put("m1_ver", cn_ver);
            columnNamesAsMap.put("m2_cad", cn_cad);
            columnNamesAsMap.put("m3_voil", cn_voil);
            columnNamesAsMap.put("m6_icl", cn_icl);
            db_fen = new DB_cat("int", "M16_FEN", columnNamesAsMap);
        }
        return db_fen;
    }

    public static void setWinLibrary(DB_cat db_fen) {
        Ecad2007.db_fen = db_fen;
    }

    public static void eraseWinLibrary() {
        db_fen = null;
    }

    public static int getLicenseCheck() {
        return lCount;
    }

    public static void addLicenseCheck(int licenseChecks) {
        lCount += licenseChecks;
    }

    public static void setLicenseCheck(int licenseChecks) {
        lCount = licenseChecks;
    }

    public static int getLicenseVersion() {
        return lVersion;
    }

    public static void setLicenseVersion(int licenseVersion) {
        lVersion = licenseVersion;
    }

    public static void loadMatDb(int autoconnect) {
        if (autoconnect > 0 && Globals.int_ver >= 510 && Globals.int_ver != 515) {
            Thread thread4 = new Thread(new Runnable(){

                @Override
                public void run() {
                    Globals.println("Thread 4 has started.");
                    HashMap<String, MaterialsDbOrg> library = new HashMap(30);
                    HashMap<String, BufferedImage[]> m_logos = new HashMap<String, BufferedImage[]>(30);
                    Map<Object, Object> m_sl = new HashMap(30);
                    Config config = new Config(System.getProperty("conf.file.name"));
                    String url = config.getPropertyString("properties", "url", new String[]{"ext"});
                    String m_http = "http://" + url + "/MaterialsDbOrg/fabs/ManufacturerService";
                    try {
                        HessianProxyFactory factory = new HessianProxyFactory();
                        ManufacturerService manufacturerService = (ManufacturerService)factory.create(ManufacturerService.class, m_http);
                        m_sl = manufacturerService.getLogos2();
                        library = manufacturerService.getLibrary();
                        System.out.println("DB_cat logos size: " + m_sl.size() + " library size: " + library.size());
                    }
                    catch (HessianRuntimeException hrex) {
                        Globals.println("enercad2007.DlgValeurUDef hrex: " + hrex.getMessage());
                    }
                    catch (HessianConnectionException hcex) {
                        Globals.println("enercad2007.DlgValeurUDef hcex: " + hcex.getMessage());
                    }
                    catch (MalformedURLException murlex) {
                        Globals.println("enercad2007.DlgValeurUDef murlex: " + murlex.getMessage());
                    }
                    catch (NullPointerException npex) {
                        Globals.println("enercad2007.DlgValeurUDef npex: " + npex.getMessage());
                    }
                    Globals.println("DB_cat.jbInit: Library loaded.");
                    for (String string : m_sl.keySet()) {
                        String[] b64 = (String[])m_sl.get(string);
                        BufferedImage[] bi = new BufferedImage[4];
                        for (int ii = 0; ii < b64.length; ++ii) {
                            byte[] bytearray = Base64.decode(b64[ii]);
                            try {
                                bi[ii] = ImageIO.read(new ByteArrayInputStream(bytearray));
                                continue;
                            }
                            catch (IOException ioex) {
                                Globals.println("Ecad2007: " + ioex.getMessage());
                            }
                        }
                        m_logos.put(string, bi);
                    }
                    Ecad2007.setMaterialsDbLogos(m_logos);
                    Ecad2007.setFabLibrary(library);
                }
            });
            thread4.start();
        }
    }

    public static void setFabLibrary(Map<String, MaterialsDbOrg> library) {
        fabMatLibraries = library;
    }

    public static Map<String, MaterialsDbOrg> getFabLibrary() {
        return fabMatLibraries;
    }

    public static void setMaterialsDbLogos(Map<String, BufferedImage[]> m_logos) {
        materialsDbLogos = m_logos;
    }

    public static Map<String, BufferedImage[]> getMaterialsDbLogos() {
        return materialsDbLogos;
    }

    public static void setFabLogos(Map<String, String> logos) {
        fabMatLogos = logos;
    }

    public static Map<String, String> getFabLogos() {
        return fabMatLogos;
    }

    private void showReadWriteErrorMessage(boolean b_read) {
        String[] write_error = new String[]{"Sie haben keine Schreibrechte f&uuml;r:<br><br>\n\\s.<br><br>\nBitte beheben Sie den Fehler auf.<br>Ich brauche <a href='\\s'>Hilfe</a>.", "Vous n'avez pas de droits en &eacute;criture pour:<br><br>\n\\s.<br><br>\n\nVeuillez corriger.<br>Pour en savoir plus cliquez sur <a href='\\s'>aide</a>.", "Non avete diritto in scrittura per:<br><br>\n\\s.<br><br>\n\nCorreggete per favore.<br>Per saperne di pi&uacute;, cliccare su <a href='\\s'>help</a>.", "Missing writing rights for:<br><br>\n\\s.<br><br>\n\nPlease correct.<br>I need <a href='\\s'>help</a>."};
        if (b_writetest) {
            return;
        }
        if (!b_read) {
            b_writetest = true;
            return;
        }
        b_writetest = true;
        globals.beep();
        String osName = System.getProperty("os.name");
        String link2 = "www.enercad.ch/ecad13/fr/support/page_03.htm";
        if (osName.startsWith("Mac OS")) {
            link2 = "www.enercad.ch/ecad13/fr/support/page_03.htm";
        }
        if (lan == 0) {
            link2 = osName.startsWith("Mac OS") ? "www.enercad.ch/ecad13/de/support/page_03.htm" : "www.enercad.ch/ecad13/de/support/page_03.htm";
        }
        String msgpath = System.getProperty("user.dir");
        DM_Trad gen_trad = new DM_Trad("gen");
        String message = gen_trad.getCodeLan("write_error", write_error[lan], new String[]{msgpath.replaceAll("\\\\", "\\\\\\\\"), link2});
        HTMLMessageDialog htmlMD = new HTMLMessageDialog("EnerCAD-info");
        htmlMD.setFont(Globals.FT_STAND1);
        htmlMD.setHyperlinkExit(true);
        htmlMD.showMessageDialog(message, 0);
        Ecad2007.closeConnection("cat");
        System.exit(0);
    }

    public static void updateGraphs(DM_Zone dm_zone) {
        if (dlgOutQh != null && dlgOutQh.isVisible()) {
            dlgOutQh.setListQh(dm_zone.getQh());
            dlgOutQh.setQhli(dm_zone.getQhli());
            dlgOutQh.setFLim(dm_pro.getF_LIM());
            dlgOutQh.repaint();
        }
        if (dlgOutGraph != null && dlgOutGraph.isVisible()) {
            dlgOutGraph.setValeurs(dm_zone.getQtM(), dm_zone.getQvM(), dm_zone.getQsM(), dm_zone.getQpM(), dm_zone.getQeM(), dm_zone.getFapM());
            dlgOutGraph.repaint();
        }
        if (dlgOutFlux != null && dlgOutFlux.isVisible()) {
            dlgOutFlux.setVal(dm_zone.getQt(), dm_zone.getQtr(), dm_zone.getQtw(), dm_zone.getQtf(), dm_zone.getQv(), dm_zone.getQsF(), dm_zone.getQpF(), dm_zone.getQeF(), dm_zone.getQTpr(), dm_zone.getQTpm(), dm_zone.getQTpf());
            dlgOutFlux.repaint();
        }
        if (dlgOutTableau != null && dlgOutTableau.isVisible()) {
            dlgOutTableau.setVal(dm_zone.getQtM(), dm_zone.getQvM(), dm_zone.getQsM(), dm_zone.getQpM(), dm_zone.getQeM(), dm_zone.getFapM());
            dlgOutTableau.setUnit(dm_zone.getSRE());
            dlgOutTableau.setNomMois(meteO.getNomMoisShort());
            dlgOutTableau.repaint();
        }
        if (dlgOutCeb != null && dlgOutCeb.isVisible()) {
            Ecad2007.initializeDlgOutCeb(dm_zone);
            dlgOutCeb.repaint();
        }
        if (iasf != null && iasf.isVisible()) {
            iasf.refreshSolarDialog();
        }
    }

    public static void reloadBiblio(String biblio) {
    }

    public static void updateLicenseLevel() {
        lLevel = dlgStart.getPLicenceLevel();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Globals.setDebug(args[0]);
        }
        if (args.length > 1) {
            Globals.setDevelop(args[1]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Font FT_STAND = Globals.FT_STAND1;
                    MetalLookAndFeel mlf = new MetalLookAndFeel();
                    UIManager.setLookAndFeel(mlf);
                    UIManager.put("swing.boldMetal", Boolean.FALSE);
                    UIManager.put("Label.font", FT_STAND);
                    UIManager.put("TabbedPane.font", FT_STAND);
                    UIManager.put("RadioButton.font", FT_STAND);
                    UIManager.put("TextField.font", FT_STAND);
                    UIManager.put("FormattedTextField.font", FT_STAND);
                    UIManager.put("FileChooser.font", FT_STAND);
                    UIManager.put("ComboBox.font", FT_STAND);
                    UIManager.put("Button.font", FT_STAND);
                    UIManager.put("List.font", FT_STAND);
                    UIManager.put("ToolTip.font", FT_STAND);
                    UIManager.put("Menu.background", Color.white);
                    UIManager.put("MenuBar.background", Color.white);
                    UIManager.put("MenuItem.background", Color.white);
                    UIManager.put("PopupMenu.background", Color.white);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                new Ecad2007();
            }
        });
    }

    static {
        icGen = null;
        m_dbCat_start = new HashMap<String, DB_cat>(4);
        m_dbCat_valeurUDef = new HashMap<String, DB_cat>(4);
        m_dbCat_valeurU = new HashMap<String, DB_cat>(4);
        today = Calendar.getInstance();
        cn_comp = new HashMap<String, Connection>(10);
        logger = Logger.getLogger(Ecad2007.class);
        m_scy = new HashMap<String, Scy>(2);
        lLevel = -1L;
        lCount = 0;
        lVersion = 0;
        userNAME = "";
        b_clientCheck = false;
        saveVER = 0;
        ID_B = 0;
        tm_imf = new TreeMap();
        id_z = 0;
        m_dmElement = new HashMap<Integer, DM_Element>();
        startError = "";
        errorCode = 0;
        b_writetest = false;
    }
}

