/*
 * Decompiled with CFR 0.152.
 */
package enercad2007;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class IMFTableCellRenderer
extends DefaultTableCellRenderer {
    TableModel tm;
    TableColumnModel tcm;
    boolean b_solar = false;
    DecimalFormat df0;
    DecimalFormat df1;
    int alp = -1;

    public IMFTableCellRenderer(TableModel tablemodel) {
        this(tablemodel, null);
    }

    public IMFTableCellRenderer(TableModel tablemodel, TableColumnModel tablecolumnmodel) {
        this.tm = tablemodel;
        this.tcm = tablecolumnmodel;
        this.df0 = Ecad2007.getDecimalFormat("0");
        this.df1 = Ecad2007.getDecimalFormat("0.0");
    }

    public IMFTableCellRenderer(TableModel tablemodel, TableColumnModel tablecolumnmodel, boolean b_solar) {
        this.tm = tablemodel;
        this.tcm = tablecolumnmodel;
        this.b_solar = b_solar;
        this.df0 = Ecad2007.getDecimalFormat("0");
        this.df1 = Ecad2007.getDecimalFormat("0.0");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int flag;
        block26: {
            flag = -2;
            if (this.b_solar) {
                if (this.tm == null) {
                    this.setForeground(Color.black);
                } else {
                    try {
                        if (this.tm.getValueAt(row, 6) != null) {
                            flag = Globals.getIntValue(this.tm.getValueAt(row, 6));
                            String nbsp = "";
                            if (flag == -1) {
                                this.setFont(Globals.FT_BOLD1);
                                nbsp = column == 0 ? "" : "    ";
                                isSelected = false;
                            } else {
                                this.setFont(Globals.FT_STAND1);
                                nbsp = column == 0 ? "    " : "";
                            }
                            if (column >= 1) {
                                this.setText(value + nbsp);
                            } else {
                                this.setText(nbsp + value);
                            }
                            break block26;
                        }
                        this.setForeground(Color.black);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        this.setForeground(Color.black);
                    }
                }
            } else {
                if (this.tm == null) {
                    this.setForeground(Color.black);
                    this.setText(value + " m\u00b2");
                } else if (this.tm.getValueAt(row, 6) != null) {
                    String[] cc = (String[])this.tm.getValueAt(row, 6);
                    if (cc[1].equals("4")) {
                        this.setForeground(new Color(879050));
                        this.setText(value + " m");
                    } else if (cc[1].equals("8")) {
                        this.setForeground(new Color(292515));
                        this.setText(this.df0.format(value));
                    } else {
                        this.setForeground(Color.black);
                        this.setText(this.df1.format(value) + " m\u00b2");
                    }
                } else {
                    this.setForeground(Color.black);
                    this.setText(value + " m\u00b2");
                }
                if (this.alp > 8 && this.tcm != null) {
                    String txt = this.getText();
                    int pdot = txt.indexOf(".");
                    int cc = 0;
                    if (pdot > 0) {
                        txt = txt.substring(pdot);
                        FontMetrics fm = this.getFontMetrics(this.getFont());
                        int aa = fm.stringWidth(txt);
                        cc = this.tcm.getColumn(column).getWidth() - this.alp - aa;
                    } else {
                        cc = this.tcm.getColumn(column).getWidth() - this.alp;
                    }
                    this.setHorizontalAlignment(4);
                    this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, cc));
                }
            }
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else if (flag == -1) {
            this.setBackground(new Color(240, 240, 240));
        } else {
            this.setBackground(table.getBackground());
        }
        return this;
    }

    public void setHorizontalTextCTabAlignment(int alp) {
        this.alp = alp;
    }

    public int getHorizontalTextCTabAlignment() {
        return this.alp;
    }

    public void setModels(TableModel tablemodel) {
        this.tm = tablemodel;
    }

    public void setTableColumnmodel(TableColumnModel tablecolumnmodel) {
        this.tcm = tablecolumnmodel;
    }
}

