/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs;

import core.Calculation;
import core.Config;
import core.hibernate.pro.db.Envelope;
import enercad2007.DM_Comp;
import enercad2007.DM_Element;
import enercad2007.DM_Trad;
import enercad2007.DMpr_ValU;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.dialogs.ComponentComparator;
import enercad2007.dialogs.DlgElement;
import jTreeBiblio.JTreeBiblio;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.border.Border;
import jecadcomp.GraphElements;
import jecadcomp.GraphSIALimits;

public class DlgComp
extends JDialog {
    private JDialog parent;
    private JPanel pnl_0 = new JPanel();
    private JPanel jPa_cadre01 = new JPanel();
    Dimension size = new Dimension(690, 495);
    String title = "";
    String componentCode = "-0,0,0";
    String[] cc;
    int flags = 0;
    String[] cNames = new String[]{"", "U", "g"};
    String[] cTooltips;
    String[] columnNames = new String[]{"NOM_FR", "U_C", "GG", "CODE"};
    Color[] colors = new Color[]{new Color(255, 255, 255), new Color(223, 223, 223), new Color(191, 191, 255)};
    String ref = "";
    String[] row;
    JTreeBiblio jtrBint;
    DM_Comp dm_comp;
    String[] selectedIntRefs;
    Map<String, String[]> datamapInt;
    Map<String, String[]> m4_mat = Ecad2007.getMatLibrary();
    transient Object[][] M4data;
    String[][] M4d;
    int nlay = 0;
    int ch_c = -1;
    int st_c = -1;
    transient Config config = new Config(System.getProperty("conf.file.name"));
    int ilan = this.config.getPropertyInt("properties", "lan");
    DM_Trad biblio_trad;
    DM_Trad gen_trad;
    DM_Trad comp_trad;
    Globals globals = new Globals();
    transient Calculation calc = new Calculation();
    transient DlgComp_EventQueue dcompevq;
    Component[] component = null;
    DecimalFormat df2;
    HashMap ic_gen = Ecad2007.getIcons("gen");
    Font FT_STAND = new Font("Dialog", 0, 11);
    Font FT_STAND2 = new Font("Dialog", 0, 12);
    Font FT_BOLD = new Font("Dialog", 1, 11);
    String lan = "FR";
    String txt_title = "Composants";
    String txt_el_fr = "\u00c9l\u00e9ment (fran\u00e7ais)";
    String txt_cancel = "Annuler";
    String txt_ok = "Ok";
    transient Border border1;
    Color clr_inactif;
    private JLabel jLa_title = new JLabel();
    private JButton jB_esc = new JButton();
    private JButton jB_ok = new JButton();
    GraphElements gelCompR = new GraphElements(this.m4_mat, false);
    GraphElements gelCompS = new GraphElements(this.m4_mat, false);
    GraphSIALimits gsia = new GraphSIALimits(0);
    int exitstate = 0;

    public DlgComp() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public DlgComp(JDialog parent) {
        this.parent = parent;
        try {
            this.jbInit();
            this.pack();
            this.setSize(this.size);
            this.setResizable(false);
            if (this.globals != null) {
                this.globals.setLocation(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgComp(JDialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.title = title;
        try {
            this.jbInit();
            this.pack();
            this.setSize(this.size);
            this.setResizable(false);
            if (this.globals != null) {
                this.globals.setLocation(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgComp(JDialog parent, String title, boolean modal, String componentCode) {
        super(parent, title, modal);
        this.parent = parent;
        this.title = title;
        this.componentCode = componentCode;
        try {
            this.jbInit();
            this.pack();
            this.setSize(this.size);
            this.setResizable(false);
            if (this.globals != null) {
                this.globals.setLocation(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgComp(JDialog parent, String title, boolean modal, String componentCode, int flags) {
        super(parent, title, modal);
        this.parent = parent;
        this.title = title;
        this.componentCode = componentCode;
        this.flags = flags;
        try {
            this.jbInit();
            this.pack();
            this.setSize(this.size);
            this.setResizable(false);
            if (this.globals != null) {
                this.globals.setLocation(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgComp(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setSize(this.size);
            this.setResizable(false);
            if (this.globals != null) {
                this.globals.setLocation(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(100, 100, 100)), BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.clr_inactif = new Color(225, 225, 225);
        this.setTitle(this.txt_title);
        this.addWindowListener(new DlgComp_windowAdapter(this));
        if (this.globals != null) {
            this.FT_STAND = Globals.FT_STAND1;
            this.FT_STAND2 = Globals.FT_STAND2;
            this.FT_BOLD = Globals.FT_BOLD1;
            switch (this.ilan) {
                case 0: {
                    this.lan = "GE";
                    break;
                }
                case 1: {
                    this.lan = "FR";
                    break;
                }
                case 2: {
                    this.lan = "IT";
                    break;
                }
                case 3: {
                    this.lan = "EN";
                }
            }
            this.df2 = Ecad2007.getDecimalFormat("0.00");
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.biblio_trad = Ecad2007.getTraduction("biblio");
            this.comp_trad = Ecad2007.getTraduction("comp");
            this.txt_title = this.comp_trad.getCodeLan("titre");
            this.txt_el_fr = this.gen_trad.getCodeLan("el") + " (" + this.gen_trad.getCodeLan("lan_" + this.lan.toLowerCase()).toLowerCase() + ")";
            this.txt_ok = this.gen_trad.getCodeLan("ok");
            this.txt_cancel = this.gen_trad.getCodeLan("cancel");
            this.globals.setLocation(this);
        }
        if (this.componentCode != null) {
            this.cc = this.componentCode.split(",");
        }
        this.cTooltips = new String[]{"Nom du composant", "Valeur U [W/m\u00b2K]"};
        if (this.cc.length > 1) {
            if (Globals.getIntValue(this.cc[1]) == 4) {
                this.cNames = new String[]{"", "\u03a8", "g"};
                this.cTooltips = new String[]{"Nom du composant", "Valeur \u03a8 (Psi) [W/mK]"};
            } else if (Globals.getIntValue(this.cc[1]) == 8) {
                this.cNames = new String[]{"", "\u03a7", "g"};
                this.cTooltips = new String[]{"Nom du composant", "Valeur \u03a7 (Chi) [W/K]"};
            }
        }
        this.dm_comp = new DM_Comp("int", this.columnNames, this.componentCode, this.flags, this.m4_mat);
        Vector vctInt = this.dm_comp.getVectorData();
        this.datamapInt = this.dm_comp.getDataMap();
        this.jLa_title.setBounds(16, 8, 200, 22);
        this.jLa_title.setFont(this.FT_BOLD);
        this.jLa_title.setText(this.title);
        this.pnl_0.setBounds(new Rectangle(0, 0, 870, 590));
        this.pnl_0.setLayout(null);
        this.pnl_0.setFocusTraversalPolicy(new OrderFocusTraversalPolicy());
        this.pnl_0.setFocusCycleRoot(true);
        this.jtrBint = new JTreeBiblio(vctInt, this.cNames, this.cTooltips, 4);
        this.jtrBint.setColumnsColors(this.colors);
        this.jtrBint.setColumnsAlignment(new int[]{2, 0, 0});
        this.jtrBint.setColumnsWidth(new int[]{550, 50, 50});
        this.jtrBint.setBounds(new Rectangle(16, 35, 650, 241));
        this.jtrBint.setTreeSelectionMode(2);
        this.jtrBint.addMouseListener(new DlgComp_mouseAdapter(this));
        if (this.cc != null && this.cc.length > 1 && !this.cc[1].equals("2")) {
            this.jtrBint.setColumnsWidth(new int[]{600, 50, 0});
        }
        this.jB_esc.setText(this.txt_cancel);
        this.jB_esc.setBounds(new Rectangle(570, 430, 95, 22));
        this.jB_esc.addActionListener(new DlgComp_actionAdapter(this));
        this.jB_ok.setText(this.txt_ok);
        this.jB_ok.addActionListener(new DlgComp_actionAdapter(this));
        this.jB_ok.setBounds(new Rectangle(470, 430, 95, 22));
        this.jPa_cadre01.setBorder(BorderFactory.createEtchedBorder());
        this.jPa_cadre01.setBounds(new Rectangle(16, 285, 650, 135));
        this.gelCompR.setBounds(new Rectangle(26, 5, 125, 125));
        this.gelCompR.setBorder(this.border1);
        this.gelCompS.setBounds(new Rectangle(150, 5, 125, 125));
        this.gelCompS.setBorder(BorderFactory.createLineBorder(Color.black));
        this.gelCompS.setVisible(false);
        this.gsia.setBounds(new Rectangle(550, 5, 90, 125));
        this.gsia.setBackground(this.getBackground());
        this.gsia.setUtxtVisible(false);
        this.gsia.setVisible(false);
        this.jPa_cadre01.setDebugGraphicsOptions(0);
        this.jPa_cadre01.setLayout(null);
        this.jPa_cadre01.add((Component)this.gelCompR, null);
        this.jPa_cadre01.add((Component)this.gelCompS, null);
        if (Globals.int_ver > 426) {
            this.jPa_cadre01.add((Component)this.gsia, null);
        }
        this.pnl_0.add((Component)this.jLa_title, null);
        this.pnl_0.add((Component)this.jtrBint, null);
        this.pnl_0.add((Component)this.jPa_cadre01, null);
        this.pnl_0.add((Component)this.jB_ok, null);
        this.pnl_0.add((Component)this.jB_esc, null);
        container.add((Component)this.pnl_0, null);
        container.setSize(this.size);
        this.dcompevq = new DlgComp_EventQueue(this);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.dcompevq);
    }

    private void beep() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    public void drawGSIA(String compRef) {
        String bb = "";
        if (this.componentCode == null) {
            return;
        }
        if (!(this.parent instanceof DlgElement)) {
            return;
        }
        String[] cc = this.componentCode.split(",");
        String[] ccR = compRef.split(",");
        int typeF = Globals.getIntValue(cc[0]);
        int typeC = Globals.getIntValue(cc[1]);
        int typeV = Globals.getIntValue(cc[2]);
        double[] uli = new double[4];
        String f_b = "";
        int ch_e = 0;
        int bl_e = 0;
        double tch_e = 0.0;
        double valeurU = 0.0;
        DM_Element dm_element = ((DlgElement)this.parent).createDMElement();
        Envelope element = dm_element.getElement();
        Map<String, Object> map = dm_element.getCalcE(element);
        double[][] res = (double[][])map.get("res_E");
        double dch_e = Globals.getDoubleValue(map.get("Dch_E"));
        double a_e = Globals.getDoubleValue(map.get("A_E"));
        double ar_e = Globals.getDoubleValue(map.get("Ar_E"));
        this.selectedIntRefs = this.jtrBint.getArraySel();
        if (typeC == 1) {
            int type = -1;
            Map<String, Object> c2 = this.getC2Values();
            DMpr_ValU datamodule = new DMpr_ValU(compRef);
            ch_e = datamodule.getCoucheCh();
            bl_e = datamodule.getCoucheSt();
            if (cc[0].equals("1")) {
                type = 0;
            } else if (cc[0].equals("2")) {
                type = 1;
            } else if (cc[0].equals("4")) {
                type = 2;
            } else if (cc[0].equals("8")) {
                type = 3;
            }
            Object[] object = Ecad2007.getDM_E_NC().getE_NC(typeV);
            if (object != null && object[4] != null) {
                tch_e = Globals.getDoubleValue(object[4], 0.0f);
            }
            double[] pTherm = datamodule.getPontTherm();
            double[] rs = datamodule.getDimRS();
            this.calc.setCT(this.config.getPropertyInt("constants", "cT"));
            if (type == 2 || type == 3) {
                Map<String, Object> arrays = this.globals.reverseArrays((Object[][])datamodule.getDlgData(), datamodule.getDlgd(), datamodule.getDlgFlags());
                this.calc.setData((Object[][])arrays.get("data"));
                this.calc.setDimData((String[][])arrays.get("dimdata"));
                this.calc.setFlags((String[][])arrays.get("flags"));
                if (ch_e >= 0) {
                    ch_e = this.nlay - ch_e - 1;
                }
            } else {
                this.calc.setData((Object[][])datamodule.getDlgData());
                this.calc.setDimData(datamodule.getDlgd());
                this.calc.setFlags(datamodule.getDlgFlags());
            }
            this.calc.setRAie(datamodule.getRAie());
            double rmoy = this.calc.getRMoy(rs, this.nlay);
            rmoy = this.calc.getRmoyAvecPontThermique(rmoy, pTherm[0], (int)pTherm[1]);
            valeurU = 1.0 / rmoy;
            if (valeurU < 0.0) {
                valeurU = datamodule.getValeurU();
            }
            bb = dm_element.getCodeSIA(this.componentCode, typeF, typeC, typeV, a_e, ar_e, ch_e, dch_e, bl_e, tch_e);
        } else if (typeC == 2) {
            Map<String, Object> c1 = this.getC1Values();
            double[] wvalue = new double[]{Globals.getDoubleValue(c1.get("UG_C")), Globals.getDoubleValue(c1.get("G_C")), Globals.getDoubleValue(c1.get("UI_C")), Globals.getDoubleValue(c1.get("LR_C")), Globals.getDoubleValue(c1.get("UF_C")), Globals.getDoubleValue(c1.get("FF_C"))};
            valeurU = wvalue[4] * wvalue[5] + wvalue[0] * (1.0 - wvalue[5]) + wvalue[2] * wvalue[3];
            bb = dm_element.getCodeSIA(this.componentCode, typeF, typeC, typeV, a_e, ar_e, ch_e, dch_e, bl_e, tch_e);
        } else if (typeC == 4) {
            Map<String, Object> c3 = this.getC3Values();
            valeurU = Globals.getDoubleValue(c3.get("U_C"));
            if (c3.get("BASE") != null) {
                bb = (String)c3.get("BASE");
            }
        } else if (typeC == 8) {
            Map<String, Object> c4 = this.getC4Values();
            valeurU = Globals.getDoubleValue(c4.get("U_C"));
            if (c4.get("BASE") != null) {
                bb = (String)c4.get("BASE");
            }
        }
        f_b = this.df2.format(res[2][1]);
        uli = dm_element.getUlimElement(bb);
        boolean b_visible = false;
        if (valeurU > 0.0 && Globals.int_ver > 426) {
            this.gsia.setB(f_b);
            this.gsia.setValeurU(valeurU);
            this.gsia.setLimits(uli);
            if (uli.length > 3 && uli[0] > 0.0 && uli[1] > 0.0) {
                b_visible = true;
            }
        }
        this.gsia.setVisible(b_visible);
    }

    public int getExitState() {
        return this.exitstate;
    }

    public String getSelectedIntRef() {
        String res = "";
        if (this.selectedIntRefs != null && this.selectedIntRefs != null) {
            res = this.selectedIntRefs[3].trim();
        }
        return res;
    }

    public Map<String, String[]> getC1Materials() {
        String wref = this.getSelectedIntRef();
        Object[] c1_fen = Ecad2007.c1_fen.get(wref);
        HashMap<String, String[]> map = new HashMap<String, String[]>(4);
        Map<String, String[]> m_ver = Ecad2007.getWinLibrary().getDataMapM16()[0];
        Map<String, String[]> m_cad = Ecad2007.getWinLibrary().getDataMapM16()[1];
        Map<String, String[]> m_voil = Ecad2007.getWinLibrary().getDataMapM16()[2];
        Map<String, String[]> m_icl = Ecad2007.getWinLibrary().getDataMapM16()[3];
        map.put("m1_ver", m_ver.get(c1_fen[3]));
        map.put("m2_cad", m_cad.get(c1_fen[4]));
        map.put("m3_voil", m_voil.get(c1_fen[5]));
        map.put("m6_icl", m_icl.get(c1_fen[6]));
        return map;
    }

    public Map<String, Object> getC1Values() {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        String wref = this.getSelectedIntRef();
        Object[] c1_fen = Ecad2007.c1_fen.get(wref);
        Map<String, String[]> m_ver = Ecad2007.getWinLibrary().getDataMapM16()[0];
        String[] m1_ver = m_ver.get(c1_fen[3]);
        Map<String, String[]> m_cad = Ecad2007.getWinLibrary().getDataMapM16()[1];
        String[] m2_cad = m_cad.get(c1_fen[4]);
        Map<String, String[]> m_voil = Ecad2007.getWinLibrary().getDataMapM16()[2];
        String[] m3_voil = m_voil.get(c1_fen[5]);
        Map<String, String[]> m_icl = Ecad2007.getWinLibrary().getDataMapM16()[3];
        String[] m6_icl = m_icl.get(c1_fen[6]);
        double ug = new Double(m1_ver[4]);
        double g = new Double(m1_ver[5]);
        double uf = new Double(m2_cad[4]);
        double ff = new Double(m2_cad[5]);
        double fc = new Double(m3_voil[4]);
        double ui = new Double(m6_icl[4]);
        double lr = 3.5;
        map.put("NOM_C", c1_fen[0]);
        map.put("UG_C", new Double(ug));
        map.put("G_C", new Double(g));
        map.put("UF_C", new Double(uf));
        map.put("FF_C", new Double(ff));
        map.put("FC_C", new Double(fc));
        map.put("UI_C", new Double(ui));
        map.put("LR_C", new Double(lr));
        map.put("ICA_C", new Double(1.0));
        map.put("ICL_C", new Double(3.5));
        Map wmap = this.calc.getCompFen(uf, ug, ff, fc, g, ui, lr);
        map.put("U_C", wmap.get("U"));
        return map;
    }

    public Object[][] getC2Data() {
        return this.M4data;
    }

    public String[][] getC2DimData() {
        return this.M4d;
    }

    public Map<String, Object> getC2Values() {
        HashMap<String, Object> map = new HashMap<String, Object>(60);
        String ref = this.getSelectedIntRef();
        Object[] object = Ecad2007.c2_mur.get(ref);
        this.calc.setData(this.M4data);
        this.calc.setDimData(this.M4d);
        double[] rsdim = new double[]{1.0, 0.0};
        double Rmoy = 0.0;
        double[] PontTherm = new double[]{0.0, 0.0};
        float[] raie = new float[]{0.13f, 0.04f};
        int numPT = 0;
        double valPT = 0.0;
        if (object[40] != null && !object[40].equals("")) {
            rsdim[0] = ((Float)object[40]).doubleValue();
        }
        if (object[41] != null && !object[41].equals("")) {
            rsdim[1] = ((Float)object[41]).doubleValue();
        }
        if (object[45] != null && !object[45].equals("")) {
            valPT = ((Float)object[45]).doubleValue();
        }
        if (object[46] != null && !object[46].equals("")) {
            numPT = ((Float)object[46]).intValue();
        }
        PontTherm[0] = numPT;
        PontTherm[1] = valPT;
        if (object[42] != null && !object[42].equals("")) {
            raie[1] = ((Float)object[42]).floatValue();
        }
        if (object[43] != null && !object[43].equals("")) {
            raie[0] = ((Float)object[43]).floatValue();
        }
        this.calc.setRAie(raie);
        Rmoy = this.calc.getRMoy(rsdim, this.ch_c, this.st_c, this.nlay);
        Rmoy = this.calc.getRmoyAvecPontThermique(Rmoy, valPT, numPT);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        for (int ii = 0; ii < 12; ++ii) {
            if (ii < 10) {
                map.put("REF_M4_0" + String.valueOf(ii + 1), object[3 * ii + 4]);
                map.put("REF_M42_0" + String.valueOf(ii + 1), object[3 * ii + 5]);
                map.put("D_C_0" + String.valueOf(ii + 1), object[3 * ii + 6]);
                continue;
            }
            map.put("REF_M4_" + String.valueOf(ii + 1), object[3 * ii + 4]);
            map.put("REF_M42_" + String.valueOf(ii + 1), object[3 * ii + 5]);
            map.put("D_C_" + String.valueOf(ii + 1), object[3 * ii + 6]);
        }
        map.put("N_LAY", new Integer(this.nlay));
        map.put("D1_C", object[40]);
        map.put("D2_C", object[41]);
        map.put("RSDIM", rsdim);
        map.put("RAE", object[42]);
        map.put("RAI", object[43]);
        map.put("RAIE", raie);
        map.put("CH_C", new Integer(this.ch_c));
        map.put("ST_C", this.st_c);
        map.put("U_C", new Double(1.0 / Rmoy));
        map.put("PT_C", object[45]);
        map.put("PT_N", object[46]);
        map.put("PT", PontTherm);
        map.put("REF", object[47]);
        return map;
    }

    public Map<String, Object> getC3Values() {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        String pref = this.getSelectedIntRef();
        Object[] object = Ecad2007.c3_pthl.get(pref);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        map.put("BASE", object[4]);
        map.put("U_C", object[5]);
        map.put("CODE", object[6]);
        map.put("IMG", object[7]);
        map.put("REF", object[8]);
        return map;
    }

    public Map<String, Object> getC4Values() {
        HashMap<String, Object> map = new HashMap<String, Object>(11);
        String pref = this.getSelectedIntRef();
        Object[] object = Ecad2007.c4_pthp.get(pref);
        map.put("NOM_GE", object[0]);
        map.put("NOM_FR", object[1]);
        map.put("NOM_IT", object[2]);
        map.put("NOM_EN", object[3]);
        map.put("BASE", object[4]);
        map.put("U_LIM", object[5]);
        map.put("U_C", object[6]);
        map.put("CODE", object[7]);
        map.put("IMG", object[8]);
        map.put("REF", object[9]);
        return map;
    }

    private int loadDataForGraphElement(String componentCode) {
        int cter;
        Object[] comp;
        Map<String, Object[]> map = null;
        int dim = 12;
        this.nlay = 0;
        String type = "MAT";
        String subtype = "";
        String ref = "";
        String temp = "";
        String[] cc = null;
        int[] icc = new int[5];
        if (componentCode == null) {
            return 0;
        }
        cc = componentCode.trim().split(",");
        for (int ii = 0; ii < cc.length; ++ii) {
            icc[ii] = new Integer(cc[ii]);
        }
        if (componentCode.substring(0, 3).indexOf("000") == 0) {
            type = "USR";
            if (componentCode.substring(0, 4).indexOf("0002") == 0) {
                subtype = "C2";
            }
        } else if (componentCode.substring(0, 2).indexOf("00") == 0) {
            type = "PROJ";
            if (componentCode.substring(0, 2).indexOf("002") == 0) {
                subtype = "C2";
            }
        } else if (componentCode.substring(0, 1).indexOf("0") == 0) {
            type = "FAB";
            if (componentCode.substring(0, 2).indexOf("02") == 0) {
                subtype = "C2";
            }
        } else if ((icc[1] & 1) == 1) {
            subtype = "C2";
        } else if ((icc[1] & 2) == 2) {
            subtype = "C1";
        } else if ((icc[1] & 4) == 4) {
            subtype = "C3";
        } else if ((icc[1] & 8) == 8) {
            subtype = "C4";
        }
        this.M4data = new Object[dim][10];
        this.M4d = new String[dim][2];
        for (int cter2 = 0; cter2 < dim; ++cter2) {
            this.M4d[cter2][1] = "-1";
        }
        if (!type.equals("PROJ")) {
            if (subtype.equals("C1")) {
                return -1;
            }
            if (subtype.equals("C2")) {
                map = Ecad2007.c2_mur;
            } else {
                if (subtype.equals("C3")) {
                    return -3;
                }
                if (subtype.equals("C4")) {
                    return -4;
                }
            }
        }
        if ((comp = (Object[])map.get(componentCode)) != null) {
            String rr;
            int index;
            for (cter = 0; cter < comp.length && (index = (rr = comp[3 * cter + 4].toString()).indexOf(",")) > 0; ++cter) {
                int tmpst_c;
                int tmpch_c;
                ++this.nlay;
                if (this.ch_c == -1 && (tmpch_c = Integer.parseInt(rr.substring(0, index))) == 20 && this.ch_c == -1) {
                    this.ch_c = cter;
                }
                if (this.st_c != -1 || (tmpst_c = Integer.parseInt(rr.substring(0, index))) != 21 || this.st_c != -1) continue;
                this.st_c = cter;
            }
        }
        for (cter = 0; cter < this.nlay; ++cter) {
            Object[] row;
            ref = comp[3 * cter + 4].toString().trim();
            if (this.m4_mat.get(ref) != null) {
                row = this.m4_mat.get(ref);
                this.M4data[cter][4] = ref;
                this.M4data[cter][0] = row[this.ilan].trim();
                this.M4data[cter][1] = row[6];
                this.M4data[cter][2] = row[7];
                this.M4data[cter][3] = row[8];
                temp = String.valueOf(comp[3 * cter + 6]);
                this.M4d[cter][0] = temp.equals("") ? "0" : temp;
                if (row[13] != null && Globals.getDoubleValue(row[13]) != 0.0) {
                    this.M4d[cter][1] = row[13];
                }
            }
            if (this.m4_mat.get(ref = comp[3 * cter + 5].toString().trim()) == null) continue;
            row = this.m4_mat.get(ref);
            this.M4data[cter][9] = ref;
            this.M4data[cter][5] = ((String)row[this.ilan]).trim();
            this.M4data[cter][6] = row[6];
            this.M4data[cter][7] = row[7];
            this.M4data[cter][8] = row[8];
            this.M4d[cter][0] = String.valueOf(comp[3 * cter + 6]);
            if (Globals.getDoubleValue(row[13]) == 0.0 || this.M4d[cter][1].compareTo("-1") == 0) continue;
            this.M4d[cter][0] = (String)row[13];
        }
        return this.nlay;
    }

    private void refreshCompInGen(String compref, int nlay) {
        float d2_c = 0.0f;
        float d1_c = 0.0f;
        this.gelCompR.drawElements(this.M4data, this.M4d, nlay, 1);
        Object[] c2_mur = Ecad2007.c2_mur.get(compref);
        if (c2_mur != null) {
            d1_c = Globals.getFloatValue(c2_mur[40]);
            d2_c = Globals.getFloatValue(c2_mur[41]);
        }
        if (d2_c == 0.0f) {
            this.gelCompR.setBounds(new Rectangle(26, 5, 125, 125));
            this.gelCompR.setBorder(this.border1);
            this.gelCompR.setMargins(2, 2);
            this.gelCompS.setVisible(false);
        } else {
            double dy = 0.0;
            for (int ii = 0; ii < nlay; ++ii) {
                if (this.M4d[ii][1].equals("-1")) {
                    dy += (double)Globals.getIntValue(this.M4d[ii][0], 0);
                    continue;
                }
                dy += (double)Globals.getIntValue(this.M4d[ii][1], 0);
            }
            double div = 1.0;
            div = (double)((d1_c + d2_c) * 50.0f) > dy ? 2.5 / (double)(d1_c + d2_c) : 125.0 / dy;
            int dx1 = (int)(div * (double)d1_c * 100.0 + 0.5);
            int dx2 = (int)(div * (double)d2_c * 100.0 + 0.5);
            int idy = (int)(div * dy + 0.5);
            int dpy = 0;
            if (idy < 125) {
                dpy = (int)((125.0 - (double)idy) / 2.0);
            }
            this.gelCompR.setBounds(new Rectangle(26, 5 + dpy, dx1, idy));
            this.gelCompR.setMargins(0, 0);
            this.gelCompR.setBorder(BorderFactory.createLineBorder(Color.black));
            this.gelCompR.drawElements(this.M4data, this.M4d, nlay, 1);
            this.gelCompS.setBounds(new Rectangle(25 + dx1, 5 + dpy, dx2, idy));
            this.gelCompS.setVisible(true);
            this.gelCompS.setMargins(0, 0);
            this.gelCompS.drawElements(this.M4data, this.M4d, nlay, 2);
            this.gelCompR.repaint();
            this.gelCompS.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jB_esc) {
            this.dispose();
        } else if (e.getSource() == this.jB_ok) {
            this.selectedIntRefs = this.jtrBint.getArraySel();
            if (this.selectedIntRefs != null) {
                this.exitstate = 2;
                this.dispose();
            }
        }
    }

    public void mouseClicked(MouseEvent me) {
        int ivref = 0;
        int nlay = 0;
        boolean b_ie = false;
        boolean b_mm = false;
        String node = "";
        String compref = "";
        String type = "";
        if (me.getButton() == 1 && me.getSource() == this.jtrBint) {
            String[] temp;
            node = this.jtrBint.getRefSel();
            this.ref = this.jtrBint.getRefSel().trim();
            ivref = this.ref.indexOf(",");
            if (ivref > 0 && (temp = this.jtrBint.getParentRefs(this.ref)).length > 2) {
                type = temp[temp.length - 3].trim();
            }
            if (node != null) {
                compref = ((String[])this.jtrBint.getDatamapObject(node))[3].trim();
                nlay = this.loadDataForGraphElement(compref);
                if (nlay >= 0) {
                    this.refreshCompInGen(compref, nlay);
                } else if (nlay == -1) {
                    this.gelCompS.setVisible(false);
                    Object[] values = Ecad2007.c1_fen.get(compref);
                    double fc = 0.0;
                    values = Ecad2007.getWinLibrary().getDataMapM16()[1].get(values[4]);
                    double ff = Globals.getDoubleValue(values[5].toString());
                    this.gelCompR.drawWindow(ff, fc);
                } else if (nlay == -3) {
                    this.gelCompS.setVisible(false);
                    Object[] object = Ecad2007.c3_pthl.get(compref);
                    this.gelCompR.drawImageIcon((ImageIcon)object[7]);
                } else if (nlay == -4) {
                    this.gelCompS.setVisible(false);
                    this.gelCompR.drawImageIcon((ImageIcon)Ecad2007.c4_pthp.get(compref)[8]);
                }
            }
            if (ivref == -1) {
                this.gelCompS.setVisible(false);
                this.gelCompR.drawEmptyImageIcon(null);
            }
            if (ivref != -1) {
                if (this.ref.substring(0, ivref).equals("1")) {
                    b_mm = true;
                }
                if (this.ref.substring(ivref + 1).indexOf("0") == 0) {
                    b_ie = true;
                }
            } else {
                b_ie = true;
            }
            if (!b_ie) {
                this.row = this.datamapInt.get(this.ref);
            }
            if (me.getClickCount() == 2) {
                Globals.println("J'ai cliqu\u00e9 deux fois.");
            }
            this.drawGSIA(compref);
        }
    }

    void windowClosed(WindowEvent we) {
        this.dcompevq.pop();
    }

    void jCb_itemStateChanged(ItemEvent ie) {
        System.out.println(ie);
    }

    class DlgComp_EventQueue
    extends EventQueue {
        DlgComp adaptee;

        public DlgComp_EventQueue(DlgComp adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void dispatchEvent(AWTEvent event) {
            super.dispatchEvent(event);
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                int sel = DlgComp.this.jtrBint.getSelectedRow();
                int max = DlgComp.this.jtrBint.getDataMap().size();
                if (ke.paramString().contains("KEY_RELEASED")) {
                    if (ke.getKeyCode() == 40) {
                        if (sel < max - 1) {
                            DlgComp.this.jtrBint.setRowSelection(sel + 1);
                            this.prepareCompInGen();
                        }
                    } else if (ke.getKeyCode() == 38 && sel > 0) {
                        DlgComp.this.jtrBint.setRowSelection(sel - 1);
                        this.prepareCompInGen();
                    }
                }
            }
        }

        private void prepareCompInGen() {
            String[] data = DlgComp.this.jtrBint.getArraySel();
            if (data != null) {
                int nlay = DlgComp.this.loadDataForGraphElement(data[3]);
                DlgComp.this.refreshCompInGen(data[3], nlay);
            }
        }

        @Override
        public void pop() {
            try {
                super.pop();
            }
            catch (EmptyStackException esex) {
                Globals.println("DlgComp_EventQueue: " + esex.getMessage());
            }
        }
    }

    class DlgComp_jCb_itemAdapter
    implements ItemListener {
        DlgComp adaptee;

        DlgComp_jCb_itemAdapter(DlgComp adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.adaptee.jCb_itemStateChanged(e);
        }
    }

    class DlgComp_windowAdapter
    extends WindowAdapter {
        DlgComp adaptee;

        DlgComp_windowAdapter(DlgComp adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.adaptee.windowClosed(e);
        }
    }

    class DlgComp_mouseAdapter
    extends MouseAdapter {
        DlgComp adaptee;

        DlgComp_mouseAdapter(DlgComp adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.mouseClicked(e);
        }
    }

    class DlgComp_actionAdapter
    implements ActionListener {
        DlgComp adaptee;

        DlgComp_actionAdapter(DlgComp adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.actionPerformed(e);
        }
    }

    public class OrderFocusTraversalPolicy
    extends SortingFocusTraversalPolicy {
        OrderFocusTraversalPolicy() {
            super(new ComponentComparator());
        }

        @Override
        protected boolean accept(Component aComp) {
            if (aComp instanceof JTextField) {
                return super.accept(aComp);
            }
            return false;
        }
    }
}

