/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs;

import core.Calc_Ceb;
import core.Config;
import enercad2007.DM_Trad;
import enercad2007.DM_Zone;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DlgDistribLossCalculator
extends JDialog {
    Globals globals = new Globals();
    Config config = new Config(System.getProperty("conf.file.name"));
    int lan = 0;
    String nomc = "NOM_FR";
    Map<String, Object> values = new HashMap<String, Object>(5);
    Map<String, Object> prevValues;
    int units = 0;
    String unit = "GJ";
    public static final int ESCAPE = 0;
    public static final int CALCULATE = 1;
    public static final int OK = 2;
    int flag = -1;
    DM_Trad gen_trad;
    DM_Trad symbol_trad;
    DM_Trad ceb_trad;
    DM_Zone dm_zone;
    Calc_Ceb calc_Ceb = new Calc_Ceb();
    HashMap ic_gen = this.globals.getResources("gen");
    double qtot;
    double qhw;
    Color color_01 = new Color(230, 255, 230);
    Color color_02 = new Color(255, 230, 230);
    JPanel jPa_0 = new JPanel();
    JPanel jPa_QW = new JPanel();
    JLabel jLa_titre = new JLabel();
    JLabel jLa_diam = new JLabel();
    JComboBox jCb_diam;
    JLabel jLa_L = new JLabel();
    JFormattedTextField jFTF_L;
    JLabel jLa_L_unit = new JLabel();
    JLabel jLa_dT = new JLabel();
    JFormattedTextField jFTF_dT;
    JLabel jLa_dT_unit = new JLabel();
    JLabel jLa_isol = new JLabel();
    JLabel jLa_ep = new JLabel();
    JFormattedTextField jFTF_ep;
    JLabel jLa_ep_unit = new JLabel();
    JLabel jLa_lambda = new JLabel();
    JFormattedTextField jFTF_lambda;
    JLabel jLa_lambda_unit = new JLabel();
    JLabel jLa_Q_unit = new JLabel();
    JLabel jLa_Q = new JLabel();
    JButton jB_esc = new JButton();
    JButton jB_apply = new JButton();
    JButton jB_ok = new JButton();
    DecimalFormat df0;
    DecimalFormat df1;
    DecimalFormat df2;
    DecimalFormat df3;
    private final Font FT_STAND1 = Globals.FT_STAND1;
    private final Font FT_BOLD1 = Globals.FT_BOLD1;
    String txt_distrib = "Distribution";
    String txt_apply = "Calculer";
    String txt_cancel = "Annuler";
    String txt_diam = "Diam\u00e8tre";
    String txt_diam_system = "Diam\u00e8tre conduites";
    String txt_length = "Longueur";
    String txt_length_system = "Longueur conduite";
    String txt_delta_th_tww = "Diff\u00e9rence de temp\u00e9rature air ambiante - eau chaude";
    String txt_isol = "Isolation";
    String txt_epaisseur = "\u00c9paisseur";
    String txt_epaisseur_isol = "\u00c9paisseur de l'isolation";
    String txt_c = "Conductivit\u00e9 thermique de l'isolation";
    String txt_loss_system_y = "D\u00e9perdition de chaleur dans les conduites par ann\u00e9e";
    String txt_loss_unit = "[GJ/ann\u00e9e]";
    String txt_loss = "D\u00e9perdition thermique";
    String className;

    public DlgDistribLossCalculator() {
        this((JDialog)null, "", false);
    }

    public DlgDistribLossCalculator(JDialog parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public DlgDistribLossCalculator(JDialog parent, String title, Map<String, Object> values, boolean modal) {
        super(parent, title, modal);
        this.values = values;
        if (values != null) {
            this.prevValues = new HashMap<String, Object>(values.size());
            this.prevValues.putAll(values);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        if (this.globals != null) {
            if (Ecad2007.ic_gen == null) {
                Ecad2007.ic_gen = this.globals.getResources("gen");
            }
            this.dm_zone = Ecad2007.getDM_Zone(0);
            this.ic_gen = Ecad2007.ic_gen;
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.symbol_trad = Ecad2007.getTraduction("symbol");
            this.ceb_trad = Ecad2007.getTraduction("ceb");
            this.df0 = Ecad2007.getDecimalFormat("0");
            this.df1 = Ecad2007.getDecimalFormat("0.0");
            this.df2 = Ecad2007.getDecimalFormat("0.00");
            this.df3 = Ecad2007.getDecimalFormat("0.000");
            this.lan = this.config.getPropertyInt("properties", "lan");
            Config config = new Config(System.getProperty("conf.file.name"));
            this.units = config.getPropertyInt("properties", "units");
            this.unit = this.units == 0 ? "GJ" : "MWh";
            this.txt_apply = this.ceb_trad.getCodeLan("calculator");
            this.txt_cancel = this.gen_trad.getCodeLan("cancel");
            this.txt_distrib = this.gen_trad.getCodeLan("distrib");
            this.txt_diam = this.ceb_trad.getCodeLan("diam");
            this.txt_diam_system = this.ceb_trad.getCodeLan("diam_system");
            this.txt_length = this.gen_trad.getCodeLan("long");
            this.txt_length_system = this.ceb_trad.getCodeLan("length_system");
            this.txt_delta_th_tww = this.ceb_trad.getCodeLan("delta_th_tww");
            this.txt_isol = this.ceb_trad.getCodeLan("isol");
            this.txt_epaisseur = this.symbol_trad.getCodeLan("d");
            this.txt_epaisseur_isol = this.ceb_trad.getCodeLan("epaisseur_isol");
            this.txt_c = this.ceb_trad.getCodeLan("c");
            this.txt_loss_system_y = this.ceb_trad.getCodeLan("loss_system_y");
            this.txt_loss_unit = this.ceb_trad.getCodeLan("loss_unit", "GJ");
            this.txt_loss = this.ceb_trad.getCodeLan("loss");
            this.className = this.getClass().getName();
            this.className = this.className.substring(this.className.lastIndexOf(".") + 1);
            this.globals.setLocation(this, config.getPropertyString("properties", "pos", new String[]{this.className}));
            this.setDefaultCloseOperation(2);
        }
        this.setSize(new Dimension(355, 230));
        this.setResizable(false);
        this.addWindowListener(new DlgDistribLossCalculator_WindowAdapter(this));
        this.jPa_0.setLayout(null);
        this.jPa_0.setBounds(new Rectangle(0, 0, 360, 210));
        Container container = this.getContentPane();
        container.setLayout(null);
        container.setSize(this.jPa_0.getSize());
        container.setBounds(new Rectangle(10, 10, 350, 200));
        this.jLa_titre.setText(this.txt_loss_system_y);
        this.jLa_titre.setFont(this.FT_BOLD1);
        this.jLa_titre.setBounds(new Rectangle(10, 5, 305, 20));
        this.jPa_QW.setLayout(null);
        this.jPa_QW.setBorder(BorderFactory.createEtchedBorder());
        this.jPa_QW.setBounds(new Rectangle(10, 30, 330, 125));
        this.jLa_diam.setText(this.txt_diam + ":");
        this.jLa_diam.setToolTipText(this.txt_diam_system);
        this.jLa_diam.setBounds(new Rectangle(5, 33, 75, 20));
        this.jCb_diam = new JComboBox<String>(this.calc_Ceb.getDiams());
        this.jCb_diam.setBounds(new Rectangle(80, 33, 45, 21));
        this.jCb_diam.setFont(this.FT_STAND1);
        this.jCb_diam.setMaximumRowCount(6);
        this.jCb_diam.setSelectedIndex(0);
        this.jLa_L.setText(this.txt_length + ":");
        this.jLa_L.setToolTipText(this.txt_length_system);
        this.jLa_L.setBounds(new Rectangle(5, 55, 75, 20));
        this.jFTF_L = new JFormattedTextField(this.df0);
        this.jFTF_L.setBounds(new Rectangle(80, 55, 45, 20));
        this.jFTF_L.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jFTF_L.setHorizontalAlignment(4);
        this.jFTF_L.addFocusListener(new DlgDistribLoss_FocusAdapter(this));
        this.jLa_L_unit.setText("[m]");
        this.jLa_L_unit.setToolTipText(this.txt_length_system);
        this.jLa_L_unit.setBounds(new Rectangle(128, 55, 25, 20));
        this.jLa_dT.setText("\u0394 T (\u03b8):");
        this.jLa_dT.setToolTipText(this.txt_delta_th_tww + " \u03b8 (theta)");
        this.jLa_dT.setBounds(new Rectangle(5, 76, 75, 20));
        this.jLa_dT_unit.setText("[K]");
        this.jLa_dT_unit.setToolTipText(this.txt_delta_th_tww + " \u03b8 (theta)");
        this.jLa_dT_unit.setBounds(new Rectangle(128, 76, 25, 20));
        this.jFTF_dT = new JFormattedTextField(this.df0);
        this.jFTF_dT.setBounds(new Rectangle(80, 76, 45, 20));
        this.jFTF_dT.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jFTF_dT.setHorizontalAlignment(4);
        this.jFTF_dT.addFocusListener(new DlgDistribLoss_FocusAdapter(this));
        this.jLa_isol.setText(this.txt_isol + ":");
        this.jLa_isol.setFont(this.FT_BOLD1);
        this.jLa_isol.setBounds(new Rectangle(160, 5, 75, 20));
        this.jLa_ep.setText(this.txt_epaisseur + ":");
        this.jLa_ep.setToolTipText(this.txt_epaisseur_isol);
        this.jLa_ep.setBounds(new Rectangle(160, 33, 75, 20));
        this.jFTF_ep = new JFormattedTextField(this.df0);
        this.jFTF_ep.setBounds(new Rectangle(235, 33, 45, 20));
        this.jFTF_ep.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jFTF_ep.setHorizontalAlignment(4);
        this.jFTF_ep.addFocusListener(new DlgDistribLoss_FocusAdapter(this));
        this.jLa_ep_unit.setText("[mm]");
        this.jLa_ep_unit.setToolTipText(this.txt_epaisseur_isol);
        this.jLa_ep_unit.setBounds(new Rectangle(284, 33, 35, 20));
        this.jLa_lambda.setText("Lambda (\u03bb):");
        this.jLa_lambda.setToolTipText(this.txt_c);
        this.jLa_lambda.setBounds(new Rectangle(160, 55, 75, 20));
        this.jFTF_lambda = new JFormattedTextField(this.df3);
        this.jFTF_lambda.setBounds(new Rectangle(235, 55, 45, 20));
        this.jFTF_lambda.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jFTF_lambda.setHorizontalAlignment(4);
        this.jFTF_lambda.addFocusListener(new DlgDistribLoss_FocusAdapter(this));
        this.jLa_lambda_unit.setText("[W/mK]");
        this.jLa_lambda_unit.setToolTipText(this.txt_c);
        this.jLa_lambda_unit.setBounds(new Rectangle(284, 55, 45, 20));
        this.jLa_Q.setHorizontalAlignment(4);
        this.jLa_Q.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jLa_Q.setToolTipText(this.txt_loss + " [" + this.txt_loss_unit + "]");
        this.jLa_Q.setBackground(this.color_01);
        this.jLa_Q.setOpaque(true);
        this.jLa_Q.setBounds(new Rectangle(235, 100, 45, 20));
        this.jLa_Q_unit.setText("[GJ]");
        this.jLa_Q_unit.setToolTipText(this.txt_loss + " [" + this.txt_loss_unit + "]");
        this.jLa_Q_unit.setHorizontalAlignment(2);
        this.jLa_Q_unit.setBounds(new Rectangle(284, 100, 40, 20));
        this.jB_esc.setFont(this.FT_STAND1);
        this.jB_esc.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_esc.setText(this.txt_cancel);
        this.jB_esc.setVerticalAlignment(0);
        this.jB_esc.setVerticalTextPosition(0);
        this.jB_esc.setBounds(new Rectangle(20, 165, 100, 22));
        this.jB_esc.addActionListener(new DlgCecb_actionAdapter(this));
        this.jB_apply.setFont(this.FT_STAND1);
        this.jB_apply.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_apply.setText(this.txt_apply);
        this.jB_apply.setVerticalAlignment(0);
        this.jB_apply.setVerticalTextPosition(0);
        this.jB_apply.setBounds(new Rectangle(130, 165, 100, 22));
        this.jB_apply.addActionListener(new DlgCecb_actionAdapter(this));
        this.jB_ok.setFont(this.FT_STAND1);
        this.jB_ok.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_ok.setText("Ok");
        this.jB_ok.setVerticalAlignment(0);
        this.jB_ok.setVerticalTextPosition(0);
        this.jB_ok.setBounds(new Rectangle(240, 165, 100, 22));
        this.jB_ok.addActionListener(new DlgCecb_actionAdapter(this));
        this.jPa_QW.add((Component)this.jLa_isol, null);
        this.jPa_QW.add((Component)this.jLa_diam, null);
        this.jPa_QW.add((Component)this.jCb_diam, null);
        this.jPa_QW.add((Component)this.jLa_L, null);
        this.jPa_QW.add((Component)this.jFTF_L, null);
        this.jPa_QW.add((Component)this.jLa_L_unit, null);
        this.jPa_QW.add((Component)this.jLa_dT, null);
        this.jPa_QW.add((Component)this.jFTF_dT, null);
        this.jPa_QW.add((Component)this.jLa_dT_unit, null);
        this.jPa_QW.add((Component)this.jLa_ep, null);
        this.jPa_QW.add((Component)this.jFTF_ep, null);
        this.jPa_QW.add((Component)this.jLa_ep_unit, null);
        this.jPa_QW.add((Component)this.jLa_lambda, null);
        this.jPa_QW.add((Component)this.jFTF_lambda, null);
        this.jPa_QW.add((Component)this.jLa_isol, null);
        this.jPa_QW.add((Component)this.jLa_lambda_unit, null);
        this.jPa_QW.add((Component)this.jLa_Q_unit, null);
        this.jPa_QW.add((Component)this.jLa_Q, null);
        this.jPa_0.add((Component)this.jLa_titre, null);
        this.jPa_0.add((Component)this.jPa_QW, null);
        this.jPa_0.add((Component)this.jB_esc, null);
        this.jPa_0.add((Component)this.jB_apply, null);
        this.jPa_0.add((Component)this.jB_ok, null);
        container.add((Component)this.jPa_0, null);
        this.resetSavedFieldValues();
        this.jCb_diam.addItemListener(new DlgCecb_itemStateAdapter(this));
    }

    private void calcQ() {
        double qh = this.dm_zone.getQh();
        double qw = this.dm_zone.getQwwStd();
        double ae = this.dm_zone.getSRE();
        double qtot = (qh + qw) * ae / 1000.0;
        try {
            this.jFTF_dT.commitEdit();
            this.jFTF_L.commitEdit();
            this.jFTF_ep.commitEdit();
            this.jFTF_lambda.commitEdit();
            int i_dn = this.jCb_diam.getSelectedIndex();
            String dn = this.calc_Ceb.getDiams()[i_dn];
            Object dT = this.jFTF_dT.getValue();
            Object length = this.jFTF_L.getValue();
            Object ep = this.jFTF_ep.getValue();
            Object lambda = this.jFTF_lambda.getValue();
            if (dn != null) {
                double res = 0.0;
                double dd = Globals.getDoubleValue(ep);
                res = dd == 0.0 ? this.calc_Ceb.getQls(Globals.getDoubleValue(lambda), dn, dd, 13.0, Globals.getDoubleValue(length), Globals.getDoubleValue(dT)) : this.calc_Ceb.getQls(Globals.getDoubleValue(lambda), dn, dd, 7.5, Globals.getDoubleValue(length), Globals.getDoubleValue(dT));
                this.jLa_Q.setText(this.df0.format(res));
                if (this.units == 1 && res > 0.0 && Ecad2007.getIntCalcmod() < 7) {
                    this.jLa_Q.setToolTipText("<html><body>" + this.txt_loss + " " + this.txt_loss_unit + "<br>(" + this.df1.format(res * 0.2777777777777778) + " " + this.ceb_trad.getCodeLan("loss_unit", this.unit) + ")</body></html>");
                }
                if (res > qtot * 0.1) {
                    this.jLa_Q.setBackground(this.color_02);
                } else {
                    this.jLa_Q.setBackground(this.color_01);
                }
                this.values.put("dn", dn);
                this.values.put("Q", res);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setDlgValues(Map<String, Object> values) {
        this.values = values;
    }

    public Map<String, Object> getDlgValues() {
        return this.values;
    }

    private Map<String, Object> getPreviousValues() {
        if (this.prevValues == null) {
            return this.prevValues;
        }
        this.jFTF_L.setValue(Globals.getIntValue(this.prevValues.get("L")));
        this.jFTF_dT.setValue(Globals.getIntValue(this.prevValues.get("dT")));
        this.jFTF_ep.setValue(Globals.getIntValue(this.prevValues.get("dd")));
        this.jFTF_lambda.setValue(Globals.getDoubleValue(this.prevValues.get("lambda")));
        this.jCb_diam.setSelectedIndex(Globals.getIntValue(this.prevValues.get("dn")));
        return this.prevValues;
    }

    public int getStatus() {
        return this.flag;
    }

    private void resetSavedFieldValues() {
        double Q = 0.0;
        Object object = this.values.get("dn");
        this.jCb_diam.setSelectedIndex(Globals.getIntValue(object));
        object = this.values.get("dd");
        this.jFTF_ep.setValue(Globals.getIntValue(object));
        object = this.values.get("dT");
        this.jFTF_dT.setValue(Globals.getIntValue(object));
        object = this.values.get("L");
        this.jFTF_L.setValue(Globals.getIntValue(object));
        object = this.values.get("lambda");
        this.jFTF_lambda.setValue(Globals.getDoubleValue(object));
        object = this.values.get("Q");
        if (object != null) {
            double qh = this.dm_zone.getQh();
            double qw = this.dm_zone.getQwwStd();
            double ae = this.dm_zone.getSRE();
            double qtot = (qh + qw) * ae / 1000.0;
            Q = Globals.getDoubleValue(object);
            if (Q > qtot * 0.1) {
                this.jLa_Q.setBackground(this.color_02);
            } else {
                this.jLa_Q.setBackground(this.color_01);
            }
            this.jLa_Q.setText(this.df0.format(Q));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Ecad2007.getMainFrame().setCursor(new Cursor(0));
        }
        super.setVisible(true);
    }

    private void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.jB_ok) {
            this.flag = 2;
            String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
            this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
            this.dispose();
        } else if (ae.getSource() == this.jB_apply) {
            this.flag = 1;
        } else if (ae.getSource() == this.jB_esc) {
            this.flag = 0;
            String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
            this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
            this.values = this.getPreviousValues();
            this.dispose();
        }
    }

    private void focusGained(FocusEvent fe) {
    }

    private void focusLost(FocusEvent fe) {
        if (fe.getSource() == this.jFTF_L) {
            try {
                this.jFTF_L.commitEdit();
                Object object = this.jFTF_L.getValue();
                this.values.put("L", object);
            }
            catch (ParseException object) {
                // empty catch block
            }
            this.calcQ();
        } else if (fe.getSource() == this.jFTF_dT) {
            try {
                this.jFTF_dT.commitEdit();
                Object object = this.jFTF_dT.getValue();
                this.values.put("dT", object);
            }
            catch (ParseException object) {
                // empty catch block
            }
            this.calcQ();
        } else if (fe.getSource() == this.jFTF_ep) {
            try {
                this.jFTF_ep.commitEdit();
                Object object = this.jFTF_ep.getValue();
                this.values.put("dd", object);
            }
            catch (ParseException object) {
                // empty catch block
            }
            this.calcQ();
        } else if (fe.getSource() == this.jFTF_lambda) {
            try {
                this.jFTF_lambda.commitEdit();
                Object object = this.jFTF_lambda.getValue();
                this.values.put("lambda", object);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.calcQ();
        }
    }

    private void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.jCb_diam) {
            Integer object = this.jCb_diam.getSelectedIndex();
            this.values.put("dn", object);
            this.calcQ();
        }
    }

    private void windowClosing(WindowEvent we) {
        String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
        this.config = new Config(System.getProperty("conf.file.name"));
        this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
        this.values = this.getPreviousValues();
        this.flag = 0;
    }

    class DlgDistribLossCalculator_WindowAdapter
    extends WindowAdapter {
        DlgDistribLossCalculator adaptee;

        DlgDistribLossCalculator_WindowAdapter(DlgDistribLossCalculator adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.adaptee.windowClosing(we);
        }
    }

    class DlgDistribLoss_FocusAdapter
    extends FocusAdapter {
        DlgDistribLossCalculator adaptee;

        DlgDistribLoss_FocusAdapter(DlgDistribLossCalculator adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            this.adaptee.focusGained(fe);
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.adaptee.focusLost(fe);
        }
    }

    class DlgCecb_itemStateAdapter
    implements ItemListener {
        DlgDistribLossCalculator adaptee;

        DlgCecb_itemStateAdapter(DlgDistribLossCalculator adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            this.adaptee.itemStateChanged(ie);
        }
    }

    class DlgCecb_actionAdapter
    implements ActionListener {
        DlgDistribLossCalculator adaptee;

        DlgCecb_actionAdapter(DlgDistribLossCalculator adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

