/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs;

import core.Config;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jecadcomp.Ceb;

public class DlgOutCeb
extends JDialog {
    Globals globals = new Globals();
    Config config = new Config(System.getProperty("conf.file.name"));
    JPanel jPa_0 = new JPanel();
    Ceb ceb;
    Rectangle rect = new Rectangle(3, 40, 320, 180);
    DM_Trad ceb_trad;
    DM_Trad gen_trad;
    Font FT_STAND = new Font("Dialog", 0, 11);
    Font FT_BOLD = new Font("Dialog", 1, 11);
    Font FT_BOLD14 = new Font("Dialog", 1, 14);
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    Font FT_STAND12 = new Font("Dialog", 0, 12);
    Font font = new Font("Dialog", 0, 11);
    String className;
    double[] values;
    JLabel jLa_ep = new JLabel();
    JLabel jLa_qh = new JLabel();
    JLabel jLa_ind_r = new JLabel();
    JLabel jLa_co2_txt = new JLabel();
    JLabel jLa_co2 = new JLabel();
    JLabel jLa_fep_txt = new JLabel();
    JLabel jLa_fep = new JLabel();
    String txt_consum_prim = "Consommation<br>d'&eacute;nergie primaire";
    String txt_qh = "Besoin de chaleur<br>pour chauffage";
    String txt_ind_r = "Indice normalis\u00e9 de besoin de chauffage ou<br>indice de consommation d'\u00e9nergie primaire normalis\u00e9";
    String txt_class_co2 = "Classe pour l'\u00e9mission de gaz \u00e0 effet de serre";
    String txt_fren = "Fraction d'\u00e9nergie primaire renouvelable";
    int units = 0;
    String unit = "MJ/m\u00b2";

    public DlgOutCeb() {
        this((Frame)null, "", false);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgOutCeb(double[] values) {
        this((Frame)null, "", false);
        this.values = values;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgOutCeb(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgOutCeb(Frame parent, String title, boolean modal, double[] values) {
        super(parent, title, modal);
        this.values = values;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.jPa_0.setLayout(null);
        this.jPa_0.setSize(this.rect.width + 13, this.rect.height + 115);
        this.setSize(new Dimension(this.rect.width + 13, this.rect.height + 115));
        this.setResizable(false);
        this.addWindowListener(new DlgOutQh_windowAdapter(this));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        if (this.globals != null) {
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.ceb_trad = Ecad2007.getTraduction("ceb");
            this.FT_STAND = Globals.FT_STAND1;
            this.FT_BOLD = Globals.FT_BOLD1;
            this.className = this.getClass().getName();
            this.className = this.className.substring(this.className.lastIndexOf(".") + 1);
            this.txt_consum_prim = this.ceb_trad.getCodeLan("consum_prim");
            this.txt_qh = this.ceb_trad.getCodeLan("qh");
            this.txt_ind_r = this.ceb_trad.getCodeLan("ind_r");
            this.txt_class_co2 = this.ceb_trad.getCodeLan("class_co2");
            this.txt_fren = this.ceb_trad.getCodeLan("fren");
        }
        this.jLa_ep.setText("<html><body align='center'>E<sub>P</sub><br>[" + this.unit + "]</body></html>");
        this.jLa_ep.setVerticalAlignment(1);
        this.jLa_ep.setToolTipText(this.txt_consum_prim + " [" + this.unit + "]");
        this.jLa_ep.setBounds(new Rectangle(152, 1, 50, 37));
        this.jLa_qh.setText("<html><body align='center'>Q<sub>H</sub><br>[" + this.unit + "]</body></html>");
        this.jLa_qh.setVerticalAlignment(1);
        this.jLa_qh.setToolTipText(this.txt_qh + " [" + this.unit + "]");
        this.jLa_qh.setBounds(new Rectangle(222, 1, 50, 37));
        this.jLa_ind_r.setText("<html><body>R<sub>P,2009</sub><br>R<sub>QH,2009</sub></body></html>");
        this.jLa_ind_r.setVerticalAlignment(3);
        this.jLa_ind_r.setToolTipText("<html><body>" + this.txt_ind_r + "</body></html>");
        this.jLa_ind_r.setBounds(new Rectangle(275, 0, 60, 37));
        this.jLa_co2_txt.setText(this.txt_class_co2 + ":");
        this.jLa_co2_txt.setFont(this.FT_STAND1);
        this.jLa_co2_txt.setBounds(new Rectangle(3, 220, 275, 20));
        this.jLa_co2.setFont(this.FT_BOLD14);
        this.jLa_co2.setBounds(new Rectangle(283, 220, 40, 20));
        this.jLa_co2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.jLa_co2.setOpaque(true);
        this.jLa_fep_txt.setText(this.txt_fren + ":");
        this.jLa_fep_txt.setFont(this.FT_STAND1);
        this.jLa_fep_txt.setBounds(new Rectangle(3, 240, 280, 20));
        this.jLa_fep.setFont(this.FT_BOLD14);
        this.jLa_fep.setBounds(new Rectangle(283, 240, 40, 20));
        this.jLa_fep.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.ceb = new Ceb(this.values);
        this.ceb.setBounds(this.rect);
        this.setCO2Class();
        this.setFepr();
        this.jPa_0.add((Component)this.jLa_ep, null);
        this.jPa_0.add((Component)this.jLa_qh, null);
        this.jPa_0.add((Component)this.jLa_ind_r, null);
        this.jPa_0.add((Component)this.jLa_co2_txt, null);
        this.jPa_0.add((Component)this.jLa_co2, null);
        this.jPa_0.add((Component)this.jLa_fep_txt, null);
        this.jPa_0.add((Component)this.jLa_fep, null);
        this.jPa_0.add((Component)this.ceb, null);
        contentPane.add((Component)this.jPa_0, null);
        if (this.globals != null) {
            this.globals.setLocation(this, this.config.getPropertyString("properties", "pos", new String[]{this.className}));
            this.repaint();
        }
    }

    private void setCO2Class() {
        Color[] clr_ceb = this.ceb.getCebColors();
        if (this.values != null && this.values.length > 5) {
            int cco2 = this.ceb.getClassRCO2(this.values[5]);
            char ch = (char)(65 + cco2);
            if (this.values[5] > 0.0) {
                this.jLa_co2.setText(String.valueOf(ch));
                if (clr_ceb != null && clr_ceb.length > cco2) {
                    this.jLa_co2.setBackground(clr_ceb[cco2]);
                }
            } else {
                this.jLa_co2.setText("-");
            }
        }
    }

    private void setFepr() {
        if (this.values != null && this.values.length > 7) {
            double fep = this.values[7] * 100.0 + 0.5;
            String fep_txt = Ecad2007.getDecimalFormat("0").format(fep) + " %";
            if (Double.isNaN(fep)) {
                fep_txt = "  0 %";
            }
            if (fep_txt == null) {
                return;
            }
            if (fep_txt.length() < 1) {
                return;
            }
            Font font = this.jLa_fep.getFont();
            FontMetrics fm = this.jLa_fep.getFontMetrics(font);
            String tmp = fep_txt.substring(fep_txt.length() - 1);
            int width = fm.stringWidth(tmp);
            this.jLa_fep.setBounds(283 - width, 240, 40 + width, 20);
            this.jLa_fep.setText(fep_txt);
        }
    }

    public double[] getValues() {
        return this.ceb.getValues();
    }

    @Override
    public void repaint() {
        Config config = new Config(System.getProperty("conf.file.name"));
        this.units = config.getPropertyInt("properties", "units");
        this.unit = this.units == 0 ? "MJ/m\u00b2" : "kWh/m\u00b2";
        this.ceb.setUnits(this.units);
        this.jLa_ep.setToolTipText(this.txt_consum_prim + " [" + this.unit + "]");
        this.jLa_qh.setToolTipText(this.txt_qh + " [" + this.unit + "]");
    }

    public void setValues(double[] values) {
        this.values = values;
        this.ceb.setValues(values);
        this.setCO2Class();
        this.setFepr();
    }

    private void windowClosing(WindowEvent we) {
        String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
        this.config = new Config(System.getProperty("conf.file.name"));
        this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
    }

    class DlgOutQh_windowAdapter
    extends WindowAdapter {
        DlgOutCeb adaptee;

        DlgOutQh_windowAdapter(DlgOutCeb adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.adaptee.windowClosing(we);
        }
    }
}

