/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs;

import core.Config;
import enercad2007.DM_Trad;
import enercad2007.DM_Zone;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jecadcomp.Out_Flux;

public class DlgOutFlux
extends JDialog {
    Globals globals = new Globals();
    transient Config config = new Config(System.getProperty("conf.file.name"));
    Font FT_STAND = new Font("Dialog", 0, 11);
    Font FT_BOLD = new Font("Dialog", 1, 11);
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    Font font = new Font("Dialog", 0, 11);
    String className;
    int percents = 0;
    private ButtonGroup bGr_units = new ButtonGroup();
    private JCheckBox jChB_units = new JCheckBox();
    private JCheckBox jChB_percent = new JCheckBox();
    private JLabel jLa_Q = new JLabel();
    private JLabel jLa_QUnit = new JLabel();
    Out_Flux out_flux = new Out_Flux();
    String txt_flux_La_Q = "Diagramme des flux";
    String txt_units = "Unit\u00e9s";
    String txt_norm_380 = "Norme SIA 380/1";
    DM_Trad out_trad;
    DM_Trad gen_trad;

    public DlgOutFlux() {
        this((Frame)null, "", false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public DlgOutFlux(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        if (this.globals != null) {
            this.out_trad = Ecad2007.getTraduction("out");
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.FT_STAND = Globals.FT_STAND1;
            this.FT_BOLD = Globals.FT_BOLD1;
            this.className = this.getClass().getName();
            this.className = this.className.substring(this.className.lastIndexOf(".") + 1);
            this.txt_flux_La_Q = this.out_trad.getCodeLan("flux_La_Q");
            this.txt_units = this.gen_trad.getCodeLan("units") + ":";
            this.txt_norm_380 = this.gen_trad.getCodeLan("norm_380");
        }
        this.jChB_units.setBounds(new Rectangle(180, 5, 80, 20));
        this.jChB_units.setText("MJ/m\u00b2");
        this.jChB_units.setToolTipText(this.txt_norm_380);
        this.jChB_units.setHorizontalAlignment(2);
        this.jChB_units.setFont(this.FT_STAND);
        this.jChB_units.addActionListener(new DlgOutFlux_ActionAdapter(this));
        this.jChB_percent.setBounds(new Rectangle(260, 5, 40, 20));
        this.jChB_percent.setText("%");
        this.jChB_percent.setHorizontalAlignment(4);
        this.jChB_percent.setFont(this.FT_STAND);
        this.jChB_percent.addActionListener(new DlgOutFlux_ActionAdapter(this));
        this.percents = this.config.getPropertyInt("properties", "percents");
        if (Ecad2007.getCalcmod() < 7) {
            this.jChB_units.setText("MJ/m\u00b2");
        } else {
            this.jChB_units.setText("kWh/m\u00b2");
        }
        if (this.percents == 0) {
            this.jChB_percent.setSelected(true);
        } else {
            this.jChB_units.setSelected(true);
        }
        this.bGr_units.add(this.jChB_units);
        this.bGr_units.add(this.jChB_percent);
        this.jLa_Q.setText(this.txt_flux_La_Q);
        this.jLa_Q.setFont(this.FT_STAND);
        this.jLa_Q.setBounds(new Rectangle(5, 5, 110, 20));
        this.jLa_QUnit.setHorizontalAlignment(4);
        this.out_flux.setBounds(new Rectangle(2, 25, 300, 180));
        this.out_flux.setFont(this.FT_STAND);
        this.setSize(new Dimension(313, 238));
        this.setResizable(false);
        this.addWindowListener(new DlgOutFlux_windowAdapter(this));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        contentPane.add((Component)this.out_flux, null);
        contentPane.add((Component)this.jLa_QUnit, null);
        contentPane.add((Component)this.jLa_Q, null);
        contentPane.add((Component)this.jChB_units, null);
        contentPane.add((Component)this.jChB_percent, null);
        this.globals.setLocation(this, this.config.getPropertyString("properties", "pos", new String[]{this.className}));
    }

    @Override
    public void repaint() {
        int units = 0;
        if (Ecad2007.getCalcmod() >= 7) {
            units = 1;
        }
        if (units == 0) {
            this.jChB_units.setText("MJ/m\u00b2");
        } else {
            this.jChB_units.setText("kWh/m\u00b2");
        }
        this.out_flux.setUnits(units);
        if (this.percents == 1) {
            this.out_flux.repaint();
        }
    }

    public void setVal(double Qt, double Qtr, double Qtw, double Qtf, double Qv, double Qsf, double Qpf, double Qef, double QTpr, double QTpm, double QTpf) {
        this.out_flux.setVal(Qt, Qtr, Qtw, Qtf, Qv, Qsf, Qpf, Qef, QTpr, QTpm, QTpf);
    }

    private void actionPerformed(ActionEvent ae) {
        DM_Zone dm_zone = Ecad2007.getDM_Zone(0);
        int units = 0;
        if (Ecad2007.getCalcmod() >= 7) {
            units = 1;
        }
        dm_zone.setUnits(units);
        this.out_flux.setVal(dm_zone);
        this.percents = this.jChB_percent.isSelected() ? 0 : 1;
        this.out_flux.setPercentOrUnits(this.percents);
        this.out_flux.repaint();
    }

    private void windowClosing(WindowEvent we) {
        String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
        this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
        this.percents = this.jChB_percent.isSelected() ? 0 : 1;
        this.config.setPropertyInt("properties", "percents", this.percents);
    }

    class DlgOutFlux_windowAdapter
    extends WindowAdapter {
        DlgOutFlux adaptee;

        DlgOutFlux_windowAdapter(DlgOutFlux adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.adaptee.windowClosing(we);
        }
    }

    class DlgOutFlux_ActionAdapter
    implements ActionListener {
        DlgOutFlux adaptee;

        public DlgOutFlux_ActionAdapter(DlgOutFlux adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

