/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.dialogs.InternalMainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class HelpPane
extends JEditorPane
implements Printable {
    JDialog dialog;
    JTextPane JTP_popup;
    Globals globals = new Globals();
    protected Font FT_STAND1;
    protected Font FT_BOLD1;
    protected Font FT_STAND2;
    JScrollPane scrollPane;
    Point pdiff;
    Component parent;
    Container container;
    JLabel jLa_titre;
    JButton jB_exit;
    JPanel jPa_titre;
    String html;
    int padding = 6;
    Color bgcolor = new Color(246, 250, 222);
    Color ticolor = new Color(246, 246, 139);
    Color bordercolor = new Color(180, 190, 90);
    String htmlbodyend = "</body></html>";

    public HelpPane(Component parent, String html) {
        this.parent = parent;
        this.html = html;
        this.JTP_popup = new JTextPane();
        this.scrollPane = new JScrollPane(this.JTP_popup);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.refreshHtml();
        if (this.globals != null) {
            this.FT_STAND1 = Globals.FT_STAND1;
            this.FT_BOLD1 = Globals.FT_BOLD1;
            this.FT_STAND2 = Globals.FT_STAND2;
        }
    }

    public HelpPane(Component parent, String html, String title) {
        this(parent, html);
        this.setTitle(title);
    }

    private void refreshHtml() {
        this.html = "<html><body style='padding: " + String.valueOf(this.padding) + "px; background-color: rgb(" + this.bgcolor.getRed() + ", " + this.bgcolor.getGreen() + ", " + this.bgcolor.getBlue() + ");'>" + this.html + this.htmlbodyend;
    }

    @Override
    public void setBackground(Color color) {
        this.bgcolor = color;
        this.refreshHtml();
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.refreshHtml();
    }

    public void setTitle(String title) {
        this.jLa_titre = new JLabel(title);
        this.jLa_titre.setBackground(this.ticolor);
        this.jLa_titre.setFont(new Font(this.FT_BOLD1.getFamily(), this.FT_BOLD1.getStyle(), 12));
        if (Ecad2007.ic_gen == null) {
            Ecad2007.ic_gen = this.globals.getResources("gen");
        }
        ImageIcon im_exit = (ImageIcon)Ecad2007.ic_gen.get("exit");
        this.jB_exit = new JButton(im_exit);
        this.jB_exit.addActionListener(new HelpPane_actionAdapter(this));
        this.jPa_titre = new JPanel();
        this.jPa_titre.setLayout(null);
        this.jPa_titre.setAlignmentY(0.5f);
        this.jPa_titre.setBackground(this.ticolor);
        this.jPa_titre.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.bordercolor));
        this.jPa_titre.addMouseListener(new HelpPane_mouseAdapter(this));
        this.jPa_titre.addMouseMotionListener(new HelpPane_mouseMotionAdapter(this));
        this.jPa_titre.add(this.jLa_titre);
        this.jPa_titre.add(this.jB_exit);
    }

    public void showPopupHelp(Point point, Dimension size) {
        this.JTP_popup.setContentType("text/html");
        this.JTP_popup.setText(this.html);
        this.JTP_popup.setEditable(false);
        this.JTP_popup.setCaretPosition(0);
        this.JTP_popup.setSize(size.width, size.height);
        this.JTP_popup.setBorder(BorderFactory.createLineBorder(this.bgcolor));
        StyledDocument doc = this.JTP_popup.getStyledDocument();
        Style style = this.JTP_popup.addStyle("FT_STAND", null);
        StyleConstants.setFontFamily(style, this.FT_STAND1.getFamily());
        StyleConstants.setFontSize(style, this.FT_STAND1.getSize());
        StyleConstants.setBackground(style, this.bgcolor);
        doc.setCharacterAttributes(0, this.html.length(), style, false);
        if (this.parent instanceof JDialog) {
            this.dialog = new JDialog((JDialog)this.parent);
        } else if (this.parent instanceof JFrame) {
            this.dialog = new JDialog((JFrame)this.parent);
        } else if (this.parent instanceof InternalMainFrame) {
            this.dialog = new JDialog(Ecad2007.getMainFrame());
        }
        if (this.dialog == null) {
            return;
        }
        Container container = this.dialog.getContentPane();
        SpringLayout layout = new SpringLayout();
        container.setLayout(layout);
        this.dialog.setUndecorated(true);
        this.dialog.setSize(this.JTP_popup.getSize().width + 1, this.JTP_popup.getSize().height + 1);
        this.dialog.addWindowFocusListener(new HelpPane_WindowFocusAdapter(this));
        this.JTP_popup.setDoubleBuffered(true);
        if (this.jPa_titre != null) {
            this.jLa_titre.setBounds(5, 0, size.width - 30, 30);
            this.jB_exit.setBounds(size.width - 20, 3, 16, 16);
            this.jPa_titre.setPreferredSize(new Dimension(size.width, 28));
            this.scrollPane.setPreferredSize(new Dimension(size.width, size.height - 28));
            layout.putConstraint("North", (Component)this.jPa_titre, 0, "South", (Component)container);
            layout.putConstraint("North", (Component)this.jPa_titre, 0, "North", (Component)container);
            container.add(this.jPa_titre);
        }
        layout.putConstraint("North", (Component)this.scrollPane, 28, "South", (Component)this.jPa_titre);
        layout.putConstraint("North", (Component)this.scrollPane, 28, "North", (Component)container);
        container.add(this.scrollPane);
        Point pt_parent = null;
        if (this.parent != null) {
            pt_parent = this.parent.getLocation();
            if (this.parent instanceof InternalMainFrame) {
                Point pt_mf = Ecad2007.getMainFrame().getLocation();
                pt_parent.x = pt_mf.x + pt_parent.x;
                pt_parent.y = pt_mf.y + pt_parent.y + 89;
            } else {
                pt_parent.x += (this.parent.getWidth() - this.dialog.getWidth()) / 2;
                pt_parent.y += (this.parent.getHeight() - this.dialog.getHeight()) / 2;
            }
        }
        this.dialog.setLocation(pt_parent.x, pt_parent.y);
        this.dialog.requestFocus();
        this.dialog.setVisible(true);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        this.paintComponent(g);
        return 0;
    }

    private void actionPerformed(ActionEvent ae) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setVisible(false);
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseDragged(MouseEvent me) {
        Point mp = MouseInfo.getPointerInfo().getLocation();
        int x = 0;
        int y = 0;
        if (mp == null) {
            return;
        }
        x = mp.x - this.pdiff.x;
        y = mp.y - this.pdiff.y;
        Point xy = new Point(x, y);
        if (this.dialog != null) {
            this.dialog.setLocation(xy);
        }
    }

    private void mousePressed(MouseEvent me) {
        Point pp = null;
        if (this.dialog != null) {
            pp = this.dialog.getLocationOnScreen();
        }
        Point mp = MouseInfo.getPointerInfo().getLocation();
        this.pdiff = new Point(mp.x - pp.x, mp.y - pp.y);
    }

    public void windowGainedFocus(WindowEvent we) {
    }

    public void windowLostFocus(WindowEvent we) {
        if (this.dialog == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HelpPane.this.dialog.isVisible()) {
                    HelpPane.this.dialog.setVisible(false);
                }
            }
        });
    }

    @Override
    public void addHyperlinkListener(HyperlinkListener listener) {
        this.JTP_popup.addHyperlinkListener(listener);
    }

    @Override
    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.JTP_popup.removeHyperlinkListener(listener);
    }

    class HelpPane_WindowFocusAdapter
    implements WindowFocusListener {
        HelpPane adaptee;

        HelpPane_WindowFocusAdapter(HelpPane adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowGainedFocus(WindowEvent we) {
            this.adaptee.windowGainedFocus(we);
        }

        @Override
        public void windowLostFocus(WindowEvent we) {
            this.adaptee.windowLostFocus(we);
        }
    }

    class HelpPane_mouseMotionAdapter
    extends MouseMotionAdapter {
        HelpPane adaptee;

        HelpPane_mouseMotionAdapter(HelpPane adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.adaptee.mouseDragged(me);
        }
    }

    class HelpPane_mouseAdapter
    extends MouseAdapter {
        HelpPane adaptee;

        HelpPane_mouseAdapter(HelpPane adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.adaptee.mousePressed(me);
        }
    }

    class HelpPane_actionAdapter
    implements ActionListener {
        HelpPane adaptee;

        HelpPane_actionAdapter(HelpPane adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

