/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.dialogs.toolbars;

import core.ContextMenu1;
import core.TextTransfer;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.dialogs.toolbars.PrivateToolBarListener;
import enercad2007.dialogs.toolbars.ToolBarEvent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class PrivateEditToolBar
extends JToolBar {
    CardLayout cardlayout;
    Container parent;
    int tbbvcter = 2;
    private JButton jB_copy = new JButton();
    private JButton jB_cut = new JButton();
    private JButton jB_paste = new JButton();
    private JButton jB_delete = new JButton();
    private JButton jB_select_all = new JButton();
    JButton[] jB_vides = new JButton[this.tbbvcter];
    DM_Trad gen_trad;
    Globals globals = new Globals();
    TextTransfer textTransfer = new TextTransfer();
    ArrayList<JTextComponent> al = new ArrayList(20);
    String txt_select_all = "Tout s\u00e9lectionner";
    String txt_cut = "Couper";
    String txt_copy = "Copier";
    String txt_paste = "Coller";
    String txt_delete = "Effacer";

    public PrivateEditToolBar() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public PrivateEditToolBar(Container parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(true);
        this.setDebugGraphicsOptions(0);
        this.setFloatable(false);
        this.setForeground(Color.black);
        if (this.parent != null) {
            this.setBounds(new Rectangle(0, 1, this.parent.getWidth(), 26));
            this.setEnabled(0);
            this.addPrivateToolBarListener(new PrivateToolBarAdapter(this));
            this.addFocusToFields(this.al, this.parent);
            if (this.al.size() > 0) {
                for (JTextComponent textComponent : this.al) {
                    new ContextMenu1(textComponent);
                }
            }
        }
        int dx = 24;
        int dy = 24;
        HashMap<String, ImageIcon> ic_gen = this.globals.getResources("gen");
        if (this.globals != null) {
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.txt_select_all = this.gen_trad.getCodeLan("select_all");
            this.txt_cut = this.gen_trad.getCodeLan("cut");
            this.txt_copy = this.gen_trad.getCodeLan("copy");
            this.txt_paste = this.gen_trad.getCodeLan("paste");
            this.txt_delete = this.gen_trad.getCodeLan("delete2");
        }
        int cter = 0;
        for (cter = 0; cter < this.tbbvcter; ++cter) {
            this.jB_vides[cter] = new JButton();
            this.jB_vides[cter].setBorder(BorderFactory.createEmptyBorder());
            this.jB_vides[cter].setPreferredSize(new Dimension(12, dy));
            this.jB_vides[cter].setMinimumSize(new Dimension(12, dy));
            this.jB_vides[cter].setMaximumSize(new Dimension(12, dy));
            this.jB_vides[cter].setRequestFocusEnabled(false);
            this.jB_vides[cter].setOpaque(false);
        }
        this.jB_copy.setBorder(BorderFactory.createEtchedBorder());
        this.jB_copy.setIcon((Icon)ic_gen.get("copy"));
        this.jB_copy.setPreferredSize(new Dimension(dx, dy));
        this.jB_copy.setMinimumSize(new Dimension(dx, dy));
        this.jB_copy.setMaximumSize(new Dimension(dx, dy));
        this.jB_copy.setToolTipText(this.txt_copy);
        this.jB_copy.addMouseListener(new PrivateEditToolBar_MouseAdapter(this));
        this.jB_cut.setBorder(BorderFactory.createEtchedBorder());
        this.jB_cut.setIcon((Icon)ic_gen.get("cut"));
        this.jB_cut.setPreferredSize(new Dimension(dx, dy));
        this.jB_cut.setMinimumSize(new Dimension(dx, dy));
        this.jB_cut.setMaximumSize(new Dimension(dx, dy));
        this.jB_cut.setToolTipText(this.txt_cut);
        this.jB_cut.addMouseListener(new PrivateEditToolBar_MouseAdapter(this));
        this.jB_paste.setBorder(BorderFactory.createEtchedBorder());
        this.jB_paste.setIcon((Icon)ic_gen.get("paste"));
        this.jB_paste.setPreferredSize(new Dimension(dx, dy));
        this.jB_paste.setMinimumSize(new Dimension(dx, dy));
        this.jB_paste.setMaximumSize(new Dimension(dx, dy));
        this.jB_paste.setToolTipText(this.txt_paste);
        this.jB_paste.addMouseListener(new PrivateEditToolBar_MouseAdapter(this));
        this.jB_delete.setBorder(BorderFactory.createEtchedBorder());
        this.jB_delete.setIcon((Icon)ic_gen.get("delete"));
        this.jB_delete.setPreferredSize(new Dimension(dx, dy));
        this.jB_delete.setMinimumSize(new Dimension(dx, dy));
        this.jB_delete.setMaximumSize(new Dimension(dx, dy));
        this.jB_delete.setToolTipText(this.txt_delete);
        this.jB_delete.addMouseListener(new PrivateEditToolBar_MouseAdapter(this));
        this.jB_select_all.setBorder(BorderFactory.createEtchedBorder());
        this.jB_select_all.setIcon((Icon)ic_gen.get("select_all"));
        this.jB_select_all.setPreferredSize(new Dimension(dx, dy));
        this.jB_select_all.setMinimumSize(new Dimension(dx, dy));
        this.jB_select_all.setMaximumSize(new Dimension(dx, dy));
        this.jB_select_all.setToolTipText(this.txt_select_all);
        this.jB_select_all.addMouseListener(new PrivateEditToolBar_MouseAdapter(this));
        this.add((Component)this.jB_vides[0], null);
        this.add((Component)this.jB_copy, null);
        this.add((Component)this.jB_cut, null);
        this.add((Component)this.jB_paste, null);
        this.add((Component)this.jB_delete, null);
        this.add((Component)this.jB_vides[1], null);
        this.add((Component)this.jB_select_all, null);
    }

    private ArrayList<JTextComponent> addFocusToFields(ArrayList<JTextComponent> al, Component component) {
        if (component == null) {
            return al;
        }
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.addFocusListener(new PrivateToolBar_FocusAdapter(this));
            al.add(jTextComponent);
        } else if (component instanceof JPanel) {
            Component[] components = ((JPanel)component).getComponents();
            for (int ii = 0; ii < components.length; ++ii) {
                al = this.addFocusToFields(al, components[ii]);
            }
        }
        return al;
    }

    public void addPrivateToolBarListener(PrivateToolBarListener ptbl) {
        this.listenerList.add(PrivateToolBarListener.class, ptbl);
    }

    public void removePrivateToolBarListener(PrivateToolBarListener ptbl) {
        this.listenerList.remove(PrivateToolBarListener.class, ptbl);
    }

    public void setEnabled(int ids) {
        if ((ids & 1) == 1) {
            this.jB_copy.setEnabled(true);
        } else {
            this.jB_copy.setEnabled(false);
        }
        if ((ids & 2) == 2) {
            this.jB_cut.setEnabled(true);
        } else {
            this.jB_cut.setEnabled(false);
        }
        if ((ids & 4) == 4) {
            this.jB_paste.setEnabled(true);
        } else {
            this.jB_paste.setEnabled(false);
        }
        if ((ids & 8) == 8) {
            this.jB_delete.setEnabled(true);
        } else {
            this.jB_delete.setEnabled(false);
        }
        if ((ids & 0x10) == 16) {
            this.jB_select_all.setEnabled(true);
        } else {
            this.jB_select_all.setEnabled(false);
        }
    }

    protected void fireToolBarMouseClicked(ToolBarEvent tbe) {
        boolean b_pointer = false;
        int buttonId = -1;
        if (tbe.getSource() == this.jB_copy) {
            buttonId = 0;
        } else if (tbe.getSource() == this.jB_cut) {
            buttonId = 1;
        } else if (tbe.getSource() == this.jB_paste) {
            buttonId = 2;
        } else if (tbe.getSource() == this.jB_delete) {
            buttonId = 3;
        } else if (tbe.getSource() == this.jB_select_all) {
            buttonId = 4;
        }
        if (buttonId > -1) {
            tbe.setButtonId(buttonId);
            b_pointer = true;
        }
        Object[] listeners = this.listenerList.getListenerList();
        tbe.setSource(this);
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != PrivateToolBarListener.class || !b_pointer) continue;
            ((PrivateToolBarListener)listeners[ii + 1]).toolbarButtonClicked(tbe);
        }
    }

    private void mousePressed(MouseEvent me) {
        Component source = me.getComponent();
        int id = me.getID();
        long when = me.getWhen();
        int modifiers = me.getModifiers();
        int clicks = me.getClickCount();
        Point point = me.getPoint();
        boolean popupTrigger = me.isPopupTrigger();
        ToolBarEvent tbe = new ToolBarEvent(source, id, when, modifiers, point.x, point.y, clicks, popupTrigger);
        this.fireToolBarMouseClicked(tbe);
    }

    private void componentToolbarButtonClicked(ToolBarEvent tbe) {
        if (this.parent == null) {
            return;
        }
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
        if (window == null) {
            return;
        }
        Component component = window.getFocusOwner();
        if (component == null) {
            return;
        }
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            if (tbe.getButtonId() == 0) {
                textComponent.copy();
                this.textTransfer.setClipboardContents(textComponent.getSelectedText());
            } else if (tbe.getButtonId() == 1) {
                textComponent.cut();
                this.textTransfer.setClipboardContents(textComponent.getSelectedText());
            } else if (tbe.getButtonId() == 2) {
                textComponent.paste();
            } else if (tbe.getButtonId() == 3) {
                textComponent.replaceSelection(null);
            } else if (tbe.getButtonId() == 4) {
                textComponent.selectAll();
            }
            textComponent.requestFocus();
        }
    }

    private void focusGained(FocusEvent fe) {
        if (this.parent == null) {
            return;
        }
        Component component = fe.getComponent();
        if (component instanceof JTextComponent) {
            if (this.textTransfer.getClipboardContents() == "") {
                this.setEnabled(27);
            } else {
                this.setEnabled(31);
            }
        }
    }

    class PrivateToolBar_FocusAdapter
    extends FocusAdapter {
        PrivateEditToolBar adaptee;

        PrivateToolBar_FocusAdapter(PrivateEditToolBar adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            this.adaptee.focusGained(fe);
        }
    }

    class PrivateToolBarAdapter
    implements PrivateToolBarListener {
        PrivateEditToolBar adaptee;

        PrivateToolBarAdapter(PrivateEditToolBar adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void toolbarButtonClicked(ToolBarEvent tbe) {
            this.adaptee.componentToolbarButtonClicked(tbe);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }

    class PrivateEditToolBar_MouseAdapter
    extends MouseAdapter {
        PrivateEditToolBar adaptee;

        public PrivateEditToolBar_MouseAdapter(PrivateEditToolBar adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.adaptee.mousePressed(me);
        }
    }
}

