/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.printdlg;

import core.Calc_Ceb;
import core.Config;
import core.ImageFop;
import core.hibernate.cat.dao.HibernateCeb_D1Dao;
import core.hibernate.cat.db.Ceb_D1;
import core.hibernate.pro.dao.HibernatePro_CebDao;
import core.hibernate.pro.db.Pro_Ceb;
import enercad2007.DM_Trad_SIA;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.printdlg.PrtSIA;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jecadcomp.Ceb;

public class FoCeb {
    PrtSIA prtSIA;
    Ceb out_ceb;
    double[] ef;
    DecimalFormat df0;
    DecimalFormat df1;
    DecimalFormat df2;
    private static int ff = 1;
    Font FT_P11 = new Font("Dialog", 0, 11 * ff);
    static String unit = "MJ";
    static String kunit = "GJ";
    int units = 0;
    int lan = 0;
    Rectangle rec_img = new Rectangle(70, 370, 450, 180);
    Config config = new Config(System.getProperty("conf.file.name"));
    double ae = 0.0;
    Map<String, Object> m_ceb;
    double qh = 0.0;
    double rqh = 0.0;

    public FoCeb(PrtSIA prtSIA) {
        this.prtSIA = prtSIA;
        this.lan = Ecad2007.getCodeLan();
        this.m_ceb = Ecad2007.getDM_Zone(0).calculate(0);
        double CHli = Globals.getDoubleValue(this.m_ceb.get("CHli"));
        this.ae = Ecad2007.getDM_Zone(0).getAE();
        this.qh = Globals.getDoubleValue(this.m_ceb.get("sumQH")) / this.ae;
        this.rqh = this.qh / CHli;
        this.ef = Ecad2007.calculateEnergyFactors();
        this.out_ceb = new Ceb(true, new double[]{this.qh, this.rqh, this.ef[0], this.ef[1], this.ef[2], this.ef[3], this.ef[4], this.ef[5]});
        this.df0 = Ecad2007.getDecimalFormat("0");
        this.df1 = Ecad2007.getDecimalFormat("0.0");
        this.df2 = Ecad2007.getDecimalFormat("0.00");
    }

    public String buildFoJCeb() {
        int index;
        String[] txt_ef;
        int ii;
        DM_Trad_SIA dm_tradSIA = Ecad2007.getTraduction_SIA("ceb");
        String foString = "";
        String foSection = FoCeb.fo(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Ecad2007.getLicenseLevel() > 2L) {
            map.put("\\$_titleCeb", dm_tradSIA.getCodeLan("$_title"));
        } else {
            map.put("\\$_titleCeb", Globals.getGenericName() + " - EDUCATION");
        }
        map.put("\\$_nom", dm_tradSIA.getCodeLan("$_nom"));
        map.put("\\%_nom", this.prtSIA.cleanS(Ecad2007.getDM_Pro().getNOM_B()));
        map.put("\\$_dossier", dm_tradSIA.getCodeLan("$_dossier"));
        map.put("\\%_dossier", this.prtSIA.cleanS(Ecad2007.getDM_Pro().getNO_B()));
        map.put("\\$_logiciel", dm_tradSIA.getCodeLan("$_logiciel"));
        map.put("\\%_logiciel", this.prtSIA.ECAD_ID);
        map.put("\\$_printDate", dm_tradSIA.getCodeLan("$_printDate"));
        map.put("\\%_printDate", this.prtSIA.now);
        map.put("\\%_QH_B", String.format(Locale.ENGLISH, "%.0f", this.qh));
        map.put("\\$_page", dm_tradSIA.getCodeLan("$_page"));
        foString = foString + this.prtSIA.loadFo(foSection, map);
        foSection = FoCeb.fo(1);
        map = new HashMap();
        map.put("\\%_userID", this.prtSIA.getUserId());
        map.put("\\%_ecadURL", "www.enercad.ch");
        map.put("\\%_fileNAME", this.prtSIA.getProjectFileName());
        foString = foString + this.prtSIA.loadFo(foSection, map);
        String subE = "<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">E</fo:inline>";
        String subH = "<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">H</fo:inline>";
        foSection = FoCeb.fo(2);
        map = new HashMap();
        for (ii = 1; ii < 10; ++ii) {
            if (ii == 1) {
                map.put("\\$_01", dm_tradSIA.getCodeLan("$_01", "<fo:inline font-weight='bold'>SIA 2031:2009</fo:inline>"));
                continue;
            }
            if (ii == 9) {
                txt_ef = new String[3];
                if (this.ef[0] < 0.0) {
                    txt_ef[0] = "<fo:inline font-weight='bold' color='red'>0 " + kunit + "</fo:inline>";
                    txt_ef[1] = "<fo:inline font-weight='bold' color='red'>0 " + unit + "/m&#178;</fo:inline>";
                } else {
                    txt_ef[0] = this.df0.format(this.ef[0] * this.ae / 1000.0) + " " + kunit;
                    txt_ef[1] = this.df0.format(this.ef[0]) + " " + unit + "/m&#178;";
                }
                txt_ef[2] = this.ef[1] < 0.0 ? "<fo:inline font-weight='bold' color='red'>0 %</fo:inline>" : this.df0.format(this.ef[1] * 100.0) + " %";
                map.put("\\$_09", dm_tradSIA.getCodeLan("$_09", txt_ef).replaceAll("<sub>E</sub>", "<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">E</fo:inline>"));
                continue;
            }
            map.put("\\$_0" + String.valueOf(ii), dm_tradSIA.getCodeLan("$_0" + String.valueOf(ii)));
        }
        for (ii = 10; ii < 27; ++ii) {
            if (ii == 10) {
                txt_ef = new String[3];
                if (this.ef[2] < 0.0) {
                    txt_ef[0] = "<fo:inline font-weight='bold' color='red'>0 t</fo:inline>";
                    txt_ef[1] = "<fo:inline font-weight='bold' color='red'>0 kg/m&#178;</fo:inline>";
                } else {
                    txt_ef[0] = this.df0.format(this.ef[2] * this.ae / 1000.0) + " t";
                    txt_ef[1] = this.df1.format(this.ef[2]) + " kg/m&#178;";
                }
                txt_ef[2] = this.ef[3] < 0.0 ? "<fo:inline font-weight='bold' color='red' keep-together='always'>0 %</fo:inline>" : this.df0.format(this.ef[3] * 100.0) + " %";
                map.put("\\$_10", dm_tradSIA.getCodeLan("$_10", txt_ef).replaceAll("<sub>E</sub>", "<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">E</fo:inline>"));
                continue;
            }
            if (ii == 19) {
                map.put("\\$_19", dm_tradSIA.getCodeLan("$_19", new String[]{this.df1.format(this.qh), this.df0.format(this.rqh * 100.0)}).replaceAll("<sub>H</sub>", "<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">H</fo:inline>"));
                continue;
            }
            map.put("\\$_" + String.valueOf(ii), dm_tradSIA.getCodeLan("$_" + String.valueOf(ii)));
        }
        map.put("\\%_02", this.prtSIA.cleanS(Ecad2007.getDM_Pro().getNOM_B()));
        int ac = Ecad2007.getDM_Pro().getAC_B();
        if (ac > 0) {
            map.put("\\%_03", String.valueOf(ac));
        } else {
            map.put("\\%_03", "");
        }
        String adresse = Ecad2007.getDM_Pro().getA1_B();
        if (adresse == null) {
            adresse = "";
        }
        if (adresse.equals("")) {
            map.put("\\%_04", this.prtSIA.cleanS(adresse));
        } else if (Ecad2007.getDM_Pro().getA2_B() == null) {
            map.put("\\%_04", adresse);
        } else if (Ecad2007.getDM_Pro().getA2_B().trim().equals("")) {
            map.put("\\%_04", adresse);
        } else {
            map.put("\\%_04", adresse + ", " + Ecad2007.getDM_Pro().getA2_B());
        }
        map.put("\\%_05", this.df1.format(this.ae));
        map.put("\\%_07", Ecad2007.getDM_Met().getNOM_MET());
        String resp = Ecad2007.getDM_Pro().getCOL_AJ();
        if (resp == null) {
            resp = "";
        }
        if (resp.trim().equals("")) {
            map.put("\\%_13", resp);
        } else {
            String soc = Ecad2007.getDM_Pro().getNOM_AJ();
            if (soc == null) {
                soc = "";
            }
            if (!soc.trim().equals("")) {
                map.put("\\%_13", this.prtSIA.cleanS(resp + ", " + soc));
            }
        }
        String ld = Ecad2007.getDM_Pro().getA1_AJ();
        if (ld == null) {
            ld = "";
        }
        if ((index = ld.lastIndexOf(" ")) + 1 < ld.length()) {
            ld = ld.substring(index + 1);
        }
        SimpleDateFormat sdf = null;
        if (Ecad2007.getCodeLan() == 1 || Ecad2007.getCodeLan() == 2) {
            sdf = new SimpleDateFormat("d MMMM yyyy", Locale.getDefault());
        } else if (Ecad2007.getCodeLan() == 0) {
            sdf = new SimpleDateFormat("d. MMMM yyyy", Locale.getDefault());
        }
        if (ld.equals("")) {
            ld = sdf.format(new Date());
        } else if (this.lan == 0) {
            ld = ld + ", " + sdf.format(new Date());
        } else if (this.lan == 1) {
            ld = ld + ", le " + sdf.format(new Date());
        } else if (this.lan == 2) {
            ld = ld + ", di " + sdf.format(new Date());
        }
        map.put("\\%_14", ld);
        int ren = Ecad2007.getDM_Pro().getREN_B();
        if (ren > 0) {
            map.put("\\%_17", String.valueOf(ren));
        } else {
            map.put("\\%_17", "");
        }
        int tr_b = Ecad2007.getDM_Pro().getTR_B();
        if (tr_b == 1) {
            map.put("\\%_18", "<fo:inline color='white' font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
            map.put("\\%_20", "<fo:inline font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
        } else if (tr_b > 1) {
            map.put("\\%_18", "<fo:inline font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
            map.put("\\%_20", "<fo:inline color='white' font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
        } else {
            map.put("\\%_18", "<fo:inline color='white' font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
            map.put("\\%_20", "<fo:inline color='white' font-family='ZapfDingbats' font-size='10pt' border=\"0.25mm solid black\" padding-left='1pt' padding-right='1pt' padding-bottom='1pt'>&#x2713;</fo:inline>");
        }
        if (this.ef != null && this.ef.length > 4) {
            double fep = this.ef[5] * 100.0 + 0.5;
            String fep_txt = Ecad2007.getDecimalFormat("0").format(fep) + " %";
            if (Double.isNaN(fep)) {
                fep_txt = "  0 %";
            }
            map.put("\\%_25", fep_txt);
        }
        int cco2 = this.out_ceb.getClassRCO2();
        char ch = (char)(65 + cco2);
        if (this.ef[2] < 0.0) {
            map.put("\\%_26", "-");
        } else {
            map.put("\\%_26", String.valueOf(ch));
        }
        foString = foString + "        <fo:block space-before=\"1em\" role=\"div\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"  keep-together.within-page=\"always\">\n";
        foString = foString + this.prtSIA.loadFo(foSection, map);
        foString = foString + "        </fo:block>\n";
        map = new HashMap();
        for (int ii2 = 27; ii2 <= 54; ++ii2) {
            map.put("\\$_" + ii2, dm_tradSIA.getCodeLan("$_" + ii2));
        }
        map.put("\\$_42", dm_tradSIA.getCodeLan("$_42", new String[]{"[MJ/m\u00b2]", "A<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">E</fo:inline> = " + this.df0.format(this.ae) + "m\u00b2"}));
        foString = foString + "        <fo:block space-before=\"7em\" role=\"div\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"  keep-together.within-page=\"always\">\n";
        foSection = FoCeb.fo(7);
        foString = foString + this.prtSIA.loadFo(foSection, map);
        foString = foString + "                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\" border='0.1mm solid black'>\n";
        HibernatePro_CebDao hp_ceb = new HibernatePro_CebDao();
        HibernateCeb_D1Dao hibernateCeb_D1Dao = new HibernateCeb_D1Dao();
        Pro_Ceb pro_ceb = hp_ceb.getPro_Ceb();
        String[] ref_d1 = new String[]{pro_ceb.getRef_d11(), pro_ceb.getRef_d12(), pro_ceb.getRef_d13()};
        Calc_Ceb calc_ceb = Ecad2007.getCalcCeb(0);
        double lossQH = pro_ceb.getDistrib_qhli();
        double lossQW = pro_ceb.getDistrib_qwli();
        lossQW += pro_ceb.getDistrib_qwgen().doubleValue();
        double flossQH = (double)pro_ceb.getFa_distrib_hrec().floatValue() / 100.0;
        double flossQW = (double)pro_ceb.getFa_distrib_wrec().floatValue() / 100.0;
        double lossQHWgen = 0.0;
        double recupQgen = 0.0;
        double[] part = new double[3];
        for (int ii3 = 0; ii3 < ref_d1.length; ++ii3) {
            if (ii3 == 0) {
                lossQHWgen = Globals.getDoubleValue(pro_ceb.getGenerator_qh1());
                recupQgen = Globals.getDoubleValue(pro_ceb.getGenerator_qh1()) * Globals.getDoubleValue(pro_ceb.getFa_generator_recup1()) / 100.0;
                part[0] = Globals.getDoubleValue(pro_ceb.getFa_generator_part1());
                continue;
            }
            if (ii3 == 1) {
                lossQHWgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh2());
                recupQgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh2()) * Globals.getDoubleValue(pro_ceb.getFa_generator_recup2()) / 100.0;
                part[1] = Globals.getDoubleValue(pro_ceb.getFa_generator_part2());
                continue;
            }
            if (ii3 != 2) continue;
            lossQHWgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh3());
            recupQgen += Globals.getDoubleValue(pro_ceb.getGenerator_qh3()) * Globals.getDoubleValue(pro_ceb.getFa_generator_recup3()) / 100.0;
            part[2] = Globals.getDoubleValue(pro_ceb.getFa_generator_part3());
        }
        double consumE = calc_ceb.getQtot(lossQH, lossQW, lossQHWgen, flossQH, flossQW, recupQgen);
        double sum_csm = 0.0;
        double sum_ep = 0.0;
        double sum_pren = 0.0;
        double sum_tco2 = 0.0;
        String tmp = "";
        String tmp_fo = "";
        for (int ii4 = 0; ii4 < 3; ++ii4) {
            Ceb_D1 ceb_d1 = hibernateCeb_D1Dao.getCeb_D1(ref_d1[ii4]);
            if (ceb_d1 == null) continue;
            String nom = ceb_d1.getNom(this.lan).trim();
            double dbl_csm = consumE * part[ii4] / 100.0;
            String csm = this.df0.format(dbl_csm);
            sum_csm += dbl_csm;
            double dbl_fep = ceb_d1.getFep();
            String fep = this.df2.format(dbl_fep);
            double dbl_ep = dbl_fep * dbl_csm;
            String ep = this.df0.format(dbl_ep);
            sum_ep += dbl_ep;
            double dbl_kco2 = (double)ceb_d1.getKco2() * 1000.0;
            String kco = this.df0.format(dbl_kco2);
            double dbl_tco2 = dbl_kco2 * dbl_csm / 1000.0;
            String tco2 = this.df0.format(dbl_tco2);
            sum_tco2 += dbl_tco2;
            double dbl_fren = ceb_d1.getFren();
            String fren = this.df1.format(dbl_fren);
            double dbl_pren = dbl_fren * dbl_fep * dbl_csm / 100.0;
            String pren = this.df0.format(dbl_pren);
            sum_pren += dbl_pren;
            map.put("\\%_nom_d1" + ii4, nom);
            map.put("\\%_csm" + ii4, csm);
            map.put("\\%_fep" + ii4, fep);
            map.put("\\%_ep" + ii4, ep);
            map.put("\\%_kco2" + ii4, kco);
            map.put("\\%_tco2" + ii4, tco2);
            map.put("\\%_fren" + ii4, fren);
            map.put("\\%_pren" + ii4, pren);
            tmp_fo = FoCeb.fo(8);
            tmp_fo = tmp_fo.replaceAll("%_nom_d1", "%_nom_d1" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_csm", "%_csm" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_fep", "%_fep" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_ep", "%_ep" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_kco2", "%_kco2" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_tco2", "%_tco2" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_fren", "%_fren" + ii4);
            tmp_fo = tmp_fo.replaceAll("%_pren", "%_pren" + ii4);
            tmp = tmp + tmp_fo;
        }
        map.put("\\%_sum_csm", this.df0.format(sum_csm));
        map.put("\\%_sum_fep", this.df2.format(sum_ep / sum_csm));
        map.put("\\%_sum_ep", this.df0.format(sum_ep));
        map.put("\\%_sum_co2", this.df0.format(sum_tco2 / sum_csm * 1000.0));
        map.put("\\%_sum_tco2_csm", this.df0.format(sum_tco2));
        map.put("\\%_sum_fren_csm", this.df1.format(sum_pren / sum_csm * 100.0));
        map.put("\\%_sum_pren", this.df0.format(sum_pren));
        foString = foString + this.prtSIA.loadFo(tmp, map);
        foString = foString + "                         </fo:table-body>\n";
        foString = foString + this.prtSIA.loadFo(FoCeb.fo(9), map);
        foString = foString + "        </fo:block>\n";
        double sum_elaux = (Globals.getDoubleValue(pro_ceb.getFa_elaux()) + Globals.getDoubleValue(pro_ceb.getFa_elhaux()) + Globals.getDoubleValue(pro_ceb.getFa_elwaux())) * this.ae / 1000.0;
        map.put("\\%_sum_aux", this.df0.format(sum_elaux));
        double csm_eev = Globals.getDoubleValue(pro_ceb.getConsum_eev());
        map.put("\\%_csm_eev", this.df0.format(csm_eev));
        double csm_eel = pro_ceb.getConsum_eel();
        map.put("\\%_csm_eel", this.df0.format(csm_eel));
        double csm_eep = Globals.getDoubleValue(pro_ceb.getConsum_easc()) + Globals.getDoubleValue(pro_ceb.getConsum_eap());
        map.put("\\%_csm_eep", this.df0.format(csm_eep));
        double sum_el = sum_elaux + csm_eev + csm_eel + csm_eep;
        map.put("\\%_sum_el", this.df0.format(sum_el));
        double[] f_el = calc_ceb.getEletricityCH();
        double fep_el = f_el[0];
        map.put("\\%_fep_el", this.df2.format(fep_el));
        double sum_prim_elaux = fep_el * sum_el;
        map.put("\\%_sum_prim_elaux", this.df0.format(sum_prim_elaux));
        map.put("\\%_sum_prim_pond", this.df0.format(sum_ep + sum_prim_elaux));
        map.put("\\%_ind_cms", this.df0.format(sum_ep / this.ae * 1000.0));
        map.put("\\%_ind_elaux", this.df0.format(sum_prim_elaux / this.ae * 1000.0));
        map.put("\\%_sum_ind_elaux", this.df0.format((sum_ep + sum_prim_elaux) / this.ae * 1000.0));
        map.put("\\%_kco2_el", this.df0.format(f_el[2] * 1000.0));
        double sum_el_tco2 = f_el[2] * sum_el;
        map.put("\\%_sum_tco2_el", this.df0.format(sum_el_tco2));
        double sum_tco2_pond = sum_tco2 + sum_el_tco2;
        map.put("\\%_sum_tco2_pond", this.df0.format(sum_tco2_pond));
        double ind_co2_csm = sum_tco2 / this.ae * 1000.0;
        map.put("\\%_ind_co2_csm", this.df1.format(ind_co2_csm));
        double ind_co2_el = sum_el_tco2 / this.ae * 1000.0;
        map.put("\\%_ind_co2_el", this.df1.format(ind_co2_el));
        map.put("\\%_ind_sum_co2", this.df1.format(ind_co2_csm + ind_co2_el));
        map.put("\\%_sum_fren_el", this.df1.format(f_el[1]));
        double sum_primren_csm = sum_pren / sum_csm * sum_ep;
        map.put("\\%_sum_primren_csm", this.df0.format(sum_primren_csm));
        double sum_primren_el = sum_prim_elaux * f_el[1] / 100.0;
        map.put("\\%_sum_primren_el", this.df0.format(sum_primren_el));
        double sum_primren_pond = sum_primren_csm + sum_primren_el;
        map.put("\\%_sum_primren_pond", this.df0.format(sum_primren_pond));
        double sum_fren_pond = sum_primren_pond / (sum_ep + sum_prim_elaux) * 100.0;
        map.put("\\%_sum_fren_pond", this.df0.format(sum_fren_pond));
        foString = foString + "        <fo:block space-before=\"3em\" role=\"div\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"  keep-together.within-page=\"always\">\n";
        foSection = FoCeb.fo(10);
        foString = foString + this.prtSIA.loadFo(foSection, map);
        foString = foString + "        </fo:block>\n";
        foString = foString + "      </fo:block>\n";
        foString = foString + FoCeb.fo(16);
        Globals.println(10000, "Printing FoReport");
        Globals.println(10000, "--------------------------------------------------------------------------------------------------------------");
        Globals.println(10000, foString);
        Globals.println(10000, "--------------------------------------------------------------------------------------------------------------");
        return foString;
    }

    public static String fo(int section) {
        String[] fo = new String[20];
        if (section == 0) {
            fo[0] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<fo:root \n  xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" \n  xmlns:html=\"http://www.w3.org/1999/xhtml\" writing-mode=\"lr-tb\" hyphenate=\"false\" text-align=\"start\" role=\"doc\">\n  <fo:layout-master-set>\n    <fo:simple-page-master page-width=\"210mm\" page-height=\"297mm\" master-name=\"first-page\">\n      <fo:region-body column-gap=\"12pt\" column-count=\"1\" margin-left=\"1.8cm\" margin-bottom=\"1.0cm\" margin-right=\"1.0cm\" margin-top=\"4.0cm\"/>\n      <fo:region-before display-align=\"before\" extent=\"1.8cm\" region-name=\"page-header\"/>\n      <fo:region-after display-align=\"after\" extent=\"1.5cm\" region-name=\"page-footer\"/>\n      <fo:region-start extent=\"1.8cm\"/>\n      <fo:region-end extent=\"1.0cm\"/>\n    </fo:simple-page-master>\n    <fo:simple-page-master page-width=\"210mm\" page-height=\"297mm\" master-name=\"all-pages\">\n      <fo:region-body column-gap=\"12pt\" column-count=\"1\" margin-left=\"1.8cm\" margin-bottom=\"1.0cm\" margin-right=\"1.0cm\" margin-top=\"4.0cm\"/>\n      <fo:region-before display-align=\"before\" extent=\"1.8cm\" region-name=\"page-header\"/>\n      <fo:region-after display-align=\"after\" extent=\"1.5cm\" region-name=\"page-footer\"/>\n      <fo:region-start extent=\"1.8cm\"/>\n      <fo:region-end extent=\"1.0cm\"/>\n    </fo:simple-page-master>\n  </fo:layout-master-set>\n  \n  <fo:page-sequence master-reference=\"first-page\">\n    <!-- header 1\u00e8re page-->\n    <fo:static-content flow-name=\"page-header\">\n      <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-before=\"0.25cm\" space-before.conditionality=\"retain\">    \n        <fo:wrapper>\n          <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"14pt\" font-weight=\"bold\">\n          <fo:table-column role=\"col\" column-width=\"12.0cm\"/>\n          <fo:table-column role=\"col\" column-width=\"5.0cm\"/>\n            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                  <fo:table-row>\n                      <fo:table-cell padding-top='24pt'>\n                          <fo:block font-weight='bold'>$_titleCeb</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell display-align='after'>\n                          <fo:block font-size=\"36pt\" text-align='right' color='#555555' font-weight='bold'></fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n            </fo:table-body>\n          </fo:table> \n          <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border=\"0.1mm solid black\" margin=\"2px\" font-size=\"8pt\">\n            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n            <fo:table-column role=\"col\" column-width=\"11cm\"/>\n            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n            <fo:table-column role=\"col\" column-width=\"1.6cm\"/>\n            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_nom</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_nom</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_dossier</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\"><fo:block>%_dossier</fo:block></fo:table-cell>\n              </fo:table-row>\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_logiciel</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_logiciel</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>Q<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">h</fo:inline> [" + unit + "/m" + "<fo:inline baseline-shift=\"super\" font-size=\"6pt\">2</fo:inline>" + "]:</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\" font-weight=\"bold\"><fo:block>%_QH_B</fo:block></fo:table-cell>\n              </fo:table-row>\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_printDate</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_printDate</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_page</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\">                  <fo:block>\n                    <fo:page-number azimuth=\"0\"/>/<fo:page-number-citation ref-id=\"last-page\"/>\n                  </fo:block>\n               </fo:table-cell>\n              </fo:table-row>\n            </fo:table-body>\n          </fo:table>\n        </fo:wrapper>\n      </fo:block>\n      <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n      <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n    </fo:static-content>\n    \n";
        } else if (section == 1) {
            fo[1] = "    <!-- footer 1\u00e8re page-->\n    <fo:static-content flow-name=\"page-footer\">\n      <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-after=\"1cm\" space-after.conditionality=\"retain\">    \n        <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"8pt\" font-style=\"italic\">\n          <fo:table-column role=\"col\" column-width=\"6.0cm\"/>\n          <fo:table-column role=\"col\" column-width=\"11.0cm\"/>\n          <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n            <fo:table-row role=\"tr\">\n              <fo:table-cell padding=\"2px\" role=\"td\">\n                <fo:block>\n                  <fo:basic-link text-decoration=\"underline\" color=\"blue\" role=\"a\" external-destination=\"url('http://%_ecadURL')\">\n                    %_ecadURL\n                  </fo:basic-link>\n                  %_userID\n                </fo:block>\n              </fo:table-cell>\n              <fo:table-cell padding=\"2px\" role=\"td\" text-align=\"right\">\n                <fo:block>%_fileNAME</fo:block>\n              </fo:table-cell>\n            </fo:table-row>\n          </fo:table-body>\n        </fo:table>\n      </fo:block>\n    </fo:static-content>\n    \n    <fo:flow flow-name=\"xsl-region-body\">\n      <fo:block role=\"body\" font-family=\"Arial, Helvetica, sans-serif\" font-size=\"8pt\">\n\n";
        } else if (section == 2) {
            String fs9 = "'9pt'";
            fo[2] = "            <!-- Titre -->\n            <fo:table text-align=\"left\" table-layout=\"fixed\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"17cm\"/>\n              <fo:table-body>\n                  <fo:table-row>\n                      <fo:table-cell padding-top='1cm' padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block keep-together=\"always\">$_01.</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block  keep-together=\"always\">$_02: <fo:inline font-weight='bold'>%_02</fo:inline></fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table text-align=\"left\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"6cm\"/>\n              <fo:table-column column-width=\"6cm\"/>\n              <fo:table-column column-width=\"2.5cm\"/>\n              <fo:table-column column-width=\"2.5cm\"/>\n              <fo:table-body>\n                  <fo:table-row keep-together='always' line-height='12pt' display-align='after'>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>$_03: %_03\n                          </fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell padding-bottom='4pt'>\n                          <fo:block>$_17 %_17\n                          </fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell padding-bottom='4pt'>\n                             <fo:block>$_20: %_20</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell padding-bottom='4pt'>\n                             <fo:block>$_18: %_18</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table text-align=\"left\" table-layout=\"fixed\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"17cm\"/>\n              <fo:table-body>\n                  <fo:table-row >\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>$_04: %_04</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>$_05 A<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">E</fo:inline> %_05 m&#178;</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>$_06.</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block keep-together=\"always\">$_07: %_07</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table text-align=\"left\" table-layout=\"fixed\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"17cm\"/>\n              <fo:table-body>\n                  <fo:table-row line-height='0.5cm'>\n                     <fo:table-cell>\n                       <fo:block>&#160;</fo:block>\n                     </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table text-align=\"left\" border='0.25mm solid black' margin-bottom='4mm' table-layout=\"fixed\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"2cm\"/>\n              <fo:table-column column-width=\"6cm\"/>\n              <fo:table-column column-width=\"3cm\"/>\n              <fo:table-column column-width=\"0.4cm\"/>\n              <fo:table-column column-width=\"3cm\"/>\n              <fo:table-column column-width='0.8cm'/>\n              <fo:table-column column-width=\"1.8cm\"/>\n              <fo:table-body>\n                  <fo:table-row line-height='2mm'>\n                      <fo:table-cell number-columns-spanned='6'>\n                     <fo:block>&#160;</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.4cm' text-align='start'>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>$_21</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>$_23</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>$_24</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block></fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.7cm'>\n                      <fo:table-cell number-columns-spanned='6'>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>0</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='2.5cm' text-align='start'>\n                      <fo:table-cell number-columns-spanned='6'>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>100</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.65cm' text-align='start'>\n                      <fo:table-cell number-columns-spanned='6'>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>200</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.3cm'>\n                      <fo:table-cell number-columns-spanned='6'>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>&#160;</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='2cm'>\n                      <fo:table-cell number-columns-spanned='6'>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>300</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.8cm' text-align='start'>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell number-columns-spanned='5'>\n                          <fo:block>$_22</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.4cm' text-align='start'>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell number-columns-spanned='2'>\n                          <fo:block font-size='10pt'>$_26:</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell  number-columns-spanned='4'>\n                          <fo:block font-size='11pt' font-weight='bold'>%_25</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.4cm' text-align='start'>\n                      <fo:table-cell>\n                          <fo:block/>\n                      </fo:table-cell>\n                      <fo:table-cell number-columns-spanned='2'>\n                          <fo:block font-size='10pt'>$_25:</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell number-columns-spanned='4'>\n                          <fo:block font-size='11pt' font-weight='bold'>%_26</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row  line-height='0.6cm' text-align='start'>\n                      <fo:table-cell number-columns-spanned='7'>\n                          <fo:block font-size='10pt'>&#160;</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table text-align=\"left\" table-layout=\"fixed\" font-size=" + fs9 + ">\n              <fo:table-column column-width=\"17cm\"/>\n              <fo:table-body>\n                  <fo:table-row>\n                      <fo:table-cell  padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>                            $_08:                            <fo:block white-space-collapse='false'>$_09.</fo:block>\n                         </fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>$_19.</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4pt' margin-left='2pt'>\n                          <fo:block>\n                            $_10.\n                      </fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell  padding-bottom='1.0cm' margin-left='2pt'>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table font-size=" + fs9 + ">\n              <fo:table-column column-width=\"17cm\"/>\n              <fo:table-body>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='4mm' margin-left='2pt'>\n                          <fo:block keep-together=\"always\">$_12:</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n                  <fo:table-row>\n                      <fo:table-cell padding-bottom='10mm' margin-left='2pt'>\n                          <fo:block>$_13: %_13</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n          <fo:table font-size=" + fs9 + ">\n              <fo:table-column column-width=\"8.15cm\"/>\n              <fo:table-column column-width=\"8.15cm\"/>\n              <fo:table-body>\n                  <fo:table-row>\n                      <fo:table-cell margin-left='2pt'>\n                          <fo:block>$_14: %_14</fo:block>\n                      </fo:table-cell>\n                      <fo:table-cell>\n                          <fo:block>$_15</fo:block>\n                      </fo:table-cell>\n                  </fo:table-row>\n              </fo:table-body>\n          </fo:table>\n";
        } else if (section == 5) {
            fo[5] = "<!-- header et footer 2\u00e8me et reste des pages ________________________________________________________________________ -->   \n  <fo:page-sequence master-reference=\"all-pages\">\n    <!-- header reste des pages -->\n    <fo:static-content flow-name=\"page-header\">\n      <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\">    \n        <fo:wrapper>\n          <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"14pt\" font-weight=\"bold\">\n            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n              <fo:table-row role=\"tr\" display-align=\"before\">\n                <fo:table-cell padding=\"2px\" role=\"td\">\n                  <fo:block>$_titleR2</fo:block>\n                </fo:table-cell>\n              </fo:table-row>\n            </fo:table-body>\n          </fo:table> \n          <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border=\"0.1mm solid black\" margin=\"2px\" font-size=\"8pt\">\n            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n            <fo:table-column role=\"col\" column-width=\"11cm\"/>\n            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n            <fo:table-column role=\"col\" column-width=\"1.6cm\"/>\n            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_nom</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_nom</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_dossier</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\"><fo:block>%_dossier</fo:block></fo:table-cell>\n              </fo:table-row>\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_logiciel</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_logiciel</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block></fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\" font-weight=\"bold\"><fo:block></fo:block></fo:table-cell>\n              </fo:table-row>\n              <fo:table-row role=\"tr\" text-align=\"left\">\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_printDate</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_printDate</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_page</fo:block></fo:table-cell>\n                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\">\n                  <fo:block>\n                    <fo:page-number azimuth=\"1\"/>/<fo:page-number-citation ref-id=\"last-page\"/>\n                  </fo:block>\n                </fo:table-cell>\n              </fo:table-row>\n            </fo:table-body>\n          </fo:table>\n        </fo:wrapper>\n      </fo:block>\n      <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n      <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>     \n    </fo:static-content>\n    \n";
        } else if (section == 6) {
            fo[6] = "    <!-- footer reste des pages-->\n    <fo:static-content flow-name=\"page-footer\">\n      <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-after=\"1cm\" space-after.conditionality=\"retain\">    \n        <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"8pt\" font-style=\"italic\">\n          <fo:table-column role=\"col\" column-width=\"6.0cm\"/>\n          <fo:table-column role=\"col\" column-width=\"11.0cm\"/>\n          <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n            <fo:table-row role=\"tr\">\n              <fo:table-cell padding=\"2px\" role=\"td\">\n                <fo:block>\n                  <fo:basic-link text-decoration=\"underline\" color=\"blue\" role=\"a\" external-destination=\"url('http://%_ecadURL')\">\n                    %_ecadURL\n                  </fo:basic-link>\n                  %_userID\n                </fo:block>\n              </fo:table-cell>\n              <fo:table-cell padding=\"2px\" role=\"td\" text-align=\"right\">\n                <fo:block>%_fileNAME</fo:block>\n              </fo:table-cell>\n            </fo:table-row>\n          </fo:table-body>\n        </fo:table>\n      </fo:block>\n    </fo:static-content>\n    \n    <fo:flow flow-name=\"xsl-region-body\">\n      <fo:block role=\"body\" font-family=\"Arial, Helvetica, sans-serif\" font-size=\"8pt\">\n\n";
        } else if (section == 7) {
            fo[7] = "<!-- Consommation d'\u00e9nergie, production de gaz \u00e0 effet de serre et fraction renouvelable__________________________________________________ -->\n                <fo:block role=\"body\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"   keep-together.within-page=\"always\">\n                    <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"11pt\" font-weight=\"bold\">\n                        <fo:table-column role=\"col\" column-width=\"17cm\"/>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\" text-align=\"left\" display-align=\"before\">\n                                <fo:table-cell padding=\"2px\" role=\"td\"><fo:block>$_53</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                    </fo:table>\n                    <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border=\"0.1mm solid black\" margin=\"2px\" font-size=\"8pt\">\n                        <fo:table-column role=\"col\" column-width=\"5.2cm\"/>                        <fo:table-column role=\"col\" column-width=\"2.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"1.4cm\"/>\n                        <fo:table-column role=\"col\" column-width=\"2.5cm\"/>                        <fo:table-column role=\"col\" column-width=\"1.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"1.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"1.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"1.4cm\"/>                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\" border='0.1mm solid black'>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell number-rows-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_48</fo:block></fo:table-cell>\n                                <fo:table-cell number-columns-spanned='2' padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_49</fo:block></fo:table-cell>\n                                <fo:table-cell number-columns-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right='0.1mm solid black'><fo:block>CO<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">2</fo:inline></fo:block></fo:table-cell>\n                                <fo:table-cell number-columns-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\"><fo:block>$_50</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>GJ</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>$_51</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>GJ</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>kg/GJ</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>t</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='center' display-align='before' border-bottom='0.1mm solid black'><fo:block>GJ</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n";
        } else if (section == 8) {
            fo[8] = "                    <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_nom_d1</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_fep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_ep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_kco2</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_tco2</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align='right' border-right=\"0.1mm solid black\"><fo:block>%_fren</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align='right' ><fo:block>%_pren</fo:block></fo:table-cell>\n                            </fo:table-row>\n";
        } else if (section == 9) {
            fo[9] = "                   <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-top='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_52</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-top='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_sum_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" font-weight='bold' border-top='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%_sum_fep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-top='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%_sum_ep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" font-weight='bold' border-top='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%_sum_co2</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-top='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%_sum_tco2_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" font-weight='bold' border-top='0.1mm solid black' border-right='0.1mm solid black'><fo:block>%_sum_fren_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align='right' display-align=\"before\" border-top='0.1mm solid black'><fo:block>%_sum_pren</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                      </fo:table>\n                    </fo:block>\n                  <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n";
        } else if (section == 10) {
            fo[10] = "<!-- Consommation d'\u00e9nergie, production de gaz \u00e0 effet de serre et fraction renouvelable__________________________________________________ -->\n                <fo:block role=\"body\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"   keep-together.within-page=\"always\">\n                    <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"11pt\" font-weight=\"bold\">\n                        <fo:table-column role=\"col\" column-width=\"17cm\"/>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\" text-align=\"left\" display-align=\"before\">\n                                <fo:table-cell padding=\"2px\" role=\"td\"><fo:block>$_27</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                    </fo:table>\n                    <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border=\"0.1mm solid black\" margin=\"2px\" font-size=\"8pt\">\n                        <fo:table-column role=\"col\" column-width=\"5.2cm\"/>                        <fo:table-column role=\"col\" column-width=\"2.3cm\"/>                        <fo:table-column role=\"col\" column-width=\"2.3cm\"/>\n                        <fo:table-column role=\"col\" column-width=\"2.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"2.4cm\"/>                        <fo:table-column role=\"col\" column-width=\"2.4cm\"/>                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\" border='0.1mm solid black'>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell number-rows-spanned=\"2\" padding=\"4px\" role=\"td\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_28</fo:block></fo:table-cell>\n                                <fo:table-cell number-rows-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_29</fo:block></fo:table-cell>\n                                <fo:table-cell number-rows-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_30</fo:block></fo:table-cell>\n                                <fo:table-cell number-columns-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_31</fo:block></fo:table-cell>\n                                <fo:table-cell number-rows-spanned=\"2\" padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black'><fo:block>$_34</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_32</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" border-bottom='0.1mm solid black' border-right='0.1mm solid black'><fo:block>$_33</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\" border='0.1mm solid black'>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_32</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_aux</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_aux</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_35</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_csm_eev</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_36</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_csm_eel</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_37</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_csm_eep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_38</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>0</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_39</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-right=\"0.1mm solid black\" ><fo:block>$_40</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_fep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_fep_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\" ><fo:block>$_41</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"  background-color='#cccccc'><fo:block/></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_sum_ep</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_sum_prim_elaux</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black'><fo:block>%_sum_prim_pond</fo:block></fo:table-cell>\n                            </fo:table-row>\n                         </fo:table-body>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_42</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_ind_cms</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_ind_elaux</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black'><fo:block>%_sum_ind_elaux</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_43 [kg/GJ]</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_co2</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_kco2_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" background-color='#cccccc'><fo:block/></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_44 (t)</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_tco2_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_tco2_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\"><fo:block>%_sum_tco2_pond</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>$_45 (kg/m\u00b2)</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_ind_co2_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black' border-right=\"0.1mm solid black\"><fo:block>%_ind_co2_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-bottom='0.1mm solid black'><fo:block>%_ind_sum_co2</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_46</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_fren_csm %</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_fren_el %</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\"><fo:block>%_sum_fren_pond %</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\">\n                                <fo:table-cell padding=\"4px\" role=\"td\" number-columns-spanned=\"3\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>$_47</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_primren_csm</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\" border-right=\"0.1mm solid black\"><fo:block>%_sum_primren_el</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" display-align=\"before\"><fo:block>%_sum_primren_pond</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                      </fo:table>\n                    </fo:block>\n                  <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n";
        } else if (section == 16) {
            fo[16] = "      <fo:block id=\"last-page\"/>\n    </fo:flow>\n  </fo:page-sequence>\n</fo:root>";
        }
        return fo[section];
    }

    private Image getCebDiagramm() {
        this.out_ceb.setFont(this.FT_P11);
        this.out_ceb.setBounds(this.rec_img);
        BufferedImage buffImg = new BufferedImage(this.rec_img.width, this.rec_img.height, 2);
        Graphics2D g2d = buffImg.createGraphics();
        this.out_ceb.paint(g2d);
        return buffImg;
    }

    public ImageFop[] getImageFop() {
        ImageFop[] imageFop = new ImageFop[]{new ImageFop(this.getCebDiagramm(), this.rec_img.x, this.rec_img.y)};
        return imageFop;
    }
}

